/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.filetransfer;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.RenderIdSupport;
import nextapp.echo2.app.filetransfer.UploadSelect;
import nextapp.echo2.webcontainer.ContainerContext;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.filetransfer.UploadReceiver;
import nextapp.echo2.webcontainer.propertyrender.ColorRender;
import nextapp.echo2.webrender.Connection;
import nextapp.echo2.webrender.ContentType;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.output.XmlDocument;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Element;

public class UploadFormService
implements Serializable,
Service {
    private static final String SERVICE_ID = "Echo.UploadForm";
    public static final String FILE_PARAMETER_NAME = "Echo.UploadForm.File";
    private static final String PARAMETER_UPLOAD_FORM_UID = "uploadformUid";
    private static final String[] URL_PARAMETERS = new String[]{"uploadformUid"};
    private static final String RESOURCE_BUNDLE_BASE_NAME = "nextapp.echo2.webcontainer.filetransfer.resource.bundle.UploadSelectMessages";
    private static final String SEND_TEXT_KEY = "upload.send.default";
    private static final String WAIT_TEXT_KEY = "upload.send.wait";
    public static final UploadFormService INSTANCE = new UploadFormService();
    public static final Service UPLOAD_SERVICE = JavaScriptService.forResource((String)"Echo.UploadComponent", (String)"/nextapp/echo2/webcontainer/filetransfer/resource/js/Upload.js");

    public String createUri(ContainerInstance containerInstance, String imageId) {
        return containerInstance.getServiceUri((Service)this, URL_PARAMETERS, new String[]{imageId});
    }

    public String getId() {
        return PARAMETER_UPLOAD_FORM_UID;
    }

    public int getVersion() {
        return -1;
    }

    public void service(Connection conn) throws IOException {
        ContainerInstance containerInstance = (ContainerInstance)conn.getUserInstance();
        if (containerInstance == null) {
            this.serviceBadRequest(conn, "No container available.");
            return;
        }
        String uploadId = conn.getRequest().getParameter(PARAMETER_UPLOAD_FORM_UID);
        if (uploadId == null) {
            this.serviceBadRequest(conn, "Upload UID not specified.");
            return;
        }
        UploadSelect upload = (UploadSelect)containerInstance.getIdTable().getObject(uploadId);
        if (upload == null) {
            this.serviceBadRequest(conn, "Upload UID is not valid.");
            return;
        }
        this.service(conn, upload);
    }

    protected void service(Connection conn, UploadSelect uploadSelect) throws IOException {
        ContainerInstance ci = (ContainerInstance)conn.getUserInstance();
        ApplicationInstance app = uploadSelect.getApplicationInstance();
        XmlDocument doc = new XmlDocument("html", null, null, "http://www.w3.org/TR/xhtml1");
        Element head = doc.getDocument().createElement("head");
        doc.getDocument().getDocumentElement().appendChild(head);
        Element body = doc.getDocument().createElement("body");
        doc.getDocument().getDocumentElement().appendChild(body);
        body.setAttribute("onload", "EchoUploadComponent.synchronize('" + ContainerInstance.getElementId((Component)uploadSelect) + "');");
        Element script = doc.getDocument().createElement("script");
        head.appendChild(script);
        String uploadScriptUrl = ci.getServiceUri(UPLOAD_SERVICE);
        script.setAttribute("language", "JavaScript");
        script.setAttribute("src", uploadScriptUrl);
        script.appendChild(doc.getDocument().createTextNode(" "));
        CssStyle style = new CssStyle();
        style.setAttribute("text-align", "center");
        style.setAttribute("vertical-align", "center");
        style.setAttribute("border", "none");
        ColorRender.renderToStyle((CssStyle)style, (Color)((Color)uploadSelect.getRenderProperty("foreground")), (Color)((Color)uploadSelect.getRenderProperty("background")));
        body.setAttribute("style", style.renderInline());
        String id = uploadSelect.getRenderId();
        ci.getIdTable().register((RenderIdSupport)uploadSelect);
        String actionUrl = UploadReceiver.INSTANCE.createUri(ci, id);
        Element form = doc.getDocument().createElement("form");
        body.appendChild(form);
        form.setAttribute("method", "POST");
        form.setAttribute("enctype", "multipart/form-data");
        form.setAttribute("action", actionUrl);
        Element fileInput = doc.getDocument().createElement("input");
        form.appendChild(fileInput);
        fileInput.setAttribute("type", "file");
        fileInput.setAttribute("name", FILE_PARAMETER_NAME);
        fileInput.setAttribute("size", "20");
        if (!uploadSelect.isSendButtonDisplayed()) {
            fileInput.setAttribute("onchange", "document.forms[0].submit()");
        }
        if (uploadSelect.isSendButtonDisplayed()) {
            ContainerContext containerContext = (ContainerContext)app.getContextProperty(ContainerContext.CONTEXT_PROPERTY_NAME);
            Locale locale = new Locale(containerContext.getClientProperties().getString("navigatorLanguage"));
            String enabledText = this.ensureValue(uploadSelect.getEnabledSendButtonText(), this.getResourceProperty(SEND_TEXT_KEY, locale));
            String disabledText = this.ensureValue(uploadSelect.getDisabledSendButtonText(), this.getResourceProperty(WAIT_TEXT_KEY, locale));
            Element sendButton = doc.getDocument().createElement("input");
            form.appendChild(sendButton);
            sendButton.setAttribute("name", "sendButton");
            sendButton.setAttribute("onclick", "EchoUploadComponent.upload('" + enabledText + "','" + disabledText + "')");
            sendButton.setAttribute("type", "button");
            sendButton.setAttribute("value", enabledText);
        }
        conn.setContentType(ContentType.TEXT_HTML);
        PrintWriter pw = conn.getWriter();
        doc.render(pw);
        pw.close();
    }

    protected String ensureValue(String value, String defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    protected String getResourceProperty(String key, Locale locale) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE_BASE_NAME, locale);
            return bundle.getString(key);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void serviceBadRequest(Connection conn, String message) {
        conn.getResponse().setStatus(400);
        conn.setContentType(ContentType.TEXT_PLAIN);
        conn.getWriter().write(message);
    }

    static {
        WebRenderServlet.getServiceRegistry().add(UPLOAD_SERVICE);
        WebRenderServlet.getServiceRegistry().add((Service)INSTANCE);
    }
}

