/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.propertyrender;

import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.LayoutDirection;
import nextapp.echo2.webrender.output.CssStyle;
import org.w3c.dom.Element;

public class AlignmentRender {
    public static int getRenderedHorizontal(Alignment alignment, Component component) {
        LayoutDirection layoutDirection = component == null ? LayoutDirection.LTR : component.getRenderLayoutDirection();
        switch (alignment.getHorizontal()) {
            case 1: {
                return layoutDirection.isLeftToRight() ? 3 : 5;
            }
            case 2: {
                return layoutDirection.isLeftToRight() ? 5 : 3;
            }
        }
        return alignment.getHorizontal();
    }

    public static void renderToElement(Element element, Alignment alignment) {
        AlignmentRender.renderToElement(element, alignment, null);
    }

    public static void renderToElement(Element element, Alignment alignment, Component component) {
        String vertical;
        if (alignment == null) {
            return;
        }
        String horizontal = AlignmentRender.getHorizontalCssAttributeValue(alignment, component);
        if (horizontal != null) {
            element.setAttribute("align", horizontal);
        }
        if ((vertical = AlignmentRender.getVerticalCssAttributeValue(alignment)) != null) {
            element.setAttribute("valign", vertical);
        }
    }

    public static void renderToStyle(CssStyle cssStyle, Alignment alignment) {
        AlignmentRender.renderToStyle(cssStyle, alignment, null);
    }

    public static void renderToStyle(CssStyle cssStyle, Alignment alignment, Component component) {
        String vertical;
        if (alignment == null) {
            return;
        }
        String horizontal = AlignmentRender.getHorizontalCssAttributeValue(alignment, component);
        if (horizontal != null) {
            cssStyle.setAttribute("text-align", horizontal);
        }
        if ((vertical = AlignmentRender.getVerticalCssAttributeValue(alignment)) != null) {
            cssStyle.setAttribute("vertical-align", vertical);
        }
    }

    private static String getHorizontalCssAttributeValue(Alignment alignment, Component component) {
        switch (AlignmentRender.getRenderedHorizontal(alignment, component)) {
            case 3: {
                return "left";
            }
            case 4: {
                return "center";
            }
            case 5: {
                return "right";
            }
        }
        return null;
    }

    private static String getVerticalCssAttributeValue(Alignment alignment) {
        switch (alignment.getVertical()) {
            case 6: {
                return "top";
            }
            case 4: {
                return "middle";
            }
            case 7: {
                return "bottom";
            }
        }
        return null;
    }

    private AlignmentRender() {
    }
}

