/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.propertyrender;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo2.app.Extent;
import nextapp.echo2.webrender.output.CssStyle;

public class ExtentRender {
    private static final Map UNIT_NAMES_TO_VALUES;

    public static boolean isZeroLength(Extent extent) {
        return extent == null || extent.getValue() == 0;
    }

    public static final String renderCssAttributePixelValue(Extent extent) {
        return ExtentRender.renderCssAttributePixelValue(extent, null);
    }

    public static final String renderCssAttributePixelValue(Extent extent, String invalidValue) {
        if (extent != null && extent.getUnits() == 1) {
            return extent.getValue() + "px";
        }
        return invalidValue;
    }

    public static final String renderCssAttributeValue(Extent extent) {
        return extent.getValue() + ExtentRender.renderUnits(extent.getUnits());
    }

    public static final String renderCssAttributeValueHalf(Extent extent) {
        if (extent.getValue() % 2 == 0) {
            return extent.getValue() / 2 + ExtentRender.renderUnits(extent.getUnits());
        }
        return extent.getValue() / 2 + ".5" + ExtentRender.renderUnits(extent.getUnits());
    }

    public static final void renderToStyle(CssStyle cssStyle, String cssAttribute, Extent extent) {
        if (extent == null) {
            return;
        }
        cssStyle.setAttribute(cssAttribute, ExtentRender.renderCssAttributeValue(extent));
    }

    public static final String renderUnits(int units) {
        switch (units) {
            case 8: {
                return "cm";
            }
            case 64: {
                return "em";
            }
            case 128: {
                return "ex";
            }
            case 32: {
                return "in";
            }
            case 16: {
                return "mm";
            }
            case 256: {
                return "pc";
            }
            case 2: {
                return "%";
            }
            case 4: {
                return "pt";
            }
            case 1: {
                return "px";
            }
        }
        throw new IllegalArgumentException("Invalid extent.");
    }

    private static int getUnitPosition(String s) {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            if (ch == '-' || ch >= '0' && ch <= '9') continue;
            return i;
        }
        return -1;
    }

    public static final Extent toExtent(String extentString) {
        try {
            if (extentString == null) {
                return null;
            }
            int unitPosition = ExtentRender.getUnitPosition(extentString);
            if (unitPosition == -1) {
                return null;
            }
            String unitString = extentString.substring(unitPosition);
            Integer unitInteger = (Integer)UNIT_NAMES_TO_VALUES.get(unitString);
            if (unitInteger == null) {
                return null;
            }
            Extent extent = new Extent(Integer.parseInt(extentString.substring(0, unitPosition)), unitInteger.intValue());
            return extent;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static final int toPixels(Extent extent, int defaultPixels) {
        if (extent != null && extent.getUnits() == 1) {
            return extent.getValue();
        }
        return defaultPixels;
    }

    private ExtentRender() {
    }

    static {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put("cm", new Integer(8));
        m.put("em", new Integer(64));
        m.put("ex", new Integer(128));
        m.put("in", new Integer(32));
        m.put("mm", new Integer(16));
        m.put("pc", new Integer(256));
        m.put("%", new Integer(2));
        m.put("pt", new Integer(4));
        m.put("px", new Integer(1));
        UNIT_NAMES_TO_VALUES = Collections.unmodifiableMap(m);
    }
}

