/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATermAppl;
import aterm.ATermList;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSFacet;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObjectList;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseUnionDatatype;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.EmptyDatatype;
import org.mindswap.pellet.datatypes.RDFSLiteral;
import org.mindswap.pellet.datatypes.RDFXMLLiteral;
import org.mindswap.pellet.datatypes.StringValue;
import org.mindswap.pellet.datatypes.UnionDatatype;
import org.mindswap.pellet.datatypes.UnknownDatatype;
import org.mindswap.pellet.datatypes.ValueSpace;
import org.mindswap.pellet.datatypes.XSDAnyURI;
import org.mindswap.pellet.datatypes.XSDAtomicType;
import org.mindswap.pellet.datatypes.XSDBoolean;
import org.mindswap.pellet.datatypes.XSDDate;
import org.mindswap.pellet.datatypes.XSDDateTime;
import org.mindswap.pellet.datatypes.XSDDay;
import org.mindswap.pellet.datatypes.XSDDecimal;
import org.mindswap.pellet.datatypes.XSDDouble;
import org.mindswap.pellet.datatypes.XSDDuration;
import org.mindswap.pellet.datatypes.XSDFloat;
import org.mindswap.pellet.datatypes.XSDInteger;
import org.mindswap.pellet.datatypes.XSDMonth;
import org.mindswap.pellet.datatypes.XSDMonthDay;
import org.mindswap.pellet.datatypes.XSDSimpleType;
import org.mindswap.pellet.datatypes.XSDString;
import org.mindswap.pellet.datatypes.XSDTime;
import org.mindswap.pellet.datatypes.XSDYear;
import org.mindswap.pellet.datatypes.XSDYearMonth;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.URIUtils;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatatypeReasoner {
    public static Log log = LogFactory.getLog(DatatypeReasoner.class);
    public static boolean DEBUG = false;
    private Map<String, Datatype> uriToDatatype = new Hashtable<String, Datatype>();
    private Map<Datatype, String> datatypeToURI = new Hashtable<Datatype, String>();
    private Map<ATermAppl, Datatype> termToDatatype = new Hashtable<ATermAppl, Datatype>();
    private Map<Datatype, Datatype> normalized = new Hashtable<Datatype, Datatype>();
    private Map<URL, XSNamedMap> loadedSchemas = new HashMap<URL, XSNamedMap>();
    private int datatypeCount = 0;

    public DatatypeReasoner() {
        this.defineDatatype("http://www.w3.org/2000/01/rdf-schema#Literal", RDFSLiteral.instance);
        this.defineDatatype("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral", RDFXMLLiteral.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#decimal", XSDDecimal.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#string", XSDString.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#boolean", XSDBoolean.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#float", XSDFloat.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#double", XSDDouble.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#dateTime", XSDDateTime.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#date", XSDDate.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#time", XSDTime.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#gYear", XSDYear.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#gMonth", XSDMonth.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#gDay", XSDDay.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#gYearMonth", XSDYearMonth.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#gMonthDay", XSDMonthDay.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#duration", XSDDuration.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#anyURI", XSDAnyURI.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#anySimpleType", XSDSimpleType.instance);
        XSDDecimal decimal = XSDDecimal.instance;
        ValueSpace valueSpace = decimal.getValueSpace();
        Object zero = valueSpace.getMidValue();
        XSDInteger integer = XSDInteger.instance;
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#integer", integer);
        XSDAtomicType nonPositiveInteger = integer.restrictMaxInclusive(zero);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#nonPositiveInteger", nonPositiveInteger);
        XSDAtomicType negativeInteger = nonPositiveInteger.restrictMaxExclusive(zero);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#negativeInteger", negativeInteger);
        XSDAtomicType nonNegativeInteger = integer.restrictMinInclusive(zero);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#nonNegativeInteger", nonNegativeInteger);
        XSDAtomicType positiveInteger = nonNegativeInteger.restrictMinExclusive(zero);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#positiveInteger", positiveInteger);
        XSDAtomicType xsdLong = integer.restrictMinInclusive(new Long(Long.MIN_VALUE)).restrictMaxInclusive(new Long(Long.MAX_VALUE));
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#long", xsdLong);
        XSDAtomicType xsdInt = xsdLong.restrictMinInclusive(new Integer(Integer.MIN_VALUE)).restrictMaxInclusive(new Integer(Integer.MAX_VALUE));
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#int", xsdInt);
        XSDAtomicType xsdShort = xsdInt.restrictMinInclusive(new Short(Short.MIN_VALUE)).restrictMaxInclusive(new Short(Short.MAX_VALUE));
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#short", xsdShort);
        XSDAtomicType xsdByte = xsdShort.restrictMinInclusive(new Byte(-128)).restrictMaxInclusive(new Byte(127));
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#byte", xsdByte);
        XSDAtomicType unsignedLong = nonNegativeInteger.restrictMaxInclusive(valueSpace.getValue("18446744073709551615"));
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#unsignedLong", unsignedLong);
        XSDAtomicType unsignedInt = unsignedLong.restrictMaxInclusive(valueSpace.getValue("4294967295"));
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#unsignedInt", unsignedInt);
        XSDAtomicType unsignedShort = unsignedInt.restrictMaxInclusive(valueSpace.getValue("65535"));
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#unsignedShort", unsignedShort);
        XSDAtomicType unsignedByte = unsignedShort.restrictMaxInclusive(valueSpace.getValue("255"));
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#unsignedByte", unsignedByte);
    }

    public final Set<String> getDatatypeURIs() {
        return this.uriToDatatype.keySet();
    }

    public final boolean isDefined(String datatypeURI) {
        return this.uriToDatatype.containsKey(datatypeURI);
    }

    public final boolean isDefined(Datatype datatype) {
        return this.datatypeToURI.containsKey(datatype);
    }

    public void defineDatatype(String name, Datatype dt) {
        if (this.uriToDatatype.containsKey(name)) {
            throw new RuntimeException(name + " is already defined");
        }
        this.uriToDatatype.put(name, dt);
        this.datatypeToURI.put(dt, name);
        this.normalize(dt);
    }

    public void defineUnknownDatatype(String name) {
        this.defineDatatype(name, UnknownDatatype.create(name));
    }

    public XSNamedMap parseXMLSchema(URL url) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Parsing XML Schema " + url));
        }
        System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMXSImplementationSourceImpl ");
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        DOMImplementationLS ls = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        LSInput input = ls.createLSInput();
        input.setCharacterStream(new InputStreamReader(url.openStream()));
        XSImplementation impl = (XSImplementation)registry.getDOMImplementation("XS-Loader");
        XSLoader schemaLoader = impl.createXSLoader(null);
        XSModel schema = schemaLoader.load(input);
        XSNamedMap map = schema.getComponents((short)16);
        return map;
    }

    public void loadUserDefinedDatatype(String name) {
        try {
            XSNamedMap map;
            if (this.uriToDatatype.containsKey(name)) {
                return;
            }
            URL url = new URL(name);
            url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile());
            if (log.isInfoEnabled()) {
                log.info((Object)("Load " + url));
            }
            if ((map = this.loadedSchemas.get(url)) == null) {
                map = this.parseXMLSchema(url);
                this.loadedSchemas.put(url, map);
            }
            String localName = URIUtils.getLocalName(name);
            String nameSpace = URIUtils.getNameSpace(name);
            XSSimpleType simpleType = (XSSimpleType)map.itemByName(nameSpace, localName);
            if (simpleType == null) {
                simpleType = (XSSimpleType)map.itemByName("", localName);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Type: " + simpleType));
                log.debug((Object)("Base: " + simpleType.getBaseType()));
                log.debug((Object)("MinInclusive value: " + simpleType.getLexicalFacetValue((short)256)));
                log.debug((Object)("MaxInclusive value: " + simpleType.getLexicalFacetValue((short)32)));
            }
            String baseType = "http://www.w3.org/2001/XMLSchema#" + simpleType.getBaseType().getName();
            XSDAtomicType xsdType = (XSDAtomicType)this.getDatatype(baseType);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Facets: ");
            }
            XSObjectList facets = simpleType.getFacets();
            for (int i = 0; i < facets.getLength(); ++i) {
                XSFacet facet = (XSFacet)facets.item(i);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(i + ") Facet kind: " + facet.getFacetKind() + " Facet name = " + facet.getName() + " Facet value: " + facet.getLexicalFacetValue()));
                }
                Object facetValue = xsdType.getValue(facet.getLexicalFacetValue(), baseType);
                xsdType = xsdType.deriveByRestriction(facet.getFacetKind(), facetValue);
            }
            StringList enumValues = simpleType.getLexicalEnumeration();
            if (enumValues != null && enumValues.getLength() > 0) {
                if (log.isDebugEnabled()) {
                    for (int k = 0; k < enumValues.getLength(); ++k) {
                        log.debug((Object)("enum: " + enumValues.item(k)));
                    }
                }
                xsdType = xsdType.deriveByRestriction(2048, enumValues);
            }
            this.defineDatatype(name, xsdType);
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            log.warn((Object)("WARNING: Cannot load XML schema associated with the user-defined datatype " + name));
            this.defineDatatype(name, UnknownDatatype.create(name));
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            log.warn((Object)("WARNING: Cannot process the definition of the user-defined datatype " + name));
            this.defineDatatype(name, UnknownDatatype.create(name));
        }
    }

    public String defineDatatype(Datatype dt) {
        String name = dt.getName() == null ? "datatype" + this.datatypeCount++ : dt.getName().getName();
        this.defineDatatype(name, dt);
        return name;
    }

    public void removeDatatype(String name) {
        Datatype dt = this.getDatatype(name);
        this.uriToDatatype.remove(name);
        this.datatypeToURI.remove(dt);
        this.normalized.remove(dt);
        ATermAppl term = ATermUtils.makeTermAppl(name);
        this.termToDatatype.remove(term);
        ATermAppl not = ATermUtils.makeNot(term);
        this.termToDatatype.remove(not);
    }

    public Datatype getDatatype(String datatypeURI) {
        if (datatypeURI == null || datatypeURI.length() == 0) {
            return XSDString.instance;
        }
        if (this.uriToDatatype.containsKey(datatypeURI)) {
            return this.uriToDatatype.get(datatypeURI);
        }
        return UnknownDatatype.instance;
    }

    public String getDatatypeURI(Datatype datatype) {
        return this.datatypeToURI.get(datatype);
    }

    public Object getValue(ATermAppl lit) {
        if (!ATermUtils.isLiteral(lit)) {
            return null;
        }
        String lexicalValue = ((ATermAppl)lit.getArgument(0)).getName();
        String lang = ((ATermAppl)lit.getArgument(1)).getName();
        String datatypeURI = ((ATermAppl)lit.getArgument(2)).getName();
        if (!lang.equals("") && !datatypeURI.equals("")) {
            throw new UnsupportedFeatureException("A literal value cannot have both a datatype URI and a language identifier " + lit);
        }
        Datatype datatype = this.getDatatype(datatypeURI);
        if (lang.equals("")) {
            return datatype.getValue(lexicalValue, datatypeURI);
        }
        return new StringValue(lexicalValue, lang);
    }

    public Datatype singleton(ATermAppl term) {
        ATermAppl lit = null;
        if (ATermUtils.isNominal(term)) {
            lit = (ATermAppl)term.getArgument(0);
        } else if (ATermUtils.isLiteral(term)) {
            lit = term;
        } else {
            throw new RuntimeException("An invalid data value is found " + term);
        }
        String lexicalValue = ((ATermAppl)lit.getArgument(0)).getName();
        String lang = ((ATermAppl)lit.getArgument(1)).getName();
        String datatypeURI = ((ATermAppl)lit.getArgument(2)).getName();
        if (!lang.equals("") && !datatypeURI.equals("")) {
            throw new UnsupportedFeatureException("A literal value cannot have both a datatype URI and a language identifier " + lit);
        }
        Datatype datatype = this.getDatatype(datatypeURI);
        Object value = lang.equals("") ? datatype.getValue(lexicalValue, datatypeURI) : new StringValue(lexicalValue, lang);
        return datatype.singleton(value);
    }

    public Datatype enumeration(Set values) {
        Datatype[] enums = new Datatype[values.size()];
        Iterator i = values.iterator();
        for (int index = 0; index < enums.length; ++index) {
            enums[index] = this.singleton((ATermAppl)i.next());
        }
        return this.normalize(new BaseUnionDatatype(enums));
    }

    public ATermAppl getCanonicalRepresentation(ATermAppl dataValue) {
        String lexicalValue = ((ATermAppl)dataValue.getArgument(0)).getName();
        String lang = ((ATermAppl)dataValue.getArgument(1)).getName();
        String datatypeURI = ((ATermAppl)dataValue.getArgument(2)).getName();
        ATermAppl name = null;
        if (!datatypeURI.equals("")) {
            Datatype dt = this.getDatatype(datatypeURI);
            if (dt instanceof AtomicDatatype) {
                datatypeURI = ((AtomicDatatype)dt).getPrimitiveType().getURI();
            }
            name = ATermUtils.makeTypedLiteral(lexicalValue, datatypeURI);
        } else {
            name = ATermUtils.makePlainLiteral(lexicalValue, lang);
        }
        return name;
    }

    public Datatype getDatatype(ATermAppl datatypeTerm) {
        Datatype datatype = this.termToDatatype.get(datatypeTerm);
        if (datatype != null) {
            return datatype;
        }
        if (ATermUtils.isNominal(datatypeTerm)) {
            datatype = this.singleton(datatypeTerm);
        } else if (ATermUtils.isNot(datatypeTerm)) {
            ATermAppl negatedDatatype = (ATermAppl)datatypeTerm.getArgument(0);
            if (ATermUtils.isAnd(negatedDatatype)) {
                ATermList list = ATermUtils.negate((ATermList)negatedDatatype.getArgument(0));
                datatype = this.enumeration(ATermUtils.listToSet(list));
            } else {
                datatype = this.negate(this.getDatatype(negatedDatatype));
            }
        } else {
            datatype = this.getDatatype(datatypeTerm.getName());
        }
        if (datatype == null) {
            datatype = UnknownDatatype.instance;
        }
        this.termToDatatype.put(datatypeTerm, datatype);
        return datatype;
    }

    public Datatype negate(Datatype datatype) {
        Datatype norm = this.normalize(datatype);
        Set<Datatype> atomicTypes = ((UnionDatatype)this.normalized.get(RDFSLiteral.instance)).getMembers();
        atomicTypes = SetUtils.create(atomicTypes);
        if (norm instanceof AtomicDatatype) {
            AtomicDatatype atomicType = (AtomicDatatype)norm;
            AtomicDatatype primitiveType = atomicType.getPrimitiveType();
            atomicTypes.remove(primitiveType);
            AtomicDatatype not = atomicType.not();
            if (!not.isEmpty()) {
                atomicTypes.add(not);
            }
            Datatype[] datatypeArray = new Datatype[atomicTypes.size()];
            atomicTypes.toArray(datatypeArray);
            datatype = new BaseUnionDatatype(datatypeArray);
            return datatype;
        }
        if (norm instanceof UnionDatatype) {
            Map<AtomicDatatype, AtomicDatatype> groupedTypes = new HashMap<AtomicDatatype, AtomicDatatype>();
            UnionDatatype union = (UnionDatatype)norm;
            for (AtomicDatatype atomicDatatype : union.getMembers()) {
                AtomicDatatype normalizedMember = (AtomicDatatype)this.normalize(atomicDatatype);
                AtomicDatatype not = normalizedMember.not();
                if (not.isEmpty()) continue;
                groupedTypes = this.unionWithGroup(groupedTypes, not);
            }
            Datatype[] datatypes = new Datatype[groupedTypes.size()];
            groupedTypes.values().toArray(datatypes);
            norm = datatypes.length == 1 ? datatypes[0] : new BaseUnionDatatype(datatypes);
            return norm;
        }
        throw new RuntimeException("Error in datatype reasoning");
    }

    private Datatype normalize(Datatype datatype) {
        Datatype norm = this.normalized.get(datatype);
        if (norm != null) {
            return norm;
        }
        if (datatype instanceof UnionDatatype) {
            Map<AtomicDatatype, AtomicDatatype> groupedTypes = new HashMap<AtomicDatatype, AtomicDatatype>();
            UnionDatatype union = (UnionDatatype)datatype;
            for (Datatype member : union.getMembers()) {
                Datatype normalizedMember = this.normalize(member);
                groupedTypes = this.unionWithGroup(groupedTypes, normalizedMember);
            }
            Datatype[] datatypes = new Datatype[groupedTypes.size()];
            groupedTypes.values().toArray(datatypes);
            norm = datatypes.length == 1 ? datatypes[0] : new BaseUnionDatatype(datatypes);
        } else {
            norm = datatype;
        }
        this.normalized.put(datatype, norm);
        return norm;
    }

    public boolean isSubTypeOf(ATermAppl d1, ATermAppl d2) {
        ATermAppl notD2 = ATermUtils.makeNot(d2);
        Datatype conjunction = this.intersection(new ATermAppl[]{d1, notD2});
        return conjunction.isEmpty();
    }

    public Datatype intersection(ATermAppl[] datatypeTerms) {
        if (datatypeTerms.length == 0) {
            return EmptyDatatype.instance;
        }
        if (datatypeTerms.length == 1 && ATermUtils.isPrimitive(datatypeTerms[0])) {
            return this.getDatatype(datatypeTerms[0]);
        }
        ATermList list = ATermUtils.makeList(datatypeTerms);
        ATermAppl and = ATermUtils.normalize(ATermUtils.makeAnd(list));
        Datatype intersection = this.termToDatatype.get(and);
        if (intersection != null) {
            return intersection;
        }
        Datatype[] datatypes = null;
        if (ATermUtils.isAnd(and)) {
            list = (ATermList)and.getArgument(0);
            datatypes = new Datatype[list.getLength()];
            int i = 0;
            while (!list.isEmpty()) {
                datatypes[i++] = this.getDatatype((ATermAppl)list.getFirst());
                list = list.getNext();
            }
        } else {
            datatypes = new Datatype[]{this.getDatatype((ATermAppl)list.getFirst())};
        }
        Map<Object, Object> groupedTypes = new HashMap<AtomicDatatype, AtomicDatatype>();
        Set<Datatype> atomicTypes = ((UnionDatatype)this.normalized.get(RDFSLiteral.instance)).getMembers();
        for (AtomicDatatype atomicDatatype : atomicTypes) {
            groupedTypes.put(atomicDatatype, atomicDatatype);
        }
        for (int i = 0; i < datatypes.length; ++i) {
            groupedTypes = this.intersectWithGroup(groupedTypes, datatypes[i]);
        }
        intersection = groupedTypes.size() == 1 ? (Datatype)groupedTypes.values().iterator().next() : new BaseUnionDatatype(new HashSet<Object>(groupedTypes.values()));
        this.termToDatatype.put(and, intersection);
        return intersection;
    }

    private Map<AtomicDatatype, Datatype> intersectWithGroup(Map groupedTypes, Datatype datatype) {
        HashMap<AtomicDatatype, Datatype> newGroup = new HashMap<AtomicDatatype, Datatype>();
        if (datatype instanceof AtomicDatatype) {
            AtomicDatatype atomicType = (AtomicDatatype)datatype;
            AtomicDatatype primitiveType = atomicType.getPrimitiveType();
            AtomicDatatype type = (AtomicDatatype)groupedTypes.get(primitiveType);
            if (type != null) {
                type = type.intersection(atomicType);
                newGroup.put(primitiveType, type);
            }
        } else if (datatype instanceof UnionDatatype) {
            UnionDatatype union = (UnionDatatype)datatype;
            for (Datatype member : union.getMembers()) {
                newGroup.putAll(this.intersectWithGroup(groupedTypes, member));
            }
        } else {
            throw new RuntimeException("Error in datatype reasoning");
        }
        return newGroup;
    }

    private Map<AtomicDatatype, AtomicDatatype> unionWithGroup(Map<AtomicDatatype, AtomicDatatype> groupedTypes, Datatype datatype) {
        Map<AtomicDatatype, AtomicDatatype> newGroup = groupedTypes;
        if (datatype instanceof AtomicDatatype) {
            AtomicDatatype atomicType = (AtomicDatatype)datatype;
            AtomicDatatype primitiveType = atomicType.getPrimitiveType();
            AtomicDatatype type = groupedTypes.get(primitiveType);
            type = type == null ? atomicType : type.union(atomicType);
            newGroup.put(primitiveType, type);
        } else if (datatype instanceof UnionDatatype) {
            UnionDatatype union = (UnionDatatype)datatype;
            for (Datatype member : union.getMembers()) {
                newGroup = this.unionWithGroup(groupedTypes, member);
            }
        } else {
            throw new RuntimeException("Error in datatype reasoning");
        }
        return newGroup;
    }
}

