/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import aterm.ATerm;
import aterm.ATermAppl;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.XSD;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.datatypes.DatatypeReasoner;
import org.mindswap.pellet.datatypes.XSDDecimal;
import org.mindswap.pellet.datatypes.XSDInteger;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletQueryExecution;
import org.mindswap.pellet.jena.PelletReasoner;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.jena.vocabulary.OWL_1_1;
import org.mindswap.pellet.rete.Fact;
import org.mindswap.pellet.rete.Interpreter;
import org.mindswap.pellet.rules.RulesToReteTranslator;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.test.PelletTestSuite;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.FileUtils;
import org.semanticweb.owl.model.OWLException;

public class MiscTests
extends PelletTestCase {
    public static String base = "file:" + PelletTestSuite.base + "misc/";

    public static void main(String[] args) {
        for (int i = 0; i < 10000; ++i) {
            System.out.println(i);
            new MiscTests().testSubDataPropCard();
        }
    }

    public void testIncrementalABoxAddition() throws MalformedURLException {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, null);
        ObjectProperty p = model.createObjectProperty("p");
        ObjectProperty t = model.createObjectProperty("t");
        DatatypeProperty q = model.createDatatypeProperty("q");
        AnnotationProperty r = model.createAnnotationProperty("r");
        Individual a = model.createIndividual("a", OWL.Thing);
        Individual b = model.createIndividual("b", OWL.Thing);
        model.add((Resource)t, RDF.type, (RDFNode)OWL.TransitiveProperty);
        model.prepare();
        Resource bnode1 = model.createResource();
        Resource bnode2 = model.createResource();
        Resource c = ResourceFactory.createResource();
        Resource d = ResourceFactory.createResource();
        model.add((Resource)a, (Property)p, (RDFNode)b);
        model.add(d, (Property)p, (RDFNode)b);
        model.add((Resource)a, (Property)p, (RDFNode)c);
        model.add((Resource)a, (Property)q, (RDFNode)model.createLiteral("l"));
        model.add((Resource)a, (Property)t, (RDFNode)bnode1);
        model.add(bnode1, (Property)t, (RDFNode)bnode2);
        TestCase.assertTrue((boolean)model.contains((Resource)a, (Property)t, (RDFNode)bnode2));
        model.prepare();
        model.add((Resource)a, (Property)r, (RDFNode)model.createLiteral("l"));
        model.add((Resource)a, (Property)r, (RDFNode)model.createResource());
        MiscTests.assertTrue((boolean)model.validate().isValid());
        model.prepare();
        model.add((Resource)p, RDF.type, (RDFNode)OWL.FunctionalProperty);
        model.add((Resource)b, OWL.differentFrom, (RDFNode)c);
        model.prepare();
        MiscTests.assertFalse((boolean)model.validate().isValid());
        model.remove((Resource)b, OWL.differentFrom, (RDFNode)c);
        MiscTests.assertTrue((boolean)model.validate().isValid());
        model.prepare();
        model.add((Resource)p, RDF.type, (RDFNode)OWL.InverseFunctionalProperty);
        model.add((Resource)a, OWL.differentFrom, (RDFNode)d);
        MiscTests.assertFalse((boolean)model.validate().isValid());
    }

    public void testFileUtilsToURI() throws MalformedURLException {
        MiscTests.assertEquals((String)new File("build.xml").toURI().toURL().toString(), (String)FileUtils.toURI("build.xml"));
        MiscTests.assertEquals((String)"http://example.com/foo", (String)FileUtils.toURI("http://example.com/foo"));
        MiscTests.assertEquals((String)"file:///foo", (String)FileUtils.toURI("file:///foo"));
        MiscTests.assertEquals((String)"ftp://example.com/foo", (String)FileUtils.toURI("ftp://example.com/foo"));
        MiscTests.assertEquals((String)"https://example.com/foo", (String)FileUtils.toURI("https://example.com/foo"));
    }

    public void testInverse() {
        String ns = "http://www.example.org/test#";
        OntModel ont = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, null);
        ObjectProperty p1 = ont.createObjectProperty(ns + "p1");
        ObjectProperty p2 = ont.createObjectProperty(ns + "p2");
        ObjectProperty p3 = ont.createObjectProperty(ns + "p3");
        p2.addSubProperty((Property)p1);
        p2.addInverseOf((Property)p3);
        Individual s1 = ont.createIndividual(ns + "s1", OWL.Thing);
        Individual o1 = ont.createIndividual(ns + "o1", OWL.Thing);
        Individual s2 = ont.createIndividual(ns + "s2", OWL.Thing);
        Individual o2 = ont.createIndividual(ns + "o2", OWL.Thing);
        Individual s3 = ont.createIndividual(ns + "s3", OWL.Thing);
        Individual o3 = ont.createIndividual(ns + "o3", OWL.Thing);
        s1.addProperty((Property)p1, (RDFNode)o1);
        s2.addProperty((Property)p2, (RDFNode)o2);
        s3.addProperty((Property)p3, (RDFNode)o3);
        Statement stmt = ont.createStatement((Resource)o1, (Property)p3, (RDFNode)s1);
        this.assertIteratorContains((Iterator)o1.listPropertyValues((Property)p3), s1);
        MiscTests.assertTrue((boolean)ont.contains(stmt));
        this.assertIteratorContains((Iterator)ont.listStatements(null, (Property)p3, (RDFNode)null), stmt);
        this.assertIteratorContains((Iterator)ont.listStatements((Resource)o1, null, (RDFNode)null), stmt);
        this.assertIteratorContains((Iterator)ont.listStatements(), stmt);
        MiscTests.assertFalse((boolean)ont.contains((Resource)o3, (Property)p1, (RDFNode)s3));
        MiscTests.assertTrue((boolean)p2.isInverseOf((Property)p3));
        MiscTests.assertIteratorValues((Iterator)p2.listInverseOf(), new Property[]{p3});
        MiscTests.assertTrue((boolean)p3.isInverseOf((Property)p2));
        MiscTests.assertIteratorValues((Iterator)p3.listInverseOf(), new Property[]{p2});
    }

    public void testOWL_1_1() {
        String ns = "http://www.example.org/test#";
        OntModel factory = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "owl1.1.owl");
        OntClass C = model.getOntClass(ns + "C");
        OntClass D = model.getOntClass(ns + "D");
        OntClass D1 = model.getOntClass(ns + "D1");
        OntClass D2 = model.getOntClass(ns + "D2");
        OntClass D3 = model.getOntClass(ns + "D3");
        OntClass test1 = model.getOntClass(ns + "test1");
        OntClass test2 = model.getOntClass(ns + "test2");
        OntClass test3 = model.getOntClass(ns + "test3");
        OntClass OlderThan10 = model.getOntClass(ns + "OlderThan10");
        OntClass YoungerThan20 = model.getOntClass(ns + "youngerThan20");
        OntClass Teenager = model.getOntClass(ns + "Teenager");
        OntClass Teen = model.getOntClass(ns + "Teen");
        Individual ind1 = model.getIndividual(ns + "ind1");
        Individual ind3 = model.getIndividual(ns + "ind3");
        Individual ind4 = model.getIndividual(ns + "ind4");
        Individual ind5 = model.getIndividual(ns + "ind5");
        Individual ind6 = model.getIndividual(ns + "ind6");
        Individual ind7 = model.getIndividual(ns + "ind7");
        Individual ind8 = model.getIndividual(ns + "ind8");
        DatatypeProperty dp = model.getDatatypeProperty(ns + "dp");
        ObjectProperty p = model.getObjectProperty(ns + "p");
        ObjectProperty r = model.getObjectProperty(ns + "r");
        ObjectProperty invR = model.getObjectProperty(ns + "invR");
        ObjectProperty ir = model.getObjectProperty(ns + "ir");
        ObjectProperty as = model.getObjectProperty(ns + "as");
        ObjectProperty d1 = model.getObjectProperty(ns + "d1");
        ObjectProperty d2 = model.getObjectProperty(ns + "d2");
        model.prepare();
        MiscTests.assertTrue((boolean)r.hasRDFType(OWL_1_1.ReflexiveProperty));
        MiscTests.assertTrue((boolean)invR.hasRDFType(OWL_1_1.ReflexiveProperty));
        MiscTests.assertTrue((boolean)ir.hasRDFType(OWL_1_1.IrreflexiveProperty));
        MiscTests.assertTrue((boolean)as.hasRDFType(OWL_1_1.AntisymmetricProperty));
        UnionClass union = factory.createUnionClass(null, factory.createList(new RDFNode[]{D1, D2, D3}));
        MiscTests.assertTrue((boolean)model.listStatements((Resource)D, OWL.equivalentClass, (RDFNode)union, (Model)factory).hasNext());
        MiscTests.assertTrue((boolean)model.contains((Resource)D, OWL.equivalentClass, (RDFNode)test1));
        MiscTests.assertTrue((boolean)D1.isDisjointWith((Resource)D2));
        MiscTests.assertTrue((boolean)D1.isDisjointWith((Resource)D3));
        MiscTests.assertTrue((boolean)D2.isDisjointWith((Resource)D3));
        MiscTests.assertTrue((boolean)model.contains((Resource)d1, OWL_1_1.disjointObjectProperties, (RDFNode)d2));
        MiscTests.assertTrue((boolean)model.contains((Resource)d2, OWL_1_1.disjointObjectProperties, (RDFNode)d1));
        MiscTests.assertTrue((boolean)model.contains((Resource)ind1, (Property)r, (RDFNode)ind1));
        MiscTests.assertTrue((boolean)model.contains((Resource)ind1, (Property)invR, (RDFNode)ind1));
        MiscTests.assertTrue((boolean)model.contains((Resource)ind1, OWL.differentFrom, (RDFNode)ind3));
        MiscTests.assertTrue((boolean)model.contains((Resource)ind1, OWL.differentFrom, (RDFNode)ind4));
        MiscTests.assertTrue((boolean)model.contains((Resource)ind5, OWL.differentFrom, (RDFNode)ind6));
        MiscTests.assertTrue((boolean)model.contains((Resource)ind1, (Property)p, (RDFNode)ind1));
        MiscTests.assertTrue((boolean)model.contains((Resource)ind1, RDF.type, (RDFNode)test2));
        MiscTests.assertTrue((boolean)model.contains((Resource)ind1, RDF.type, (RDFNode)test3));
        MiscTests.assertTrue((boolean)model.contains((Resource)ind7, OWL.differentFrom, (RDFNode)ind8));
        MiscTests.assertTrue((boolean)model.contains((Resource)ind8, OWL.differentFrom, (RDFNode)ind7));
        MiscTests.assertTrue((boolean)model.contains((Resource)ind1, (Property)dp, (RDFNode)model.createTypedLiteral(false)));
        MiscTests.assertIteratorValues((Iterator)ind1.listRDFTypes(false), new Object[]{OWL.Thing, C, test2, test3});
        MiscTests.assertTrue((boolean)model.contains((Resource)Teenager, RDFS.subClassOf, (RDFNode)OlderThan10));
        MiscTests.assertTrue((boolean)model.contains((Resource)Teenager, RDFS.subClassOf, (RDFNode)YoungerThan20));
        MiscTests.assertTrue((boolean)model.contains((Resource)Teenager, OWL.equivalentClass, (RDFNode)Teen));
    }

    public void testPropertyChain() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "propertyChain.owl");
        OntClass C = model.getOntClass(ns + "C");
        OntClass S0 = model.getOntClass(ns + "S0");
        OntClass R0 = model.getOntClass(ns + "R0");
        OntClass R1 = model.getOntClass(ns + "R1");
        ObjectProperty r = model.getObjectProperty(ns + "r");
        ObjectProperty s = model.getObjectProperty(ns + "s");
        if (PelletOptions.USE_LOCAL_NAME) {
            ns = "";
        }
        int n = 17;
        Resource[] a = new Resource[n];
        for (int i = 0; i < n; ++i) {
            a[i] = model.getResource(ns + "a" + i);
        }
        Object[] theList = new Resource[]{a[1], a[2], a[3], a[4], a[5], a[6], a[8], a[10], a[12], a[14], a[16]};
        MiscTests.assertTrue((boolean)r.isTransitiveProperty());
        MiscTests.assertFalse((boolean)s.isTransitiveProperty());
        MiscTests.assertIteratorValues((Iterator)C.listInstances(), theList);
        MiscTests.assertIteratorValues((Iterator)S0.listInstances(), theList);
        MiscTests.assertIteratorValues((Iterator)R0.listInstances(), new Resource[]{a[7], a[9]});
        MiscTests.assertIteratorValues((Iterator)R1.listInstances(), new Resource[]{a[2], a[3], a[4], a[5], a[6]});
        Model rValues = ModelFactory.createDefaultModel();
        this.addStatements(rValues, a[0], (Property)r, new RDFNode[]{a[7], a[9]});
        this.addStatements(rValues, a[1], (Property)r, new RDFNode[]{a[2], a[3], a[4], a[5], a[6]});
        this.addStatements(rValues, a[2], (Property)r, new RDFNode[]{a[4], a[5], a[6]});
        this.addStatements(rValues, a[4], (Property)r, new RDFNode[]{a[5], a[6]});
        this.addStatements(rValues, a[7], (Property)r, new RDFNode[]{a[9]});
        this.addStatements(rValues, a[8], (Property)r, new RDFNode[]{a[10]});
        this.assertPropertyValues((Model)model, (Property)r, rValues);
        Model sValues = ModelFactory.createDefaultModel();
        this.addStatements(sValues, a[0], (Property)s, new RDFNode[]{a[1], a[2], a[3], a[4], a[5], a[6], a[8], a[10], a[12], a[14], a[16]});
        this.addStatements(sValues, a[7], (Property)s, new RDFNode[]{a[8], a[10], a[12]});
        this.addStatements(sValues, a[8], (Property)s, new RDFNode[]{a[11]});
        this.addStatements(sValues, a[9], (Property)s, new RDFNode[]{a[12]});
        this.addStatements(sValues, a[10], (Property)s, new RDFNode[]{a[11]});
        this.addStatements(sValues, a[13], (Property)s, new RDFNode[]{a[14]});
        this.addStatements(sValues, a[15], (Property)s, new RDFNode[]{a[16]});
        this.assertPropertyValues((Model)model, (Property)s, sValues);
    }

    public void testPropertyChainInverses() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "propertyChainInverses.owl");
        ObjectProperty p = model.getObjectProperty(ns + "p");
        ObjectProperty q = model.getObjectProperty(ns + "q");
        if (PelletOptions.USE_LOCAL_NAME) {
            ns = "";
        }
        int n = 8;
        Resource[] a = new Resource[n];
        for (int i = 0; i < n; ++i) {
            a[i] = model.getResource(ns + "a" + i);
        }
        Model pValues = ModelFactory.createDefaultModel();
        this.addStatements(pValues, a[0], (Property)p, new RDFNode[]{a[1], a[3], a[4]});
        this.addStatements(pValues, a[3], (Property)p, new RDFNode[]{a[4]});
        this.addStatements(pValues, a[6], (Property)p, new RDFNode[]{a[0], a[1], a[3], a[4]});
        this.addStatements(pValues, a[7], (Property)p, new RDFNode[]{a[6], a[0], a[1], a[3], a[4]});
        this.assertPropertyValues((Model)model, (Property)p, pValues);
        Model qValues = ModelFactory.createDefaultModel();
        this.addStatements(qValues, a[0], (Property)q, new RDFNode[]{a[2], a[5]});
        this.addStatements(qValues, a[3], (Property)q, new RDFNode[]{a[5]});
        this.addStatements(qValues, a[6], (Property)q, new RDFNode[]{a[2], a[5]});
        this.addStatements(qValues, a[7], (Property)q, new RDFNode[]{a[2], a[5]});
        this.assertPropertyValues((Model)model, (Property)q, qValues);
    }

    public void testPropertyChainValid() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "propertyChainValid.owl");
        ObjectProperty r = model.getObjectProperty(ns + "r");
        int n = 6;
        Resource[] a = new Resource[n];
        for (int i = 0; i < n; ++i) {
            a[i] = model.getResource(ns + "a" + i);
        }
        Model rValues = ModelFactory.createDefaultModel();
        this.addStatements(rValues, a[0], (Property)r, new RDFNode[]{a[3], a[5]});
        this.addStatements(rValues, a[1], (Property)r, new RDFNode[]{a[3], a[5]});
        this.addStatements(rValues, a[2], (Property)r, new RDFNode[]{a[3]});
        this.addStatements(rValues, a[4], (Property)r, new RDFNode[]{a[5]});
        this.assertPropertyValues((Model)model, (Property)r, rValues);
    }

    public void testPropertyChainInvalid() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "propertyChainInvalid.owl");
        model.prepare();
        KnowledgeBase kb = ((PelletInfGraph)model.getGraph()).getKB();
        for (Role r : kb.getRBox().getRoles()) {
            MiscTests.assertTrue((String)(r + " is not simple"), (boolean)r.isSimple());
            MiscTests.assertFalse((String)(r + " is transitive"), (boolean)r.isTransitive());
            MiscTests.assertFalse((String)(r + " has complex sub roles"), (boolean)r.hasComplexSubRole());
        }
    }

    public void testUncle() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "uncle.owl");
        Individual Bob = model.getIndividual(ns + "Bob");
        Individual Sam = model.getIndividual(ns + "Sam");
        Property uncleOf = model.getProperty(ns + "uncleOf");
        Model uncleValues = ModelFactory.createDefaultModel();
        this.addStatements(uncleValues, (Resource)Bob, uncleOf, new RDFNode[]{Sam});
        this.assertPropertyValues((Model)model, uncleOf, uncleValues);
    }

    public void testQualifiedCardinality1() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "qcr.owl");
        OntClass sub = model.getOntClass(ns + "sub");
        OntClass sup = model.getOntClass(ns + "sup");
        MiscTests.assertTrue((boolean)sub.hasSuperClass((Resource)sup));
        this.assertIteratorContains((Iterator)sub.listSuperClasses(), sup);
        this.assertIteratorContains((Iterator)sup.listSubClasses(), sub);
    }

    public void testQualifiedCardinality2() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl c = MiscTests.term("c");
        ATermAppl d = MiscTests.term("d");
        ATermAppl p = MiscTests.term("p");
        ATermAppl f = MiscTests.term("f");
        ATermAppl sub = MiscTests.term("sub");
        ATermAppl sup = MiscTests.term("sup");
        kb.addObjectProperty(p);
        kb.addObjectProperty(f);
        kb.addFunctionalProperty(f);
        kb.addClass(c);
        kb.addClass(d);
        kb.addClass(sub);
        kb.addClass(sup);
        kb.addSubClass(sub, sup);
        this.assertSatisfiable(kb, MiscTests.and(MiscTests.min(p, 2, MiscTests.and(c, d)), MiscTests.max(p, 2, c), MiscTests.some(p, MiscTests.or(MiscTests.and(c, MiscTests.not(d)), c))));
        this.assertSubClass(kb, MiscTests.min(p, 4, TOP), MiscTests.min(p, 2, TOP));
        this.assertNotSubClass(kb, MiscTests.min(p, 1, TOP), MiscTests.min(p, 2, TOP));
        this.assertNotSubClass(kb, MiscTests.min(p, 1, c), MiscTests.min(p, 1, d));
        this.assertNotSubClass(kb, MiscTests.and(MiscTests.some(p, c), MiscTests.some(p, MiscTests.not(c))), MiscTests.min(p, 2, d));
        this.assertSubClass(kb, MiscTests.min(p, 3, c), MiscTests.min(p, 2, c));
        this.assertSubClass(kb, MiscTests.min(p, 3, c), MiscTests.min(p, 2, TOP));
        this.assertSubClass(kb, MiscTests.min(p, 2, c), MiscTests.min(p, 2, TOP));
        this.assertNotSubClass(kb, MiscTests.min(p, 2, c), MiscTests.min(p, 2, d));
        this.assertSubClass(kb, MiscTests.min(p, 2, MiscTests.and(c, d)), MiscTests.some(p, c));
        this.assertSubClass(kb, MiscTests.max(p, 1, sup), MiscTests.max(p, 2, sub));
        this.assertSubClass(kb, MiscTests.and(MiscTests.max(f, 1, TOP), MiscTests.all(f, c)), MiscTests.max(f, 1, c));
        this.assertSubClass(kb, MiscTests.and(MiscTests.min(p, 2, c), MiscTests.min(p, 2, MiscTests.not(c))), MiscTests.min(p, 4, TOP));
    }

    public void testQualifiedCardinality3() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl c = MiscTests.term("z");
        ATermAppl d = MiscTests.term("d");
        ATermAppl e = MiscTests.term("e");
        ATermAppl notD = MiscTests.term("notD");
        ATermAppl p = MiscTests.term("p");
        ATermAppl x = MiscTests.term("x");
        ATermAppl y3 = MiscTests.term("y3");
        kb.addObjectProperty(p);
        kb.addClass(c);
        kb.addClass(d);
        kb.addClass(e);
        kb.addClass(notD);
        kb.addDisjointClass(d, notD);
        kb.addIndividual(x);
        kb.addIndividual(y3);
        kb.addType(x, MiscTests.and(MiscTests.min(p, 2, MiscTests.and(d, e)), MiscTests.max(p, 2, d)));
        kb.addType(y3, MiscTests.not(e));
        kb.addType(y3, MiscTests.some(MiscTests.inv(p), MiscTests.value(x)));
        kb.addType(y3, MiscTests.or(d, c));
        MiscTests.assertTrue((boolean)kb.isConsistent());
    }

    public void testInvalidTransitivity() {
        OntModel ont = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntClass C = ont.createClass("C");
        ObjectProperty p1 = ont.createObjectProperty("p1");
        p1.addRDFType(OWL.TransitiveProperty);
        ObjectProperty p2 = ont.createObjectProperty("p2");
        Individual x = ont.createIndividual(OWL.Thing);
        Individual y = ont.createIndividual(OWL.Thing);
        Individual z = ont.createIndividual(OWL.Thing);
        x.addRDFType((Resource)ont.createAllValuesFromRestriction(null, (Property)p1, (Resource)C));
        x.addProperty((Property)p1, (RDFNode)y);
        y.addProperty((Property)p1, (RDFNode)z);
        ont.prepare();
        OntModel pellet = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, (Model)ont);
        MiscTests.assertTrue((boolean)pellet.contains((Resource)y, RDF.type, (RDFNode)C));
        MiscTests.assertTrue((boolean)pellet.contains((Resource)z, RDF.type, (RDFNode)C));
        Statement[] statements = new Statement[]{ont.createStatement((Resource)p1, RDF.type, (RDFNode)OWL.FunctionalProperty), ont.createStatement((Resource)p1, RDF.type, (RDFNode)OWL.InverseFunctionalProperty), ont.createStatement((Resource)p1, RDF.type, (RDFNode)OWL_1_1.IrreflexiveProperty), ont.createStatement((Resource)p1, RDF.type, (RDFNode)OWL_1_1.AntisymmetricProperty), ont.createStatement((Resource)p1, OWL_1_1.disjointObjectProperties, (RDFNode)p2), ont.createStatement((Resource)C, RDFS.subClassOf, (RDFNode)ont.createMinCardinalityRestriction(null, (Property)p1, 2)), ont.createStatement((Resource)x, RDF.type, (RDFNode)ont.createMaxCardinalityRestriction(null, (Property)p1, 3)), ont.createStatement((Resource)C, OWL.disjointWith, (RDFNode)ont.createCardinalityRestriction(null, (Property)p1, 2))};
        for (int i = 0; i < statements.length; ++i) {
            ont.add(statements[i]);
            pellet = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, (Model)ont);
            MiscTests.assertTrue((String)statements[i].toString(), (boolean)pellet.contains((Resource)y, RDF.type, (RDFNode)C));
            MiscTests.assertFalse((String)statements[i].toString(), (boolean)pellet.contains((Resource)z, RDF.type, (RDFNode)C));
            ont.remove(statements[i]);
        }
    }

    public void testInvalidComplexSubRole() {
        OntModel ont = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntClass C = ont.createClass("C");
        ObjectProperty p1 = ont.createObjectProperty("p1");
        ObjectProperty p2 = ont.createObjectProperty("p2");
        RDFList pChain = ont.createList(new RDFNode[]{p1, p2});
        ont.add((Resource)pChain, RDFS.subPropertyOf, (RDFNode)p1);
        Individual x = ont.createIndividual(OWL.Thing);
        Individual y = ont.createIndividual(OWL.Thing);
        Individual z = ont.createIndividual(OWL.Thing);
        x.addProperty((Property)p1, (RDFNode)y);
        y.addProperty((Property)p2, (RDFNode)z);
        ont.prepare();
        OntModel pellet = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, (Model)ont);
        MiscTests.assertTrue((boolean)pellet.contains((Resource)x, (Property)p1, (RDFNode)y));
        MiscTests.assertTrue((boolean)pellet.contains((Resource)x, (Property)p1, (RDFNode)z));
        MinCardinalityRestriction min = ont.createMinCardinalityRestriction(null, (Property)p1, 2);
        MaxCardinalityRestriction max = ont.createMaxCardinalityRestriction(null, (Property)p1, 3);
        CardinalityRestriction card = ont.createCardinalityRestriction(null, (Property)p1, 2);
        Statement[] statements = new Statement[]{ont.createStatement((Resource)p1, RDF.type, (RDFNode)OWL.FunctionalProperty), ont.createStatement((Resource)p1, RDF.type, (RDFNode)OWL.InverseFunctionalProperty), ont.createStatement((Resource)p1, RDF.type, (RDFNode)OWL_1_1.IrreflexiveProperty), ont.createStatement((Resource)p1, RDF.type, (RDFNode)OWL_1_1.AntisymmetricProperty), ont.createStatement((Resource)p1, OWL_1_1.disjointObjectProperties, (RDFNode)p2), ont.createStatement((Resource)C, RDFS.subClassOf, (RDFNode)min), ont.createStatement((Resource)x, RDF.type, (RDFNode)max), ont.createStatement((Resource)C, OWL.disjointWith, (RDFNode)card)};
        for (int i = 0; i < statements.length; ++i) {
            ont.add(statements[i]);
            pellet = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, (Model)ont);
            MiscTests.assertTrue((String)statements[i].toString(), (boolean)pellet.contains((Resource)x, (Property)p1, (RDFNode)y));
            MiscTests.assertFalse((String)statements[i].toString(), (boolean)pellet.contains((Resource)x, (Property)p1, (RDFNode)z));
            ont.remove(statements[i]);
        }
    }

    public void testSelfRestrictions() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl c = MiscTests.term("c");
        ATermAppl d = MiscTests.term("d");
        ATermAppl p = MiscTests.term("p");
        kb.addClass(c);
        kb.addClass(d);
        kb.addObjectProperty(p);
        kb.addRange(p, d);
        kb.addSubClass(c, MiscTests.and(MiscTests.self(p), MiscTests.some(p, TOP)));
        MiscTests.assertTrue((boolean)kb.isConsistent());
        MiscTests.assertTrue((boolean)kb.isSatisfiable(c));
        MiscTests.assertTrue((boolean)kb.isSubClassOf(c, d));
    }

    public void testReflexive1() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl c = MiscTests.term("c");
        ATermAppl d = MiscTests.term("d");
        ATermAppl sub = MiscTests.term("sub");
        ATermAppl sup = MiscTests.term("sup");
        ATermAppl p = MiscTests.term("p");
        ATermAppl r = MiscTests.term("r");
        ATermAppl weakR = MiscTests.term("weakR");
        ATermAppl x = MiscTests.term("x");
        ATermAppl y = MiscTests.term("y");
        kb.addClass(c);
        kb.addClass(d);
        kb.addClass(sub);
        kb.addClass(sup);
        kb.addSubClass(sub, sup);
        kb.addSubClass(MiscTests.some(weakR, TOP), MiscTests.self(weakR));
        kb.addObjectProperty(p);
        kb.addObjectProperty(r);
        kb.addObjectProperty(weakR);
        kb.addReflexiveProperty(r);
        kb.addRange(r, d);
        kb.addIndividual(x);
        kb.addType(x, MiscTests.self(p));
        kb.addType(x, MiscTests.not(MiscTests.some(weakR, MiscTests.value(x))));
        kb.addIndividual(y);
        kb.addPropertyValue(weakR, y, x);
        MiscTests.assertTrue((boolean)kb.isConsistent());
        MiscTests.assertTrue((boolean)kb.isSubClassOf(MiscTests.and(c, MiscTests.self(p)), MiscTests.some(p, c)));
        MiscTests.assertTrue((boolean)kb.isSubClassOf(MiscTests.and(c, MiscTests.min(r, 1, MiscTests.not(c))), MiscTests.min(r, 2, TOP)));
        MiscTests.assertTrue((boolean)kb.isSubClassOf(MiscTests.min(r, 1, c), d));
        MiscTests.assertTrue((boolean)kb.hasPropertyValue(x, p, x));
        MiscTests.assertTrue((boolean)kb.hasPropertyValue(y, weakR, y));
        MiscTests.assertTrue((boolean)kb.isDifferentFrom(x, y));
        MiscTests.assertTrue((boolean)kb.isDifferentFrom(y, x));
        MiscTests.assertTrue((boolean)kb.isType(x, MiscTests.some(r, MiscTests.value(x))));
        MiscTests.assertTrue((boolean)kb.isSatisfiable(MiscTests.and(MiscTests.self(p), MiscTests.self(MiscTests.inv(p)), MiscTests.max(p, 1, TOP))));
    }

    public void testReflexive2() {
        String ns = "http://www.example.org/test#";
        String foaf = "http://xmlns.com/foaf/0.1/";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "reflexive.owl");
        ObjectProperty[] knows = new ObjectProperty[]{model.getObjectProperty(foaf + "knows"), model.getObjectProperty(ns + "knows2"), model.getObjectProperty(ns + "knows3")};
        Individual[] people = new Individual[5];
        for (int i = 0; i < people.length; ++i) {
            people[i] = model.getIndividual(ns + "P" + (i + 1));
            for (int j = 0; j < knows.length; ++j) {
                MiscTests.assertTrue((String)(people[i] + " " + knows[j]), (boolean)people[i].hasProperty((Property)knows[j], (RDFNode)people[i]));
                MiscTests.assertIteratorValues((Iterator)people[i].listPropertyValues((Property)knows[j]), new Resource[]{people[i]});
            }
        }
        Query query = QueryFactory.create((String)"PREFIX foaf: <http://xmlns.com/foaf/0.1/>SELECT * \nWHERE { ?p foaf:knows ?q } \n");
        List answers = this.createBindings(new String[]{"p", "q"}, new Resource[][]{{people[0], people[0]}, {people[1], people[1]}, {people[2], people[2]}, {people[3], people[3]}, {people[4], people[4]}});
        ResultSet results1 = new PelletQueryExecution(query, (Model)model).execSelect();
        this.testResultSet(results1, answers);
        ResultSet results2 = QueryExecutionFactory.create((Query)query, (Model)model).execSelect();
        this.testResultSet(results2, answers);
    }

    public void testAntisymmetry() {
        ATermAppl p = MiscTests.term("p");
        KnowledgeBase kb = new KnowledgeBase();
        kb.addObjectProperty(p);
        kb.addAntisymmetricProperty(p);
        MiscTests.assertTrue((boolean)kb.isIrreflexiveProperty(p));
    }

    public void testEscher1() {
        String ns = "foo://bla/names#";
        String source = "@prefix owl: <http://www.w3.org/2002/07/owl#>.\r\n@prefix owl11: <http://www.w3.org/2006/12/owl11#>.\r\n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>.\r\n@prefix : <foo://bla/names#>.\r\n\r\n:Corner owl:oneOf (:a :b :c);\r\n  rdfs:subClassOf\r\n  [a owl:Restriction; owl:onProperty :higher; owl:cardinality 1].\r\nowl:AllDifferent owl:distinctMembers (:a :b :c).\r\n:higher rdfs:domain :Corner; rdfs:range :Corner.\r\n:higher a owl:FunctionalProperty. ## redundant, note cardinality 1\r\n:higher a owl11:AntisymmetricProperty.\r\n:higher a owl11:IrreflexiveProperty.\r\n:a :higher :b.\r\n";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read((Reader)new StringReader(source), "", "N3");
        model.prepare();
        Resource a = model.getResource(ns + "a");
        Resource b = model.getResource(ns + "b");
        Resource c = model.getResource(ns + "c");
        OntProperty higher = model.getOntProperty(ns + "higher");
        MiscTests.assertIteratorValues((Iterator)model.listStatements(null, (Property)higher, (RDFNode)null), new Statement[]{model.createStatement(a, (Property)higher, (RDFNode)b), model.createStatement(b, (Property)higher, (RDFNode)c), model.createStatement(c, (Property)higher, (RDFNode)a)});
    }

    public void testEscher2() {
        String ns = "foo://bla/names#";
        String source = "@prefix owl: <http://www.w3.org/2002/07/owl#>.\r\n@prefix owl11: <http://www.w3.org/2006/12/owl11#>.\r\n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>.\r\n@prefix : <foo://bla/names#>.\r\n\r\n:Corner owl:oneOf (:a :b :c);\r\n  rdfs:subClassOf\r\n  [a owl:Restriction; owl:onProperty :higher; owl:cardinality 1].\r\nowl:AllDifferent owl:distinctMembers (:a :b :c).\r\n:higher rdfs:domain :Corner; rdfs:range :Corner.\r\n:higher a owl:FunctionalProperty. ## redundant, note cardinality 1\r\n:higher a owl11:AntisymmetricProperty.\r\n:higher a owl11:IrreflexiveProperty.\r\n:a :higher :b.\r\n:b :higher :d. :d a :Corner.\r\n:c a owl:Thing.\r\n";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read((Reader)new StringReader(source), "", "N3");
        model.prepare();
        Individual a = model.getIndividual(ns + "a");
        Individual b = model.getIndividual(ns + "b");
        Individual c = model.getIndividual(ns + "c");
        Individual d = model.getIndividual(ns + "d");
        OntProperty higher = model.getOntProperty(ns + "higher");
        MiscTests.assertIteratorValues((Iterator)model.listStatements(null, (Property)higher, (RDFNode)null), new Statement[]{model.createStatement((Resource)a, (Property)higher, (RDFNode)b), model.createStatement((Resource)b, (Property)higher, (RDFNode)c), model.createStatement((Resource)b, (Property)higher, (RDFNode)d), model.createStatement((Resource)c, (Property)higher, (RDFNode)a), model.createStatement((Resource)d, (Property)higher, (RDFNode)a)});
        MiscTests.assertTrue((boolean)c.isSameAs((Resource)d));
        MiscTests.assertTrue((boolean)d.isSameAs((Resource)c));
    }

    public void testDatatypeCardinality() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass C1 = model.createClass(ns + "C1");
        OntClass C2 = model.createClass(ns + "C2");
        DatatypeProperty p = model.createDatatypeProperty(ns + "p");
        p.addRange(XSD.xboolean);
        C1.addSuperClass((Resource)model.createMinCardinalityRestriction(null, (Property)p, 2));
        C2.addSuperClass((Resource)model.createMinCardinalityRestriction(null, (Property)p, 3));
        model.prepare();
        MiscTests.assertTrue((boolean)((PelletInfGraph)model.getGraph()).getKB().isConsistent());
        MiscTests.assertTrue((!model.contains((Resource)C1, RDFS.subClassOf, (RDFNode)OWL.Nothing) ? 1 : 0) != 0);
        MiscTests.assertTrue((boolean)model.contains((Resource)C2, RDFS.subClassOf, (RDFNode)OWL.Nothing));
    }

    public void testIFDP1() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        Individual a = model.createIndividual(ns + "a", OWL.Thing);
        Individual b = model.createIndividual(ns + "b", OWL.Thing);
        Individual c = model.createIndividual(ns + "c", OWL.Thing);
        ObjectProperty op = model.createObjectProperty(ns + "op");
        DatatypeProperty dp = model.createDatatypeProperty(ns + "dp");
        dp.convertToInverseFunctionalProperty();
        a.addProperty((Property)op, (RDFNode)c);
        Literal one = model.createTypedLiteral((Object)1);
        a.addProperty((Property)dp, (RDFNode)one);
        b.addProperty((Property)dp, (RDFNode)one);
        model.prepare();
        MiscTests.assertTrue((boolean)a.isSameAs((Resource)b));
        MiscTests.assertIteratorValues((Iterator)a.listSameAs(), new Resource[]{a, b});
        MiscTests.assertTrue((boolean)b.hasProperty((Property)op, (RDFNode)c));
        MiscTests.assertIteratorValues((Iterator)b.listPropertyValues((Property)op), new Resource[]{c});
    }

    public void testIFDP2() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.setStrictMode(false);
        DatatypeProperty p = model.createDatatypeProperty(ns + "p");
        p.addRDFType(OWL.InverseFunctionalProperty);
        p.addRange(XSD.xboolean);
        OntClass C = model.createClass(ns + "C");
        C.addSuperClass((Resource)model.createCardinalityRestriction(null, (Property)p, 1));
        OntClass D = model.createClass(ns + "D");
        OntClass E = model.createClass(ns + "E");
        D.addDisjointWith((Resource)E);
        Individual i1 = model.createIndividual(ns + "i1", (Resource)C);
        i1.addRDFType((Resource)D);
        Individual i2 = model.createIndividual(ns + "i2", (Resource)C);
        i2.addRDFType((Resource)D);
        Individual i3 = model.createIndividual(ns + "i3", (Resource)C);
        i3.addRDFType((Resource)E);
        model.prepare();
        MiscTests.assertTrue((boolean)i1.isSameAs((Resource)i2));
        MiscTests.assertIteratorValues((Iterator)i1.listSameAs(), new Resource[]{i1, i2});
        MiscTests.assertTrue((!i1.isSameAs((Resource)i3) ? 1 : 0) != 0);
        MiscTests.assertIteratorValues((Iterator)i1.listProperties((Property)p), new Resource[0]);
        MiscTests.assertIteratorValues((Iterator)i2.listProperties((Property)p), new Resource[0]);
        MiscTests.assertIteratorValues((Iterator)i3.listProperties((Property)p), new Resource[0]);
    }

    public void testIFDP3() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        DatatypeProperty dp = model.createDatatypeProperty(ns + "dp");
        dp.addRange(XSD.nonNegativeInteger);
        dp.convertToInverseFunctionalProperty();
        OntClass C = model.createClass(ns + "C");
        C.addSuperClass((Resource)model.createMinCardinalityRestriction(null, (Property)dp, 1));
        Individual a = model.createIndividual(ns + "a", (Resource)C);
        Individual b = model.createIndividual(ns + "b", (Resource)C);
        Individual c = model.createIndividual(ns + "c", (Resource)C);
        Literal zero = model.createTypedLiteral((Object)0);
        a.addProperty((Property)dp, (RDFNode)zero);
        b.addRDFType((Resource)model.createAllValuesFromRestriction(null, (Property)dp, XSD.nonPositiveInteger));
        Literal one = model.createTypedLiteral((Object)1);
        c.addProperty((Property)dp, (RDFNode)one);
        model.prepare();
        MiscTests.assertTrue((boolean)a.isSameAs((Resource)b));
        MiscTests.assertTrue((boolean)b.isSameAs((Resource)a));
        MiscTests.assertIteratorValues((Iterator)a.listSameAs(), new Resource[]{a, b});
        MiscTests.assertIteratorValues((Iterator)b.listSameAs(), new Resource[]{a, b});
        MiscTests.assertTrue((!c.isSameAs((Resource)a) ? 1 : 0) != 0);
        MiscTests.assertTrue((!c.isSameAs((Resource)b) ? 1 : 0) != 0);
    }

    public void testResrictedDataRange() {
        byte MIN = 0;
        byte MAX = 127;
        int COUNT = MAX - MIN + 1;
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = MiscTests.term("C");
        ATermAppl D = MiscTests.term("D");
        ATermAppl E = MiscTests.term("E");
        ATermAppl datatype = MiscTests.term("datatype");
        ATermAppl p = MiscTests.term("p");
        ATermAppl x = MiscTests.term("x");
        ATermAppl y = MiscTests.term("y");
        kb.addClass(C);
        kb.addClass(D);
        kb.addClass(E);
        kb.addDatatype(datatype.getName(), XSDInteger.instance.restrictMinInclusive(new Byte(MIN)).restrictMaxInclusive(new Byte(MAX)));
        kb.addDatatypeProperty(p);
        kb.addRange(p, datatype);
        kb.addSubClass(C, MiscTests.card(p, COUNT + 1, ATermUtils.TOP_LIT));
        kb.addSubClass(D, MiscTests.card(p, COUNT, ATermUtils.TOP_LIT));
        kb.addSubClass(E, MiscTests.card(p, COUNT - 1, ATermUtils.TOP_LIT));
        kb.addIndividual(x);
        kb.addType(x, D);
        kb.addIndividual(y);
        kb.addType(y, E);
        MiscTests.assertFalse((boolean)kb.isSatisfiable(C));
        MiscTests.assertTrue((boolean)kb.isSatisfiable(D));
        MiscTests.assertTrue((boolean)kb.isSatisfiable(E));
        MiscTests.assertTrue((boolean)kb.hasPropertyValue(x, p, ATermUtils.makeTypedLiteral("5", XSDInteger.instance.getURI())));
        MiscTests.assertFalse((boolean)kb.hasPropertyValue(y, p, ATermUtils.makeTypedLiteral("5", XSDDecimal.instance.getURI())));
    }

    public void testDuplicateLiterals() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        DatatypeProperty dp = model.createDatatypeProperty(ns + "dp");
        OntClass C = model.createClass(ns + "C");
        Individual a = model.createIndividual(ns + "a", (Resource)C);
        Literal one = model.createTypedLiteral("1", TypeMapper.getInstance().getTypeByName(XSD.positiveInteger.getURI()));
        a.addProperty((Property)dp, (RDFNode)one);
        model.prepare();
        MiscTests.assertIteratorValues((Iterator)a.listPropertyValues((Property)dp), new Literal[]{one});
    }

    public void testClosedUniverse() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "ClosedUniverse.owl");
        model.prepare();
        OntClass Unsat = model.getOntClass(ns + "Unsat");
        MiscTests.assertTrue((boolean)Unsat.hasSuperClass(OWL.Nothing));
    }

    public void test3Sat() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "3Sat.owl");
        String solution = "101";
        int n = solution.length();
        Individual T = model.getIndividual(ns + "T");
        Individual F = model.getIndividual(ns + "F");
        model.prepare();
        MiscTests.assertTrue((boolean)((PelletInfGraph)model.getGraph()).getKB().isConsistent());
        Object[] positives = new Individual[n + 1];
        Object[] negatives = new Individual[n + 1];
        positives[0] = T;
        negatives[0] = F;
        for (int i = 1; i <= n; ++i) {
            boolean t;
            boolean bl = t = solution.charAt(i - 1) == '1';
            if (t) {
                positives[i] = model.getIndividual(ns + "plus" + i);
                negatives[i] = model.getIndividual(ns + "minus" + i);
            } else {
                positives[i] = model.getIndividual(ns + "minus" + i);
                negatives[i] = model.getIndividual(ns + "plus" + i);
            }
            TestCase.assertTrue((String)(T + " = " + positives[i]), (boolean)T.isSameAs((Resource)positives[i]));
            TestCase.assertTrue((String)(F + " = " + negatives[i]), (boolean)F.isSameAs((Resource)negatives[i]));
        }
        MiscTests.assertIteratorValues((Iterator)T.listSameAs(), positives);
        MiscTests.assertIteratorValues((Iterator)F.listSameAs(), negatives);
    }

    public void testPropertyRestrictionsInSuperclasses() {
        String ns = "urn:test:";
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)new PelletReasoner());
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        OntClass X = model.createClass(ns + "X");
        ObjectProperty hasX = model.createObjectProperty(ns + "hasX");
        AllValuesFromRestriction AllX = model.createAllValuesFromRestriction(null, (Property)hasX, (Resource)X);
        IntersectionClass Y = model.createIntersectionClass(ns + "Y", model.createList(new RDFNode[]{X, AllX}));
        MiscTests.assertTrue((String)"AllX is not a superclass of Y", (boolean)Y.hasSuperClass((Resource)AllX));
    }

    public void testListStatementsDifferentFrom() {
        String ns = "http://www.example.org/test#";
        OntModel ont = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, null);
        InverseFunctionalProperty p = ont.createInverseFunctionalProperty(ns + "p1", true);
        Individual s1 = ont.createIndividual(ns + "s1", OWL.Thing);
        Individual s2 = ont.createIndividual(ns + "s2", OWL.Thing);
        s1.addDifferentFrom((Resource)s2);
        Individual o1 = ont.createIndividual(ns + "o1", OWL.Thing);
        Individual o2 = ont.createIndividual(ns + "o2", OWL.Thing);
        s1.addProperty((Property)p, (RDFNode)o1);
        s2.addProperty((Property)p, (RDFNode)o2);
        Model values = ModelFactory.createDefaultModel();
        this.addStatements(values, (Resource)s1, OWL.differentFrom, new RDFNode[]{s2});
        this.addStatements(values, (Resource)s2, OWL.differentFrom, new RDFNode[]{s1});
        this.addStatements(values, (Resource)o1, OWL.differentFrom, new RDFNode[]{o2});
        this.addStatements(values, (Resource)o2, OWL.differentFrom, new RDFNode[]{o1});
        this.assertPropertyValues((Model)ont, OWL.differentFrom, values);
    }

    public void testListStatementsSameAs() {
        String ns = "http://www.example.org/test#";
        OntModel ont = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, null);
        ObjectProperty p = ont.createObjectProperty(ns + "p", true);
        Individual s = ont.createIndividual(ns + "s", OWL.Thing);
        Individual o1 = ont.createIndividual(ns + "o1", OWL.Thing);
        Individual o2 = ont.createIndividual(ns + "o2", OWL.Thing);
        s.addProperty((Property)p, (RDFNode)o1);
        s.addProperty((Property)p, (RDFNode)o2);
        ont.prepare();
        Model values = ModelFactory.createDefaultModel();
        this.addStatements(values, (Resource)s, OWL.sameAs, new RDFNode[]{s});
        this.addStatements(values, (Resource)o1, OWL.sameAs, new RDFNode[]{o1, o2});
        this.addStatements(values, (Resource)o2, OWL.sameAs, new RDFNode[]{o1, o2});
        this.assertPropertyValues((Model)ont, OWL.sameAs, values);
    }

    public void testMaxCardinality() {
        KnowledgeBase kb = new KnowledgeBase();
        kb.addObjectProperty(MiscTests.term("p"));
        kb.addObjectProperty(MiscTests.term("q"));
        kb.addFunctionalProperty(MiscTests.term("q"));
        kb.addClass(MiscTests.term("C"));
        kb.addSubClass(MiscTests.term("C"), ATermUtils.makeMax((ATerm)MiscTests.term("p"), 2, (ATerm)ATermUtils.TOP));
        kb.addClass(MiscTests.term("D1"));
        kb.addClass(MiscTests.term("D2"));
        kb.addClass(MiscTests.term("D3"));
        kb.addClass(MiscTests.term("D4"));
        kb.addClass(MiscTests.term("E1"));
        kb.addClass(MiscTests.term("E2"));
        kb.addClass(MiscTests.term("E3"));
        kb.addClass(MiscTests.term("E4"));
        kb.addSubClass(MiscTests.term("D1"), ATermUtils.makeSomeValues(MiscTests.term("q"), MiscTests.term("E1")));
        kb.addSubClass(MiscTests.term("D2"), ATermUtils.makeSomeValues(MiscTests.term("q"), MiscTests.term("E2")));
        kb.addSubClass(MiscTests.term("D3"), ATermUtils.makeSomeValues(MiscTests.term("q"), MiscTests.term("E3")));
        kb.addSubClass(MiscTests.term("D4"), ATermUtils.makeSomeValues(MiscTests.term("q"), MiscTests.term("E4")));
        kb.addIndividual(MiscTests.term("x"));
        kb.addType(MiscTests.term("x"), MiscTests.term("C"));
        kb.addIndividual(MiscTests.term("x1"));
        kb.addType(MiscTests.term("x1"), MiscTests.term("D1"));
        kb.addIndividual(MiscTests.term("x2"));
        kb.addType(MiscTests.term("x2"), MiscTests.term("D2"));
        kb.addIndividual(MiscTests.term("x3"));
        kb.addType(MiscTests.term("x3"), MiscTests.term("D3"));
        kb.addIndividual(MiscTests.term("x4"));
        kb.addType(MiscTests.term("x4"), MiscTests.term("D4"));
        kb.addPropertyValue(MiscTests.term("p"), MiscTests.term("x"), MiscTests.term("x1"));
        kb.addPropertyValue(MiscTests.term("p"), MiscTests.term("x"), MiscTests.term("x2"));
        kb.addPropertyValue(MiscTests.term("p"), MiscTests.term("x"), MiscTests.term("x3"));
        kb.addPropertyValue(MiscTests.term("p"), MiscTests.term("x"), MiscTests.term("x4"));
        kb.addDisjointClass(MiscTests.term("E1"), MiscTests.term("E2"));
        kb.addDisjointClass(MiscTests.term("E1"), MiscTests.term("E4"));
        kb.addDisjointClass(MiscTests.term("E2"), MiscTests.term("E3"));
        MiscTests.assertTrue((boolean)kb.isConsistent());
        MiscTests.assertTrue((boolean)kb.isSameAs(MiscTests.term("x1"), MiscTests.term("x3")));
        MiscTests.assertTrue((boolean)kb.isSameAs(MiscTests.term("x3"), MiscTests.term("x1")));
        MiscTests.assertTrue((boolean)kb.isSameAs(MiscTests.term("x2"), MiscTests.term("x4")));
        MiscTests.assertTrue((boolean)kb.getSames(MiscTests.term("x1")).contains(MiscTests.term("x3")));
        MiscTests.assertTrue((boolean)kb.getSames(MiscTests.term("x2")).contains(MiscTests.term("x4")));
    }

    public void testAnonTypes() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass c = model.createClass(ns + "C");
        Individual anon = model.createIndividual((Resource)c);
        Individual x = model.createIndividual(ns + "x", (Resource)c);
        MiscTests.assertIteratorValues((Iterator)model.listObjectsOfProperty((Resource)x, RDF.type), new Resource[]{OWL.Thing, c});
        MiscTests.assertIteratorValues((Iterator)model.listObjectsOfProperty((Resource)anon, RDF.type), new Resource[]{OWL.Thing, c});
    }

    public void testAnonInverse() throws OWLException {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "anon_inverse.owl");
        model.prepare();
        ((PelletInfGraph)model.getGraph()).getKB().getRoleTaxonomy().getTop().print();
        OntClass C = model.getOntClass(ns + "C");
        OntClass D = model.getOntClass(ns + "D");
        ObjectProperty r = model.getObjectProperty(ns + "r");
        OntModel posit = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        Resource invR = posit.createResource();
        invR.addProperty(OWL.inverseOf, (RDFNode)r);
        Resource restr = posit.createResource();
        restr.addProperty(OWL.onProperty, (RDFNode)invR);
        restr.addProperty(OWL.someValuesFrom, (RDFNode)D);
        MiscTests.assertTrue((boolean)model.listStatements((Resource)C, RDFS.subClassOf, (RDFNode)restr, (Model)posit).hasNext());
        MiscTests.assertTrue((boolean)model.contains((Resource)model.getProperty(ns + "functionalP"), RDF.type, (RDFNode)OWL.InverseFunctionalProperty));
        MiscTests.assertTrue((boolean)model.contains((Resource)model.getProperty(ns + "inverseFunctionalP"), RDF.type, (RDFNode)OWL.FunctionalProperty));
        MiscTests.assertTrue((boolean)model.contains((Resource)model.getProperty(ns + "transitiveP"), RDF.type, (RDFNode)OWL.TransitiveProperty));
        MiscTests.assertTrue((boolean)model.contains((Resource)model.getProperty(ns + "symmetricP"), RDF.type, (RDFNode)OWL.SymmetricProperty));
        MiscTests.assertTrue((boolean)model.contains((Resource)model.getProperty(ns + "reflexiveP"), RDF.type, (RDFNode)OWL_1_1.ReflexiveProperty));
        MiscTests.assertTrue((boolean)model.contains((Resource)model.getProperty(ns + "irreflexiveP"), RDF.type, (RDFNode)OWL_1_1.IrreflexiveProperty));
        MiscTests.assertTrue((boolean)model.contains((Resource)model.getProperty(ns + "antiSymmetricP"), RDF.type, (RDFNode)OWL_1_1.AntisymmetricProperty));
        ObjectProperty p1 = model.getObjectProperty(ns + "p1");
        ObjectProperty p2 = model.getObjectProperty(ns + "p2");
        MiscTests.assertTrue((boolean)model.contains((Resource)p1, OWL.equivalentProperty, (RDFNode)p2));
    }

    public void testAnonClasses() {
        OntModel ontmodel = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        String nc = "urn:test:";
        OntClass class1 = ontmodel.createClass(nc + "C1");
        OntClass class2 = ontmodel.createClass(nc + "C2");
        Individual[] inds = new Individual[6];
        for (int j = 0; j < 6; ++j) {
            inds[j] = ontmodel.createIndividual(nc + "Ind" + j, OWL.Thing);
        }
        inds[0].addRDFType((Resource)class1);
        inds[1].addRDFType((Resource)class1);
        inds[2].addRDFType((Resource)class1);
        inds[3].addRDFType((Resource)class1);
        inds[2].addRDFType((Resource)class2);
        inds[3].addRDFType((Resource)class2);
        inds[4].addRDFType((Resource)class2);
        inds[5].addRDFType((Resource)class2);
        MiscTests.assertIteratorValues((Iterator)class1.listInstances(), new Resource[]{inds[0], inds[1], inds[2], inds[3]});
        MiscTests.assertIteratorValues((Iterator)class2.listInstances(), new Resource[]{inds[2], inds[3], inds[4], inds[5]});
        RDFList list = ontmodel.createList(new RDFNode[]{class1, class2});
        IntersectionClass class3 = ontmodel.createIntersectionClass(null, list);
        UnionClass class4 = ontmodel.createUnionClass(null, list);
        MiscTests.assertIteratorValues((Iterator)class3.listInstances(), new Resource[]{inds[2], inds[3]});
        MiscTests.assertIteratorValues((Iterator)class4.listInstances(), new Resource[]{inds[0], inds[1], inds[2], inds[3], inds[4], inds[5]});
    }

    public void testDelete() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel();
        OntClass A = model.createClass(ns + "A");
        ObjectProperty P = model.createObjectProperty(ns + "P");
        P.addDomain((Resource)A);
        Individual x = model.createIndividual(ns + "x", OWL.Thing);
        Individual y = model.createIndividual(ns + "y", OWL.Thing);
        x.addProperty((Property)P, (RDFNode)y);
        MiscTests.assertTrue((boolean)x.hasRDFType((Resource)A));
        x.removeRDFType((Resource)A);
        MiscTests.assertTrue((boolean)x.hasRDFType((Resource)A));
    }

    public void testDeclaredProperties() {
        String ns = "urn:test:";
        Reasoner r = PelletReasonerFactory.theInstance().create();
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner(r);
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        OntClass A = model.createClass(ns + "A");
        OntClass B = model.createClass(ns + "B");
        ObjectProperty P = model.createObjectProperty(ns + "P");
        P.addDomain((Resource)model.createUnionClass(null, model.createList(new RDFNode[]{A, B})));
        OntClass oc = model.getOntClass(ns + "B");
        MiscTests.assertIteratorValues((Iterator)oc.listDeclaredProperties(), new Resource[]{P});
    }

    public void testDifferentFrom1() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass C = model.createClass(ns + "C");
        OntClass D = model.createClass(ns + "D");
        Individual a = model.createIndividual(ns + "a", (Resource)C);
        Individual b = model.createIndividual(ns + "b", (Resource)C);
        Individual c = model.createIndividual(ns + "c", (Resource)D);
        Individual d = model.createIndividual(ns + "d", OWL.Thing);
        ObjectProperty p = model.createObjectProperty(ns + "p");
        C.addDisjointWith((Resource)D);
        a.addProperty((Property)p, (RDFNode)b);
        d.addRDFType((Resource)model.createAllValuesFromRestriction(null, (Property)p, OWL.Nothing));
        model.prepare();
        MiscTests.assertIteratorValues((Iterator)a.listDifferentFrom(), new Resource[]{c, d});
        MiscTests.assertIteratorValues((Iterator)model.listSubjectsWithProperty(OWL.differentFrom, (RDFNode)a), new Resource[]{c, d});
        MiscTests.assertIteratorValues((Iterator)b.listDifferentFrom(), new Resource[]{c});
        MiscTests.assertIteratorValues((Iterator)model.listSubjectsWithProperty(OWL.differentFrom, (RDFNode)b), new Resource[]{c});
    }

    public void testDifferentFrom2() {
        KnowledgeBase kb = new KnowledgeBase();
        kb.addClass(MiscTests.term("C"));
        kb.addClass(MiscTests.term("D"));
        kb.addDisjointClass(MiscTests.term("C"), MiscTests.term("D"));
        kb.addIndividual(MiscTests.term("a"));
        kb.addType(MiscTests.term("a"), MiscTests.term("C"));
        kb.addIndividual(MiscTests.term("b"));
        kb.addType(MiscTests.term("b"), MiscTests.term("D"));
        kb.classify();
        MiscTests.assertTrue((boolean)kb.getDifferents(MiscTests.term("a")).contains(MiscTests.term("b")));
        MiscTests.assertTrue((boolean)kb.getDifferents(MiscTests.term("b")).contains(MiscTests.term("a")));
    }

    public void testSameAs1() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        Individual a = model.createIndividual(ns + "a", OWL.Thing);
        Individual b = model.createIndividual(ns + "b", OWL.Thing);
        Individual c = model.createIndividual(ns + "c", OWL.Thing);
        ObjectProperty p = model.createObjectProperty(ns + "p");
        ObjectProperty q = model.createObjectProperty(ns + "q");
        a.addProperty((Property)p, (RDFNode)c);
        b.addProperty((Property)p, (RDFNode)b);
        c.addProperty((Property)q, (RDFNode)a);
        c.addSameAs((Resource)b);
        a.addProperty((Property)q, (RDFNode)c);
        model.prepare();
        MiscTests.assertIteratorValues((Iterator)a.listPropertyValues((Property)p), new Resource[]{b, c});
        MiscTests.assertIteratorValues((Iterator)a.listPropertyValues((Property)q), new Resource[]{b, c});
        MiscTests.assertIteratorValues((Iterator)b.listPropertyValues((Property)p), new Resource[]{b, c});
        MiscTests.assertIteratorValues((Iterator)b.listPropertyValues((Property)q), new Resource[]{a});
        MiscTests.assertIteratorValues((Iterator)c.listPropertyValues((Property)p), new Resource[]{b, c});
        MiscTests.assertIteratorValues((Iterator)c.listPropertyValues((Property)q), new Resource[]{a});
    }

    public void testSameAs2() {
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM_RULE_INF);
        ontModelSpec.setReasoner((Reasoner)new PelletReasoner());
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)ontModelSpec);
        Individual i1 = model.createIndividual("http://test#i1", OWL.Thing);
        Individual i2 = model.createIndividual("http://test#i2", OWL.Thing);
        Property prop = model.createProperty("http://test#prop");
        i1.addProperty(prop, "test");
        i1.addSameAs((Resource)i2);
        MiscTests.assertTrue((boolean)i1.isSameAs((Resource)i2));
        MiscTests.assertTrue((boolean)i2.isSameAs((Resource)i1));
        MiscTests.assertTrue((boolean)i1.hasProperty(prop, "test"));
        this.assertIteratorContains((Iterator)i1.listProperties(), model.createStatement((Resource)i1, prop, "test"));
        MiscTests.assertTrue((boolean)i2.hasProperty(prop, "test"));
        this.assertIteratorContains((Iterator)i2.listProperties(), model.createStatement((Resource)i2, prop, "test"));
    }

    public void testSameAs3() {
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM_RULE_INF);
        ontModelSpec.setReasoner((Reasoner)new PelletReasoner());
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)ontModelSpec);
        Individual i1 = model.createIndividual("http://test#i1", OWL.Thing);
        Individual i2 = model.createIndividual("http://test#i2", OWL.Thing);
        EnumeratedClass c = model.createEnumeratedClass("http://test#C", model.createList(new RDFNode[]{i1, i2}));
        Individual i3 = model.createIndividual("http://test#i3", (Resource)c);
        MiscTests.assertTrue((!i1.isSameAs((Resource)i2) ? 1 : 0) != 0);
        MiscTests.assertTrue((!i1.isSameAs((Resource)i3) ? 1 : 0) != 0);
        MiscTests.assertIteratorValues((Iterator)i1.listSameAs(), new Resource[]{i1});
        MiscTests.assertTrue((!i2.isSameAs((Resource)i1) ? 1 : 0) != 0);
        MiscTests.assertTrue((!i2.isSameAs((Resource)i3) ? 1 : 0) != 0);
        MiscTests.assertIteratorValues((Iterator)i2.listSameAs(), new Resource[]{i2});
        MiscTests.assertTrue((!i3.isSameAs((Resource)i1) ? 1 : 0) != 0);
        MiscTests.assertTrue((!i3.isSameAs((Resource)i2) ? 1 : 0) != 0);
        MiscTests.assertIteratorValues((Iterator)i3.listSameAs(), new Resource[]{i3});
    }

    public void testSudaku() {
        String ns = "http://sudoku.owl#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "sudaku.owl");
        OntClass[][] C = new OntClass[4][4];
        Individual[][] V = new Individual[4][4];
        Individual[] N = new Individual[4];
        for (int i = 1; i < 4; ++i) {
            N[i] = model.getIndividual(ns + i);
            for (int j = 1; j < 4; ++j) {
                V[i][j] = model.getIndividual(ns + "V" + i + j);
                C[i][j] = model.getOntClass(ns + "C" + i + j);
            }
        }
        V[2][1].setSameAs((Resource)N[2]);
        V[1][2].setSameAs((Resource)N[3]);
        Individual[][] eq = new Individual[][]{{V[1][1], V[2][2], V[3][3], N[1]}, {V[1][3], V[2][1], V[3][2], N[2]}, {V[1][2], V[2][3], V[3][1], N[3]}};
        for (int k = 0; k < 3; ++k) {
            for (int i = 0; i < 4; ++i) {
                Individual ind = eq[k][i];
                for (int j = 0; j < 4; ++j) {
                    MiscTests.assertTrue((boolean)ind.isSameAs((Resource)eq[k][j]));
                }
                MiscTests.assertIteratorValues((Iterator)ind.listSameAs(), eq[k]);
            }
        }
    }

    public void testFuncProp() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        Individual a = model.createIndividual(ns + "a", OWL.Thing);
        Individual b = model.createIndividual(ns + "b", OWL.Thing);
        Individual c = model.createIndividual(ns + "c", OWL.Thing);
        Individual d = model.createIndividual(ns + "d", OWL.Thing);
        ObjectProperty p = model.createObjectProperty(ns + "p");
        a.addProperty((Property)p, (RDFNode)b);
        ObjectProperty q = model.createObjectProperty(ns + "q", true);
        a.addProperty((Property)q, (RDFNode)b);
        a.addProperty((Property)q, (RDFNode)d);
        c.addSameAs((Resource)b);
        MiscTests.assertIteratorValues((Iterator)a.listPropertyValues((Property)p), new Resource[]{b, c, d});
        Model values = ModelFactory.createDefaultModel();
        this.addStatements(values, (Resource)a, OWL.sameAs, new RDFNode[]{a});
        this.addStatements(values, (Resource)b, OWL.sameAs, new RDFNode[]{b, c, d});
        this.addStatements(values, (Resource)c, OWL.sameAs, new RDFNode[]{b, c, d});
        this.addStatements(values, (Resource)d, OWL.sameAs, new RDFNode[]{b, c, d});
        this.assertPropertyValues((Model)model, OWL.sameAs, values);
    }

    public void testHasValueReasoning() {
        String ns = "urn:test:";
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)new PelletReasoner());
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        OntClass HomeOwner = model.createClass(ns + "HomeOwner");
        Individual bob = model.createIndividual(ns + "bob", (Resource)HomeOwner);
        ObjectProperty hasNeighbor = model.createObjectProperty(ns + "hasNeighbor");
        OntClass NeighborOfBob = model.createClass(ns + "NeighborOfBob");
        NeighborOfBob.addEquivalentClass((Resource)model.createHasValueRestriction(null, (Property)hasNeighbor, (RDFNode)bob));
        Individual susan = model.createIndividual(ns + "susan", (Resource)HomeOwner);
        susan.setPropertyValue((Property)hasNeighbor, (RDFNode)bob);
        MiscTests.assertTrue((String)"susan is not a NeighborOfBob", (boolean)susan.hasRDFType((Resource)NeighborOfBob));
    }

    public void testInfiniteChain() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "infiniteChain.owl");
        model.prepare();
        MiscTests.assertFalse((boolean)((PelletInfGraph)model.getGraph()).getKB().isConsistent());
        String ns = "http://www.example.org/test#";
        OntProperty prop = model.getOntProperty(ns + "ssn");
        prop.removeRange((Resource)prop.getRange());
        model.prepare();
        MiscTests.assertTrue((boolean)((PelletInfGraph)model.getGraph()).getKB().isConsistent());
    }

    public void testInfiniteChainDP() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "infiniteChainDP.owl");
        model.prepare();
        MiscTests.assertFalse((boolean)((PelletInfGraph)model.getGraph()).getKB().isConsistent());
        String ns = "http://www.example.org/test#";
        DatatypeProperty prop = model.getDatatypeProperty(ns + "ssn");
        prop.removeRange((Resource)prop.getRange());
        MiscTests.assertTrue((boolean)model.validate().isValid());
    }

    public void testParents() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "parents.owl");
        Individual Bob = model.getIndividual(ns + "Bob");
        Individual Mom = model.getIndividual(ns + "Mom");
        Individual Dad = model.getIndividual(ns + "Dad");
        ObjectProperty hasParent = model.getObjectProperty(ns + "hasParent");
        ObjectProperty hasFather = model.getObjectProperty(ns + "hasFather");
        ObjectProperty hasMother = model.getObjectProperty(ns + "hasMother");
        model.prepare();
        MiscTests.assertTrue((boolean)((PelletInfGraph)model.getGraph()).getKB().isConsistent());
        MiscTests.assertIteratorValues((Iterator)model.listObjectsOfProperty((Resource)Bob, (Property)hasParent), new Resource[]{Mom, Dad});
        MiscTests.assertIteratorValues((Iterator)model.listObjectsOfProperty((Property)hasFather), new Object[]{Dad});
        MiscTests.assertIteratorValues((Iterator)model.listObjectsOfProperty((Property)hasMother), new Object[]{Mom});
        MiscTests.assertIteratorValues((Iterator)model.listStatements(null, (Property)hasParent, (RDFNode)((Resource)null)), new Statement[]{ResourceFactory.createStatement((Resource)Bob, (Property)hasParent, (RDFNode)Mom), ResourceFactory.createStatement((Resource)Bob, (Property)hasParent, (RDFNode)Dad)});
        MiscTests.assertIteratorValues((Iterator)model.listStatements((Resource)Bob, null, (RDFNode)Dad), new Statement[]{ResourceFactory.createStatement((Resource)Bob, (Property)hasParent, (RDFNode)Dad), ResourceFactory.createStatement((Resource)Bob, (Property)hasFather, (RDFNode)Dad)});
        MiscTests.assertIteratorValues((Iterator)model.listObjectsOfProperty((Resource)Bob, (Property)hasFather), new Resource[]{Dad});
        MiscTests.assertIteratorValues((Iterator)model.listObjectsOfProperty((Resource)Bob, (Property)hasMother), new Resource[]{Mom});
    }

    public void testTeams() {
        String ns = "http://owl.man.ac.uk/2005/sssw/teams#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "teams.owl");
        Individual t1 = model.getIndividual(ns + "OntologyFC");
        OntClass Male = model.getOntClass(ns + "Male");
        OntClass Female = model.getOntClass(ns + "Female");
        Individual Sam = model.getIndividual(ns + "Sam");
        Individual Chris = model.getIndividual(ns + "Chris");
        OntClass Team = model.getOntClass(ns + "Team");
        OntClass MixedTeam = model.getOntClass(ns + "MixedTeam");
        OntClass NonSingletonTeam = model.getOntClass(ns + "NonSingletonTeam");
        OntClass SingletonTeam = model.getOntClass(ns + "SingletonTeam");
        model.prepare();
        MiscTests.assertTrue((boolean)Sam.isDifferentFrom((Resource)Chris));
        MiscTests.assertTrue((boolean)Chris.isDifferentFrom((Resource)Sam));
        MiscTests.assertTrue((boolean)MixedTeam.hasSuperClass((Resource)Team));
        MiscTests.assertFalse((boolean)MixedTeam.hasSuperClass((Resource)SingletonTeam));
        MiscTests.assertIteratorValues((Iterator)MixedTeam.listSuperClasses(), new Resource[]{Team, NonSingletonTeam, OWL.Thing});
        MiscTests.assertTrue((boolean)NonSingletonTeam.hasSubClass((Resource)MixedTeam));
        MiscTests.assertIteratorValues((Iterator)NonSingletonTeam.listSubClasses(), new Resource[]{MixedTeam, OWL.Nothing});
        MiscTests.assertTrue((boolean)t1.hasRDFType((Resource)MixedTeam));
        MiscTests.assertTrue((boolean)t1.hasRDFType((Resource)MixedTeam, true));
        MiscTests.assertIteratorValues((Iterator)t1.listRDFTypes(false), new Resource[]{Team, NonSingletonTeam, MixedTeam, OWL.Thing});
        Male.removeDisjointWith((Resource)Female);
        Female.removeDisjointWith((Resource)Male);
        Sam.removeDifferentFrom((Resource)Chris);
        Chris.removeDifferentFrom((Resource)Sam);
        MiscTests.assertTrue((!Sam.isDifferentFrom((Resource)Chris) ? 1 : 0) != 0);
        MiscTests.assertTrue((!Chris.isDifferentFrom((Resource)Sam) ? 1 : 0) != 0);
        MiscTests.assertTrue((boolean)MixedTeam.hasSuperClass((Resource)Team));
        MiscTests.assertIteratorValues((Iterator)MixedTeam.listSuperClasses(), new Resource[]{Team, OWL.Thing});
        MiscTests.assertTrue((!NonSingletonTeam.hasSuperClass((Resource)MixedTeam) ? 1 : 0) != 0);
        MiscTests.assertIteratorValues((Iterator)NonSingletonTeam.listSuperClasses(), new Resource[]{Team, OWL.Thing});
        MiscTests.assertTrue((boolean)t1.hasRDFType((Resource)MixedTeam));
        MiscTests.assertTrue((boolean)t1.hasRDFType((Resource)MixedTeam, true));
        MiscTests.assertIteratorValues((Iterator)t1.listRDFTypes(false), new Resource[]{Team, MixedTeam, OWL.Thing});
    }

    public void testPropertyAssertions2() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass Person = model.createClass(ns + "Person");
        ObjectProperty hasFather = model.createObjectProperty(ns + "hasFather");
        ObjectProperty hasBioFather = model.createObjectProperty(ns + "hasBioFather", true);
        hasBioFather.addSuperProperty((Property)hasFather);
        Person.addSuperClass((Resource)model.createMinCardinalityRestriction(null, (Property)hasBioFather, 1));
        Individual Bob = model.createIndividual(ns + "Bob", (Resource)Person);
        Individual Dad = model.createIndividual(ns + "Dad", (Resource)Person);
        Bob.addProperty((Property)hasBioFather, (RDFNode)Dad);
        Bob.addRDFType((Resource)model.createCardinalityRestriction(null, (Property)hasFather, 1));
        model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, (Model)model);
        MiscTests.assertIteratorValues((Iterator)model.listObjectsOfProperty((Resource)Bob, (Property)hasFather), new Resource[]{Dad});
        MiscTests.assertIteratorValues((Iterator)model.listObjectsOfProperty((Resource)Bob, (Property)hasBioFather), new Resource[]{Dad});
    }

    public void testTransitive1() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "agencies.owl");
        model.prepare();
        String ns = "http://www.owl-ontologies.com/unnamed.owl#";
        Individual Forest_Service = model.getIndividual(ns + "Forest_Service");
        ObjectProperty comprises = model.getObjectProperty(ns + "comprises");
        Individual Executive = model.getIndividual(ns + "Executive");
        Individual USDA = model.getIndividual(ns + "USDA");
        MiscTests.assertTrue((String)"Forest_Service, comprises, Executive", (boolean)model.contains((Resource)Forest_Service, (Property)comprises, (RDFNode)Executive));
        MiscTests.assertIteratorValues((Iterator)model.listObjectsOfProperty((Resource)Forest_Service, (Property)comprises), new Resource[]{USDA, Executive});
        MiscTests.assertIteratorValues((Iterator)model.listSubjectsWithProperty((Property)comprises, (RDFNode)Executive), new Resource[]{model.getIndividual(ns + "USDA"), model.getIndividual(ns + "DOE"), model.getIndividual(ns + "DHS"), model.getIndividual(ns + "HHS"), model.getIndividual(ns + "HUD"), model.getIndividual(ns + "DOC"), model.getIndividual(ns + "DOD"), model.getIndividual(ns + "DOI"), model.getIndividual(ns + "Research__Economics___Education"), model.getIndividual(ns + "Forest_Service"), model.getIndividual(ns + "Rural_Development"), model.getIndividual(ns + "Natural_Resources_Conservation_Service"), model.getIndividual(ns + "Economic_Research_Service"), model.getIndividual(ns + "Farm_Service_Agency"), model.getIndividual(ns + "Cooperative_State_Research__Education__and_Extension_Service"), model.getIndividual(ns + "Animal___Plant_Health_Inspection_Service"), model.getIndividual(ns + "Agricultural_Research_Service"), model.getIndividual(ns + "National_Agricultural_Library")});
    }

    public void testTransitive2() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "cyclic_transitive.owl");
        model.prepare();
        String ns = "http://www.example.org/test#";
        OntClass Probe = model.getOntClass(ns + "Probe");
        Individual Instance1 = model.getIndividual(ns + "Instance1");
        Individual Instance2 = model.getIndividual(ns + "Instance2");
        Individual Instance3 = model.getIndividual(ns + "Instance3");
        MiscTests.assertIteratorValues((Iterator)Probe.listInstances(), new Resource[]{Instance1, Instance2, Instance3});
    }

    public void testTransitiveSubProperty1() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        ObjectProperty knows = model.createObjectProperty(ns + "knows");
        ObjectProperty hasRelative = model.createObjectProperty(ns + "hasRelative");
        hasRelative.addSuperProperty((Property)knows);
        hasRelative.addRDFType(OWL.TransitiveProperty);
        ObjectProperty hasParent = model.createObjectProperty(ns + "hasParent");
        hasParent.addSuperProperty((Property)hasRelative);
        OntClass cls = model.createClass(ns + "cls");
        Individual a = cls.createIndividual(ns + "a");
        Individual b = cls.createIndividual(ns + "b");
        Individual c = cls.createIndividual(ns + "c");
        Individual d = cls.createIndividual(ns + "d");
        Individual e = cls.createIndividual(ns + "e");
        Individual f = cls.createIndividual(ns + "f");
        Individual g = cls.createIndividual(ns + "g");
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner(PelletReasonerFactory.theInstance().create());
        model = ModelFactory.createOntologyModel((OntModelSpec)spec, (Model)model);
        model.add((Resource)a, (Property)hasParent, (RDFNode)b);
        model.add((Resource)b, (Property)hasParent, (RDFNode)c);
        model.add((Resource)a, (Property)knows, (RDFNode)d);
        model.add((Resource)d, (Property)knows, (RDFNode)e);
        model.add((Resource)b, (Property)knows, (RDFNode)e);
        model.add((Resource)c, (Property)hasRelative, (RDFNode)f);
        model.add((Resource)d, (Property)hasRelative, (RDFNode)g);
        MiscTests.assertTrue((boolean)model.contains((Resource)a, (Property)hasRelative, (RDFNode)b));
        MiscTests.assertTrue((boolean)model.contains((Resource)a, (Property)knows, (RDFNode)b));
        MiscTests.assertTrue((boolean)model.contains((Resource)b, (Property)hasRelative, (RDFNode)c));
        MiscTests.assertTrue((boolean)model.contains((Resource)b, (Property)knows, (RDFNode)c));
        MiscTests.assertTrue((boolean)model.contains((Resource)a, (Property)hasRelative, (RDFNode)c));
        MiscTests.assertTrue((boolean)model.contains((Resource)a, (Property)knows, (RDFNode)c));
        MiscTests.assertTrue((boolean)model.contains((Resource)b, (Property)hasRelative, (RDFNode)f));
        MiscTests.assertTrue((boolean)model.contains((Resource)b, (Property)knows, (RDFNode)f));
        MiscTests.assertTrue((boolean)model.contains((Resource)a, (Property)hasRelative, (RDFNode)f));
        MiscTests.assertTrue((boolean)model.contains((Resource)a, (Property)knows, (RDFNode)f));
        MiscTests.assertTrue((!model.contains((Resource)a, (Property)hasRelative, (RDFNode)e) ? 1 : 0) != 0);
        MiscTests.assertTrue((!model.contains((Resource)a, (Property)knows, (RDFNode)e) ? 1 : 0) != 0);
        MiscTests.assertTrue((!model.contains((Resource)a, (Property)knows, (RDFNode)g) ? 1 : 0) != 0);
        MiscTests.assertTrue((!model.contains((Resource)a, (Property)hasRelative, (RDFNode)g) ? 1 : 0) != 0);
        MiscTests.assertIteratorValues((Iterator)model.listObjectsOfProperty((Resource)a, (Property)hasRelative), new Resource[]{b, c, f});
        MiscTests.assertIteratorValues((Iterator)model.listObjectsOfProperty((Resource)a, (Property)knows), new Resource[]{b, c, d, f});
        MiscTests.assertIteratorValues((Iterator)model.listObjectsOfProperty((Resource)b, (Property)knows), new Resource[]{c, e, f});
        MiscTests.assertIteratorValues((Iterator)model.listSubjectsWithProperty((Property)knows, (RDFNode)e), new Resource[]{b, d});
        MiscTests.assertIteratorValues((Iterator)model.listSubjectsWithProperty((Property)hasRelative, (RDFNode)f), new Resource[]{a, b, c});
    }

    public void testTransitiveSubProperty2() {
        String ns = "http://www.co-ode.org/ontologies/test/pellet/transitive.owl#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "transitiveSub.owl");
        OntClass ThingsThatpSomeC = model.getOntClass(ns + "ThingsThatpSomeC");
        OntClass A = model.getOntClass(ns + "A");
        OntClass B = model.getOntClass(ns + "B");
        MiscTests.assertTrue((boolean)A.hasSuperClass((Resource)ThingsThatpSomeC));
        MiscTests.assertTrue((boolean)B.hasSuperClass((Resource)ThingsThatpSomeC));
        this.assertIteratorContains((Iterator)A.listSuperClasses(), ThingsThatpSomeC);
        this.assertIteratorContains((Iterator)B.listSuperClasses(), ThingsThatpSomeC);
    }

    public void testInvalidTransitivity2() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "invalidTransitivity.owl");
        model.prepare();
        KnowledgeBase kb = ((PelletInfGraph)model.getGraph()).getKB();
        for (Role r : kb.getRBox().getRoles()) {
            MiscTests.assertTrue((String)r.toString(), (boolean)r.isSimple());
            MiscTests.assertFalse((String)r.toString(), (boolean)r.isTransitive());
        }
        for (ATermAppl p : kb.getObjectProperties()) {
            MiscTests.assertFalse((String)p.toString(), (boolean)kb.isTransitiveProperty(p));
        }
    }

    public void testNominals() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "nominals.owl");
        OntClass Color2 = model.getOntClass(ns + "Color");
        Individual red = model.getIndividual(ns + "red");
        OntClass PrimaryColors = model.getOntClass(ns + "PrimaryColors");
        OntClass MyFavoriteColors = model.getOntClass(ns + "MyFavoriteColors");
        OntClass HasFourPrimaryColors = model.getOntClass(ns + "HasFourPrimaryColors");
        model.prepare();
        MiscTests.assertTrue((boolean)model.contains((Resource)red, RDF.type, (RDFNode)MyFavoriteColors));
        MiscTests.assertTrue((boolean)model.contains((Resource)HasFourPrimaryColors, RDFS.subClassOf, (RDFNode)OWL.Nothing));
        MiscTests.assertIteratorValues((Iterator)Color2.listSubClasses(), new Resource[]{PrimaryColors, MyFavoriteColors, HasFourPrimaryColors, OWL.Nothing});
    }

    public void testDatatypeProperties() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass Person = model.createClass(ns + "Person");
        Individual john = model.createIndividual(ns + "JohnDoe", (Resource)Person);
        DatatypeProperty email = model.createDatatypeProperty(ns + "email", false);
        john.addProperty((Property)email, "john.doe@unknown.org");
        john.addProperty((Property)email, "jdoe@unknown.org");
        MiscTests.assertTrue((boolean)model.validate().isValid());
        MiscTests.assertIteratorValues((Iterator)model.listSubjectsWithProperty((Property)email, "john.doe@unknown.org"), new Resource[]{john});
        MiscTests.assertTrue((boolean)model.contains(null, (Property)email, "john.doe@unknown.org"));
        MiscTests.assertTrue((!model.contains(null, (Property)email, (RDFNode)john) ? 1 : 0) != 0);
        DatatypeProperty name1 = model.createDatatypeProperty(ns + "name1", true);
        john.addProperty((Property)name1, "Name", "en");
        john.addProperty((Property)name1, "Nom", "fr");
        MiscTests.assertTrue((boolean)model.validate().isValid());
        DatatypeProperty name2 = model.createDatatypeProperty(ns + "name2", true);
        john.addProperty((Property)name2, "Name");
        john.addProperty((Property)name2, "Nom");
        MiscTests.assertTrue((!model.validate().isValid() ? 1 : 0) != 0);
    }

    public void testDatatypeHierarchy() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "all_datatypes.owl");
        OntModel hierarchy = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        model.read(base + "datatype_hierarchy.owl");
        ExtendedIterator i = hierarchy.listClasses();
        while (i.hasNext()) {
            OntClass cls = (OntClass)i.next();
            MiscTests.assertIteratorValues((Iterator)model.getOntClass(cls.getURI()).listSubClasses(true), (Iterator)cls.listSubClasses());
        }
    }

    public void testDataPropCard1() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        DatatypeProperty prop = model.createDatatypeProperty(ns + "prop");
        OntClass C = model.createClass(ns + "C");
        C.addSuperClass((Resource)model.createCardinalityRestriction(null, (Property)prop, 2));
        Individual x = model.createIndividual(ns + "x", (Resource)C);
        x.addProperty((Property)prop, "literal");
        model.prepare();
        MiscTests.assertTrue((boolean)((PelletInfGraph)model.getGraph()).isConsistent());
    }

    public void testDataPropCard2() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        DatatypeProperty prop = model.createDatatypeProperty(ns + "prop");
        OntClass C = model.createClass(ns + "C");
        C.addSuperClass((Resource)model.createCardinalityRestriction(null, (Property)prop, 2));
        Individual x = model.createIndividual(ns + "x", (Resource)C);
        x.addProperty((Property)prop, "literal1");
        x.addProperty((Property)prop, "literal2");
        x.addProperty((Property)prop, "literal3");
        MiscTests.assertTrue((!model.validate().isValid() ? 1 : 0) != 0);
    }

    public void testSubDataPropCard() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        DatatypeProperty prop = model.createDatatypeProperty(ns + "prop");
        DatatypeProperty sub = model.createDatatypeProperty(ns + "sub");
        sub.addSuperProperty((Property)prop);
        OntClass C = model.createClass(ns + "C");
        C.addSuperClass((Resource)model.createCardinalityRestriction(null, (Property)prop, 2));
        Individual x = model.createIndividual(ns + "x", (Resource)C);
        Literal val1 = model.createLiteral("val1");
        x.addProperty((Property)prop, (RDFNode)val1);
        Literal val2 = model.createLiteral("val2");
        x.addProperty((Property)sub, (RDFNode)val2);
        MiscTests.assertTrue((boolean)model.validate().isValid());
        this.assertPropertyValues((Model)model, (Resource)x, (Property)prop, new RDFNode[]{val1, val2});
    }

    public void testUniqueNameAssumption() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass Country = model.createClass(ns + "Country");
        Individual USA = model.createIndividual(ns + "USA", (Resource)Country);
        Individual UnitedStates = model.createIndividual(ns + "UnitedStates", (Resource)Country);
        ObjectProperty livesIn = model.createObjectProperty(ns + "livesIn");
        livesIn.convertToFunctionalProperty();
        OntClass Person = model.createClass(ns + "Person");
        Individual JohnDoe = model.createIndividual(ns + "JohnDoe", (Resource)Person);
        JohnDoe.addProperty((Property)livesIn, (RDFNode)USA);
        JohnDoe.addProperty((Property)livesIn, (RDFNode)UnitedStates);
        MiscTests.assertTrue((boolean)model.contains((Resource)JohnDoe, RDF.type, (RDFNode)Person));
        MiscTests.assertTrue((boolean)model.contains((Resource)USA, OWL.sameAs, (RDFNode)UnitedStates));
        MiscTests.assertIteratorValues((Iterator)model.listObjectsOfProperty((Resource)JohnDoe, (Property)livesIn), new Resource[]{USA, UnitedStates});
    }

    public void testQuerySorting() {
        String data = "@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> . @prefix foaf: <http://xmlns.com/foaf/0.1/> . _:a foaf:name \"Eve\". _:b foaf:name \"Alice\" . _:c foaf:name \"Fred\" . _:e foaf:name \"Bob\" .";
        String query = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\r\nSELECT ?name\r\nWHERE { ?x foaf:name ?name }\r\nORDER BY ?name";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read((Reader)new StringReader(data), "", "N3");
        model.prepare();
        Query qry = QueryFactory.create((String)query);
        PelletQueryExecution exec = new PelletQueryExecution(qry, (Model)model);
        ResultSet results = exec.execSelect();
        RDFNode[] expected = new RDFNode[]{ResourceFactory.createPlainLiteral((String)"Alice"), ResourceFactory.createPlainLiteral((String)"Bob"), ResourceFactory.createPlainLiteral((String)"Eve"), ResourceFactory.createPlainLiteral((String)"Fred")};
        for (int i = 0; i < expected.length; ++i) {
            MiscTests.assertTrue((boolean)results.hasNext());
            MiscTests.assertEquals((Object)expected[i], (Object)results.nextSolution().getLiteral("name"));
        }
    }

    public void testESG() {
        String ns = "http://www.csm.ornl.gov/~7lp/onto-library/esg1.1#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.getDocumentManager().setProcessImports(false);
        model.read(base + "ESG1.1.owl");
        model.prepare();
        MiscTests.assertTrue((boolean)((PelletInfGraph)model.getGraph()).getKB().isConsistent());
        Individual jdl62 = model.getIndividual(ns + "JDL_00062");
        Individual jdl63 = model.getIndividual(ns + "JDL_00063");
        MiscTests.assertTrue((boolean)jdl62.isSameAs((Resource)jdl63));
        MiscTests.assertTrue((boolean)jdl63.isSameAs((Resource)jdl62));
        MiscTests.assertIteratorValues((Iterator)jdl62.listSameAs(), new Resource[]{jdl62, jdl63});
        MiscTests.assertIteratorValues((Iterator)jdl63.listSameAs(), new Resource[]{jdl62, jdl63});
        model.getDocumentManager().setProcessImports(true);
    }

    public void testSHOIN() {
        KnowledgeBase kb = new KnowledgeBase();
        kb.addObjectProperty(MiscTests.term("R1"));
        kb.addObjectProperty(MiscTests.term("invR1"));
        kb.addObjectProperty(MiscTests.term("R2"));
        kb.addObjectProperty(MiscTests.term("invR2"));
        kb.addObjectProperty(MiscTests.term("S1"));
        kb.addObjectProperty(MiscTests.term("invS1"));
        kb.addObjectProperty(MiscTests.term("S2"));
        kb.addObjectProperty(MiscTests.term("invS2"));
        kb.addInverseProperty(MiscTests.term("R1"), MiscTests.term("invR1"));
        kb.addInverseProperty(MiscTests.term("R2"), MiscTests.term("invR2"));
        kb.addInverseProperty(MiscTests.term("S1"), MiscTests.term("invS1"));
        kb.addInverseProperty(MiscTests.term("S2"), MiscTests.term("invS2"));
        kb.addIndividual(MiscTests.term("o1"));
        kb.addIndividual(MiscTests.term("o2"));
        kb.addSubClass(MiscTests.value(MiscTests.term("o1")), MiscTests.and(MiscTests.max(MiscTests.term("invR1"), 2, ATermUtils.TOP), MiscTests.all(MiscTests.term("invR1"), MiscTests.some(MiscTests.term("S1"), MiscTests.some(MiscTests.term("invS2"), MiscTests.some(MiscTests.term("R2"), MiscTests.value(MiscTests.term("o2"))))))));
        kb.addSubClass(MiscTests.value(MiscTests.term("o2")), MiscTests.and(MiscTests.max(MiscTests.term("invR2"), 2, ATermUtils.TOP), MiscTests.all(MiscTests.term("invR2"), MiscTests.some(MiscTests.term("S2"), MiscTests.some(MiscTests.term("invS1"), MiscTests.some(MiscTests.term("R1"), MiscTests.value(MiscTests.term("o1"))))))));
        MiscTests.assertTrue((boolean)kb.isConsistent());
        MiscTests.assertTrue((boolean)kb.isSatisfiable(MiscTests.and(MiscTests.value(MiscTests.term("o1")), MiscTests.some(MiscTests.term("invR1"), TOP))));
    }

    public void testDatapropertyRange() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "datataype_range.owl");
        model.prepare();
        ExtendedIterator i = model.listDatatypeProperties();
        while (i.hasNext()) {
            DatatypeProperty p = (DatatypeProperty)i.next();
            ExtendedIterator j = p.listRange();
            while (j.hasNext()) {
                Resource range = (Resource)j.next();
                MiscTests.assertTrue((TypeMapper.getInstance().getTypeByName(range.getURI()) != null ? 1 : 0) != 0);
            }
        }
    }

    public void testMultipleDatatypes() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        DatatypeProperty f = model.createDatatypeProperty(ns + "f");
        f.addRange(XSD.xfloat);
        DatatypeProperty d = model.createDatatypeProperty(ns + "d");
        d.addRange(XSD.xdouble);
        OntClass C = model.createClass(ns + "C");
        C.addSuperClass((Resource)model.createMinCardinalityRestriction(null, (Property)f, 5));
        C.addSuperClass((Resource)model.createMinCardinalityRestriction(null, (Property)d, 5));
        model.prepare();
        MiscTests.assertFalse((boolean)C.hasSuperClass(OWL.Nothing));
    }

    public void testUserDefinedFloatDatatypes() {
        PelletOptions.AUTO_XML_SCHEMA_LOADING = true;
        String ns = "http://www.lancs.ac.uk/ug/dobsong/owl/float_test.owl#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "float_test.owl");
        model.prepare();
        MiscTests.assertTrue((boolean)model.validate().isValid());
        OntClass ThingWithFloatValue = model.getOntClass(ns + "ThingWithFloatValue");
        OntClass ThingWithFloatProbability = model.getOntClass(ns + "ThingWithProbabilityValue");
        Individual exampleThingWithFloatValue = model.getIndividual(ns + "exampleThingWithFloatValue");
        Individual exampleThingWithFloatProbability = model.getIndividual(ns + "exampleThingWithProbabilityValue");
        MiscTests.assertTrue((boolean)ThingWithFloatValue.hasSubClass((Resource)ThingWithFloatProbability));
        MiscTests.assertTrue((!ThingWithFloatProbability.hasSubClass((Resource)ThingWithFloatValue) ? 1 : 0) != 0);
        MiscTests.assertTrue((boolean)exampleThingWithFloatValue.hasRDFType((Resource)ThingWithFloatValue));
        MiscTests.assertTrue((!exampleThingWithFloatValue.hasRDFType((Resource)ThingWithFloatProbability) ? 1 : 0) != 0);
        MiscTests.assertTrue((boolean)exampleThingWithFloatProbability.hasRDFType((Resource)ThingWithFloatValue));
        MiscTests.assertTrue((boolean)exampleThingWithFloatProbability.hasRDFType((Resource)ThingWithFloatProbability));
        PelletOptions.AUTO_XML_SCHEMA_LOADING = false;
    }

    public void testUserDefinedDecimalDatatypes() {
        PelletOptions.AUTO_XML_SCHEMA_LOADING = true;
        String ns = "http://www.lancs.ac.uk/ug/dobsong/owl/decimal_test.owl#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "decimal_test.owl");
        model.prepare();
        MiscTests.assertTrue((boolean)model.validate().isValid());
        OntClass ThingWithDecimalValue = model.getOntClass(ns + "ThingWithDecimalValue");
        OntClass ThingWithDecimalProbability = model.getOntClass(ns + "ThingWithDecimalProbability");
        OntClass ThingWithIntegerValue = model.getOntClass(ns + "ThingWithIntegerValue");
        Individual exampleThingWithDecimalValue = model.getIndividual(ns + "exampleThingWithDecimalValue");
        Individual exampleThingWithDecimalProbability = model.getIndividual(ns + "exampleThingWithDecimalProbability");
        MiscTests.assertTrue((boolean)ThingWithDecimalValue.hasSubClass((Resource)ThingWithIntegerValue));
        MiscTests.assertTrue((boolean)ThingWithDecimalValue.hasSubClass((Resource)ThingWithDecimalProbability));
        MiscTests.assertTrue((boolean)exampleThingWithDecimalValue.hasRDFType((Resource)ThingWithDecimalValue));
        MiscTests.assertTrue((boolean)exampleThingWithDecimalProbability.hasRDFType((Resource)ThingWithIntegerValue));
        MiscTests.assertTrue((boolean)exampleThingWithDecimalProbability.hasRDFType((Resource)ThingWithDecimalProbability));
        MiscTests.assertTrue((boolean)exampleThingWithDecimalProbability.hasRDFType((Resource)ThingWithDecimalValue));
        PelletOptions.AUTO_XML_SCHEMA_LOADING = false;
    }

    public void testUserDefinedDatatypes() {
        PelletOptions.AUTO_XML_SCHEMA_LOADING = true;
        String ns = "http://www.mindswap.org/ontologies/family.owl#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read("http://www.mindswap.org/ontologies/family-ages.owl");
        model.prepare();
        OntClass Child = model.getOntClass(ns + "Child");
        OntClass Teenage = model.getOntClass(ns + "Teenage");
        OntClass Adult = model.getOntClass(ns + "Adult");
        OntClass Senior = model.getOntClass(ns + "Senior");
        OntClass Female = model.getOntClass(ns + "Female");
        OntClass Person = model.getOntClass(ns + "Person");
        Individual Daughter = model.getIndividual(ns + "Daughter");
        Individual Son = model.getIndividual(ns + "Son");
        Individual Dad = model.getIndividual(ns + "Dad");
        Individual Grandpa = model.getIndividual(ns + "Grandpa");
        MiscTests.assertTrue((boolean)Adult.hasSubClass((Resource)Senior));
        MiscTests.assertIteratorValues((Iterator)Adult.listSubClasses(true), new Resource[]{Senior});
        MiscTests.assertTrue((boolean)Daughter.hasRDFType((Resource)Child));
        MiscTests.assertIteratorValues((Iterator)Daughter.listRDFTypes(false), new Resource[]{Female, Person, Child, OWL.Thing});
        MiscTests.assertTrue((boolean)Son.hasRDFType((Resource)Teenage));
        MiscTests.assertTrue((boolean)Dad.hasRDFType((Resource)Adult));
        MiscTests.assertTrue((boolean)Grandpa.hasRDFType((Resource)Senior));
        MiscTests.assertIteratorValues((Iterator)Adult.listInstances(), new Resource[]{Dad, Grandpa});
        PelletOptions.AUTO_XML_SCHEMA_LOADING = false;
    }

    public void testBuiltinDatatypes1() {
        String ns = "urn:test:";
        Object[] datatypes = new Object[]{XSD.anyURI, "http://www.w3.com", XSD.xboolean, "true", "1", XSD.xbyte, "8", XSD.date, "2004-03-15", XSD.dateTime, "2003-12-25T08:30:00", "2003-12-25T08:30:00.001", "2003-12-25T08:30:00-05:00", "2003-12-25T08:30:00Z", XSD.decimal, "3.1415292", XSD.xdouble, "3.1415292", "INF", "NaN", XSD.duration, "P8M3DT7H33M2S", "P1Y", "P1M", "P1Y2MT2H", XSD.xfloat, "3.1415292", "-1E4", "12.78e-2", "INF", "NaN", XSD.gDay, "---11", XSD.gMonth, "--02", XSD.gMonthDay, "--02-14", XSD.gYear, "0001", "1999", XSD.gYearMonth, "1972-08", XSD.xint, "77", XSD.integer, "77", XSD.xlong, "214", XSD.negativeInteger, "-123", XSD.nonNegativeInteger, "2", XSD.nonPositiveInteger, "0", XSD.positiveInteger, "500", XSD.xshort, "476", XSD.xstring, "Test", XSD.time, "13:02:00"};
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        Individual ind = model.createIndividual(ns + "test", OWL.Thing);
        int i = 0;
        while (i < datatypes.length) {
            Resource datatype = (Resource)datatypes[i++];
            DatatypeProperty p = model.createDatatypeProperty(ns + "prop_" + datatype.getLocalName());
            p.addRange(datatype);
            while (i < datatypes.length && datatypes[i] instanceof String) {
                Literal value = model.createTypedLiteral((String)datatypes[i], datatype.getURI());
                ind.addProperty((Property)p, (RDFNode)value);
                ++i;
            }
        }
        model.prepare();
        MiscTests.assertTrue((boolean)model.validate().isValid());
    }

    public void testBuiltinDatatypes2() {
        String ns = "urn:test:";
        Object[] datatypes = new Object[]{XSD.anyURI, "http://www.w3.com\\invalid", XSD.xboolean, "True", "01", XSD.xbyte, "257", XSD.date, "2004-15-03", "2004/03/15", "03-15-2004", XSD.dateTime, "2003-12-25", XSD.decimal, "x3.1415292", XSD.xdouble, "Inf", XSD.duration, "P-8M", XSD.xfloat, "3.1g-1", XSD.gDay, "11", "Monday", "Mon", XSD.gMonth, "02", "Feb", "February", XSD.gMonthDay, "02-14", "02/14", XSD.gYear, "0000", "012345", "542", XSD.gYearMonth, "1972/08", XSD.xint, "2147483648", XSD.integer, "1.1", XSD.xlong, "9223372036854775808", XSD.negativeInteger, "0", "1", XSD.nonNegativeInteger, "-1", XSD.nonPositiveInteger, "1", XSD.positiveInteger, "-1", XSD.xshort, "32768", "1.1"};
        int i = 0;
        while (i < datatypes.length) {
            Resource datatype = (Resource)datatypes[i++];
            while (i < datatypes.length && datatypes[i] instanceof String) {
                OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
                Individual ind = model.createIndividual(ns + "test", OWL.Thing);
                DatatypeProperty p = model.createDatatypeProperty(ns + "prop_" + datatype.getLocalName());
                p.addRange(datatype);
                Literal value = model.createTypedLiteral((String)datatypes[i], datatype.getURI());
                ind.addProperty((Property)p, (RDFNode)value);
                MiscTests.assertFalse((String)(value.getLexicalForm() + " should not belong to " + datatype.getLocalName()), (boolean)model.validate().isValid());
                ++i;
            }
        }
    }

    public void testBuiltinDatatypes3() {
        String ns = "urn:test:";
        DatatypeReasoner dtReasoner = new DatatypeReasoner();
        for (String uri : dtReasoner.getDatatypeURIs()) {
            OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
            DatatypeProperty prop = model.createDatatypeProperty(ns + "prop");
            Resource datatype = model.createResource(uri);
            prop.addRange(datatype);
            OntClass C = model.createClass(ns + "C");
            int cardinality = uri.endsWith("boolean") ? 2 : 10;
            C.addSuperClass((Resource)model.createCardinalityRestriction(null, (Property)prop, cardinality));
            model.createIndividual(ns + "x", (Resource)C);
            model.prepare();
            MiscTests.assertTrue((boolean)((PelletInfGraph)model.getGraph()).isConsistent());
        }
    }

    public void testBuiltinDatatypes4() {
        String ns = "urn:test:";
        Object[] datatypes = new Object[]{XSD.anyURI, "http://www.w3.com", XSD.xboolean, "true", "1", XSD.xbyte, "8", XSD.date, "2004-03-15", XSD.dateTime, "2003-12-25T08:30:00", "2003-12-25T08:30:00.001", "2003-12-25T08:30:00-05:00", "2003-12-25T08:30:00Z", XSD.decimal, "3.1415292", XSD.xdouble, "3.1415292", "INF", "NaN", XSD.duration, "P8M3DT7H33M2S", "P1Y", "P1M", "P1Y2MT2H", XSD.xfloat, "3.1415292", "-1E4", "12.78e-2", "INF", "NaN", XSD.gDay, "---11", XSD.gMonth, "--02", XSD.gMonthDay, "--02-14", XSD.gYear, "0001", "1999", XSD.gYearMonth, "1972-08", XSD.xint, "77", XSD.integer, "77", XSD.xlong, "214", XSD.negativeInteger, "-123", XSD.nonNegativeInteger, "2", XSD.nonPositiveInteger, "0", XSD.positiveInteger, "500", XSD.xshort, "476", XSD.xstring, "Test", XSD.time, "13:02:00"};
        int i = 0;
        while (i < datatypes.length) {
            Resource datatype = (Resource)datatypes[i++];
            OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
            System.out.println(datatype);
            DatatypeProperty p = model.createDatatypeProperty(ns + "prop");
            p.addRange(datatype);
            int start = i;
            while (i < datatypes.length && datatypes[i] instanceof String) {
                Individual ind = model.createIndividual(ns + "testInd" + i, OWL.Thing);
                System.out.println(datatypes[i]);
                Literal value = model.createTypedLiteral((String)datatypes[i], datatype.getURI());
                ind.addProperty((Property)p, (RDFNode)value);
                OntClass c = model.createClass(ns + "testCls" + i);
                c.addEquivalentClass((Resource)model.createHasValueRestriction(null, (Property)p, (RDFNode)value));
                ++i;
            }
            model.prepare();
            for (int j = start; j < i; ++j) {
                MiscTests.assertTrue((String)(datatype.getLocalName() + " " + datatypes[j]), (boolean)model.getIndividual(ns + "testInd" + j).hasRDFType((Resource)model.getIndividual(ns + "testCls" + j)));
            }
        }
    }

    public void testRete() throws OWLException {
        String ontURI = base + "rules.owl";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(ontURI);
        model.prepare();
        KnowledgeBase kb = ((PelletInfGraph)model.getGraph()).getKB();
        Interpreter interp = new Interpreter(kb.getABox());
        interp.rete.compile(new RulesToReteTranslator(kb.getABox()).translateRules(kb.getRules()));
        Set<Fact> facts = interp.rete.compileFacts(kb.getABox());
        interp.addFacts(facts, true);
        interp.run();
        MiscTests.assertEquals((int)2, (int)interp.inferredFacts.size());
    }

    public void testFamily() {
        String ns = "http://www.example.org/family#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, null);
        model.read(base + "family.owl");
        ObjectProperty hasBrother = model.getObjectProperty(ns + "hasBrother");
        ObjectProperty hasSon = model.getObjectProperty(ns + "hasSon");
        ObjectProperty hasFather = model.getObjectProperty(ns + "hasFather");
        ObjectProperty hasParent = model.getObjectProperty(ns + "hasParent");
        ObjectProperty hasChild = model.getObjectProperty(ns + "hasChild");
        ObjectProperty hasMother = model.getObjectProperty(ns + "hasMother");
        ObjectProperty hasDaughter = model.getObjectProperty(ns + "hasDaughter");
        ObjectProperty hasAncestor = model.getObjectProperty(ns + "hasAncestor");
        ObjectProperty likes = model.getObjectProperty(ns + "likes");
        ObjectProperty isMarriedTo = model.getObjectProperty(ns + "isMarriedTo");
        ObjectProperty dislikes = model.getObjectProperty(ns + "dislikes");
        ObjectProperty hasSister = model.getObjectProperty(ns + "hasSister");
        ObjectProperty hasDescendant = model.getObjectProperty(ns + "hasDescendant");
        ObjectProperty hasSibling = model.getObjectProperty(ns + "hasSibling");
        OntClass Child = model.getOntClass(ns + "Child");
        OntClass Person = model.getOntClass(ns + "Person");
        OntClass PersonWithAtLeastTwoMaleChildren = model.getOntClass(ns + "PersonWithAtLeastTwoMaleChildren");
        OntClass PersonWithAtLeastTwoFemaleChildren = model.getOntClass(ns + "PersonWithAtLeastTwoFemaleChildren");
        OntClass PersonWithAtLeastTwoChildren = model.getOntClass(ns + "PersonWithAtLeastTwoChildren");
        OntClass PersonWithAtLeastFourChildren = model.getOntClass(ns + "PersonWithAtLeastFourChildren");
        OntClass Teen = model.getOntClass(ns + "Teen");
        OntClass Teenager = model.getOntClass(ns + "Teenager");
        OntClass Male = model.getOntClass(ns + "Male");
        OntClass Adult = model.getOntClass(ns + "Adult");
        OntClass Female = model.getOntClass(ns + "Female");
        OntClass Senior = model.getOntClass(ns + "Senior");
        Individual grandmother = model.getIndividual(ns + "grandmother");
        Individual grandfather = model.getIndividual(ns + "grandfather");
        Individual father = model.getIndividual(ns + "father");
        Individual son = model.getIndividual(ns + "son");
        Individual mother = model.getIndividual(ns + "mother");
        Individual daughter = model.getIndividual(ns + "daughter");
        Individual personX = model.getIndividual(ns + "personX");
        Individual personY = model.getIndividual(ns + "personY");
        Individual personZ = model.getIndividual(ns + "personZ");
        model.prepare();
        KnowledgeBase kb = ((PelletInfGraph)model.getGraph()).getKB();
        for (int test = 0; test < 1; ++test) {
            if (test != 0) {
                kb.realize();
            }
            MiscTests.assertTrue((boolean)hasAncestor.hasRDFType(OWL_1_1.TransitiveProperty));
            MiscTests.assertTrue((boolean)hasDescendant.hasRDFType(OWL_1_1.TransitiveProperty));
            MiscTests.assertTrue((boolean)isMarriedTo.hasRDFType(OWL_1_1.SymmetricProperty));
            MiscTests.assertTrue((boolean)isMarriedTo.hasRDFType(OWL_1_1.IrreflexiveProperty));
            MiscTests.assertTrue((boolean)hasParent.hasSuperProperty((Property)hasAncestor, false));
            MiscTests.assertTrue((boolean)hasFather.hasSuperProperty((Property)hasAncestor, false));
            MiscTests.assertTrue((boolean)hasMother.hasSuperProperty((Property)hasAncestor, false));
            MiscTests.assertTrue((boolean)hasChild.hasSuperProperty((Property)hasDescendant, false));
            MiscTests.assertTrue((boolean)likes.hasProperty(OWL_1_1.disjointObjectProperties, (RDFNode)dislikes));
            MiscTests.assertTrue((boolean)dislikes.hasProperty(OWL_1_1.disjointObjectProperties, (RDFNode)likes));
            MiscTests.assertTrue((boolean)hasFather.hasProperty(OWL_1_1.disjointObjectProperties, (RDFNode)hasMother));
            MiscTests.assertTrue((boolean)hasMother.hasProperty(OWL_1_1.disjointObjectProperties, (RDFNode)hasFather));
            MiscTests.assertTrue((boolean)grandfather.hasRDFType((Resource)Person));
            MiscTests.assertTrue((boolean)grandfather.hasRDFType((Resource)Male));
            MiscTests.assertTrue((boolean)grandfather.hasRDFType((Resource)Senior));
            MiscTests.assertTrue((boolean)grandfather.hasRDFType((Resource)PersonWithAtLeastTwoChildren));
            MiscTests.assertTrue((boolean)grandfather.hasRDFType((Resource)PersonWithAtLeastTwoMaleChildren));
            MiscTests.assertTrue((boolean)grandfather.hasProperty((Property)isMarriedTo, (RDFNode)grandmother));
            MiscTests.assertTrue((boolean)grandfather.hasProperty((Property)hasChild, (RDFNode)father));
            MiscTests.assertTrue((boolean)grandfather.hasProperty((Property)hasSon, (RDFNode)father));
            MiscTests.assertTrue((boolean)grandfather.isDifferentFrom((Resource)grandmother));
            MiscTests.assertTrue((boolean)grandfather.isDifferentFrom((Resource)father));
            MiscTests.assertTrue((boolean)grandfather.isDifferentFrom((Resource)mother));
            MiscTests.assertTrue((boolean)grandfather.isDifferentFrom((Resource)son));
            MiscTests.assertTrue((boolean)grandfather.isDifferentFrom((Resource)daughter));
            MiscTests.assertTrue((boolean)grandmother.hasRDFType((Resource)Person));
            MiscTests.assertTrue((boolean)grandmother.hasRDFType((Resource)Female));
            MiscTests.assertTrue((boolean)grandmother.hasRDFType((Resource)Senior));
            MiscTests.assertTrue((boolean)grandmother.hasProperty((Property)isMarriedTo, (RDFNode)grandfather));
            MiscTests.assertTrue((boolean)grandmother.hasProperty((Property)hasChild, (RDFNode)father));
            MiscTests.assertFalse((boolean)grandmother.hasProperty((Property)hasSon, (RDFNode)father));
            MiscTests.assertTrue((boolean)father.hasRDFType((Resource)Person));
            MiscTests.assertTrue((boolean)father.hasRDFType((Resource)Male));
            MiscTests.assertTrue((boolean)father.hasRDFType((Resource)Adult));
            MiscTests.assertTrue((boolean)father.hasProperty((Property)hasParent, (RDFNode)grandfather));
            MiscTests.assertTrue((boolean)father.hasProperty((Property)hasParent, (RDFNode)grandmother));
            MiscTests.assertTrue((boolean)father.hasProperty((Property)hasFather, (RDFNode)grandfather));
            MiscTests.assertTrue((boolean)father.hasProperty((Property)hasMother, (RDFNode)grandmother));
            MiscTests.assertTrue((boolean)father.hasProperty((Property)hasChild, (RDFNode)son));
            MiscTests.assertTrue((boolean)father.hasProperty((Property)hasSon, (RDFNode)son));
            MiscTests.assertTrue((boolean)father.hasProperty((Property)hasChild, (RDFNode)daughter));
            MiscTests.assertFalse((boolean)father.hasProperty((Property)hasDaughter, (RDFNode)daughter));
            MiscTests.assertTrue((boolean)mother.hasRDFType((Resource)Person));
            MiscTests.assertTrue((boolean)mother.hasRDFType((Resource)Female));
            MiscTests.assertTrue((boolean)son.hasRDFType((Resource)Male));
            MiscTests.assertTrue((boolean)son.hasRDFType((Resource)Teenager));
            MiscTests.assertTrue((boolean)son.hasRDFType((Resource)Teen));
            MiscTests.assertTrue((boolean)son.hasProperty((Property)hasParent, (RDFNode)father));
            MiscTests.assertTrue((boolean)son.hasProperty((Property)hasFather, (RDFNode)father));
            MiscTests.assertTrue((boolean)son.hasProperty((Property)hasSibling, (RDFNode)daughter));
            MiscTests.assertTrue((boolean)son.hasProperty((Property)hasSister, (RDFNode)daughter));
            MiscTests.assertTrue((boolean)daughter.hasRDFType((Resource)Female));
            MiscTests.assertTrue((boolean)daughter.hasRDFType((Resource)Child));
            MiscTests.assertTrue((boolean)daughter.hasProperty((Property)hasAncestor, (RDFNode)grandfather));
            MiscTests.assertTrue((boolean)daughter.hasProperty((Property)hasAncestor, (RDFNode)grandmother));
            MiscTests.assertTrue((boolean)daughter.hasProperty((Property)hasParent, (RDFNode)father));
            MiscTests.assertTrue((boolean)daughter.hasProperty((Property)hasFather, (RDFNode)father));
            MiscTests.assertTrue((boolean)daughter.hasProperty((Property)hasParent, (RDFNode)mother));
            MiscTests.assertTrue((boolean)daughter.hasProperty((Property)hasMother, (RDFNode)mother));
            MiscTests.assertTrue((boolean)daughter.hasProperty((Property)hasSibling, (RDFNode)son));
            MiscTests.assertFalse((boolean)daughter.hasProperty((Property)hasBrother, (RDFNode)son));
            MiscTests.assertTrue((boolean)personX.isDifferentFrom((Resource)personY));
            MiscTests.assertTrue((boolean)personX.isDifferentFrom((Resource)personZ));
            MiscTests.assertTrue((boolean)personY.isDifferentFrom((Resource)personZ));
            MiscTests.assertTrue((boolean)Teen.hasEquivalentClass((Resource)Teenager));
            MiscTests.assertTrue((boolean)Senior.hasSuperClass((Resource)Adult));
            MiscTests.assertTrue((boolean)Adult.hasSubClass((Resource)Senior));
            MiscTests.assertTrue((boolean)Person.hasSubClass((Resource)PersonWithAtLeastTwoMaleChildren));
            MiscTests.assertTrue((boolean)Person.hasSubClass((Resource)PersonWithAtLeastTwoFemaleChildren));
            MiscTests.assertTrue((boolean)Person.hasSubClass((Resource)PersonWithAtLeastTwoChildren));
            MiscTests.assertTrue((boolean)Person.hasSubClass((Resource)PersonWithAtLeastFourChildren));
            MiscTests.assertTrue((boolean)PersonWithAtLeastTwoChildren.hasSubClass((Resource)PersonWithAtLeastFourChildren));
            MiscTests.assertTrue((boolean)PersonWithAtLeastTwoChildren.hasSubClass((Resource)PersonWithAtLeastTwoMaleChildren));
            MiscTests.assertTrue((boolean)PersonWithAtLeastTwoChildren.hasSubClass((Resource)PersonWithAtLeastTwoFemaleChildren));
            MiscTests.assertFalse((boolean)PersonWithAtLeastTwoFemaleChildren.hasSubClass((Resource)PersonWithAtLeastTwoMaleChildren));
            MiscTests.assertFalse((boolean)PersonWithAtLeastTwoMaleChildren.hasSubClass((Resource)PersonWithAtLeastTwoFemaleChildren));
        }
    }

    public void testCyclicTBox1() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = MiscTests.term("C");
        kb.addEquivalentClass(C, MiscTests.not(C));
        MiscTests.assertFalse((boolean)kb.isConsistent());
    }

    public void testSimplePropertyChain() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = MiscTests.term("C");
        ATermAppl D = MiscTests.term("D");
        ATermAppl p = MiscTests.term("p");
        ATermAppl q = MiscTests.term("q");
        ATermAppl r = MiscTests.term("r");
        kb.addObjectProperty(p);
        kb.addObjectProperty(q);
        kb.addObjectProperty(r);
        kb.addSubProperty(MiscTests.list(p, q), r);
        kb.addClass(C);
        kb.addClass(D);
        kb.addSubClass(C, MiscTests.some(p, MiscTests.some(q, MiscTests.all(MiscTests.inv(r), D))));
        MiscTests.assertTrue((boolean)kb.isSubClassOf(C, D));
    }

    public void testTopClass() {
        String ns = "http://example.org/ont/";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "ticket-3-test-case.rdf");
        model.prepare();
        KnowledgeBase kb = ((PelletInfGraph)model.getGraph()).getKB();
        kb.classify();
        ATermAppl B = MiscTests.term(ns + "B");
        ATermAppl C = MiscTests.term(ns + "C");
        MiscTests.assertTrue((boolean)kb.isEquivalentClass(B, TOP));
        MiscTests.assertTrue((boolean)kb.isEquivalentClass(C, TOP));
    }

    public void testCyclicTBox2() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl B = MiscTests.term("B");
        ATermAppl C = MiscTests.term("C");
        ATermAppl D = MiscTests.term("D");
        kb.addClass(B);
        kb.addClass(C);
        kb.addClass(D);
        kb.addSubClass(C, B);
        kb.addSubClass(D, C);
        kb.addEquivalentClass(D, B);
        kb.classify();
        MiscTests.assertTrue((boolean)kb.isEquivalentClass(B, C));
        MiscTests.assertTrue((boolean)kb.isEquivalentClass(B, D));
        MiscTests.assertTrue((boolean)kb.isEquivalentClass(D, C));
    }

    public void testCyclicTBox3() {
        List<ATermAppl> classes = Arrays.asList(MiscTests.term("C0"), MiscTests.term("C1"), MiscTests.term("C2"));
        Taxonomy taxonomy = new Taxonomy(classes);
        TaxonomyNode top = taxonomy.getTop();
        TaxonomyNode[] nodes = new TaxonomyNode[classes.size()];
        int i = 0;
        for (ATermAppl c : classes) {
            nodes[i++] = taxonomy.getNode(c);
        }
        nodes[2].addSub(nodes[1]);
        nodes[1].addSub(nodes[0]);
        taxonomy.merge(top, nodes[0]);
        MiscTests.assertTrue((boolean)top.getSupers().isEmpty());
        MiscTests.assertTrue((boolean)top.getEquivalents().containsAll(classes));
    }

    public void testComplexTypes() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl a = MiscTests.term("a");
        ATermAppl p = MiscTests.term("p");
        ATermAppl q = MiscTests.term("q");
        kb.addIndividual(a);
        kb.addType(a, MiscTests.min(p, 3, TOP));
        kb.addType(a, MiscTests.max(q, 2, TOP));
        kb.addType(a, MiscTests.min(q, 1, TOP));
        kb.addType(a, MiscTests.min(q, 1, TOP));
        kb.addObjectProperty(p);
        kb.addObjectProperty(q);
        MiscTests.assertTrue((boolean)kb.isConsistent());
    }

    public void testBottomSub() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl c = MiscTests.term("c");
        kb.addClass(c);
        kb.addSubClass(ATermUtils.BOTTOM, c);
        kb.classify();
        MiscTests.assertTrue((boolean)kb.isSubClassOf(ATermUtils.BOTTOM, c));
    }

    public void testDLSafeRules() {
        String ns = "http://owldl.com/ontologies/dl-safe.owl#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, null);
        model.read(base + "dl-safe.owl");
        ObjectProperty hates = model.getObjectProperty(ns + "hates");
        ObjectProperty sibling = model.getObjectProperty(ns + "sibling");
        OntClass BadChild = model.getOntClass(ns + "BadChild");
        OntClass Child = model.getOntClass(ns + "Child");
        OntClass Grandchild = model.getOntClass(ns + "Grandchild");
        OntClass Person = model.getOntClass(ns + "Person");
        Individual Abel = model.getIndividual(ns + "Abel");
        Individual Cain = model.getIndividual(ns + "Cain");
        Individual Oedipus = model.getIndividual(ns + "Oedipus");
        Individual Remus = model.getIndividual(ns + "Remus");
        Individual Romulus = model.getIndividual(ns + "Romulus");
        model.prepare();
        KnowledgeBase kb = ((PelletInfGraph)model.getGraph()).getKB();
        for (int test = 0; test < 1; ++test) {
            if (test != 0) {
                kb.realize();
            }
            MiscTests.assertTrue((boolean)Abel.hasProperty((Property)sibling, (RDFNode)Cain));
            MiscTests.assertIteratorValues((Iterator)Abel.listPropertyValues((Property)sibling), new Resource[]{Cain});
            MiscTests.assertTrue((boolean)Cain.hasProperty((Property)sibling, (RDFNode)Abel));
            MiscTests.assertIteratorValues((Iterator)Cain.listPropertyValues((Property)sibling), new Resource[]{Abel});
            MiscTests.assertTrue((boolean)Cain.hasProperty((Property)hates, (RDFNode)Abel));
            MiscTests.assertTrue((boolean)Cain.hasRDFType((Resource)Grandchild));
            MiscTests.assertTrue((boolean)Cain.hasRDFType((Resource)BadChild));
            MiscTests.assertFalse((boolean)Romulus.hasProperty((Property)sibling, (RDFNode)Remus));
            MiscTests.assertTrue((boolean)Romulus.hasProperty((Property)hates, (RDFNode)Remus));
            MiscTests.assertTrue((boolean)Romulus.hasRDFType((Resource)Grandchild));
            MiscTests.assertFalse((boolean)Romulus.hasRDFType((Resource)BadChild));
            MiscTests.assertTrue((boolean)Oedipus.hasRDFType((Resource)Child));
        }
        MiscTests.assertIteratorValues((Iterator)Cain.listRDFTypes(true), new Object[]{BadChild, Child, Person});
    }

    public void testDLSafeConstants() {
        String ns = "http://owldl.com/ontologies/dl-safe-constants.owl#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, null);
        model.read(base + "dl-safe-constants.owl");
        OntClass DreamTeamMember = model.getOntClass(ns + "DreamTeamMember");
        OntClass DreamTeamMember1 = model.getOntClass(ns + "DreamTeamMember1");
        OntClass DreamTeamMember2 = model.getOntClass(ns + "DreamTeamMember2");
        Individual Alice = model.getIndividual(ns + "Alice");
        Individual Bob = model.getIndividual(ns + "Bob");
        Individual Charlie = model.getIndividual(ns + "Charlie");
        model.prepare();
        KnowledgeBase kb = ((PelletInfGraph)model.getGraph()).getKB();
        for (int test = 0; test < 1; ++test) {
            if (test != 0) {
                kb.realize();
            }
            MiscTests.assertIteratorValues((Iterator)DreamTeamMember.listInstances(), new Object[]{Alice, Bob, Charlie});
            MiscTests.assertIteratorValues((Iterator)DreamTeamMember1.listInstances(), new Object[]{Alice, Bob, Charlie});
            MiscTests.assertIteratorValues((Iterator)DreamTeamMember2.listInstances(), new Object[]{Alice, Bob, Charlie});
        }
    }

    public void testMergeRestore() {
        String src = "@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>.\r\n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>.\r\n@prefix owl: <http://www.w3.org/2002/07/owl#>.\r\n@prefix : <foo:bla#>.\r\n\r\n:one a :NoLeft .\r\n:one :right :two .\r\n:two :right :three .\r\n:three :right :four .\r\n:four :right :five .\r\n:five a :NoRight .\r\n\r\n:NoRight a owl:Class;\r\n      owl:intersectionOf (       [         a owl:Restriction;          owl:onProperty :right;          owl:cardinality 0       ] \r\n      [         a owl:Restriction;          owl:onProperty :neighbor;          owl:cardinality 1       ] ) .\r\n\r\n:NoLeft a owl:Class;\r\n      owl:intersectionOf (       [         a owl:Restriction;          owl:onProperty :left;          owl:cardinality 0       ] \r\n      [         a owl:Restriction;          owl:onProperty :neighbor;          owl:cardinality 1       ] ) .\r\n\r\n:left a owl:FunctionalProperty; owl:inverseOf :right;\r\n      rdfs:subPropertyOf :neighbor .\r\n:right a owl:FunctionalProperty; \r\n      rdfs:subPropertyOf :neighbor .\r\n\r\n:Universe a owl:Class;\r\n   owl:oneOf (:one :two :three :four :five );\r\n   rdfs:subClassOf [          a owl:Restriction;           owl:onProperty :neighbor;\r\n          owl:maxCardinality 2 ] .\r\n\r\n:neighbor rdfs:domain :Universe; rdfs:range :Universe .\r\n\r\n:x :neighbor :y . \r\n";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read((Reader)new StringReader(src), null, "Turtle");
        model.prepare();
        String ns = "foo:bla#";
        Property left = model.getProperty(ns + "left");
        Property right = model.getProperty(ns + "right");
        Resource[] r = new Resource[6];
        r[1] = model.getProperty(ns + "one");
        r[2] = model.getProperty(ns + "two");
        r[3] = model.getProperty(ns + "three");
        r[4] = model.getProperty(ns + "four");
        r[5] = model.getProperty(ns + "five");
        Model rightValues = ModelFactory.createDefaultModel();
        Model leftValues = ModelFactory.createDefaultModel();
        for (int i = 1; i <= 5; ++i) {
            if (i != 5) {
                this.addStatements(rightValues, r[i], right, new RDFNode[]{r[i + 1]});
            }
            if (i == 1) continue;
            this.addStatements(leftValues, r[i], left, new RDFNode[]{r[i - 1]});
        }
        this.assertPropertyValues((Model)model, left, leftValues);
        this.assertPropertyValues((Model)model, right, rightValues);
    }

    public void testTicket96() {
        OntModel pellet = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        pellet.read(base + "ticket-96-test-case.rdf");
        MiscTests.assertTrue((boolean)pellet.validate().isValid());
    }

    public void testListDirectSubProps() {
        String ns = "urn:test:";
        OntModel reasoner = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        ObjectProperty p = reasoner.createObjectProperty(ns + "p");
        ObjectProperty subP = reasoner.createObjectProperty(ns + "subP");
        ObjectProperty subSubP = reasoner.createObjectProperty(ns + "subSubP");
        DatatypeProperty q = reasoner.createDatatypeProperty(ns + "q");
        DatatypeProperty subQ = reasoner.createDatatypeProperty(ns + "subQ");
        DatatypeProperty subSubQ = reasoner.createDatatypeProperty(ns + "subSubQ");
        Model assertions = ModelFactory.createDefaultModel();
        assertions.add((Resource)subP, RDFS.subPropertyOf, (RDFNode)p);
        assertions.add((Resource)subSubP, RDFS.subPropertyOf, (RDFNode)subP);
        assertions.add((Resource)subQ, RDFS.subPropertyOf, (RDFNode)q);
        assertions.add((Resource)subSubQ, RDFS.subPropertyOf, (RDFNode)subQ);
        reasoner.add(assertions);
        Model inferences = ModelFactory.createDefaultModel();
        inferences.add(assertions);
        for (OntProperty op : new OntProperty[]{p, subP, subSubP, q, subQ, subSubQ}) {
            inferences.add((Resource)op, RDFS.subPropertyOf, (RDFNode)op);
        }
        inferences.add((Resource)subSubP, RDFS.subPropertyOf, (RDFNode)p);
        inferences.add((Resource)subSubQ, RDFS.subPropertyOf, (RDFNode)q);
        this.assertPropertyValues((Model)reasoner, RDFS.subPropertyOf, inferences);
        MiscTests.assertIteratorValues((Iterator)p.listSubProperties(true), new RDFNode[]{subP});
        MiscTests.assertIteratorValues((Iterator)subP.listSuperProperties(true), new RDFNode[]{p});
        MiscTests.assertIteratorValues((Iterator)subP.listSubProperties(true), new RDFNode[]{subSubP});
        MiscTests.assertIteratorValues((Iterator)subSubP.listSuperProperties(true), new RDFNode[]{subP});
        MiscTests.assertIteratorValues((Iterator)q.listSubProperties(true), new RDFNode[]{subQ});
        MiscTests.assertIteratorValues((Iterator)subQ.listSuperProperties(true), new RDFNode[]{q});
        MiscTests.assertIteratorValues((Iterator)subQ.listSubProperties(true), new RDFNode[]{subSubQ});
        MiscTests.assertIteratorValues((Iterator)subSubQ.listSuperProperties(true), new RDFNode[]{subQ});
    }
}

