/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.syncpeer;

import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.DomUpdateSupport;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.image.ImageRenderSupport;
import nextapp.echo2.webcontainer.propertyrender.AlignmentRender;
import nextapp.echo2.webcontainer.propertyrender.ColorRender;
import nextapp.echo2.webcontainer.propertyrender.FontRender;
import nextapp.echo2.webcontainer.propertyrender.ImageReferenceRender;
import nextapp.echo2.webcontainer.propertyrender.LayoutDirectionRender;
import nextapp.echo2.webcontainer.syncpeer.TriCellTable;
import nextapp.echo2.webcontainer.syncpeer.TriCellTableConfigurator;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.util.DomUtil;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LabelPeer
implements DomUpdateSupport,
ImageRenderSupport,
ComponentSynchronizePeer {
    private static final Alignment DEFAULT_TEXT_POSITION = new Alignment(2, 0);
    private static final Extent DEFAULT_ICON_TEXT_MARGIN = new Extent(3);
    private static final String IMAGE_ID_ICON = "icon";

    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        Element domAddElement = DomUpdate.renderElementAdd((ServerMessage)rc.getServerMessage());
        DocumentFragment htmlFragment = rc.getServerMessage().getDocument().createDocumentFragment();
        this.renderHtml(rc, update, htmlFragment, component);
        DomUpdate.renderElementAddContent((ServerMessage)rc.getServerMessage(), (Element)domAddElement, (String)targetId, (DocumentFragment)htmlFragment);
    }

    public String getContainerId(Component child) {
        throw new UnsupportedOperationException("Component does not support children.");
    }

    public ImageReference getImage(Component component, String imageId) {
        if (IMAGE_ID_ICON.equals(imageId)) {
            return (ImageReference)component.getRenderProperty(IMAGE_ID_ICON);
        }
        return null;
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
    }

    public void renderHtml(RenderContext rc, ServerComponentUpdate update, Node parentNode, Component component) {
        Label label = (Label)component;
        ImageReference icon = (ImageReference)label.getRenderProperty(IMAGE_ID_ICON);
        String text = (String)label.getRenderProperty("text");
        if (icon != null) {
            if (text != null) {
                this.renderIconTextLabel(rc, parentNode, label);
            } else {
                this.renderIconLabel(rc, parentNode, label);
            }
        } else if (text != null) {
            this.renderTextLabel(rc, parentNode, label);
        }
    }

    private void renderIconLabel(RenderContext rc, Node parentNode, Label label) {
        Element imgElement = ImageReferenceRender.renderImageReferenceElement(rc, this, (Component)label, IMAGE_ID_ICON);
        imgElement.setAttribute("id", ContainerInstance.getElementId((Component)label));
        imgElement.setAttribute("style", "border:0px none;");
        String toolTipText = (String)label.getRenderProperty("toolTipText");
        if (toolTipText != null) {
            imgElement.setAttribute("title", toolTipText);
        }
        parentNode.appendChild(imgElement);
    }

    private void renderIconTextLabel(RenderContext rc, Node parentNode, Label label) {
        Document document = rc.getServerMessage().getDocument();
        String text = (String)label.getRenderProperty("text");
        Alignment textPosition = (Alignment)label.getRenderProperty("textPosition", (Object)DEFAULT_TEXT_POSITION);
        Extent iconTextMargin = (Extent)label.getRenderProperty("iconTextMargin", (Object)DEFAULT_ICON_TEXT_MARGIN);
        String elementId = ContainerInstance.getElementId((Component)label);
        int orientation = TriCellTableConfigurator.convertIconTextPositionToOrientation(textPosition, (Component)label);
        TriCellTable tct = new TriCellTable(rc, document, elementId, orientation, iconTextMargin);
        tct.addCellCssText("padding:0px;");
        Element textTdElement = tct.getTdElement(0);
        CssStyle textTdCssStyle = new CssStyle();
        textTdCssStyle.setAttribute("border", "0px none");
        if (Boolean.FALSE.equals(label.getRenderProperty("lineWrap"))) {
            textTdCssStyle.setAttribute("white-space", "nowrap");
        }
        AlignmentRender.renderToStyle(textTdCssStyle, (Alignment)label.getRenderProperty("textAlignment"), (Component)label);
        textTdElement.setAttribute("style", textTdElement.getAttribute("style") + textTdCssStyle.renderInline());
        DomUtil.setElementText((Element)textTdElement, (String)text);
        Element imgElement = ImageReferenceRender.renderImageReferenceElement(rc, this, (Component)label, IMAGE_ID_ICON);
        Element iconTdElement = tct.getTdElement(1);
        iconTdElement.appendChild(imgElement);
        Element tableElement = tct.getTableElement();
        tableElement.setAttribute("id", elementId);
        String toolTipText = (String)label.getRenderProperty("toolTipText");
        if (toolTipText != null) {
            tableElement.setAttribute("title", toolTipText);
        }
        CssStyle cssStyle = new CssStyle();
        LayoutDirectionRender.renderToStyle(cssStyle, label.getLayoutDirection(), label.getLocale());
        ColorRender.renderToStyle(cssStyle, (Color)label.getRenderProperty("foreground"), (Color)label.getRenderProperty("background"));
        FontRender.renderToStyle(cssStyle, (Font)label.getRenderProperty("font"));
        cssStyle.setAttribute("border", "0px none");
        cssStyle.setAttribute("border-collapse", "collapse");
        tableElement.setAttribute("style", cssStyle.renderInline());
        parentNode.appendChild(tableElement);
    }

    private void renderTextLabel(RenderContext rc, Node parentNode, Label label) {
        String toolTipText;
        Document document = rc.getServerMessage().getDocument();
        Element spanElement = document.createElement("span");
        spanElement.setAttribute("id", ContainerInstance.getElementId((Component)label));
        DomUtil.setElementText((Element)spanElement, (String)((String)label.getRenderProperty("text")));
        CssStyle cssStyle = new CssStyle();
        if (Boolean.FALSE.equals(label.getRenderProperty("lineWrap"))) {
            cssStyle.setAttribute("white-space", "nowrap");
        }
        ColorRender.renderToStyle(cssStyle, (Color)label.getRenderProperty("foreground"), (Color)label.getRenderProperty("background"));
        FontRender.renderToStyle(cssStyle, (Font)label.getRenderProperty("font"));
        if (cssStyle.hasAttributes()) {
            spanElement.setAttribute("style", cssStyle.renderInline());
        }
        if ((toolTipText = (String)label.getRenderProperty("toolTipText")) != null) {
            spanElement.setAttribute("title", toolTipText);
        }
        parentNode.appendChild(spanElement);
    }

    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)ContainerInstance.getElementId(update.getParent()));
        this.renderAdd(rc, update, targetId, update.getParent());
        return false;
    }
}

