/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app;

import java.io.Serializable;

public class Color
implements Serializable {
    public static final Color BLACK = new Color(0, 0, 0);
    public static final Color BLUE = new Color(0, 0, 255);
    public static final Color GREEN = new Color(0, 255, 0);
    public static final Color CYAN = new Color(0, 255, 255);
    public static final Color RED = new Color(255, 0, 0);
    public static final Color MAGENTA = new Color(255, 0, 255);
    public static final Color YELLOW = new Color(255, 255, 0);
    public static final Color WHITE = new Color(255, 255, 255);
    public static final Color DARKGRAY = new Color(127, 127, 127);
    public static final Color LIGHTGRAY = new Color(175, 175, 175);
    public static final Color ORANGE = new Color(255, 175, 0);
    public static final Color PINK = new Color(255, 175, 175);
    private int rgb;

    public Color(int rgb) {
        this.rgb = rgb;
    }

    public Color(int r, int g, int b) {
        this.rgb = (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public boolean equals(Object o) {
        boolean equal;
        if (this == o) {
            equal = true;
        } else if (o instanceof Color) {
            Color that = (Color)o;
            equal = this.rgb == that.rgb;
        } else {
            equal = false;
        }
        return equal;
    }

    public int getBlue() {
        return this.rgb & 0xFF;
    }

    public int getGreen() {
        return this.rgb >> 8 & 0xFF;
    }

    public int getRed() {
        return this.rgb >> 16;
    }

    public int getRgb() {
        return this.rgb;
    }

    public int hashCode() {
        return this.getRgb();
    }

    public String toString() {
        return this.getClass().getName() + " [r=" + this.getRed() + ",g=" + this.getGreen() + ",b=" + this.getBlue() + "]";
    }
}

