/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.FloatingPane;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Pane;
import nextapp.echo2.app.PaneContainer;
import nextapp.echo2.app.Window;

public class ContentPane
extends Component
implements Pane,
PaneContainer {
    private static final Extent PX_0 = new Extent(0);
    private static final Extent SCROLL_BOTTOM = new Extent(-1);
    public static final String PROPERTY_BACKGROUND_IMAGE = "backgroundImage";
    public static final String PROPERTY_HORIZONTAL_SCROLL = "horizontalScroll";
    public static final String PROPERTY_INSETS = "insets";
    public static final String PROPERTY_VERTICAL_SCROLL = "verticalScroll";

    public FillImage getBackgroundImage() {
        return (FillImage)this.getProperty(PROPERTY_BACKGROUND_IMAGE);
    }

    public Extent getHorizontalScroll() {
        return (Extent)this.getProperty(PROPERTY_HORIZONTAL_SCROLL);
    }

    public Insets getInsets() {
        return (Insets)this.getProperty(PROPERTY_INSETS);
    }

    public Extent getVerticalScroll() {
        return (Extent)this.getProperty(PROPERTY_VERTICAL_SCROLL);
    }

    public boolean isValidChild(Component child) {
        if (child instanceof FloatingPane) {
            return true;
        }
        int componentCount = this.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            if (this.getComponent(i) instanceof FloatingPane) continue;
            return false;
        }
        return true;
    }

    public boolean isValidParent(Component parent) {
        return parent instanceof PaneContainer || parent instanceof Window;
    }

    public void processInput(String inputName, Object inputValue) {
        if (PROPERTY_HORIZONTAL_SCROLL.equals(inputName)) {
            this.setHorizontalScroll((Extent)inputValue);
        } else if (PROPERTY_VERTICAL_SCROLL.equals(inputName)) {
            this.setVerticalScroll((Extent)inputValue);
        }
    }

    public void setBackgroundImage(FillImage newValue) {
        this.setProperty(PROPERTY_BACKGROUND_IMAGE, newValue);
    }

    public void setHorizontalScroll(Extent newValue) {
        this.setProperty(PROPERTY_HORIZONTAL_SCROLL, newValue);
    }

    public void setInsets(Insets newValue) {
        this.setProperty(PROPERTY_INSETS, newValue);
    }

    public void setVerticalScroll(Extent newValue) {
        if (SCROLL_BOTTOM.equals(newValue)) {
            this.setProperty(PROPERTY_VERTICAL_SCROLL, PX_0);
        }
        this.setProperty(PROPERTY_VERTICAL_SCROLL, newValue);
    }
}

