/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app.componentxml.propertypeer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.componentxml.InvalidPropertyException;
import nextapp.echo2.app.componentxml.PropertyXmlPeer;
import nextapp.echo2.app.componentxml.propertypeer.ExtentPeer;
import nextapp.echo2.app.util.DomUtil;
import org.w3c.dom.Element;

public class FontPeer
implements PropertyXmlPeer {
    private static final Map TYPEFACE_TEXT_TO_CONSTANT;

    private Font.Typeface getSimpleTypeface(String name) {
        if (TYPEFACE_TEXT_TO_CONSTANT.containsKey(name)) {
            return (Font.Typeface)TYPEFACE_TEXT_TO_CONSTANT.get(name);
        }
        return new Font.Typeface(name);
    }

    public Object getValue(ClassLoader classLoader, Class objectClass, Element propertyElement) throws InvalidPropertyException {
        Font.Typeface typeface;
        Element[] typefaces;
        Element fontElement = DomUtil.getChildElementByTagName(propertyElement, "font");
        Extent size = null;
        if (fontElement.hasAttribute("size")) {
            String sizeString = fontElement.getAttribute("size");
            size = ExtentPeer.toExtent(sizeString);
        }
        int style = 0;
        if ("true".equals(fontElement.getAttribute("bold"))) {
            style |= 1;
        }
        if ("true".equals(fontElement.getAttribute("italic"))) {
            style |= 2;
        }
        if ("true".equals(fontElement.getAttribute("underline"))) {
            style |= 4;
        }
        if ("true".equals(fontElement.getAttribute("overline"))) {
            style |= 8;
        }
        if ("true".equals(fontElement.getAttribute("line-through"))) {
            style |= 0x10;
        }
        if ((typefaces = DomUtil.getChildElementsByTagName(fontElement, "typeface")).length == 0) {
            typeface = fontElement.hasAttribute("typeface") ? this.getSimpleTypeface(fontElement.getAttribute("typeface")) : null;
        } else if (typefaces.length == 1) {
            typeface = this.getSimpleTypeface(typefaces[0].getAttribute("name"));
        } else {
            typeface = new Font.Typeface(typefaces[typefaces.length - 1].getAttribute("name"));
            for (int i = typefaces.length - 2; i >= 0; --i) {
                typeface = new Font.Typeface(typefaces[i].getAttribute("name"), typeface);
            }
        }
        return new Font(typeface, style, size);
    }

    static {
        HashMap<String, Font.Typeface> constantMap = new HashMap<String, Font.Typeface>();
        constantMap.put("Helvetica", Font.HELVETICA);
        constantMap.put("Arial", Font.ARIAL);
        constantMap.put("Verdana", Font.VERDANA);
        constantMap.put("Times", Font.TIMES);
        constantMap.put("Times Roman", Font.TIMES_ROMAN);
        constantMap.put("Times New Roman", Font.TIMES_NEW_ROMAN);
        constantMap.put("Courier", Font.COURIER);
        constantMap.put("Courier New", Font.COURIER_NEW);
        TYPEFACE_TEXT_TO_CONSTANT = Collections.unmodifiableMap(constantMap);
    }
}

