/*
 * Decompiled with CFR 0.152.
 */
package echopointng.image;

import echopointng.image.BaseImageEncoder;
import echopointng.image.GifEncoderHashItem;
import echopointng.image.IntHashtable;
import java.awt.Image;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;

class GifEncoderInternal
extends BaseImageEncoder {
    static final int BITS = 12;
    static final int EOF = -1;
    static final int HSIZE = 5003;
    int a_count;
    byte[] accum = new byte[256];
    boolean clear_flg = false;
    int clearCode;
    int[] codetab = new int[5003];
    IntHashtable colorHash;
    int countDown;
    int cur_accum = 0;
    int cur_bits = 0;
    int curx;
    int cury;
    int encodeWidth;
    int encodeHeight;
    int eofCode;
    int free_ent = 0;
    int g_init_bits;
    int hsize = 5003;
    int[] htab = new int[5003];
    private boolean interlace = false;
    int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
    int maxbits = 12;
    int maxcode;
    int maxmaxcode = 4096;
    int n_bits;
    int passCount = 0;
    int[][] rgbPixels;
    int width;
    int height;

    public GifEncoderInternal(Image img, OutputStream out) {
        super(img, out);
    }

    public GifEncoderInternal(Image img, OutputStream out, boolean interlace) {
        super(img, out);
        this.interlace = interlace;
    }

    void bumpPixel() {
        ++this.curx;
        if (this.curx == this.encodeWidth) {
            this.curx = 0;
            if (!this.interlace) {
                ++this.cury;
            } else {
                switch (this.passCount) {
                    case 0: {
                        this.cury += 8;
                        if (this.cury < this.encodeHeight) break;
                        ++this.passCount;
                        this.cury = 4;
                        break;
                    }
                    case 1: {
                        this.cury += 8;
                        if (this.cury < this.encodeHeight) break;
                        ++this.passCount;
                        this.cury = 2;
                        break;
                    }
                    case 2: {
                        this.cury += 4;
                        if (this.cury < this.encodeHeight) break;
                        ++this.passCount;
                        this.cury = 1;
                        break;
                    }
                    case 3: {
                        this.cury += 2;
                    }
                }
            }
        }
    }

    void char_init() {
        this.a_count = 0;
    }

    void char_out(byte c, OutputStream outs) throws IOException {
        this.accum[this.a_count++] = c;
        if (this.a_count >= 254) {
            this.flush_char(outs);
        }
    }

    void cl_block(OutputStream outs) throws IOException {
        this.cl_hash(this.hsize);
        this.free_ent = this.clearCode + 2;
        this.clear_flg = true;
        this.output(this.clearCode, outs);
    }

    void cl_hash(int hsize) {
        for (int i = 0; i < hsize; ++i) {
            this.htab[i] = -1;
        }
    }

    void compress(int init_bits, OutputStream outs) throws IOException {
        int c;
        int fcode;
        this.g_init_bits = init_bits;
        this.clear_flg = false;
        this.n_bits = this.g_init_bits;
        this.maxcode = this.maxcode(this.n_bits);
        this.clearCode = 1 << init_bits - 1;
        this.eofCode = this.clearCode + 1;
        this.free_ent = this.clearCode + 2;
        this.char_init();
        int ent = this.nextPixel();
        int hshift = 0;
        for (fcode = this.hsize; fcode < 65536; fcode *= 2) {
            ++hshift;
        }
        hshift = 8 - hshift;
        int hsize_reg = this.hsize;
        this.cl_hash(hsize_reg);
        this.output(this.clearCode, outs);
        block1: while ((c = this.nextPixel()) != -1) {
            int i = c << hshift ^ ent;
            fcode = (c << this.maxbits) + ent;
            if (this.htab[i] == fcode) {
                ent = this.codetab[i];
                continue;
            }
            if (this.htab[i] >= 0) {
                int disp = hsize_reg - i;
                if (i == 0) {
                    disp = 1;
                }
                do {
                    if ((i -= disp) < 0) {
                        i += hsize_reg;
                    }
                    if (this.htab[i] != fcode) continue;
                    ent = this.codetab[i];
                    continue block1;
                } while (this.htab[i] >= 0);
            }
            this.output(ent, outs);
            ent = c;
            if (this.free_ent < this.maxmaxcode) {
                ++this.free_ent;
                this.htab[i] = fcode;
                continue;
            }
            this.cl_block(outs);
        }
        this.output(ent, outs);
        this.output(this.eofCode, outs);
    }

    public void encode() throws IOException {
        super.encode();
    }

    void encodeDone() throws IOException {
        int transparentIndex = -1;
        int transparentRgb = -1;
        this.colorHash = new IntHashtable();
        int index = 0;
        for (int row = 0; row < this.height; ++row) {
            for (int col = 0; col < this.width; ++col) {
                GifEncoderHashItem item;
                boolean isTransparent;
                int rgb = this.rgbPixels[row][col];
                boolean bl = isTransparent = rgb >>> 24 < 128;
                if (isTransparent) {
                    if (transparentIndex < 0) {
                        transparentIndex = index;
                        transparentRgb = rgb;
                    } else if (rgb != transparentRgb) {
                        this.rgbPixels[row][col] = rgb = transparentRgb;
                    }
                }
                if ((item = (GifEncoderHashItem)this.colorHash.get(rgb)) == null) {
                    if (index >= 256) {
                        throw new IOException("too many colors for a GIF");
                    }
                    item = new GifEncoderHashItem(rgb, 1, index, isTransparent);
                    ++index;
                    this.colorHash.put(rgb, (Object)item);
                    continue;
                }
                ++item.count;
            }
        }
        int logColors = index <= 2 ? 1 : (index <= 4 ? 2 : (index <= 16 ? 4 : 8));
        int mapSize = 1 << logColors;
        byte[] reds = new byte[mapSize];
        byte[] grns = new byte[mapSize];
        byte[] blus = new byte[mapSize];
        Enumeration e = this.colorHash.elements();
        while (e.hasMoreElements()) {
            GifEncoderHashItem item = (GifEncoderHashItem)e.nextElement();
            reds[item.index] = (byte)(item.rgb >> 16 & 0xFF);
            grns[item.index] = (byte)(item.rgb >> 8 & 0xFF);
            blus[item.index] = (byte)(item.rgb & 0xFF);
        }
        this.gifEncode(this.out, this.width, this.height, (byte)0, transparentIndex, logColors, reds, grns, blus);
    }

    void encodePixels(int x, int y, int w, int h, int[] rgbPixels, int off, int scansize) throws IOException {
        for (int row = 0; row < h; ++row) {
            System.arraycopy(rgbPixels, row * scansize + off, this.rgbPixels[y + row], x, w);
        }
    }

    void encodeStart(int width, int height) throws IOException {
        this.width = width;
        this.height = height;
        this.rgbPixels = new int[height][width];
    }

    void flush_char(OutputStream outs) throws IOException {
        if (this.a_count > 0) {
            outs.write(this.a_count);
            outs.write(this.accum, 0, this.a_count);
            this.a_count = 0;
        }
    }

    byte getPixel(int x, int y) throws IOException {
        GifEncoderHashItem item = (GifEncoderHashItem)this.colorHash.get(this.rgbPixels[y][x]);
        if (item == null) {
            throw new IOException("color not found");
        }
        return (byte)item.index;
    }

    void gifEncode(OutputStream outs, int encodeWidth, int encodeHeight, byte Background, int Transparent, int BitsPerPixel, byte[] Red, byte[] Green, byte[] Blue) throws IOException {
        this.encodeWidth = encodeWidth;
        this.encodeHeight = encodeHeight;
        int ColorMapSize = 1 << BitsPerPixel;
        int TopOfs = 0;
        int LeftOfs = 0;
        this.countDown = encodeWidth * encodeHeight;
        this.passCount = 0;
        int InitCodeSize = BitsPerPixel <= 1 ? 2 : BitsPerPixel;
        this.curx = 0;
        this.cury = 0;
        this.writeString(outs, "GIF89a");
        this.putWord(encodeWidth, outs);
        this.putWord(encodeHeight, outs);
        byte B = -128;
        B = (byte)(B | 0x70);
        B = (byte)(B | (byte)(BitsPerPixel - 1));
        this.putByte(B, outs);
        this.putByte(Background, outs);
        this.putByte((byte)0, outs);
        for (int i = 0; i < ColorMapSize; ++i) {
            this.putByte(Red[i], outs);
            this.putByte(Green[i], outs);
            this.putByte(Blue[i], outs);
        }
        if (Transparent != -1) {
            this.putByte((byte)33, outs);
            this.putByte((byte)-7, outs);
            this.putByte((byte)4, outs);
            this.putByte((byte)1, outs);
            this.putByte((byte)0, outs);
            this.putByte((byte)0, outs);
            this.putByte((byte)Transparent, outs);
            this.putByte((byte)0, outs);
        }
        this.putByte((byte)44, outs);
        this.putWord(LeftOfs, outs);
        this.putWord(TopOfs, outs);
        this.putWord(encodeWidth, outs);
        this.putWord(encodeHeight, outs);
        if (this.interlace) {
            this.putByte((byte)64, outs);
        } else {
            this.putByte((byte)0, outs);
        }
        this.putByte((byte)InitCodeSize, outs);
        this.compress(InitCodeSize + 1, outs);
        this.putByte((byte)0, outs);
        this.putByte((byte)59, outs);
    }

    int maxcode(int n_bits) {
        return (1 << n_bits) - 1;
    }

    int nextPixel() throws IOException {
        if (this.countDown == 0) {
            return -1;
        }
        --this.countDown;
        byte r = this.getPixel(this.curx, this.cury);
        this.bumpPixel();
        return r & 0xFF;
    }

    void output(int code, OutputStream outs) throws IOException {
        this.cur_accum &= this.masks[this.cur_bits];
        this.cur_accum = this.cur_bits > 0 ? (this.cur_accum |= code << this.cur_bits) : code;
        this.cur_bits += this.n_bits;
        while (this.cur_bits >= 8) {
            this.char_out((byte)(this.cur_accum & 0xFF), outs);
            this.cur_accum >>= 8;
            this.cur_bits -= 8;
        }
        if (this.free_ent > this.maxcode || this.clear_flg) {
            if (this.clear_flg) {
                this.n_bits = this.g_init_bits;
                this.maxcode = this.maxcode(this.n_bits);
                this.clear_flg = false;
            } else {
                ++this.n_bits;
                this.maxcode = this.n_bits == this.maxbits ? this.maxmaxcode : this.maxcode(this.n_bits);
            }
        }
        if (code == this.eofCode) {
            while (this.cur_bits > 0) {
                this.char_out((byte)(this.cur_accum & 0xFF), outs);
                this.cur_accum >>= 8;
                this.cur_bits -= 8;
            }
            this.flush_char(outs);
        }
    }

    void putByte(byte b, OutputStream outs) throws IOException {
        outs.write(b);
    }

    void putWord(int w, OutputStream outs) throws IOException {
        this.putByte((byte)(w & 0xFF), outs);
        this.putByte((byte)(w >> 8 & 0xFF), outs);
    }

    void writeString(OutputStream out, String str) throws IOException {
        byte[] buf = str.getBytes();
        out.write(buf);
    }
}

