/*
 * Decompiled with CFR 0.152.
 */
package echopointng.stylesheet.test;

import echopointng.TemplatePanel;
import echopointng.Tree;
import echopointng.stylesheet.CssStyleSheetException;
import echopointng.stylesheet.CssStyleSheetLoader;
import echopointng.template.JspTemplateDataSource;
import echopointng.template.TemplateCachingHints;
import echopointng.template.TemplateDataSource;
import java.util.Locale;
import junit.framework.TestCase;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.HttpImageReference;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.StyleSheet;
import nextapp.echo2.app.TextField;

public class CssStyleSheetTest
extends TestCase {
    private StyleSheet loadSS(String sheetName) {
        try {
            return CssStyleSheetLoader.load("echopointng/stylesheet/test/" + sheetName, Thread.currentThread().getContextClassLoader());
        }
        catch (CssStyleSheetException sse) {
            System.out.println(sse);
            sse.printStackTrace(System.out);
            return null;
        }
    }

    public void testStyleSheetCompound2() {
        StyleSheet styleSheet = this.loadSS("stylesheetCompound2.css");
        CssStyleSheetTest.assertNotNull((Object)styleSheet);
        Style style = styleSheet.getStyle(Tree.class, null);
        CssStyleSheetTest.assertNotNull((Object)style);
        CssStyleSheetTest.assertEquals((Object)style.getProperty("foreground"), (Object)Color.WHITE);
        CssStyleSheetTest.assertEquals((Object)style.getProperty("background"), (Object)new Color(255));
        style = styleSheet.getStyle(Label.class, null);
        CssStyleSheetTest.assertNotNull((Object)style);
        CssStyleSheetTest.assertNotNull((Object)style.getProperty("icon"));
        ImageReference imageRef = (ImageReference)style.getProperty("icon");
        CssStyleSheetTest.assertTrue((boolean)(imageRef instanceof HttpImageReference));
        HttpImageReference httpImageRef = (HttpImageReference)imageRef;
        CssStyleSheetTest.assertEquals((String)httpImageRef.getUri(), (String)"/image/testGif.png");
        CssStyleSheetTest.assertEquals((String)httpImageRef.getWidth().toString(), (String)"9px");
        CssStyleSheetTest.assertEquals((String)httpImageRef.getHeight().toString(), (String)"12pt");
    }

    public void testStyleSheetCompound1() {
        StyleSheet styleSheet = this.loadSS("stylesheetCompound1.css");
        CssStyleSheetTest.assertNotNull((Object)styleSheet);
        Style style = styleSheet.getStyle(TemplatePanel.class, null);
        CssStyleSheetTest.assertNull((Object)style);
        style = styleSheet.getStyle(TemplatePanel.class, "inst1");
        CssStyleSheetTest.assertNotNull((Object)style);
        CssStyleSheetTest.assertEquals((Object)style.getProperty("foreground"), (Object)Color.RED);
        CssStyleSheetTest.assertTrue((boolean)(style.getProperty("templateDataSource") instanceof JspTemplateDataSource));
        TemplateDataSource tds = (TemplateDataSource)style.getProperty("templateDataSource");
        CssStyleSheetTest.assertTrue((tds.getCanonicalName().indexOf("/jsp/test1.jsp") != -1 ? 1 : 0) != 0);
        TemplateCachingHints hints = tds.getCachingHints();
        CssStyleSheetTest.assertNotNull((Object)hints);
        CssStyleSheetTest.assertTrue((hints.getAccessTimeout() == 10000L ? 1 : 0) != 0);
        CssStyleSheetTest.assertTrue((hints.getTimeToLive() == 20000L ? 1 : 0) != 0);
    }

    public void testStyleSheet1() {
        StyleSheet styleSheet = this.loadSS("stylesheet1.css");
        CssStyleSheetTest.assertNotNull((Object)styleSheet);
    }

    public void testStyleSheet2() {
        StyleSheet styleSheet = this.loadSS("stylesheet2.css");
        CssStyleSheetTest.assertNotNull((Object)styleSheet);
        Style style = styleSheet.getStyle(Button.class, "modern");
        CssStyleSheetTest.assertNotNull((Object)style);
        CssStyleSheetTest.assertEquals((Object)style.getProperty("foreground"), (Object)Color.RED);
        CssStyleSheetTest.assertEquals((Object)style.getProperty("rolloverEnabled"), (Object)Boolean.FALSE);
        CssStyleSheetTest.assertEquals((Object)style.getProperty("locale"), (Object)Locale.US);
        style = styleSheet.getStyle(Component.class, "light");
        CssStyleSheetTest.assertNotNull((Object)style);
        CssStyleSheetTest.assertEquals((Object)style.getProperty("background"), (Object)Color.WHITE);
        CssStyleSheetTest.assertEquals((Object)style.getProperty("visible"), (Object)Boolean.FALSE);
        style = styleSheet.getStyle(Component.class, "dark");
        CssStyleSheetTest.assertNotNull((Object)style);
        CssStyleSheetTest.assertEquals((Object)style.getProperty("background"), (Object)Color.BLACK);
        CssStyleSheetTest.assertEquals((Object)style.getProperty("visible"), (Object)Boolean.FALSE);
        style = styleSheet.getStyle(Component.class, null);
        CssStyleSheetTest.assertNotNull((Object)style);
        CssStyleSheetTest.assertEquals((Object)style.getProperty("background"), (Object)Color.ORANGE);
        CssStyleSheetTest.assertEquals((Object)style.getProperty("visible"), (Object)Boolean.FALSE);
        style = styleSheet.getStyle(Component.class, "extraInfo");
        CssStyleSheetTest.assertNotNull((Object)style);
        CssStyleSheetTest.assertEquals((Object)style.getProperty("background"), (Object)Color.WHITE);
        CssStyleSheetTest.assertEquals((Object)style.getProperty("visible"), (Object)Boolean.FALSE);
        CssStyleSheetTest.assertEquals((Object)style.getProperty("foreground"), (Object)Color.BLACK);
        style = styleSheet.getStyle(SelectField.class, "noBaseClass");
        CssStyleSheetTest.assertNotNull((Object)style);
        CssStyleSheetTest.assertEquals((Object)style.getProperty("foreground"), (Object)Color.BLACK);
    }

    public void testStyleSheet3() {
        StyleSheet styleSheet = this.loadSS("stylesheet3.css");
        CssStyleSheetTest.assertNotNull((Object)styleSheet);
        Style style = styleSheet.getStyle(SelectField.class, "noBaseClass");
        CssStyleSheetTest.assertNotNull((Object)style);
        CssStyleSheetTest.assertEquals((Object)style.getProperty("foreground"), (Object)Color.BLACK);
        style = styleSheet.getStyle(TextField.class, "useInheritance");
        CssStyleSheetTest.assertNotNull((Object)style);
        CssStyleSheetTest.assertEquals((Object)style.getProperty("foreground"), (Object)Color.BLACK);
        CssStyleSheetTest.assertEquals((Object)style.getProperty("background"), (Object)Color.RED);
    }
}

