/*
 * Decompiled with CFR 0.152.
 */
package echopointng.tabbedpane;

import echopointng.BorderEx;
import echopointng.ButtonEx;
import echopointng.EPNG;
import echopointng.MutableStyleEx;
import echopointng.TabbedPane;
import echopointng.tabbedpane.AbstractTabModel;
import echopointng.util.ColorKit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Style;

public class DefaultTabModel
extends AbstractTabModel
implements Serializable {
    private static final Color XP_ORANGE = ColorKit.makeColor("#FFC73C");
    private static final Color XP_BLUEISH_WHITE = ColorKit.makeColor("#FAFAF9");
    private static final Color DEFAULT_SELECTED_BACKGROUND = Color.WHITE;
    private static final Color DEFAULT_SELECTED_FOREGROUND = Color.BLACK;
    private static final Color DEFAULT_SELECTED_ROLLOVER_BACKGROUND = Color.WHITE;
    public static final Color DEFAULT_SELECTED_ROLLOVER_FOREGROUND = Color.BLACK;
    private static final Color DEFAULT_BACKGROUND = XP_BLUEISH_WHITE;
    private static final Color DEFAULT_FOREGROUND = Color.BLACK;
    private static final Color DEFAULT_ROLLOVER_BACKGROUND = XP_BLUEISH_WHITE;
    private static final Color DEFAULT_ROLLOVER_FOREGROUND = Color.BLACK;
    public static Style DEFAULT_TOP_ALIGNED_STYLE;
    public static Style DEFAULT_TOP_ALIGNED_SELECTED_STYLE;
    public static Style DEFAULT_BOTTOM_ALIGNED_STYLE;
    public static Style DEFAULT_BOTTOM_ALIGNED_SELECTED_STYLE;
    private List tabEntryList = this.createTabEntryList();

    protected List createTabEntryList() {
        return new ArrayList();
    }

    protected List getTabEntryList() {
        return this.tabEntryList;
    }

    public int size() {
        return this.getTabEntryList().size();
    }

    public Component getTabAt(TabbedPane tabbedPane, int index, boolean isSelected) {
        List tabList = this.getTabEntryList();
        if (index < 0 || index > tabList.size()) {
            return null;
        }
        TabEntry entry = (TabEntry)tabList.get(index);
        Component tabComponent = entry.getTabComponent();
        if (tabComponent != null) {
            int tabPlacement = EPNG.getRP((Component)tabbedPane, "tabPlacement", tabbedPane.getTabPlacement());
            this.paintTabComponent(tabbedPane, tabComponent, isSelected, tabPlacement);
        }
        return tabComponent;
    }

    public Component getTabContentAt(int index) {
        List tabList = this.getTabEntryList();
        if (index < 0 || index > tabList.size()) {
            return null;
        }
        TabEntry entry = (TabEntry)tabList.get(index);
        return entry.getTabContent();
    }

    public void releaseTabAt(int index) {
    }

    protected Component createTabComponent(String tabTitle, ImageReference tabIcon) {
        ButtonEx tabComponent = new ButtonEx(tabTitle, tabIcon);
        tabComponent.setStyle(DEFAULT_TOP_ALIGNED_STYLE);
        return tabComponent;
    }

    public void insertTab(int index, Component tabComponent, Component tabContent) {
        TabEntry entry = new TabEntry(tabComponent, tabContent);
        this.getTabEntryList().add(index, entry);
        this.fireStateChanged();
    }

    public void insertTab(int index, String tabTitle, ImageReference tabIcon, Component tabContent) {
        Component tabComponent = this.createTabComponent(tabTitle, tabIcon);
        this.insertTab(index, tabComponent, tabContent);
    }

    public void addTab(Component tabComponent, Component tabContent) {
        this.insertTab(this.getTabEntryList().size(), tabComponent, tabContent);
    }

    public void addTab(String tabTitle, Component tabContent) {
        this.addTab(tabTitle, null, tabContent);
    }

    public void addTab(ImageReference icon, Component tabContent) {
        this.addTab(null, icon, tabContent);
    }

    public void addTab(String tabTitle, ImageReference icon, Component tabContent) {
        this.insertTab(this.getTabEntryList().size(), tabTitle, icon, tabContent);
    }

    public void removeTabAt(int index) {
        this.getTabEntryList().remove(index);
        this.fireStateChanged();
    }

    public int indexOfTab(Component tabComponent) {
        List tabList = this.getTabEntryList();
        for (int i = 0; i < tabList.size(); ++i) {
            TabEntry entry = (TabEntry)tabList.get(i);
            if (entry.getTabComponent() != tabComponent) continue;
            return i;
        }
        return -1;
    }

    public int indexOfTabContent(Component tabContent) {
        List tabList = this.getTabEntryList();
        for (int i = 0; i < tabList.size(); ++i) {
            TabEntry entry = (TabEntry)tabList.get(i);
            if (entry.getTabContent() != tabContent) continue;
            return i;
        }
        return -1;
    }

    protected void paintTabComponent(TabbedPane tabbedPane, Component tabComponent, boolean isSelected, int tabPlacement) {
        if (isSelected) {
            if (tabPlacement == 6) {
                tabComponent.setStyle(DEFAULT_TOP_ALIGNED_SELECTED_STYLE);
            } else {
                tabComponent.setStyle(DEFAULT_BOTTOM_ALIGNED_SELECTED_STYLE);
            }
        } else if (tabPlacement == 6) {
            tabComponent.setStyle(DEFAULT_TOP_ALIGNED_STYLE);
        } else {
            tabComponent.setStyle(DEFAULT_BOTTOM_ALIGNED_STYLE);
        }
    }

    static {
        MutableStyleEx baseStyle = new MutableStyleEx();
        baseStyle.setProperty("insets", new Insets(3));
        baseStyle.setProperty("outsets", new Insets(0));
        MutableStyleEx style = new MutableStyleEx((Style)baseStyle);
        style.setProperty("background", DEFAULT_BACKGROUND);
        style.setProperty("foreground", DEFAULT_FOREGROUND);
        style.setProperty("border", (Object)new BorderEx(new Extent(1), DEFAULT_BACKGROUND, 1, new Extent(1), DEFAULT_BACKGROUND, 1, new Extent(2), DEFAULT_BACKGROUND, 1, new Extent(1), DEFAULT_BACKGROUND, 1));
        style.setProperty("rolloverBackground", DEFAULT_ROLLOVER_BACKGROUND);
        style.setProperty("rolloverForeground", DEFAULT_ROLLOVER_FOREGROUND);
        style.setProperty("rolloverBorder", (Object)new BorderEx(new Extent(1), DEFAULT_ROLLOVER_BACKGROUND, 1, new Extent(1), DEFAULT_ROLLOVER_BACKGROUND, 1, new Extent(2), XP_ORANGE, 1, new Extent(1), DEFAULT_ROLLOVER_BACKGROUND, 1));
        DEFAULT_TOP_ALIGNED_STYLE = style;
        style = new MutableStyleEx((Style)baseStyle);
        style.setProperty("background", DEFAULT_SELECTED_BACKGROUND);
        style.setProperty("foreground", DEFAULT_SELECTED_FOREGROUND);
        style.setProperty("border", (Object)new BorderEx(new Extent(1), DEFAULT_SELECTED_BACKGROUND, 1, new Extent(1), DEFAULT_SELECTED_BACKGROUND, 1, new Extent(2), XP_ORANGE, 1, new Extent(1), DEFAULT_SELECTED_BACKGROUND, 1));
        style.setProperty("rolloverBackground", DEFAULT_SELECTED_ROLLOVER_BACKGROUND);
        style.setProperty("rolloverForeground", DEFAULT_SELECTED_ROLLOVER_FOREGROUND);
        style.setProperty("rolloverBorder", (Object)new BorderEx(new Extent(1), DEFAULT_SELECTED_ROLLOVER_BACKGROUND, 1, new Extent(1), DEFAULT_SELECTED_ROLLOVER_BACKGROUND, 1, new Extent(2), XP_ORANGE, 1, new Extent(1), DEFAULT_SELECTED_ROLLOVER_BACKGROUND, 1));
        DEFAULT_TOP_ALIGNED_SELECTED_STYLE = style;
        style = new MutableStyleEx((Style)baseStyle);
        style.setProperty("background", DEFAULT_BACKGROUND);
        style.setProperty("foreground", DEFAULT_FOREGROUND);
        style.setProperty("border", (Object)new BorderEx(new Extent(1), DEFAULT_BACKGROUND, 1, new Extent(1), DEFAULT_BACKGROUND, 1, new Extent(1), DEFAULT_BACKGROUND, 1, new Extent(2), DEFAULT_BACKGROUND, 1));
        style.setProperty("rolloverBackground", DEFAULT_ROLLOVER_BACKGROUND);
        style.setProperty("rolloverForeground", DEFAULT_ROLLOVER_FOREGROUND);
        style.setProperty("rolloverBorder", (Object)new BorderEx(new Extent(1), DEFAULT_BACKGROUND, 1, new Extent(1), DEFAULT_BACKGROUND, 1, new Extent(1), DEFAULT_BACKGROUND, 1, new Extent(2), XP_ORANGE, 1));
        DEFAULT_BOTTOM_ALIGNED_STYLE = style;
        style = new MutableStyleEx((Style)baseStyle);
        style.setProperty("background", DEFAULT_SELECTED_BACKGROUND);
        style.setProperty("foreground", DEFAULT_SELECTED_FOREGROUND);
        style.setProperty("border", (Object)new BorderEx(new Extent(1), DEFAULT_SELECTED_BACKGROUND, 1, new Extent(1), DEFAULT_SELECTED_BACKGROUND, 1, new Extent(1), DEFAULT_SELECTED_BACKGROUND, 1, new Extent(2), XP_ORANGE, 1));
        style.setProperty("rolloverBackground", DEFAULT_SELECTED_ROLLOVER_BACKGROUND);
        style.setProperty("rolloverForeground", DEFAULT_SELECTED_ROLLOVER_FOREGROUND);
        style.setProperty("rolloverBorder", (Object)new BorderEx(new Extent(1), DEFAULT_SELECTED_ROLLOVER_BACKGROUND, 1, new Extent(1), DEFAULT_SELECTED_ROLLOVER_BACKGROUND, 1, new Extent(1), DEFAULT_SELECTED_ROLLOVER_BACKGROUND, 1, new Extent(2), XP_ORANGE, 1));
        DEFAULT_BOTTOM_ALIGNED_SELECTED_STYLE = style;
    }

    protected class TabEntry
    implements Serializable {
        protected Component tabComponent = null;
        protected Component tabContent = null;

        public TabEntry(Component tabComponent, Component tabContent) {
            this.tabComponent = tabComponent;
            this.tabContent = tabContent;
        }

        public Component getTabComponent() {
            return this.tabComponent;
        }

        public Component getTabContent() {
            return this.tabContent;
        }
    }
}

