/*
 * Decompiled with CFR 0.152.
 */
package echopointng.tabbedpane.test;

import echopointng.TabbedPane;
import echopointng.tabbedpane.DefaultTabModel;
import echopointng.tabbedpane.test.LazyTabModel;
import echopointng.util.RandKit;
import junit.framework.TestCase;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;

public class TabbedPaneTest
extends TestCase {
    public void testTabModels() {
        LazyTabModel lazyTabModel = new LazyTabModel();
        TabbedPane tabbedPane = new TabbedPane(lazyTabModel);
        Component content = null;
        Component tab = null;
        int tabCount = tabbedPane.getModel().size();
        for (int i = 0; i < 20; ++i) {
            int index = RandKit.rand(0, tabCount - 1);
            tabbedPane.getSelectionModel().setSelectedIndex(index);
            content = tabbedPane.getModel().getTabContentAt(index);
            TabbedPaneTest.assertNotNull((Object)content);
            TabbedPaneTest.assertEquals((int)tabbedPane.getSelectionModel().getSelectedIndex(), (int)index);
            tab = tabbedPane.getModel().getTabAt(tabbedPane, index, true);
            TabbedPaneTest.assertNotNull((Object)tab);
            TabbedPaneTest.assertEquals((Object)tab.getForeground(), (Object)Color.ORANGE);
            tabbedPane.validate();
            content = tabbedPane.getModel().getTabContentAt(index);
            TabbedPaneTest.assertNotNull((Object)content);
            TabbedPaneTest.assertTrue((boolean)tabbedPane.isAncestorOf(content));
            TabbedPaneTest.assertEquals((int)tabbedPane.getSelectionModel().getSelectedIndex(), (int)index);
        }
        lazyTabModel.fireStateChanged();
        TabbedPaneTest.assertTrue((boolean)tabbedPane.isAncestorOf(content));
    }

    public void testDefaultTabModel() {
        DefaultTabModel model = new DefaultTabModel();
        model.addTab("Tab 1", null, (Component)new Label("Content 1"));
        TabbedPaneTest.assertTrue((model.size() == 1 ? 1 : 0) != 0);
        model.addTab("Tab 2", null, (Component)new Label("Content 2"));
        TabbedPaneTest.assertTrue((model.size() == 2 ? 1 : 0) != 0);
        model.releaseTabAt(0);
        TabbedPaneTest.assertTrue((model.size() == 2 ? 1 : 0) != 0);
        model.removeTabAt(0);
        TabbedPaneTest.assertTrue((model.size() == 1 ? 1 : 0) != 0);
    }
}

