/*
 * Decompiled with CFR 0.152.
 */
package echopointng.table;

import echopointng.table.PageableTableModel;
import java.util.Arrays;
import java.util.List;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;

public class PageableTableNavigation
extends Row {
    private PageableTableModel model;
    private static final Object[] ROWS_PER_PAGE_OPTIONS = new String[]{"10", "25", "50", "100"};
    private static final List ROWS_PER_PAGE_LIST = Arrays.asList(ROWS_PER_PAGE_OPTIONS);
    private boolean rowsPerPageSelectShow = true;
    private Button previousButton;
    private Button nextButton;
    private Label pageLabel;

    public PageableTableNavigation(Table table) {
        this.model = (PageableTableModel)table.getModel();
    }

    public void init() {
        super.init();
        this.reset();
    }

    protected void doLayout() {
        this.setCellSpacing(new Extent(10));
        this.add((Component)this.getPreviousButton());
        if (this.getRowsPerPageSelectShow()) {
            this.add((Component)this.getRowsPerPageSelect());
        }
        this.add((Component)this.getPageLabel());
        this.add((Component)this.getPageSelect());
        this.add((Component)this.getPageCountLabel());
        this.add((Component)this.getNextButton());
    }

    protected void reset() {
        this.removeAll();
        this.doLayout();
    }

    protected PageableTableModel getModel() {
        return this.model;
    }

    private SelectField getPageSelect() {
        Object[] pages = new String[this.model.getTotalPages()];
        for (int i = 0; i < pages.length; ++i) {
            pages[i] = "" + (i + 1);
        }
        SelectField select = new SelectField(pages);
        select.setSelectedIndex(this.model.getCurrentPage());
        select.addActionListener(this.getPageSelectListener());
        return select;
    }

    private ActionListener getPageSelectListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectField select = (SelectField)e.getSource();
                int selected = select.getSelectedIndex();
                PageableTableNavigation.this.model.setCurrentPage(selected);
                PageableTableNavigation.this.reset();
            }
        };
    }

    private Label getPageLabel() {
        if (this.pageLabel == null) {
            Label label = new Label(" Page ");
            this.setPageLabel(label);
        }
        return this.pageLabel;
    }

    public void setPageLabel(Label label) {
        this.pageLabel = label;
    }

    private Label getPageCountLabel() {
        Label label = new Label();
        label.setText(" of " + this.model.getTotalPages() + " ");
        return label;
    }

    private void setPageCountLabel(Label label) {
    }

    private SelectField getRowsPerPageSelect() {
        SelectField resultsPerPage = new SelectField(ROWS_PER_PAGE_OPTIONS);
        resultsPerPage.addActionListener(this.getRowsPerPageListener());
        int index = ROWS_PER_PAGE_LIST.indexOf("" + this.model.getRowsPerPage());
        resultsPerPage.setSelectedIndex(index);
        return resultsPerPage;
    }

    private boolean getRowsPerPageSelectShow() {
        return this.rowsPerPageSelectShow;
    }

    public void setRowsPerPageSelectShow(boolean show) {
        this.rowsPerPageSelectShow = show;
    }

    private ActionListener getRowsPerPageListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectField select = (SelectField)e.getSource();
                Integer selected = new Integer((String)select.getSelectedItem());
                PageableTableNavigation.this.getModel().setRowsPerPage(selected);
                PageableTableNavigation.this.getModel().setCurrentPage(0);
                PageableTableNavigation.this.reset();
            }
        };
    }

    private Button getPreviousButton() {
        if (this.previousButton == null) {
            this.setPreviousButton(new Button("< Previous"));
        }
        return this.previousButton;
    }

    public void setPreviousButton(Button button) {
        if (this.previousButton != null) {
            this.previousButton.removeActionListener(this.getPreviousListener());
        }
        this.previousButton = button;
        this.previousButton.addActionListener(this.getPreviousListener());
    }

    private ActionListener getPreviousListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PageableTableNavigation.this.getModel().getCurrentPage() > 0) {
                    PageableTableNavigation.this.getModel().setCurrentPage(PageableTableNavigation.this.getModel().getCurrentPage() - 1);
                    PageableTableNavigation.this.reset();
                }
            }
        };
    }

    private Button getNextButton() {
        if (this.nextButton == null) {
            this.setNextButton(new Button("Next >"));
        }
        return this.nextButton;
    }

    public void setNextButton(Button button) {
        if (this.nextButton != null) {
            this.nextButton.removeActionListener(this.getNextListener());
        }
        this.nextButton = button;
        this.nextButton.addActionListener(this.getNextListener());
    }

    private ActionListener getNextListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int maxPage;
                int currentPage = PageableTableNavigation.this.getModel().getCurrentPage();
                if (currentPage + 1 < (maxPage = PageableTableNavigation.this.getModel().getTotalPages())) {
                    PageableTableNavigation.this.getModel().setCurrentPage(currentPage + 1);
                    PageableTableNavigation.this.reset();
                }
            }
        };
    }
}

