/*
 * Decompiled with CFR 0.152.
 */
package echopointng.template;

import echopointng.template.AbstractTemplateDataSource;
import echopointng.template.SimpleTemplateCachingHints;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileTemplateDataSource
extends AbstractTemplateDataSource {
    private File file;
    private String canonicalName;

    public FileTemplateDataSource() {
        this((File)null);
    }

    public FileTemplateDataSource(String fileName) {
        this(new File(fileName));
    }

    public FileTemplateDataSource(File file) {
        this.file = file;
        try {
            this.canonicalName = "file:" + file.getCanonicalPath();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        SimpleTemplateCachingHints hints = (SimpleTemplateCachingHints)this.getCachingHints();
        hints.setLastModified(file.lastModified());
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }
}

