/*
 * Decompiled with CFR 0.152.
 */
package echopointng.tree;

import java.io.Serializable;

public class TreePath
implements Serializable {
    private TreePath parentPath;
    private transient Object lastPathComponent;

    protected TreePath() {
    }

    public TreePath(Object[] path) {
        if (path == null || path.length == 0) {
            throw new IllegalArgumentException("path in TreePath must be non null and not empty.");
        }
        this.lastPathComponent = path[path.length - 1];
        if (path.length > 1) {
            this.parentPath = new TreePath(path, path.length - 1);
        }
    }

    protected TreePath(Object[] path, int length) {
        this.lastPathComponent = path[length - 1];
        if (length > 1) {
            this.parentPath = new TreePath(path, length - 1);
        }
    }

    public TreePath(TreePath parent, Object lastElement) {
        if (lastElement == null) {
            throw new IllegalArgumentException("path in TreePath must be non null.");
        }
        this.parentPath = parent;
        this.lastPathComponent = lastElement;
    }

    public TreePath(Object singlePath) {
        if (singlePath == null) {
            throw new IllegalArgumentException("path in TreePath must be non null.");
        }
        this.lastPathComponent = singlePath;
        this.parentPath = null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TreePath) {
            TreePath oTreePath = (TreePath)o;
            if (this.getPathCount() != oTreePath.getPathCount()) {
                return false;
            }
            TreePath path = this;
            while (path != null) {
                if (path.lastPathComponent == null && oTreePath.lastPathComponent != null) {
                    return false;
                }
                if (path.lastPathComponent != null && !path.lastPathComponent.equals(oTreePath.lastPathComponent)) {
                    return false;
                }
                oTreePath = oTreePath.parentPath;
                path = path.parentPath;
            }
            return true;
        }
        return false;
    }

    public Object getLastPathComponent() {
        return this.lastPathComponent;
    }

    public TreePath getParentPath() {
        return this.parentPath;
    }

    public Object[] getPath() {
        int i = this.getPathCount();
        Object[] result = new Object[i--];
        TreePath path = this;
        while (path != null) {
            result[i--] = path.lastPathComponent;
            path = path.parentPath;
        }
        return result;
    }

    public Object getPathComponent(int element) {
        int pathLength = this.getPathCount();
        if (element < 0 || element >= pathLength) {
            throw new IllegalArgumentException("Index " + element + " is out of the specified range");
        }
        TreePath path = this;
        for (int i = pathLength - 1; i != element; --i) {
            path = path.parentPath;
        }
        return path.lastPathComponent;
    }

    public int getPathCount() {
        int result = 0;
        TreePath path = this;
        while (path != null) {
            ++result;
            path = path.parentPath;
        }
        return result;
    }

    public int hashCode() {
        return this.lastPathComponent.hashCode();
    }

    public boolean isDescendant(TreePath aTreePath) {
        if (aTreePath == this) {
            return true;
        }
        if (aTreePath != null) {
            int pathLength = this.getPathCount();
            int oPathLength = aTreePath.getPathCount();
            if (oPathLength < pathLength) {
                return false;
            }
            while (oPathLength-- > pathLength) {
                aTreePath = aTreePath.getParentPath();
            }
            return this.equals(aTreePath);
        }
        return false;
    }

    public TreePath pathByAddingChild(Object child) {
        if (child == null) {
            throw new NullPointerException("Null child not allowed");
        }
        return new TreePath(this, child);
    }

    public String toString() {
        StringBuffer tempSpot = new StringBuffer("[");
        int maxCounter = this.getPathCount();
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (counter > 0) {
                tempSpot.append(", ");
            }
            tempSpot.append(this.getPathComponent(counter));
        }
        tempSpot.append("]");
        return tempSpot.toString();
    }
}

