/*
 * Decompiled with CFR 0.152.
 */
package echopointng.tree.test;

import echopointng.tree.TreeModel;
import echopointng.tree.TreeModelListener;
import echopointng.tree.TreePath;
import echopointng.tree.test.LargeLazyTreeNode;
import echopointng.util.RandKit;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nextapp.echo2.app.event.EventListenerList;

public class LargeLazyTreeModel
implements TreeModel {
    EventListenerList listenerList = new EventListenerList();
    private LargeLazyTreeNode root;
    private int depth = 1;
    private int childCreates = 0;
    protected HashMap nodeIds = new HashMap();
    private int nextNodeId = 0;

    public LargeLazyTreeModel() {
        this.root = new LargeLazyTreeNode(null, this.toString());
    }

    public String toString() {
        return "LargeLazyTreeModel [" + this.depth + " deep] [" + this.childCreates + " child creates]";
    }

    public int getDepth() {
        return this.depth;
    }

    public int getChildCreates() {
        return this.childCreates;
    }

    private void calcDepth(LargeLazyTreeNode node) {
        int tempDepth = this.getPathToRoot(node).length;
        if (tempDepth > this.depth) {
            this.depth = tempDepth;
            this.root.setName(this.toString());
        }
    }

    private void createChildren(LargeLazyTreeNode parentNode) {
        if (parentNode.children == null) {
            ++this.childCreates;
            parentNode.children = new LargeLazyTreeNode[RandKit.rand(3, 10)];
            for (int i = 0; i < parentNode.children.length; ++i) {
                parentNode.children[i] = new LargeLazyTreeNode(parentNode, "Child-" + i);
                if (i != 0) continue;
                this.calcDepth(parentNode.children[i]);
            }
        }
    }

    public Object getChild(Object parent, int index) {
        this.createChildren((LargeLazyTreeNode)parent);
        return ((LargeLazyTreeNode)parent).getChild(index);
    }

    public int getChildCount(Object parent) {
        this.createChildren((LargeLazyTreeNode)parent);
        return ((LargeLazyTreeNode)parent).getChildren().length;
    }

    public int getIndexOfChild(Object parent, Object child) {
        this.createChildren((LargeLazyTreeNode)parent);
        LargeLazyTreeNode[] children = ((LargeLazyTreeNode)parent).getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].equals(child)) continue;
            return i;
        }
        return 0;
    }

    public Object getParent(Object child) {
        return ((LargeLazyTreeNode)child).getParent();
    }

    public Object[] getPathToRoot(Object node) {
        return this.getPathToRoot((LargeLazyTreeNode)node, 0);
    }

    public LargeLazyTreeNode[] getPathToRoot(LargeLazyTreeNode aNode, int depth) {
        LargeLazyTreeNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new LargeLazyTreeNode[depth];
        } else {
            retNodes = aNode.getParent() == null ? new LargeLazyTreeNode[depth] : this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isLeaf(Object node) {
        return false;
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.removeListener(TreeModelListener.class, (EventListener)l);
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.addListener(TreeModelListener.class, (EventListener)l);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public String getNodeId(Object node) {
        Integer nodeId = (Integer)this.nodeIds.get(node);
        if (nodeId == null) {
            nodeId = new Integer(this.nextNodeId++);
            this.nodeIds.put(node, nodeId);
        }
        return String.valueOf(nodeId);
    }

    public Object getNodeById(String id) {
        Iterator iter = this.nodeIds.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!String.valueOf(entry.getValue()).equals(id)) continue;
            return entry.getKey();
        }
        return null;
    }
}

