/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.ui.util.AblePartialUpdater;
import echopointng.ui.util.RenderingContext;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.DomUpdateSupport;
import nextapp.echo2.webcontainer.PartialUpdateManager;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.RenderState;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webcontainer.partialupdate.ColorUpdate;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractEchoPointPeer
implements DomUpdateSupport,
ComponentSynchronizePeer {
    protected static final String DEFAULT_CONTAINER_TAG = "bdo";
    protected PartialUpdateManager partialUpdateManager = new PartialUpdateManager();

    public AbstractEchoPointPeer() {
        AblePartialUpdater.addToUpdateManager(this.partialUpdateManager);
        this.partialUpdateManager.add("foreground", (PartialUpdateParticipant)new ColorUpdate("foreground", null, "color"));
        this.partialUpdateManager.add("background", (PartialUpdateParticipant)new ColorUpdate("background", null, "backgroundColor"));
        this.partialUpdateManager.add("hidden", new PartialUpdateParticipant(){

            private Boolean getHiddenFlag(ServerComponentUpdate update) {
                Object hidden = update.getParent().getRenderProperty("hidden", (Object)false);
                if (hidden instanceof Boolean) {
                    return (Boolean)hidden;
                }
                return null;
            }

            public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
                return this.getHiddenFlag(update) != null;
            }

            public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
                String elementId = ContainerInstance.getElementId((Component)update.getParent());
                Boolean hidden = this.getHiddenFlag(update);
                if (hidden.booleanValue()) {
                    DomUpdate.renderStyleUpdate((ServerMessage)rc.getServerMessage(), (String)elementId, (String)"display", (String)"none");
                } else {
                    DomUpdate.renderStyleUpdate((ServerMessage)rc.getServerMessage(), (String)elementId, (String)"display", (String)"");
                }
            }
        });
    }

    public String getContainerId(Component child) {
        throw new IllegalStateException("AbstractEchoPointPeer does not support children directly.  Use AbstractEchoPointContainerPeer instead");
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        this.disposeRenderState(rc, component);
    }

    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        Element domAddElementDirective = DomUpdate.renderElementAdd((ServerMessage)rc.getServerMessage());
        DocumentFragment htmlFragment = rc.getServerMessage().getDocument().createDocumentFragment();
        this.renderHtml(rc, update, htmlFragment, component);
        DomUpdate.renderElementAddContent((ServerMessage)rc.getServerMessage(), (Element)domAddElementDirective, (String)targetId, (DocumentFragment)htmlFragment);
    }

    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        boolean fullReplace = false;
        if (update.hasUpdatedProperties()) {
            if (this.partialUpdateManager.canProcess(rc, update)) {
                this.partialUpdateManager.process(rc, update);
            } else {
                fullReplace = true;
            }
        }
        return this.renderUpdateBaseImpl(rc, update, targetId, fullReplace);
    }

    protected boolean renderUpdateBaseImpl(RenderContext rc, ServerComponentUpdate update, String targetId, boolean fullReplace) {
        if (fullReplace) {
            String removeTagetId = ContainerInstance.getElementId((Component)update.getParent());
            DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)removeTagetId);
            this.renderAdd(rc, update, targetId, update.getParent());
        } else {
            this.renderUpdateRemoveChildren(rc, update);
            this.renderUpdateAddChildren(rc, update);
        }
        return fullReplace;
    }

    protected void renderUpdateAddChildren(RenderContext rc, ServerComponentUpdate update) {
        Element domAddElementDirective = DomUpdate.renderElementAdd((ServerMessage)rc.getServerMessage());
        Component parentComponent = update.getParent();
        String elementId = ContainerInstance.getElementId((Component)parentComponent);
        Component[] components = parentComponent.getVisibleComponents();
        Component[] addedChildren = update.getAddedChildren();
        for (int componentIndex = components.length - 1; componentIndex >= 0; --componentIndex) {
            boolean childFound = false;
            for (int addedChildrenIndex = 0; !childFound && addedChildrenIndex < addedChildren.length; ++addedChildrenIndex) {
                if (addedChildren[addedChildrenIndex] != components[componentIndex]) continue;
                DocumentFragment htmlFragment = rc.getServerMessage().getDocument().createDocumentFragment();
                this.renderReplaceableChild(rc, update, htmlFragment, components[componentIndex]);
                if (componentIndex == components.length - 1) {
                    DomUpdate.renderElementAddContent((ServerMessage)rc.getServerMessage(), (Element)domAddElementDirective, (String)elementId, (DocumentFragment)htmlFragment);
                } else {
                    DomUpdate.renderElementAddContent((ServerMessage)rc.getServerMessage(), (Element)domAddElementDirective, (String)elementId, (String)(elementId + "_contains_" + ContainerInstance.getElementId((Component)components[componentIndex + 1])), (DocumentFragment)htmlFragment);
                }
                childFound = true;
            }
        }
    }

    protected void renderUpdateRemoveChildren(RenderContext rc, ServerComponentUpdate update) {
        Component[] removedChildren = update.getRemovedChildren();
        for (int i = 0; i < removedChildren.length; ++i) {
            String containerId = ContainerInstance.getElementId((Component)update.getParent()) + "_contains_" + ContainerInstance.getElementId((Component)removedChildren[i]);
            DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)containerId);
        }
    }

    protected Element renderReplaceableChild(RenderContext rc, ServerComponentUpdate update, Node parentNode, Component child) {
        Element containerTagElement = parentNode.getOwnerDocument().createElement(this.getContainerTag());
        String containerId = this.getContainerId(child);
        containerTagElement.setAttribute("id", containerId);
        parentNode.appendChild(containerTagElement);
        ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(child.getClass());
        if (syncPeer instanceof DomUpdateSupport) {
            ((DomUpdateSupport)syncPeer).renderHtml(rc, update, (Node)containerTagElement, child);
        } else {
            syncPeer.renderAdd(rc, update, containerId, child);
        }
        return containerTagElement;
    }

    protected String getContainerTag() {
        return DEFAULT_CONTAINER_TAG;
    }

    public void renderHtml(RenderContext rc, ServerComponentUpdate update, Node parentNode, Component component) {
        if (!component.isRenderVisible()) {
            Element blank = rc.getServerMessage().getDocument().createElement(DEFAULT_CONTAINER_TAG);
            blank.setAttribute("id", ContainerInstance.getElementId((Component)component));
            parentNode.appendChild(blank);
            return;
        }
        RenderingContext renderingContext = new RenderingContext(rc, update, component);
        this.renderHtml(renderingContext, parentNode, component);
    }

    public abstract void renderHtml(RenderingContext var1, Node var2, Component var3);

    protected void storeRenderState(RenderContext rc, Component component, RenderState renderState) {
        rc.getContainerInstance().setRenderState(component, renderState);
    }

    protected RenderState retreiveRenderState(RenderContext rc, Component component) {
        return rc.getContainerInstance().getRenderState(component);
    }

    protected void disposeRenderState(RenderContext rc, Component component) {
        rc.getContainerInstance().setRenderState(component, null);
    }
}

