/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.EPNG;
import echopointng.EditableLabelEx;
import echopointng.ui.resource.Resources;
import echopointng.ui.syncpeer.AbstractEchoPointContainerPeer;
import echopointng.ui.util.CssRolloverStyleEx;
import echopointng.ui.util.ImageManager;
import echopointng.ui.util.Render;
import echopointng.ui.util.RenderingContext;
import echopointng.ui.util.TriCellTable;
import echopointng.util.HtmlKit;
import echopointng.xhtml.XhtmlFragment;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.text.TextComponent;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.DomUpdateSupport;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webcontainer.propertyrender.AlignmentRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import nextapp.echo2.webrender.util.DomUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LabelExPeer
extends AbstractEchoPointContainerPeer
implements ActionProcessor,
PropertyUpdateProcessor {
    public static final Service LABEL_SERVICE = JavaScriptService.forResource((String)"EPNG.LabelEx", (String)"/echopointng/ui/resource/js/labelex.js");

    public String getContainerId(Component child) {
        return super.getContainerId(child);
    }

    public void processAction(ContainerInstance ci, Component component, Element actionElement) {
        throw new UnsupportedOperationException("Component does not support actions.");
    }

    public void processPropertyUpdate(ContainerInstance ci, Component component, Element propertyElement) {
        String propertyName = propertyElement.getAttribute("name");
        if ("text".equals(propertyName)) {
            String propertyValue = DomUtil.getElementText((Element)propertyElement);
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "text", (Object)propertyValue);
        }
    }

    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        super.renderAdd(rc, update, targetId, component);
    }

    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        Component component = update.getParent();
        if (component instanceof EditableLabelEx) {
            String removeTagetId = ContainerInstance.getElementId((Component)component);
            DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)removeTagetId);
            if (component instanceof EditableLabelEx) {
                DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)(ContainerInstance.getElementId((Component)component) + "|EditableContainer"));
            }
            this.renderAdd(rc, update, targetId, component);
            return true;
        }
        return super.renderUpdate(rc, update, targetId);
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        super.renderDispose(rc, update, component);
        rc.getServerMessage().addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        rc.getServerMessage().addLibrary(LABEL_SERVICE.getId());
        this.createDisposeDirective(rc.getServerMessage(), component);
        if (component instanceof EditableLabelEx) {
            DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)(ContainerInstance.getElementId((Component)component) + "|EditableContainer"));
        }
    }

    protected void createInitDirective(RenderingContext rc, Component component, Style fallbackStyle) {
        Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EPLabel.MessageProcessor", "init", new String[0], new String[0]);
        Element itemElement = rc.getServerMessage().getDocument().createElement("item");
        itemizedUpdateElement.appendChild(itemElement);
        itemElement.setAttribute("eid", rc.getElementId());
        itemElement.setAttribute("enabled", String.valueOf(component.isRenderEnabled()));
        if (component instanceof EditableLabelEx) {
            EditableLabelEx editableLabelEx = (EditableLabelEx)component;
            Component target = editableLabelEx.getTarget();
            boolean isTextComponent = TextComponent.class.isAssignableFrom(target.getClass());
            itemElement.setAttribute("editable", "true");
            itemElement.setAttribute("activationMethod", String.valueOf(rc.getRP("activationMethod", fallbackStyle, 0)));
            itemElement.setAttribute("isTextComponent", String.valueOf(isTextComponent));
            itemElement.setAttribute("synchronisedWithTarget", String.valueOf(rc.getRP("synchronizedWithTarget", true)));
            itemElement.setAttribute("text", editableLabelEx.getText());
            itemElement.setAttribute("interpretNewlines", String.valueOf(rc.getRP("interpretNewlines", fallbackStyle, false)));
            if (target != null) {
                itemElement.setAttribute("targetId", ContainerInstance.getElementId((Component)target));
            }
        }
        this.renderTopLevelStyleSupport(rc, component, fallbackStyle, itemElement);
    }

    protected void createDisposeDirective(ServerMessage serverMessage, Component component) {
        serverMessage.addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        serverMessage.addLibrary(LABEL_SERVICE.getId());
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "EPLabel.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", ContainerInstance.getElementId((Component)component));
        itemizedUpdateElement.appendChild(itemElement);
    }

    public void renderHtml(RenderingContext rc, Node parent, Component component) {
        boolean roEnabled;
        Style fallbackStyle = EPNG.getFallBackStyle(component);
        String id = ContainerInstance.getElementId((Component)component);
        Element labelContentE = this.renderLabelContent(rc, component, fallbackStyle);
        labelContentE.setAttribute("id", id);
        rc.addStandardWebSupport(labelContentE);
        CssRolloverStyleEx cssStyle = this.renderTopLevelStyleSupport(rc, component, fallbackStyle, null);
        labelContentE.setAttribute("style", cssStyle.renderInline());
        if (component instanceof EditableLabelEx) {
            Element editableContainerE = rc.createE("bdo");
            editableContainerE.setAttribute("id", id + "|EditableContainer");
            editableContainerE.setAttribute("style", "display:none");
            Component[] children = component.getVisibleComponents();
            for (int i = 0; i < children.length; ++i) {
                Component child = children[i];
                String containerId = this.getContainerId(child);
                Element containerTagElement = rc.createE("bdo");
                containerTagElement.setAttribute("id", containerId);
                editableContainerE.appendChild(containerTagElement);
                ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(child.getClass());
                if (syncPeer instanceof DomUpdateSupport) {
                    ((DomUpdateSupport)syncPeer).renderHtml((RenderContext)rc, rc.getServerComponentUpdate(), (Node)containerTagElement, child);
                    continue;
                }
                syncPeer.renderAdd((RenderContext)rc, rc.getServerComponentUpdate(), containerId, child);
            }
            parent.appendChild(labelContentE);
            parent.appendChild(editableContainerE);
        } else {
            parent.appendChild(labelContentE);
        }
        boolean bl = roEnabled = rc.getRP("rolloverEnabled", fallbackStyle, false) && component.isRenderEnabled();
        if (roEnabled || component instanceof EditableLabelEx) {
            rc.addLibrary(Resources.EP_SCRIPT_SERVICE);
            rc.addLibrary(LABEL_SERVICE);
            this.createInitDirective(rc, component, fallbackStyle);
        }
    }

    protected CssRolloverStyleEx renderTopLevelStyleSupport(RenderingContext rc, Component component, Style fallbackStyle, Element itemXML) {
        Object text = rc.getRP("text", fallbackStyle);
        ImageReference icon = (ImageReference)rc.getRP("icon", fallbackStyle);
        CssRolloverStyleEx cssStyle = new CssRolloverStyleEx(component, fallbackStyle);
        Render.asFillImage(cssStyle, component, "backgroundImage", fallbackStyle, rc);
        if (!component.isRenderEnabled()) {
            Render.asColors(cssStyle, component, "disabledBackground", "disabledForeground", fallbackStyle);
            Render.asFont(cssStyle, component, "disabledFont", fallbackStyle);
            Render.asBorder(cssStyle, component, "disabledBorder", fallbackStyle);
            Render.asFillImage(cssStyle, component, "disabledBackgroundImage", fallbackStyle, rc);
            icon = (ImageReference)rc.getRP("disabledIcon", fallbackStyle);
        }
        if (!rc.getRP("lineWrap", fallbackStyle, false)) {
            cssStyle.setAttribute("white-space", "nowrap");
        }
        if (text != null && icon == null) {
            AlignmentRender.renderToStyle((CssStyle)cssStyle, (Alignment)((Alignment)rc.getRP("textAlignment")));
        }
        if (itemXML != null) {
            itemXML.setAttribute("rolloverEnabled", "false");
            itemXML.setAttribute("defaultStyle", cssStyle.renderInline());
            if (icon != null) {
                itemXML.setAttribute("defaultIcon", ImageManager.getURI(rc, icon));
            }
            boolean rolloverEnabled = rc.getRP("rolloverEnabled", fallbackStyle, false);
            if (component.isRenderEnabled() && rolloverEnabled) {
                cssStyle.setRolloverBackground((Color)rc.getRP("rolloverBackground", fallbackStyle));
                cssStyle.setRolloverForeground((Color)rc.getRP("rolloverForeground", fallbackStyle));
                cssStyle.setRolloverFont((Font)rc.getRP("rolloverFont", fallbackStyle));
                cssStyle.setRolloverBorder((Border)rc.getRP("rolloverBorder", fallbackStyle));
                cssStyle.setRolloverBackgroundImage((FillImage)rc.getRP("rolloverBackgroundImage", fallbackStyle));
                ImageReference rolloverIcon = null;
                if (icon != null) {
                    rolloverIcon = (ImageReference)rc.getRP("rolloverIcon", fallbackStyle);
                }
                itemXML.setAttribute("rolloverEnabled", "true");
                itemXML.setAttribute("rolloverStyle", cssStyle.renderRolloverSupportInline());
                if (rolloverIcon != null) {
                    itemXML.setAttribute("rolloverIcon", ImageManager.getURI(rc, rolloverIcon));
                }
            }
        }
        return cssStyle;
    }

    protected Element renderLabelContent(RenderingContext rc, Component component, Style fallbackStyle) {
        boolean enabled = component.isRenderEnabled();
        Element contentNode = null;
        String elementId = ContainerInstance.getElementId((Component)component);
        Object text = rc.getRP("text", fallbackStyle);
        ImageReference icon = (ImageReference)rc.getRP("icon", fallbackStyle);
        if (!enabled) {
            icon = (ImageReference)rc.getRP("disabledIcon", fallbackStyle);
        }
        Node[] textNodes = null;
        if (text instanceof String) {
            int newLinePolicy = 0;
            if (rc.getRP("interpretNewlines", fallbackStyle, false)) {
                newLinePolicy = 2;
            }
            textNodes = HtmlKit.encodeNewLines(rc.getDocument(), (String)text, newLinePolicy);
        } else if (text instanceof XhtmlFragment) {
            XhtmlFragment fragment = (XhtmlFragment)text;
            try {
                textNodes = fragment.toDOM(rc.getDocument());
            }
            catch (Exception e) {
                throw new RuntimeException("The XhtmlFragment is not valid XHTML : " + fragment.getFragment(), e);
            }
        }
        Element iconElement = null;
        if (icon != null) {
            iconElement = ImageManager.createImgE(rc, icon);
            iconElement.setAttribute("id", elementId + "_icon");
        }
        int entityCount = (textNodes == null ? 0 : 1) + (iconElement == null ? 0 : 1);
        switch (entityCount) {
            case 1: {
                if (textNodes != null) {
                    Element spanE = rc.createE("span");
                    spanE.setAttribute("id", elementId + "|Text");
                    for (int i = 0; i < textNodes.length; ++i) {
                        this.renderCellText(rc, spanE, textNodes[i], component);
                    }
                    Element textE = rc.createE("div");
                    textE.appendChild(spanE);
                    contentNode = textE;
                    break;
                }
                contentNode = iconElement;
                break;
            }
            case 2: {
                Extent iconTextMargin = (Extent)rc.getRP("iconTextMargin", fallbackStyle);
                Alignment textPosition = (Alignment)rc.getRP("textPosition", fallbackStyle);
                int orientation = this.convertIconTextPositionToOrientation(textPosition, component);
                TriCellTable tct = new TriCellTable(rc.getDocument(), elementId, orientation, iconTextMargin);
                for (int i = 0; i < textNodes.length; ++i) {
                    this.renderCellText(rc, tct.getTdElement(0), textNodes[i], component);
                }
                tct.getTdElement(0).setAttribute("id", elementId + "|Text");
                this.renderCellIcon(tct, iconElement, 1);
                Element tableElement = tct.getTableElement();
                tableElement.setAttribute("id", elementId + "_table");
                tableElement.setAttribute("cellpadding", "0");
                tableElement.setAttribute("cellspacing", "0");
                contentNode = tableElement;
                break;
            }
            default: {
                Element spanE = rc.createE("span");
                spanE.setAttribute("id", elementId + "|Text");
                contentNode = spanE;
            }
        }
        return contentNode;
    }

    protected void renderCellIcon(TriCellTable tct, Element iconElement, int cellIndex) {
        Element iconTdElement = tct.getTdElement(cellIndex);
        iconTdElement.appendChild(iconElement);
    }

    protected void renderCellText(RenderingContext rc, Element parentE, Node textNode, Component label) {
        CssStyle textTdCssStyle = new CssStyle();
        AlignmentRender.renderToStyle((CssStyle)textTdCssStyle, (Alignment)((Alignment)rc.getRP("textAlignment")));
        if (!rc.getRP("lineWrap", false)) {
            textTdCssStyle.setAttribute("white-space", "nowrap");
        }
        parentE.setAttribute("style", textTdCssStyle.renderInline());
        parentE.appendChild(textNode);
    }

    protected int convertIconTextPositionToOrientation(Alignment alignment, Component component) {
        if (alignment == null) {
            return 1;
        }
        if (alignment.getVertical() == 0) {
            if (alignment.getHorizontal() == 3) {
                return 0;
            }
            return 1;
        }
        if (alignment.getVertical() == 6) {
            return 2;
        }
        return 3;
    }

    static {
        WebRenderServlet.getServiceRegistry().add(LABEL_SERVICE);
    }
}

