/*
 * Decompiled with CFR 0.152.
 */
package echopointng.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Stack;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Window;

public class ComponentKit {
    private ComponentKit() {
    }

    public static boolean remove(Component parent, Component child) {
        if (parent == null || child == null) {
            return false;
        }
        boolean isAncestor = parent.isAncestorOf(child);
        if (isAncestor) {
            parent = child.getParent();
            parent.remove(child);
            return true;
        }
        return false;
    }

    public static Component[] getComponentPath(Component parent, Component child) {
        if (parent == null || child == null) {
            return new Component[0];
        }
        if (!parent.isAncestorOf(child)) {
            return new Component[0];
        }
        ArrayList<Component> compList = new ArrayList<Component>();
        while (child.getParent() != parent) {
            compList.add(child);
            child = child.getParent();
        }
        compList.add(child);
        compList.add(parent);
        Collections.reverse(compList);
        return compList.toArray(new Component[compList.size()]);
    }

    public static Component getComponentRoot(Component child) {
        Component parent = null;
        do {
            if ((parent = child.getParent()) == null) continue;
            child = parent;
        } while (parent != null);
        return child;
    }

    public static Window getComponentWindow(Component child) {
        Component parent = ComponentKit.getComponentRoot(child);
        if (parent instanceof Window) {
            return (Window)parent;
        }
        return null;
    }

    public static void setVisible(Component component, boolean visible) {
        if (component == null) {
            return;
        }
        component.setVisible(visible);
        Component[] children = component.getComponents();
        for (int i = 0; i < children.length; ++i) {
            ComponentKit.setVisible(children[i], visible);
        }
    }

    public static void setEnabled(Component component, boolean enabled) {
        if (component == null) {
            return;
        }
        component.setEnabled(enabled);
        Component[] children = component.getComponents();
        for (int i = 0; i < children.length; ++i) {
            ComponentKit.setEnabled(children[i], enabled);
        }
    }

    public static void traverseComponent(Component startComponent, ComponentTraversalCallBack traverseCallBack) {
        if (startComponent != null) {
            Stack<Component> stack = new Stack<Component>();
            stack.push(startComponent);
            while (!stack.isEmpty()) {
                Component c = (Component)stack.pop();
                traverseCallBack.onComponent(c);
                Component[] children = c.getComponents();
                for (int i = 0; i < children.length; ++i) {
                    stack.push(children[i]);
                }
            }
        }
    }

    public static void traverseInstance(ApplicationInstance instance, ComponentTraversalCallBack traverseCallBack) {
        if (instance != null && instance.getDefaultWindow() != null) {
            ComponentKit.traverseComponent((Component)instance.getDefaultWindow(), traverseCallBack);
        }
    }

    public static boolean setProperty(Component component, String propertyName, Object propertyValue) {
        return ComponentKit.setProperty(component, propertyName, propertyValue, null);
    }

    public static boolean setProperty(Component component, String propertyName, Object propertyValue, Class filterClass) {
        Method setter;
        if (component == null || propertyName == null || propertyName.length() <= 0) {
            return false;
        }
        boolean setOK = true;
        Class<?> componentClass = component.getClass();
        if ((filterClass == null || filterClass.isAssignableFrom(componentClass)) && (setter = ComponentKit._getSetter(componentClass, propertyName, propertyValue)) != null) {
            try {
                setter.invoke((Object)component, propertyValue);
                setOK = true;
            }
            catch (Exception e) {
                setOK = false;
            }
        }
        Component[] children = component.getComponents();
        for (int i = 0; i < children.length; ++i) {
            boolean wasOK = ComponentKit.setProperty(children[i], propertyName, propertyValue, filterClass);
            if (wasOK) continue;
            setOK = false;
        }
        return setOK;
    }

    private static Method _getSetter(Class clazz, String propertyName, Object propertyValue) {
        Class[] classArray;
        if (propertyValue == null) {
            classArray = null;
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = propertyValue.getClass();
        }
        Class[] params = classArray;
        Method setter = null;
        StringBuffer sb = new StringBuffer("set");
        sb.append(propertyName.substring(0, 1).toUpperCase());
        sb.append(propertyName.substring(1));
        String methodName = sb.toString();
        try {
            setter = ComponentKit._findSetterMethod(clazz, methodName, params);
            return setter;
        }
        catch (Exception e) {
            sb = new StringBuffer("set");
            sb.append(propertyName.substring(0, 1).toUpperCase());
            if (propertyName.length() >= 2) {
                sb.append(propertyName.substring(1).toLowerCase());
            }
            methodName = sb.toString();
            try {
                setter = ComponentKit._findSetterMethod(clazz, methodName, params);
            }
            catch (Exception e2) {
                // empty catch block
            }
            sb = new StringBuffer("set");
            sb.append(propertyName);
            methodName = sb.toString();
            try {
                setter = ComponentKit._findSetterMethod(clazz, methodName, params);
            }
            catch (Exception e3) {
                // empty catch block
            }
            try {
                setter = ComponentKit._findSetterMethod(clazz, propertyName, params);
            }
            catch (Exception e4) {
                // empty catch block
            }
            return setter;
        }
    }

    private static Method _findSetterMethod(Class clazz, String methodName, Class[] searchParams) {
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?> returnType = methods[i].getReturnType();
            Class<?>[] paramTypes = methods[i].getParameterTypes();
            Method method = methods[i];
            if (!method.getName().equals(methodName) || paramTypes.length != 1 || !returnType.equals(Void.TYPE)) continue;
            if (searchParams == null || searchParams.length == 0) {
                return method;
            }
            Class searchParam = searchParams[0];
            if (paramTypes[0].isAssignableFrom(searchParam)) {
                return method;
            }
            if (searchParam != null) continue;
            return method;
        }
        return null;
    }

    public static interface ComponentTraversalCallBack {
        public void onComponent(Component var1);
    }
}

