/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.chartparser;

import ch.uzh.ifi.attempto.chartparser.StringRef;
import ch.uzh.ifi.attempto.chartparser.UnificationFailedException;
import java.util.ArrayList;

class StringEntity {
    private static int nextID = 0;
    private String string;
    private final int id;
    private ArrayList<StringRef> stringRefs = new ArrayList();

    public StringEntity(String string) {
        this.string = string;
        this.id = nextID++;
    }

    public String getString() {
        return this.string;
    }

    void addReference(StringRef stringRef) {
        this.stringRefs.add(stringRef);
        stringRef.setStringEntity(this);
    }

    public void unify(StringEntity stringEntity) throws UnificationFailedException {
        if (this.string == null) {
            this.string = stringEntity.string;
        } else if (stringEntity.string != null && !this.string.equals(stringEntity.string)) {
            throw new UnificationFailedException();
        }
        this.stringRefs.addAll(stringEntity.stringRefs);
        for (StringRef stringRef : stringEntity.stringRefs) {
            stringRef.setStringEntity(this);
        }
    }

    public int getID() {
        return this.id;
    }

    public StringRef newStringRef() {
        return new StringRef(this);
    }
}

