/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity.locality;

import com.clarkparsia.modularity.locality.LocalityEvaluator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.owl.inference.OWLReasoner;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.inference.OWLReasonerFactory;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomVisitor;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDescriptionVisitor;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLRuntimeException;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.util.OWLAxiomVisitorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticLocalityEvaluator
implements LocalityEvaluator {
    public static final Logger log = Logger.getLogger(SemanticLocalityEvaluator.class.getName());
    private OWLDataFactory df;
    private AxiomLocalityVisitor axiomVisitor = new AxiomLocalityVisitor();
    private BottomReplacer bottomReplacer = new BottomReplacer();
    private OWLReasoner reasoner;

    public SemanticLocalityEvaluator(OWLOntologyManager man, OWLReasonerFactory reasonerFactory) {
        this.df = man.getOWLDataFactory();
        this.reasoner = reasonerFactory.createReasoner(man);
    }

    @Override
    public boolean isLocal(OWLAxiom axiom, Set<? extends OWLEntity> signature) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Replacing axiom by Bottom");
        }
        OWLAxiom newAxiom = this.bottomReplacer.replaceBottom(axiom, signature);
        if (log.isLoggable(Level.FINE)) {
            log.fine("DONE Replacing axiom by Bottom. Success: " + (newAxiom != null));
        }
        return newAxiom != null && this.axiomVisitor.isLocal(newAxiom);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BottomReplacer
    extends OWLAxiomVisitorAdapter
    implements OWLAxiomVisitor,
    OWLDescriptionVisitor {
        private OWLAxiom newAxiom;
        private OWLDescription newDescription;
        private Set<? extends OWLEntity> signature;

        private BottomReplacer() {
        }

        public OWLAxiom getResult() {
            return this.newAxiom;
        }

        public OWLAxiom replaceBottom(OWLAxiom axiom, Set<? extends OWLEntity> signature) {
            this.reset(signature);
            axiom.accept(this);
            return this.getResult();
        }

        public OWLDescription replaceBottom(OWLDescription desc) {
            this.newDescription = null;
            desc.accept(this);
            if (this.newDescription == null) {
                throw new RuntimeException("Unsupported description " + desc);
            }
            return this.newDescription;
        }

        public Set<OWLDescription> replaceBottom(Set<OWLDescription> descriptions) {
            HashSet<OWLDescription> result = new HashSet<OWLDescription>();
            for (OWLDescription desc : descriptions) {
                result.add(this.replaceBottom(desc));
            }
            return result;
        }

        public void reset(Set<? extends OWLEntity> signature) {
            this.signature = signature;
            this.newAxiom = null;
        }

        @Override
        public void visit(OWLClass desc) {
            this.newDescription = this.signature.contains(desc) ? desc : SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        @Override
        public void visit(OWLDataAllRestriction desc) {
            this.newDescription = this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty()) ? desc : SemanticLocalityEvaluator.this.df.getOWLThing();
        }

        @Override
        public void visit(OWLDataExactCardinalityRestriction desc) {
            this.newDescription = this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty()) ? desc : SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        @Override
        public void visit(OWLDataMaxCardinalityRestriction desc) {
            this.newDescription = this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty()) ? desc : SemanticLocalityEvaluator.this.df.getOWLThing();
        }

        @Override
        public void visit(OWLDataMinCardinalityRestriction desc) {
            this.newDescription = this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty()) ? desc : SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        @Override
        public void visit(OWLDataSomeRestriction desc) {
            this.newDescription = this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty()) ? desc : SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        @Override
        public void visit(OWLDataValueRestriction desc) {
            throw new RuntimeException();
        }

        @Override
        public void visit(OWLDisjointClassesAxiom ax) {
            Set<OWLDescription> disjointclasses = this.replaceBottom(ax.getDescriptions());
            this.newAxiom = SemanticLocalityEvaluator.this.df.getOWLDisjointClassesAxiom(disjointclasses);
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom ax) {
            Set<OWLDescription> eqclasses = this.replaceBottom(ax.getDescriptions());
            this.newAxiom = SemanticLocalityEvaluator.this.df.getOWLEquivalentClassesAxiom(eqclasses);
        }

        @Override
        public void visit(OWLObjectAllRestriction desc) {
            this.newDescription = this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) ? SemanticLocalityEvaluator.this.df.getOWLObjectAllRestriction((OWLObjectPropertyExpression)desc.getProperty(), this.replaceBottom((OWLDescription)desc.getFiller())) : SemanticLocalityEvaluator.this.df.getOWLThing();
        }

        @Override
        public void visit(OWLObjectComplementOf desc) {
            this.newDescription = SemanticLocalityEvaluator.this.df.getOWLObjectComplementOf(this.replaceBottom(desc.getOperand()));
        }

        @Override
        public void visit(OWLObjectExactCardinalityRestriction desc) {
            this.newDescription = this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) ? desc : SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        @Override
        public void visit(OWLObjectIntersectionOf desc) {
            Set<OWLDescription> operands = desc.getOperands();
            this.newDescription = SemanticLocalityEvaluator.this.df.getOWLObjectIntersectionOf(this.replaceBottom(operands));
        }

        @Override
        public void visit(OWLObjectMaxCardinalityRestriction desc) {
            this.newDescription = this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) ? desc : SemanticLocalityEvaluator.this.df.getOWLThing();
        }

        @Override
        public void visit(OWLObjectMinCardinalityRestriction desc) {
            this.newDescription = this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) ? desc : SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        @Override
        public void visit(OWLObjectOneOf desc) {
            throw new RuntimeException();
        }

        @Override
        public void visit(OWLObjectSelfRestriction desc) {
            throw new RuntimeException();
        }

        @Override
        public void visit(OWLObjectSomeRestriction desc) {
            this.newDescription = this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) ? SemanticLocalityEvaluator.this.df.getOWLObjectSomeRestriction((OWLObjectPropertyExpression)desc.getProperty(), this.replaceBottom((OWLDescription)desc.getFiller())) : SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        @Override
        public void visit(OWLObjectUnionOf desc) {
            Set<OWLDescription> operands = desc.getOperands();
            this.newDescription = SemanticLocalityEvaluator.this.df.getOWLObjectUnionOf(this.replaceBottom(operands));
        }

        @Override
        public void visit(OWLObjectValueRestriction desc) {
            throw new RuntimeException();
        }

        @Override
        public void visit(OWLSubClassAxiom ax) {
            OWLDescription sup = this.replaceBottom(ax.getSuperClass());
            OWLDescription sub = this.replaceBottom(ax.getSubClass());
            this.newAxiom = SemanticLocalityEvaluator.this.df.getOWLSubClassAxiom(sub, sup);
        }
    }

    private class AxiomLocalityVisitor
    extends OWLAxiomVisitorAdapter
    implements OWLAxiomVisitor {
        private boolean isLocal;

        public boolean isLocal() {
            return this.isLocal;
        }

        public boolean isLocal(OWLAxiom axiom) {
            this.reset();
            axiom.accept(this);
            return this.isLocal();
        }

        public void reset() {
            this.isLocal = false;
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            Set<OWLDescription> disjClasses = axiom.getDescriptions();
            OWLObjectIntersectionOf conjunction = SemanticLocalityEvaluator.this.df.getOWLObjectIntersectionOf(disjClasses);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Calling the Reasoner");
            }
            try {
                this.isLocal = SemanticLocalityEvaluator.this.reasoner.isEquivalentClass(conjunction, SemanticLocalityEvaluator.this.df.getOWLNothing());
            }
            catch (OWLReasonerException e) {
                throw new OWLRuntimeException(e);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("DONE Calling the Reasoner. isLocal = " + this.isLocal);
            }
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            Set<OWLDescription> eqClasses = axiom.getDescriptions();
            if (eqClasses.size() != 2) {
                return;
            }
            Iterator<OWLDescription> iter = eqClasses.iterator();
            OWLDescription first = iter.next();
            OWLDescription second = iter.next();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Calling the Reasoner");
            }
            try {
                this.isLocal = SemanticLocalityEvaluator.this.reasoner.isEquivalentClass(first, second);
            }
            catch (OWLReasonerException e) {
                throw new OWLRuntimeException(e);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("DONE Calling the Reasoner. isLocal = " + this.isLocal);
            }
        }

        public void visit(OWLSubClassAxiom axiom) {
            OWLDescription sup = axiom.getSuperClass();
            OWLDescription sub = axiom.getSubClass();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Calling the Reasoner");
            }
            try {
                this.isLocal = SemanticLocalityEvaluator.this.reasoner.isSubClassOf(sub, sup);
            }
            catch (OWLReasonerException e) {
                throw new OWLRuntimeException(e);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("DONE Calling the Reasoner. isLocal = " + this.isLocal);
            }
        }
    }
}

