/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.latex;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.coode.owl.latex.LatexObjectVisitor;
import org.coode.owl.latex.LatexRendererIOException;
import org.coode.owl.latex.LatexWriter;
import org.semanticweb.owl.io.AbstractOWLRenderer;
import org.semanticweb.owl.io.OWLRendererException;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.util.AxiomTypeProvider;
import org.semanticweb.owl.util.OWLEntityComparator;
import org.semanticweb.owl.util.ShortFormProvider;
import org.semanticweb.owl.util.SimpleShortFormProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatexRenderer
extends AbstractOWLRenderer {
    private ShortFormProvider shortFormProvider = new SimpleShortFormProvider();

    public LatexRenderer(OWLOntologyManager owlOntologyManager) {
        super(owlOntologyManager);
    }

    private void writeEntitySection(OWLEntity entity, LatexWriter w) {
        w.write("\\subsubsection*{");
        w.write(this.shortFormProvider.getShortForm(entity));
        w.write("}\n\n");
    }

    @Override
    public void render(OWLOntology ontology, Writer writer) throws OWLRendererException {
        try {
            LatexWriter w = new LatexWriter(writer);
            w.write("\\documentclass{article}\n");
            w.write("\\parskip 0pt\n");
            w.write("\\parindent 0pt\n");
            w.write("\\oddsidemargin 0cm\n");
            w.write("\\textwidth 19cm\n");
            w.write("\\begin{document}\n\n");
            LatexObjectVisitor renderer = new LatexObjectVisitor(w, this.getOWLOntologyManager().getOWLDataFactory());
            Collection<OWLClass> clses = this.sortEntities(ontology.getReferencedClasses());
            if (!clses.isEmpty()) {
                w.write("\\subsection*{Classes}\n\n");
            }
            for (OWLClass oWLClass : clses) {
                this.writeEntitySection(oWLClass, w);
                for (OWLAxiom ax : this.sortAxioms(ontology.getAxioms(oWLClass))) {
                    renderer.setSubject(oWLClass);
                    ax.accept(renderer);
                    w.write("\n\n");
                }
            }
            w.write("\\section*{Object properties}");
            for (OWLObjectProperty oWLObjectProperty : this.sortEntities(ontology.getReferencedObjectProperties())) {
                this.writeEntitySection(oWLObjectProperty, w);
                for (OWLAxiom ax : this.sortAxioms(ontology.getAxioms(oWLObjectProperty))) {
                    ax.accept(renderer);
                    w.write("\n\n");
                }
            }
            w.write("\\section*{Data properties}");
            for (OWLDataProperty oWLDataProperty : this.sortEntities(ontology.getReferencedDataProperties())) {
                this.writeEntitySection(oWLDataProperty, w);
                for (OWLAxiom ax : this.sortAxioms(ontology.getAxioms(oWLDataProperty))) {
                    ax.accept(renderer);
                    w.write("\n\n");
                }
            }
            w.write("\\section*{Individuals}");
            for (OWLIndividual oWLIndividual : this.sortEntities(ontology.getReferencedIndividuals())) {
                this.writeEntitySection(oWLIndividual, w);
                for (OWLAxiom ax : this.sortAxioms(ontology.getAxioms(oWLIndividual))) {
                    ax.accept(renderer);
                    w.write("\n\n");
                }
            }
            writer.write(w.toString());
            writer.write("\\end{document}\n");
            writer.flush();
        }
        catch (IOException e) {
            throw new LatexRendererIOException(e);
        }
    }

    private <T extends OWLEntity> Collection<T> sortEntities(Set<T> entites) {
        ArrayList<T> list = new ArrayList<T>(entites);
        OWLEntityComparator entityComparator = new OWLEntityComparator(this.shortFormProvider);
        Collections.sort(list, entityComparator);
        return list;
    }

    private Collection<OWLAxiom> sortAxioms(Set<? extends OWLAxiom> axioms) {
        ArrayList<OWLAxiom> list = new ArrayList<OWLAxiom>(axioms);
        Collections.sort(list, new OWLAxiomComparator());
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OWLAxiomComparator
    implements Comparator<OWLAxiom> {
        private OWLAxiomComparator() {
        }

        @Override
        public int compare(OWLAxiom o1, OWLAxiom o2) {
            AxiomTypeProvider provider = new AxiomTypeProvider();
            int index1 = provider.getAxiomType(o1).getIndex();
            int index2 = provider.getAxiomType(o2).getIndex();
            return index1 - index2;
        }
    }
}

