/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdf.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLIndividualAxiom;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectAnnotation;
import org.semanticweb.owl.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLRestriction;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.model.SWRLAtom;
import org.semanticweb.owl.model.SWRLAtomConstantObject;
import org.semanticweb.owl.model.SWRLAtomDObject;
import org.semanticweb.owl.model.SWRLAtomDVariable;
import org.semanticweb.owl.model.SWRLAtomIObject;
import org.semanticweb.owl.model.SWRLAtomIVariable;
import org.semanticweb.owl.model.SWRLAtomIndividualObject;
import org.semanticweb.owl.model.SWRLBuiltInAtom;
import org.semanticweb.owl.model.SWRLClassAtom;
import org.semanticweb.owl.model.SWRLDataRangeAtom;
import org.semanticweb.owl.model.SWRLDataValuedPropertyAtom;
import org.semanticweb.owl.model.SWRLDifferentFromAtom;
import org.semanticweb.owl.model.SWRLObjectPropertyAtom;
import org.semanticweb.owl.model.SWRLObjectVisitor;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.model.SWRLSameAsAtom;
import org.semanticweb.owl.util.OWLObjectVisitorAdapter;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;
import org.semanticweb.owl.vocab.SWRLBuiltInsVocabulary;
import org.semanticweb.owl.vocab.SWRLVocabulary;
import org.semanticweb.owl.vocab.XSDVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTranslator<NODE, RESOURCE extends NODE, PREDICATE extends NODE, LITERAL extends NODE>
implements OWLObjectVisitor,
SWRLObjectVisitor {
    private OWLOntologyManager manager;
    private OWLOntology ontology;
    private DescriptionComparator descriptionComparator = new DescriptionComparator();
    private Map<Object, NODE> nodeMap = new IdentityHashMap<Object, NODE>();
    private PunningChecker punningChecker = new PunningChecker();

    public AbstractTranslator(OWLOntologyManager manager, OWLOntology ontology) {
        this.ontology = ontology;
        this.manager = manager;
    }

    @Override
    public void visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
        this.addAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_ASYMMETRIC_PROPERTY.getURI());
    }

    @Override
    public void visit(OWLAxiomAnnotationAxiom axiom) {
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        this.addAxiom((OWLAxiom)axiom, (OWLObject)axiom.getIndividual(), OWLRDFVocabulary.RDF_TYPE.getURI(), (OWLObject)axiom.getDescription());
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.addAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubject(), (OWLObject)axiom.getProperty(), (OWLObject)axiom.getObject());
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.addAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), this.isPunned(new OWLObject[]{axiom.getProperty()}) ? OWLRDFVocabulary.OWL_DATA_PROPERTY_DOMAIN.getURI() : OWLRDFVocabulary.RDFS_DOMAIN.getURI(), (OWLObject)axiom.getDomain());
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.addAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), this.isPunned(new OWLObject[]{axiom.getProperty()}) ? OWLRDFVocabulary.OWL_DATA_PROPERTY_RANGE.getURI() : OWLRDFVocabulary.RDFS_RANGE.getURI(), (OWLObject)axiom.getRange());
    }

    @Override
    public void visit(OWLDataSubPropertyAxiom axiom) {
        this.addAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubProperty(), this.isPunned(new OWLObject[]{axiom.getSubProperty(), axiom.getSuperProperty()}) ? OWLRDFVocabulary.OWL_SUB_DATA_PROPERTY_OF.getURI() : OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getURI(), (OWLObject)axiom.getSuperProperty());
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
        if (axiom.getEntity() instanceof OWLClass) {
            this.addAxiom((OWLAxiom)axiom, (OWLObject)axiom.getEntity(), OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_CLASS.getURI());
        } else if (axiom.getEntity() instanceof OWLDataProperty) {
            this.addAxiom((OWLAxiom)axiom, (OWLObject)axiom.getEntity(), OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_DATA_PROPERTY.getURI());
        } else if (axiom.getEntity() instanceof OWLObjectProperty) {
            this.addAxiom((OWLAxiom)axiom, (OWLObject)axiom.getEntity(), OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getURI());
        } else if (axiom.getEntity() instanceof OWLIndividual) {
            this.addAxiom((OWLAxiom)axiom, (OWLObject)axiom.getEntity(), OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_INDIVIDUAL.getURI());
        } else if (axiom.getEntity() instanceof OWLDataType) {
            this.addAxiom((OWLAxiom)axiom, (OWLObject)axiom.getEntity(), OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_DATATYPE.getURI());
        }
        for (OWLEntityAnnotationAxiom ax : this.ontology.getEntityAnnotationAxioms(axiom.getEntity())) {
            this.addTriple((OWLObject)axiom.getEntity(), ax.getAnnotation().getAnnotationURI(), ax.getAnnotation().getAnnotationValue());
        }
    }

    private void addPairwise(OWLAxiom axiom, Collection<? extends OWLObject> objects, URI uri) {
        ArrayList<? extends OWLObject> objectList = new ArrayList<OWLObject>(objects);
        for (int i = 0; i < objectList.size(); ++i) {
            for (int j = i; j < objectList.size(); ++j) {
                if (i == j) continue;
                this.addAxiom(axiom, (OWLObject)objectList.get(i), uri, (OWLObject)objectList.get(j));
            }
        }
    }

    private void addPairwiseDescriptions(OWLAxiom axiom, Set<OWLDescription> descriptions, URI uri) {
        ArrayList<OWLDescription> descriptionList = new ArrayList<OWLDescription>(descriptions);
        Collections.sort(descriptionList, this.descriptionComparator);
        this.addPairwise(axiom, descriptionList, uri);
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.translateAnonymousNode(axiom);
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_ALL_DIFFERENT.getURI());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_DISTINCT_MEMBERS.getURI(), axiom.getIndividuals());
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        if (axiom.getDescriptions().size() == 2 || !this.ontology.getAnnotations(axiom).isEmpty()) {
            this.addPairwiseDescriptions(axiom, axiom.getDescriptions(), OWLRDFVocabulary.OWL_DISJOINT_WITH.getURI());
        } else {
            this.translateAnonymousNode(axiom);
            this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_ALL_DISJOINT_CLASSES.getURI());
            this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_MEMBERS.getURI(), axiom.getDescriptions());
        }
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        if (axiom.getProperties().size() == 2 || !this.ontology.getAnnotations(axiom).isEmpty()) {
            this.addPairwise(axiom, axiom.getProperties(), OWLRDFVocabulary.OWL_DISJOINT_DATA_PROPERTIES.getURI());
        } else {
            this.translateAnonymousNode(axiom);
            this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_ALL_DISJOINT_PROPERTIES.getURI());
            this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_MEMBERS.getURI(), axiom.getProperties());
        }
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        if (axiom.getProperties().size() == 2 || !this.ontology.getAnnotations(axiom).isEmpty()) {
            this.addPairwise(axiom, axiom.getProperties(), OWLRDFVocabulary.OWL_DISJOINT_OBJECT_PROPERTIES.getURI());
        } else {
            this.translateAnonymousNode(axiom);
            this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_ALL_DISJOINT_PROPERTIES.getURI());
            this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_MEMBERS.getURI(), axiom.getProperties());
        }
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        this.addAxiom((OWLAxiom)axiom, (RESOURCE)axiom.getOWLClass(), (PREDICATE)OWLRDFVocabulary.OWL_DISJOINT_UNION_OF.getURI(), (NODE)axiom.getDescriptions());
    }

    @Override
    public void visit(OWLEntityAnnotationAxiom axiom) {
        this.addTriple((OWLObject)axiom.getSubject(), axiom.getAnnotation().getAnnotationURI(), axiom.getAnnotation().getAnnotationValue());
        this.addTriple(this.getResourceNode(axiom.getAnnotation().getAnnotationURI()), this.getPredicateNode(OWLRDFVocabulary.RDF_TYPE.getURI()), this.getResourceNode(OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY.getURI()));
        ((OWLEntity)axiom.getSubject()).accept(this);
        if (!axiom.getAnnotation().isAnnotationByConstant()) {
            OWLIndividual ind = (OWLIndividual)axiom.getAnnotation().getAnnotationValue();
            this.processAnonymousIndividual(ind);
        }
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.addPairwiseDescriptions(axiom, axiom.getDescriptions(), OWLRDFVocabulary.OWL_EQUIVALENT_CLASS.getURI());
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.addPairwise(axiom, axiom.getProperties(), this.isPunned(axiom.getProperties()) ? OWLRDFVocabulary.OWL_EQUIVALENT_DATA_PROPERTIES.getURI() : OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getURI());
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.addPairwise(axiom, axiom.getProperties(), this.isPunned(axiom.getProperties()) ? OWLRDFVocabulary.OWL_EQUIVALENT_OBJECT_PROPERTIES.getURI() : OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getURI());
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.addAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getURI(), this.isPunned(new OWLObject[]{axiom.getProperty()}) ? OWLRDFVocabulary.OWL_FUNCTIONAL_DATA_PROPERTY.getURI() : OWLRDFVocabulary.OWL_FUNCTIONAL_PROPERTY.getURI());
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.addAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getURI(), this.isPunned(new OWLObject[]{axiom.getProperty()}) ? OWLRDFVocabulary.OWL_FUNCTIONAL_OBJECT_PROPERTY.getURI() : OWLRDFVocabulary.OWL_FUNCTIONAL_PROPERTY.getURI());
    }

    @Override
    public void visit(OWLImportsDeclaration axiom) {
        this.addTriple((OWLObject)axiom.getSubject(), OWLRDFVocabulary.OWL_IMPORTS.getURI(), axiom.getImportedOntologyURI());
        this.addTriple(this.getResourceNode(axiom.getImportedOntologyURI()), this.getPredicateNode(OWLRDFVocabulary.RDF_TYPE.getURI()), this.getResourceNode(OWLRDFVocabulary.OWL_ONTOLOGY.getURI()));
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.addAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_INVERSE_FUNCTIONAL_PROPERTY.getURI());
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.addAxiom((OWLAxiom)axiom, (OWLObject)axiom.getFirstProperty(), OWLRDFVocabulary.OWL_INVERSE_OF.getURI(), (OWLObject)axiom.getSecondProperty());
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.addAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_IRREFLEXIVE_PROPERTY.getURI());
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.translateAnonymousNode(axiom);
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_NEGATIVE_DATA_PROPERTY_ASSERTION.getURI());
        this.addAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubject(), (OWLObject)axiom.getProperty(), (OWLObject)axiom.getObject());
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.translateAnonymousNode(axiom);
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_NEGATIVE_OBJECT_PROPERTY_ASSERTION.getURI());
        this.addAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubject(), (OWLObject)axiom.getProperty(), (OWLObject)axiom.getObject());
        this.processAnonymousIndividual((OWLIndividual)axiom.getObject());
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.addAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubject(), (OWLObject)axiom.getProperty(), (OWLObject)axiom.getObject());
        this.processAnonymousIndividual((OWLIndividual)axiom.getObject());
    }

    @Override
    public void visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
        RESOURCE anonNode = this.getAnonymousNode(axiom);
        RESOURCE list = this.translateList(axiom.getPropertyChain());
        this.addTriple(anonNode, this.getPredicateNode(OWLRDFVocabulary.OWL_PROPERTY_CHAIN.getURI()), list);
        this.addAxiom((OWLAxiom)axiom, anonNode, this.getPredicateNode(OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getURI()), this.getResourceNode(axiom.getSuperProperty()));
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.addAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), this.isPunned(new OWLObject[]{axiom.getProperty()}) ? OWLRDFVocabulary.OWL_OBJECT_PROPERTY_DOMAIN.getURI() : OWLRDFVocabulary.RDFS_DOMAIN.getURI(), (OWLObject)axiom.getDomain());
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.addAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), this.isPunned(new OWLObject[]{axiom.getProperty()}) ? OWLRDFVocabulary.OWL_OBJECT_PROPERTY_RANGE.getURI() : OWLRDFVocabulary.RDFS_RANGE.getURI(), (OWLObject)axiom.getRange());
    }

    @Override
    public void visit(OWLObjectSubPropertyAxiom axiom) {
        this.addAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubProperty(), this.isPunned(new OWLObject[]{axiom.getSubProperty(), axiom.getSuperProperty()}) ? OWLRDFVocabulary.OWL_SUB_OBJECT_PROPERTY_OF.getURI() : OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getURI(), (OWLObject)axiom.getSuperProperty());
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.addAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_REFLEXIVE_PROPERTY.getURI());
    }

    @Override
    public void visit(OWLSameIndividualsAxiom axiom) {
        this.addPairwise(axiom, axiom.getIndividuals(), OWLRDFVocabulary.OWL_SAME_AS.getURI());
    }

    @Override
    public void visit(OWLSubClassAxiom axiom) {
        this.addAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubClass(), OWLRDFVocabulary.RDFS_SUBCLASS_OF.getURI(), (OWLObject)axiom.getSuperClass());
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.addAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_SYMMETRIC_PROPERTY.getURI());
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.addAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_TRANSITIVE_PROPERTY.getURI());
    }

    @Override
    public void visit(OWLObjectIntersectionOf desc) {
        this.translateAnonymousNode(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_INTERSECTION_OF.getURI(), desc.getOperands());
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_CLASS.getURI());
    }

    @Override
    public void visit(OWLClass desc) {
        if (!this.nodeMap.containsKey(desc)) {
            this.nodeMap.put(desc, this.getResourceNode(desc.getURI()));
        }
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_CLASS.getURI());
    }

    private void translateDataRestrictionStart(OWLRestriction desc) {
        this.translateAnonymousNode(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_RESTRICTION.getURI());
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_ON_PROPERTY.getURI(), (OWLObject)desc.getProperty());
    }

    private void translateDataCardinality(OWLDataCardinalityRestriction desc, URI cardinalityURI) {
        this.translateDataRestrictionStart(desc);
        this.addTriple((OWLObject)desc, cardinalityURI, this.toTypedConstant(desc.getCardinality()));
        if (desc.isQualified()) {
            this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_CLASS.getURI(), (OWLObject)desc.getFiller());
        }
    }

    @Override
    public void visit(OWLDataAllRestriction desc) {
        this.translateDataRestrictionStart(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_ALL_VALUES_FROM.getURI(), (OWLObject)desc.getFiller());
    }

    @Override
    public void visit(OWLDataExactCardinalityRestriction desc) {
        this.translateDataCardinality(desc, OWLRDFVocabulary.OWL_CARDINALITY.getURI());
    }

    @Override
    public void visit(OWLDataMaxCardinalityRestriction desc) {
        this.translateDataCardinality(desc, OWLRDFVocabulary.OWL_MAX_CARDINALITY.getURI());
    }

    @Override
    public void visit(OWLDataMinCardinalityRestriction desc) {
        this.translateDataCardinality(desc, OWLRDFVocabulary.OWL_MIN_CARDINALITY.getURI());
    }

    @Override
    public void visit(OWLDataSomeRestriction desc) {
        this.translateDataRestrictionStart(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_SOME_VALUES_FROM.getURI(), (OWLObject)desc.getFiller());
    }

    @Override
    public void visit(OWLDataValueRestriction desc) {
        this.translateDataRestrictionStart(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_HAS_VALUE.getURI(), (OWLObject)desc.getValue());
    }

    @Override
    public void visit(OWLObjectComplementOf desc) {
        this.translateAnonymousNode(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_CLASS.getURI());
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_COMPLEMENT_OF.getURI(), desc.getOperand());
    }

    private void translateObjectRestrictionStart(OWLRestriction desc) {
        this.translateAnonymousNode(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_RESTRICTION.getURI());
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_ON_PROPERTY.getURI(), (OWLObject)desc.getProperty());
    }

    private void translateObjectCardinality(OWLObjectCardinalityRestriction desc, URI cardinalityURI) {
        this.translateObjectRestrictionStart(desc);
        this.addTriple((OWLObject)desc, cardinalityURI, this.toTypedConstant(desc.getCardinality()));
        if (desc.isQualified()) {
            this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_ON_CLASS.getURI(), (OWLObject)desc.getFiller());
        }
    }

    @Override
    public void visit(OWLObjectAllRestriction desc) {
        this.translateObjectRestrictionStart(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_ALL_VALUES_FROM.getURI(), (OWLObject)desc.getFiller());
    }

    @Override
    public void visit(OWLObjectExactCardinalityRestriction desc) {
        this.translateObjectCardinality(desc, OWLRDFVocabulary.OWL_CARDINALITY.getURI());
    }

    @Override
    public void visit(OWLObjectMaxCardinalityRestriction desc) {
        this.translateObjectCardinality(desc, OWLRDFVocabulary.OWL_MAX_CARDINALITY.getURI());
    }

    @Override
    public void visit(OWLObjectMinCardinalityRestriction desc) {
        this.translateObjectCardinality(desc, OWLRDFVocabulary.OWL_MIN_CARDINALITY.getURI());
    }

    @Override
    public void visit(OWLObjectOneOf desc) {
        this.translateAnonymousNode(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_ONE_OF.getURI(), desc.getIndividuals());
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_CLASS.getURI());
    }

    @Override
    public void visit(OWLObjectSelfRestriction desc) {
        this.translateAnonymousNode(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_SELF_RESTRICTION.getURI());
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_ON_PROPERTY.getURI(), (OWLObject)desc.getProperty());
    }

    @Override
    public void visit(OWLObjectSomeRestriction desc) {
        this.translateObjectRestrictionStart(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_SOME_VALUES_FROM.getURI(), (OWLObject)desc.getFiller());
    }

    @Override
    public void visit(OWLObjectValueRestriction desc) {
        this.translateObjectRestrictionStart(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_HAS_VALUE.getURI(), (OWLObject)desc.getValue());
    }

    @Override
    public void visit(OWLObjectUnionOf desc) {
        this.translateAnonymousNode(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_UNION_OF.getURI(), desc.getOperands());
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_CLASS.getURI());
    }

    @Override
    public void visit(OWLDataOneOf node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_DATA_RANGE.getURI());
        this.addTriple((OWLObject)node, OWLRDFVocabulary.OWL_ONE_OF.getURI(), node.getValues());
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_DATA_RANGE.getURI());
        this.addTriple((OWLObject)node, OWLRDFVocabulary.OWL_COMPLEMENT_OF.getURI(), node.getDataRange());
    }

    @Override
    public void visit(OWLDataType node) {
        if (!this.nodeMap.containsKey(node)) {
            this.nodeMap.put(node, this.getResourceNode(node.getURI()));
        }
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_DATATYPE.getURI());
    }

    @Override
    public void visit(OWLDataRangeRestriction node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_DATA_RANGE.getURI());
        this.addTriple((OWLObject)node, OWLRDFVocabulary.OWL_ON_DATA_RANGE.getURI(), node.getDataRange());
        for (OWLDataRangeFacetRestriction restriction : node.getFacetRestrictions()) {
            this.translateAnonymousNode(node);
            this.addTriple((OWLObject)node, restriction.getFacet().getURI(), restriction.getFacetValue());
        }
    }

    @Override
    public void visit(OWLDataRangeFacetRestriction node) {
    }

    @Override
    public void visit(OWLTypedConstant node) {
        this.nodeMap.put(node, this.getLiteralNode(node.getLiteral(), node.getDataType().getURI()));
    }

    @Override
    public void visit(OWLUntypedConstant node) {
        this.nodeMap.put(node, this.getLiteralNode(node.getLiteral(), node.getLang()));
    }

    @Override
    public void visit(OWLDataProperty property) {
        if (!this.nodeMap.containsKey(property)) {
            this.nodeMap.put(property, this.getPredicateNode(property.getURI()));
        }
        this.addTriple((OWLObject)property, OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_DATA_PROPERTY.getURI());
    }

    @Override
    public void visit(OWLObjectProperty property) {
        if (!this.nodeMap.containsKey(property)) {
            this.nodeMap.put(property, this.getPredicateNode(property.getURI()));
        }
        this.addTriple((OWLObject)property, OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getURI());
    }

    @Override
    public void visit(OWLObjectPropertyInverse property) {
        this.translateAnonymousNode(property);
        this.addTriple((OWLObject)property, OWLRDFVocabulary.OWL_INVERSE_OF.getURI(), property.getInverse());
        this.addTriple((OWLObject)property, OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getURI());
    }

    @Override
    public void visit(OWLIndividual individual) {
        if (!individual.isAnonymous()) {
            if (!this.nodeMap.containsKey(individual)) {
                this.nodeMap.put(individual, this.getResourceNode(individual.getURI()));
            }
            this.nodeMap.put(individual, this.getResourceNode(individual.getURI()));
        } else {
            this.translateAnonymousNode(individual);
        }
    }

    @Override
    public void visit(OWLConstantAnnotation annotation) {
    }

    @Override
    public void visit(OWLObjectAnnotation annotation) {
    }

    @Override
    public void visit(OWLOntology ontology) {
        if (!this.nodeMap.containsKey(ontology)) {
            this.nodeMap.put(ontology, this.getResourceNode(ontology.getURI()));
        }
        this.addTriple((OWLObject)ontology, OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_ONTOLOGY.getURI());
    }

    @Override
    public void visit(OWLOntologyAnnotationAxiom axiom) {
        ((OWLOntology)axiom.getSubject()).accept(this);
        this.addTriple((OWLObject)axiom.getSubject(), axiom.getAnnotation().getAnnotationURI(), axiom.getAnnotation().getAnnotationValue());
    }

    @Override
    public void visit(SWRLRule rule) {
        if (!rule.isAnonymous()) {
            if (!this.nodeMap.containsKey(rule)) {
                this.nodeMap.put(rule, this.getResourceNode(rule.getURI()));
            }
        } else {
            this.translateAnonymousNode(rule);
        }
        this.addTriple((OWLObject)rule, OWLRDFVocabulary.RDF_TYPE.getURI(), SWRLVocabulary.IMP.getURI());
        Set<SWRLAtom> antecedent = rule.getBody();
        this.addTriple(rule, SWRLVocabulary.BODY.getURI(), antecedent, SWRLVocabulary.ATOM_LIST.getURI());
        Set<SWRLAtom> consequent = rule.getHead();
        this.addTriple(rule, SWRLVocabulary.HEAD.getURI(), consequent, SWRLVocabulary.ATOM_LIST.getURI());
    }

    @Override
    public void visit(SWRLClassAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getURI(), SWRLVocabulary.CLASS_ATOM.getURI());
        ((OWLDescription)node.getPredicate()).accept(this);
        this.addTriple((OWLObject)node, SWRLVocabulary.CLASS_PREDICATE.getURI(), (OWLObject)node.getPredicate());
        ((SWRLAtomIObject)node.getArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getURI(), (OWLObject)node.getArgument());
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getURI(), SWRLVocabulary.DATA_RANGE_ATOM.getURI());
        ((OWLDataRange)node.getPredicate()).accept(this);
        this.addTriple((OWLObject)node, SWRLVocabulary.DATA_RANGE.getURI(), (OWLObject)node.getPredicate());
        ((SWRLAtomDObject)node.getArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getURI(), (OWLObject)node.getArgument());
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getURI(), SWRLVocabulary.INDIVIDUAL_PROPERTY_ATOM.getURI());
        ((OWLObjectPropertyExpression)node.getPredicate()).accept(this);
        this.addTriple((OWLObject)node, SWRLVocabulary.PROPERTY_PREDICATE.getURI(), (OWLObject)node.getPredicate());
        ((SWRLAtomIObject)node.getFirstArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getURI(), (OWLObject)node.getFirstArgument());
        ((SWRLAtomIObject)node.getSecondArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_2.getURI(), (OWLObject)node.getSecondArgument());
    }

    @Override
    public void visit(SWRLDataValuedPropertyAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getURI(), SWRLVocabulary.DATAVALUED_PROPERTY_ATOM.getURI());
        ((OWLDataPropertyExpression)node.getPredicate()).accept(this);
        this.addTriple((OWLObject)node, SWRLVocabulary.PROPERTY_PREDICATE.getURI(), (OWLObject)node.getPredicate());
        ((SWRLAtomIObject)node.getFirstArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getURI(), (OWLObject)node.getFirstArgument());
        ((SWRLAtomDObject)node.getSecondArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_2.getURI(), (OWLObject)node.getSecondArgument());
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getURI(), SWRLVocabulary.BUILT_IN_ATOM.getURI());
        this.addTriple((OWLObject)node, SWRLVocabulary.BUILT_IN.getURI(), ((SWRLBuiltInsVocabulary)((Object)node.getPredicate())).getURI());
        this.addTriple(this.getResourceNode(((SWRLBuiltInsVocabulary)((Object)node.getPredicate())).getURI()), this.getPredicateNode(SWRLVocabulary.BUILT_IN_CLASS.getURI()), this.getResourceNode(SWRLVocabulary.BUILT_IN_CLASS.getURI()));
        this.addTriple(this.getResourceNode(node), this.getPredicateNode(SWRLVocabulary.ARGUMENTS.getURI()), this.translateList(new ArrayList<SWRLAtomDObject>(node.getArguments())));
    }

    @Override
    public void visit(SWRLDifferentFromAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getURI(), SWRLVocabulary.DIFFERENT_INDIVIDUALS_ATOM.getURI());
        ((SWRLAtomIObject)node.getFirstArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getURI(), (OWLObject)node.getFirstArgument());
        ((SWRLAtomIObject)node.getSecondArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_2.getURI(), (OWLObject)node.getSecondArgument());
    }

    @Override
    public void visit(SWRLSameAsAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getURI(), SWRLVocabulary.SAME_INDIVIDUAL_ATOM.getURI());
        ((SWRLAtomIObject)node.getFirstArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getURI(), (OWLObject)node.getFirstArgument());
        ((SWRLAtomIObject)node.getSecondArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_2.getURI(), (OWLObject)node.getSecondArgument());
    }

    @Override
    public void visit(SWRLAtomDVariable node) {
        if (!this.nodeMap.containsKey(node)) {
            this.nodeMap.put(node, this.getResourceNode(node.getURI()));
        }
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getURI(), SWRLVocabulary.VARIABLE.getURI());
    }

    @Override
    public void visit(SWRLAtomIVariable node) {
        if (!this.nodeMap.containsKey(node)) {
            this.nodeMap.put(node, this.getResourceNode(node.getURI()));
        }
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getURI(), SWRLVocabulary.VARIABLE.getURI());
    }

    @Override
    public void visit(SWRLAtomIndividualObject node) {
        node.getIndividual().accept(this);
        this.nodeMap.put(node, this.nodeMap.get(node));
    }

    @Override
    public void visit(SWRLAtomConstantObject node) {
        node.getConstant().accept(this);
        this.nodeMap.put(node, this.nodeMap.get(node.getConstant()));
    }

    private void processAnonymousIndividual(OWLIndividual ind) {
        if (!ind.isAnonymous()) {
            return;
        }
        for (OWLIndividualAxiom oWLIndividualAxiom : this.ontology.getAxioms(ind)) {
            oWLIndividualAxiom.accept(this);
        }
        for (OWLEntityAnnotationAxiom oWLEntityAnnotationAxiom : this.ontology.getEntityAnnotationAxioms(ind)) {
            oWLEntityAnnotationAxiom.accept(this);
        }
    }

    private void addAxiom(OWLAxiom ax, OWLObject subject, URI pred, OWLObject obj) {
        this.addAxiom(ax, this.getResourceNode(subject), this.getPredicateNode(pred), this.getNode(obj));
    }

    private void addAxiom(OWLAxiom ax, OWLObject subject, URI pred, URI obj) {
        this.addAxiom(ax, this.getResourceNode(subject), this.getPredicateNode(pred), this.getResourceNode(obj));
    }

    private void addAxiom(OWLAxiom ax, OWLObject subj, URI pred, Set<? extends OWLObject> obj) {
        this.addAxiom(ax, this.getResourceNode(subj), this.getPredicateNode(pred), this.translateList(new ArrayList<OWLObject>(obj)));
    }

    private void addAxiom(OWLAxiom ax, OWLObject subj, OWLObject pred, OWLObject obj) {
        this.addAxiom(ax, this.getResourceNode(subj), this.getPredicateNode(pred), this.getNode(obj));
    }

    private void addAxiom(OWLAxiom ax, RESOURCE subj, PREDICATE pred, NODE obj) {
        if (this.ontology.getAnnotations(ax).isEmpty() && !(ax instanceof OWLNegativeObjectPropertyAssertionAxiom) && !(ax instanceof OWLNegativeDataPropertyAssertionAxiom)) {
            this.addTriple(subj, pred, obj);
        } else {
            this.translateAnonymousNode(ax);
            this.addTriple(this.getResourceNode(ax), this.getPredicateNode(OWLRDFVocabulary.RDF_SUBJECT.getURI()), subj);
            this.addTriple(this.getResourceNode(ax), this.getPredicateNode(OWLRDFVocabulary.RDF_PREDICATE.getURI()), pred);
            this.addTriple(this.getResourceNode(ax), this.getPredicateNode(OWLRDFVocabulary.RDF_OBJECT.getURI()), obj);
            for (OWLAxiomAnnotationAxiom annoAx : ax.getAnnotationAxioms(this.ontology)) {
                this.addTriple(this.getResourceNode(annoAx.getAnnotation().getAnnotationURI()), this.getPredicateNode(OWLRDFVocabulary.RDF_TYPE.getURI()), this.getResourceNode(OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY.getURI()));
                this.addTriple((OWLObject)ax, annoAx.getAnnotation().getAnnotationURI(), annoAx.getAnnotation().getAnnotationValue());
                this.addTriple((OWLObject)ax, OWLRDFVocabulary.RDF_TYPE.getURI(), OWLRDFVocabulary.OWL_AXIOM.getURI());
            }
        }
    }

    private void translateAnonymousNode(OWLObject object) {
        this.nodeMap.put(object, this.getAnonymousNode(object));
    }

    protected abstract RESOURCE getResourceNode(URI var1);

    protected abstract PREDICATE getPredicateNode(URI var1);

    protected abstract RESOURCE getAnonymousNode(Object var1);

    protected abstract LITERAL getLiteralNode(String var1, URI var2);

    protected abstract LITERAL getLiteralNode(String var1, String var2);

    protected abstract void addTriple(RESOURCE var1, PREDICATE var2, NODE var3);

    private RESOURCE getResourceNode(OWLObject object) {
        NODE r = this.nodeMap.get(object);
        if (r == null) {
            object.accept(this);
            r = this.nodeMap.get(object);
            if (r == null) {
                throw new IllegalStateException("Node is null!");
            }
        }
        return (RESOURCE)r;
    }

    private PREDICATE getPredicateNode(OWLObject object) {
        NODE p = this.nodeMap.get(object);
        if (p == null) {
            object.accept(this);
            p = this.nodeMap.get(object);
            if (p == null) {
                throw new IllegalStateException("Node is null!");
            }
        }
        return (PREDICATE)p;
    }

    private NODE getNode(OWLObject obj) {
        NODE node = this.nodeMap.get(obj);
        if (node == null) {
            obj.accept(this);
            node = this.nodeMap.get(obj);
            if (node == null) {
                throw new IllegalStateException("Node is null. Attempting to get node for " + obj);
            }
        }
        return node;
    }

    private RESOURCE translateList(List<? extends OWLObject> list) {
        return this.translateList(list, OWLRDFVocabulary.RDF_LIST.getURI());
    }

    private RESOURCE translateList(List<? extends OWLObject> list, URI listType) {
        if (list.isEmpty()) {
            return this.getResourceNode(OWLRDFVocabulary.RDF_NIL.getURI());
        }
        RESOURCE main = this.getAnonymousNode(list);
        this.addTriple(main, this.getPredicateNode(OWLRDFVocabulary.RDF_TYPE.getURI()), this.getResourceNode(listType));
        this.addTriple(main, this.getPredicateNode(OWLRDFVocabulary.RDF_FIRST.getURI()), this.getNode(list.get(0)));
        this.addTriple(main, this.getPredicateNode(OWLRDFVocabulary.RDF_REST.getURI()), this.translateList(list.subList(1, list.size()), listType));
        return main;
    }

    private void addTriple(OWLObject subject, URI pred, URI object) {
        this.addTriple(this.getResourceNode(subject), this.getPredicateNode(pred), this.getResourceNode(object));
    }

    private void addTriple(URI subj, URI pred, URI obj) {
        this.addTriple(this.getResourceNode(subj), this.getPredicateNode(pred), this.getResourceNode(obj));
    }

    private void addTriple(OWLObject subject, URI pred, OWLObject object) {
        this.addTriple(this.getResourceNode(subject), this.getPredicateNode(pred), this.getNode(object));
    }

    private void addTriple(OWLObject subject, URI pred, Set<? extends OWLObject> objects) {
        this.addTriple(this.getResourceNode(subject), this.getPredicateNode(pred), this.translateList(new ArrayList<OWLObject>(objects)));
    }

    private void addTriple(OWLObject subject, URI pred, Set<? extends OWLObject> objects, URI listType) {
        this.addTriple(this.getResourceNode(subject), this.getPredicateNode(pred), this.translateList(new ArrayList<OWLObject>(objects), listType));
    }

    private OWLTypedConstant toTypedConstant(int i) {
        return this.manager.getOWLDataFactory().getOWLTypedConstant(Integer.toString(i), this.manager.getOWLDataFactory().getOWLDataType(XSDVocabulary.NON_NEGATIVE_INTEGER.getURI()));
    }

    private boolean isObjectPunned(OWLObject entity) {
        this.punningChecker.reset();
        entity.accept(this.punningChecker);
        return this.punningChecker.isPunned();
    }

    private boolean isPunned(OWLObject ... objects) {
        for (OWLObject obj : objects) {
            if (this.isObjectPunned(obj)) continue;
            return false;
        }
        return true;
    }

    private boolean isPunned(Set<? extends OWLObject> objects) {
        for (OWLObject oWLObject : objects) {
            if (this.isPunned(oWLObject)) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DescriptionComparator
    implements Comparator<OWLDescription> {
        private DescriptionComparator() {
        }

        @Override
        public int compare(OWLDescription o1, OWLDescription o2) {
            if (!o1.isAnonymous()) {
                return -1;
            }
            return 1;
        }
    }

    private class PunningChecker
    extends OWLObjectVisitorAdapter {
        private boolean punned;

        private PunningChecker() {
        }

        public void reset() {
            this.punned = false;
        }

        public boolean isPunned() {
            return this.punned;
        }

        public void visit(OWLClass desc) {
            this.punned = AbstractTranslator.this.ontology.isPunned(desc.getURI());
        }

        public void visit(OWLDataProperty property) {
            this.punned = AbstractTranslator.this.ontology.containsObjectPropertyReference(property.getURI());
        }

        public void visit(OWLObjectProperty property) {
            this.punned = AbstractTranslator.this.ontology.containsDataPropertyReference(property.getURI());
        }

        public void visit(OWLObjectPropertyInverse property) {
            property.getInverse().accept(this);
        }

        public void visit(OWLDataType node) {
            this.punned = AbstractTranslator.this.ontology.isPunned(node.getURI());
        }

        public void visit(OWLIndividual individual) {
            this.punned = individual.isAnonymous() ? false : AbstractTranslator.this.ontology.isPunned(individual.getURI());
        }
    }
}

