/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdfxml.parser;

import java.net.URI;
import java.util.logging.Logger;
import org.coode.owl.rdfxml.parser.AbstractLiteralTripleHandler;
import org.coode.owl.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owl.io.RDFXMLOntologyFormat;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;

public class GTPAnnotationLiteralHandler
extends AbstractLiteralTripleHandler {
    private static final Logger logger = Logger.getLogger(GTPAnnotationLiteralHandler.class.getName());

    public GTPAnnotationLiteralHandler(OWLRDFConsumer consumer) {
        super(consumer);
    }

    public boolean canHandleStreaming(URI subject, URI predicate, OWLConstant object) throws OWLException {
        if (!this.getConsumer().isAnnotationProperty(predicate)) {
            return false;
        }
        return this.getConsumer().isClass(subject) || this.getConsumer().isObjectPropertyOnly(subject) || this.getConsumer().isDataPropertyOnly(subject);
    }

    public boolean canHandle(URI subject, URI predicate, OWLConstant object) throws OWLException {
        return this.getConsumer().isAnnotationProperty(predicate);
    }

    public void handleTriple(URI subject, URI predicate, OWLConstant object) throws OWLException {
        this.consumeTriple(subject, predicate, object);
        if (this.getConsumer().isOntology(subject)) {
            this.consumeTriple(subject, predicate, object);
            OWLOntology ontology = this.getConsumer().getOWLOntologyManager().getOntology(subject);
            if (ontology != null) {
                OWLOntologyAnnotationAxiom ax = this.getDataFactory().getOWLOntologyAnnotationAxiom(ontology, this.getDataFactory().getOWLConstantAnnotation(predicate, object));
                this.addAxiom(ax);
            } else {
                logger.warning("Annotation on ontology " + subject + " but could not obtain ontology!");
            }
            return;
        }
        OWLConstantAnnotation annotation = this.getDataFactory().getOWLConstantAnnotation(predicate, object);
        OWLEntity entity = null;
        if (this.getConsumer().isClass(subject)) {
            entity = this.getDataFactory().getOWLClass(subject);
        } else if (this.getConsumer().isObjectPropertyOnly(subject)) {
            entity = this.getDataFactory().getOWLObjectProperty(subject);
        } else if (this.getConsumer().isDataPropertyOnly(subject)) {
            entity = this.getDataFactory().getOWLDataProperty(subject);
        } else if (this.getConsumer().isAnnotationProperty(subject)) {
            RDFXMLOntologyFormat format = this.getConsumer().getOntologyFormat();
            format.addAnnotationURIAnnotation(subject, annotation);
            this.consumeTriple(subject, predicate, object);
        } else {
            OWLAxiom ax = this.getConsumer().getAxiom(subject);
            if (ax != null) {
                this.consumeTriple(subject, predicate, object);
                OWLAxiomAnnotationAxiom annoAx = this.getDataFactory().getOWLAxiomAnnotationAxiom(ax, annotation);
                this.addAxiom(annoAx);
                return;
            }
            entity = this.getConsumer().getOWLIndividual(subject);
        }
        if (entity != null) {
            this.consumeTriple(subject, predicate, object);
            OWLEntityAnnotationAxiom decAx = this.getDataFactory().getOWLEntityAnnotationAxiom(entity, annotation);
            this.addAxiom(decAx);
        }
    }
}

