/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.AbstractCompositeOntologyChange;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.RemoveAxiom;
import org.semanticweb.owl.util.OWLDescriptionVisitorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertEquivalentClassesToSuperClasses
extends AbstractCompositeOntologyChange {
    private OWLOntology targetOntology;
    private OWLClass cls;
    private Set<OWLOntology> ontologies;
    private boolean splitIntersections;
    private List<OWLOntologyChange> changes;

    public ConvertEquivalentClassesToSuperClasses(OWLDataFactory dataFactory, OWLClass cls, Set<OWLOntology> ontologies, OWLOntology targetOntology, boolean splitIntersections) {
        super(dataFactory);
        this.targetOntology = targetOntology;
        this.cls = cls;
        this.ontologies = ontologies;
        this.splitIntersections = splitIntersections;
        this.generateChanges();
    }

    private void generateChanges() {
        this.changes = new ArrayList<OWLOntologyChange>();
        HashSet<OWLDescription> supers = new HashSet<OWLDescription>();
        for (OWLOntology o : this.ontologies) {
            for (OWLEquivalentClassesAxiom ax : o.getEquivalentClassesAxioms(this.cls)) {
                this.changes.add(new RemoveAxiom(o, ax));
                for (OWLDescription equivCls : ax.getDescriptions()) {
                    supers.addAll(this.getDescriptions(equivCls));
                }
            }
        }
        supers.remove(this.cls);
        for (OWLDescription sup : supers) {
            this.changes.add(new AddAxiom(this.targetOntology, this.getDataFactory().getOWLSubClassAxiom(this.cls, sup)));
        }
    }

    private Set<OWLDescription> getDescriptions(OWLDescription desc) {
        final HashSet<OWLDescription> result = new HashSet<OWLDescription>();
        if (this.splitIntersections) {
            desc.accept(new OWLDescriptionVisitorAdapter(){

                public void visit(OWLObjectIntersectionOf desc) {
                    for (OWLDescription op : desc.getOperands()) {
                        result.add(op);
                    }
                }
            });
        }
        if (result.isEmpty()) {
            result.add(desc);
        }
        return result;
    }

    @Override
    public List<OWLOntologyChange> getChanges() {
        return this.changes;
    }
}

