/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.AbstractCompositeOntologyChange;
import org.semanticweb.owl.MakeClassesMutuallyDisjoint;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLSubClassAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakePrimitiveSubClassesMutuallyDisjoint
extends AbstractCompositeOntologyChange {
    private OWLClass cls;
    private Set<OWLOntology> ontologies;
    private OWLOntology targetOntology;
    private boolean usePairwiseDisjointAxioms;
    private List<OWLOntologyChange> changes;

    public MakePrimitiveSubClassesMutuallyDisjoint(OWLDataFactory dataFactory, OWLClass cls, Set<OWLOntology> ontologies, OWLOntology targetOntology) {
        this(dataFactory, cls, ontologies, targetOntology, false);
    }

    public MakePrimitiveSubClassesMutuallyDisjoint(OWLDataFactory dataFactory, OWLClass cls, Set<OWLOntology> ontologies, OWLOntology targetOntology, boolean usePairwiseDisjointAxioms) {
        super(dataFactory);
        this.cls = cls;
        this.ontologies = ontologies;
        this.targetOntology = targetOntology;
        this.usePairwiseDisjointAxioms = usePairwiseDisjointAxioms;
        this.generateChanges();
    }

    private void generateChanges() {
        this.changes = new ArrayList<OWLOntologyChange>();
        HashSet<OWLClass> subclasses = new HashSet<OWLClass>();
        for (OWLOntology ont : this.ontologies) {
            for (OWLSubClassAxiom ax : ont.getSubClassAxiomsForRHS(this.cls)) {
                if (ax.getSubClass().isAnonymous() || ax.getSubClass().asOWLClass().isDefined(this.ontologies)) continue;
                subclasses.add(ax.getSuperClass().asOWLClass());
            }
        }
        MakeClassesMutuallyDisjoint makeClassesMutuallyDisjoint = new MakeClassesMutuallyDisjoint(this.getDataFactory(), subclasses, this.usePairwiseDisjointAxioms, this.targetOntology);
        this.changes.addAll(makeClassesMutuallyDisjoint.getChanges());
    }

    @Override
    public List<OWLOntologyChange> getChanges() {
        return this.changes;
    }
}

