/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.apibinding;

import de.uulm.ecs.ai.owl.krssparser.KRSS2OWLParserFactory;
import de.uulm.ecs.ai.owl.krssrenderer.KRSS2OWLSyntaxOntologyStorer;
import org.coode.manchesterowlsyntax.ManchesterOWLSyntaxParserFactory;
import org.coode.obo.parser.OBOParserFactory;
import org.coode.owl.functionalparser.OWLFunctionalSyntaxParserFactory;
import org.coode.owl.functionalrenderer.OWLFunctionalSyntaxOntologyStorer;
import org.coode.owl.latex.LatexOntologyStorer;
import org.coode.owl.owlxmlparser.OWLXMLParserFactory;
import org.coode.owl.rdf.rdfxml.RDFXMLOntologyStorer;
import org.coode.owl.rdf.turtle.TurtleOntologyStorer;
import org.coode.owl.rdfxml.parser.RDFXMLParserFactory;
import org.coode.owlapi.owlxml.renderer.OWLXMLOntologyStorer;
import org.semanticweb.owl.io.OWLParserFactoryRegistry;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.util.NonMappingOntologyURIMapper;
import uk.ac.manchester.cs.owl.EmptyInMemOWLOntologyFactory;
import uk.ac.manchester.cs.owl.OWLDataFactoryImpl;
import uk.ac.manchester.cs.owl.OWLOntologyManagerImpl;
import uk.ac.manchester.cs.owl.ParsableOWLOntologyFactory;
import uk.ac.manchester.cs.owl.mansyntaxrenderer.ManchesterOWLSyntaxOntologyStorer;
import uk.ac.manchester.cs.owl.turtle.parser.TurtleOntologyParserFactory;

public class OWLManager {
    public static OWLOntologyManager createOWLOntologyManager() {
        return OWLManager.createOWLOntologyManager(new OWLDataFactoryImpl());
    }

    public static OWLOntologyManager createOWLOntologyManager(OWLDataFactory dataFactory) {
        OWLOntologyManagerImpl ontologyManager = new OWLOntologyManagerImpl(dataFactory);
        ontologyManager.addOntologyStorer(new RDFXMLOntologyStorer());
        ontologyManager.addOntologyStorer(new OWLXMLOntologyStorer());
        ontologyManager.addOntologyStorer(new OWLFunctionalSyntaxOntologyStorer());
        ontologyManager.addOntologyStorer(new ManchesterOWLSyntaxOntologyStorer());
        ontologyManager.addOntologyStorer(new KRSS2OWLSyntaxOntologyStorer());
        ontologyManager.addOntologyStorer(new TurtleOntologyStorer());
        ontologyManager.addOntologyStorer(new LatexOntologyStorer());
        ontologyManager.addURIMapper(new NonMappingOntologyURIMapper());
        ontologyManager.addOntologyFactory(new EmptyInMemOWLOntologyFactory());
        ontologyManager.addOntologyFactory(new ParsableOWLOntologyFactory());
        return ontologyManager;
    }

    static {
        OWLParserFactoryRegistry registry = OWLParserFactoryRegistry.getInstance();
        registry.registerParserFactory(new ManchesterOWLSyntaxParserFactory());
        registry.registerParserFactory(new KRSS2OWLParserFactory());
        registry.registerParserFactory(new OBOParserFactory());
        registry.registerParserFactory(new TurtleOntologyParserFactory());
        registry.registerParserFactory(new OWLFunctionalSyntaxParserFactory());
        registry.registerParserFactory(new OWLXMLParserFactory());
        registry.registerParserFactory(new RDFXMLParserFactory());
    }
}

