/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.profiles;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.model.AxiomType;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectAnnotation;
import org.semanticweb.owl.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitorEx;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.model.SWRLAtom;
import org.semanticweb.owl.model.SWRLAtomConstantObject;
import org.semanticweb.owl.model.SWRLAtomDVariable;
import org.semanticweb.owl.model.SWRLAtomIVariable;
import org.semanticweb.owl.model.SWRLAtomIndividualObject;
import org.semanticweb.owl.model.SWRLBuiltInAtom;
import org.semanticweb.owl.model.SWRLClassAtom;
import org.semanticweb.owl.model.SWRLDataRangeAtom;
import org.semanticweb.owl.model.SWRLDataValuedPropertyAtom;
import org.semanticweb.owl.model.SWRLDifferentFromAtom;
import org.semanticweb.owl.model.SWRLObjectPropertyAtom;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.model.SWRLSameAsAtom;
import org.semanticweb.owl.profiles.AxiomNotAllowed;
import org.semanticweb.owl.profiles.ConstructNotAllowed;
import org.semanticweb.owl.profiles.DataRangeNotAllowed;
import org.semanticweb.owl.profiles.DescriptionNotAllowed;
import org.semanticweb.owl.profiles.OWL2ProfileReport;
import org.semanticweb.owl.profiles.OWLProfile;
import org.semanticweb.owl.profiles.OWLProfileReport;
import org.semanticweb.owl.util.OWLObjectPropertyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWL2Profile
implements OWLProfile {
    private OWLObjectPropertyManager propertyManager;

    @Override
    public String getName() {
        return "OWL 2";
    }

    @Override
    public OWLProfileReport checkOntology(OWLOntology ontology, OWLOntologyManager manager) {
        this.propertyManager = new OWLObjectPropertyManager(manager, ontology);
        HashSet<ConstructNotAllowed> notAllowed = new HashSet<ConstructNotAllowed>();
        AxiomChecker checker = new AxiomChecker();
        for (OWLOntology ont : manager.getImportsClosure(ontology)) {
            for (OWLAxiom ax : ont.getAxioms()) {
                Set<ConstructNotAllowed> na = ax.accept(checker);
                notAllowed.addAll(na);
            }
        }
        for (OWLObjectPropertyChainSubPropertyAxiom ax : ontology.getAxioms(AxiomType.PROPERTY_CHAIN_SUB_PROPERTY)) {
            if (ax.getPropertyChain().size() == 2 && !ax.isEncodingOfTransitiveProperty()) continue;
        }
        HashSet<URI> objectPropertyURIs = new HashSet<URI>();
        HashSet<URI> dataPropertyURIs = new HashSet<URI>();
        for (OWLOntology ont : manager.getImportsClosure(ontology)) {
            for (OWLObjectProperty oWLObjectProperty : ont.getReferencedObjectProperties()) {
                objectPropertyURIs.add(oWLObjectProperty.getURI());
            }
            for (OWLDataProperty oWLDataProperty : ont.getReferencedDataProperties()) {
                dataPropertyURIs.add(oWLDataProperty.getURI());
            }
        }
        for (URI uri : objectPropertyURIs) {
            if (!dataPropertyURIs.contains(uri)) continue;
            notAllowed.add(new DataPropertyURIUsedAsObjectPropertyURI(uri));
        }
        HashSet<OWLObjectPropertyExpression> simpleRoles = new HashSet<OWLObjectPropertyExpression>();
        HashSet<OWLObjectPropertyExpression> nonSimpleRoles = new HashSet<OWLObjectPropertyExpression>();
        for (OWLObjectProperty oWLObjectProperty : ontology.getReferencedObjectProperties()) {
            if (!this.propertyManager.getNonSimpleProperties().contains(oWLObjectProperty)) {
                simpleRoles.add(oWLObjectProperty);
                continue;
            }
            nonSimpleRoles.add(oWLObjectProperty);
        }
        return new OWL2ProfileReport(this, ontology.getURI(), notAllowed, nonSimpleRoles, simpleRoles);
    }

    private static Set<ConstructNotAllowed> getSet(ConstructNotAllowed na) {
        return Collections.singleton(na);
    }

    private static Set<ConstructNotAllowed> getSet() {
        return new HashSet<ConstructNotAllowed>(2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DataPropertyURIUsedAsObjectPropertyURI
    extends ConstructNotAllowed<URI> {
        public DataPropertyURIUsedAsObjectPropertyURI(URI uri) {
            super(uri);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("<");
            sb.append(this.getConstruct());
            sb.append(">  is used as both a data and object property URI");
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NonSimplePropertyInExistsSelfRestriction
    extends DescriptionNotAllowed {
        public NonSimplePropertyInExistsSelfRestriction(ConstructNotAllowed cause, OWLDescription construct) {
            super(cause, construct);
        }

        public NonSimplePropertyInExistsSelfRestriction(Set<ConstructNotAllowed> cause, OWLDescription construct) {
            super(cause, construct);
        }

        public NonSimplePropertyInExistsSelfRestriction(OWLDescription construct) {
            super(construct);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NonSimplePropertyInDisjointPropertiesAxiom
    extends AxiomNotAllowed {
        private Set<OWLObjectPropertyExpression> props;

        public NonSimplePropertyInDisjointPropertiesAxiom(OWLAxiom construct, Set<OWLObjectPropertyExpression> properties) {
            super(construct);
            this.props = properties;
        }

        public Set<OWLObjectPropertyExpression> getProperties() {
            return this.props;
        }
    }

    public class NonSimplePropertyInIrreflexivePropertyAxiom
    extends AxiomNotAllowed {
        public NonSimplePropertyInIrreflexivePropertyAxiom(OWLAxiom construct) {
            super(construct);
        }
    }

    public class NonSimplePropertyInAntiSymmetricPropertyAxiom
    extends AxiomNotAllowed {
        public NonSimplePropertyInAntiSymmetricPropertyAxiom(OWLAxiom construct) {
            super(construct);
        }
    }

    public class NonSimplePropertyInInverseFunctionalPropertyAxiom
    extends AxiomNotAllowed {
        public NonSimplePropertyInInverseFunctionalPropertyAxiom(OWLAxiom construct) {
            super(construct);
        }
    }

    public class NonSimplePropertyInCardinalityRestriction
    extends DescriptionNotAllowed {
        public NonSimplePropertyInCardinalityRestriction(OWLObjectCardinalityRestriction construct) {
            super(construct);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NonSimplePropertyInFunctionalPropertyAxiom
    extends AxiomNotAllowed<OWLFunctionalObjectPropertyAxiom> {
        public NonSimplePropertyInFunctionalPropertyAxiom(OWLFunctionalObjectPropertyAxiom construct) {
            super(construct);
        }
    }

    public class OWL2DataRangeNotAllowed
    extends DataRangeNotAllowed {
        public OWL2DataRangeNotAllowed(ConstructNotAllowed cause, OWLDataRange construct) {
            super(cause, construct);
        }

        public OWL2DataRangeNotAllowed(OWLDataRange construct) {
            super(construct);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AnnotationValueNotAllowed
    extends ConstructNotAllowed<OWLAnnotation> {
        public AnnotationValueNotAllowed(OWLAnnotation annotation) {
            super(annotation);
        }

        public AnnotationValueNotAllowed(ConstructNotAllowed cause, OWLAnnotation construct) {
            super(cause, construct);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AxiomChecker
    implements OWLObjectVisitorEx<Set<ConstructNotAllowed>> {
        private AxiomChecker() {
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
            if (OWL2Profile.this.propertyManager.isNonSimple((OWLObjectPropertyExpression)axiom.getProperty())) {
                return OWL2Profile.getSet(new NonSimplePropertyInAntiSymmetricPropertyAxiom(axiom));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLAxiomAnnotationAxiom axiom) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLClassAssertionAxiom axiom) {
            Set<ConstructNotAllowed> na = axiom.getDescription().accept(this);
            if (na.isEmpty()) {
                return Collections.emptySet();
            }
            return OWL2Profile.getSet(new AxiomNotAllowed<OWLClassAssertionAxiom>(na, axiom));
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLDataPropertyAssertionAxiom axiom) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLDataPropertyDomainAxiom axiom) {
            Set<ConstructNotAllowed> na = axiom.getDomain().accept(this);
            if (!na.isEmpty()) {
                return OWL2Profile.getSet(new AxiomNotAllowed<OWLDataPropertyDomainAxiom>(na, axiom));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLDataPropertyRangeAxiom axiom) {
            Set<ConstructNotAllowed> na = ((OWLDataRange)axiom.getRange()).accept(this);
            if (!na.isEmpty()) {
                return OWL2Profile.getSet(new AxiomNotAllowed<OWLDataPropertyRangeAxiom>(na, axiom));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLDataSubPropertyAxiom axiom) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLDeclarationAxiom axiom) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLDifferentIndividualsAxiom axiom) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLDisjointClassesAxiom axiom) {
            Set na = OWL2Profile.getSet();
            for (OWLDescription desc : axiom.getDescriptions()) {
                Set<ConstructNotAllowed> descNa = desc.accept(this);
                na.addAll(descNa);
            }
            if (!na.isEmpty()) {
                return OWL2Profile.getSet(new AxiomNotAllowed<OWLDisjointClassesAxiom>((Set<ConstructNotAllowed>)na, axiom));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLDisjointDataPropertiesAxiom axiom) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLDisjointObjectPropertiesAxiom axiom) {
            HashSet<OWLObjectPropertyExpression> nonSimpleProperties = new HashSet<OWLObjectPropertyExpression>();
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                if (!OWL2Profile.this.propertyManager.isNonSimple(prop)) continue;
                nonSimpleProperties.add(prop);
            }
            if (!nonSimpleProperties.isEmpty()) {
                return OWL2Profile.getSet(new NonSimplePropertyInDisjointPropertiesAxiom(axiom, nonSimpleProperties));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLDisjointUnionAxiom axiom) {
            Set na = OWL2Profile.getSet();
            for (OWLDescription desc : axiom.getDescriptions()) {
                na.addAll((Collection)desc.accept(this));
            }
            if (!na.isEmpty()) {
                return OWL2Profile.getSet(new AxiomNotAllowed<OWLDisjointUnionAxiom>((Set<ConstructNotAllowed>)na, axiom));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLEntityAnnotationAxiom axiom) {
            Set<ConstructNotAllowed> na = axiom.getAnnotation().accept(this);
            if (!na.isEmpty()) {
                return OWL2Profile.getSet(new AxiomNotAllowed<OWLEntityAnnotationAxiom>(na, axiom));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLEquivalentClassesAxiom axiom) {
            Set na = OWL2Profile.getSet();
            for (OWLDescription desc : axiom.getDescriptions()) {
                na.addAll((Collection)desc.accept(this));
            }
            if (!na.isEmpty()) {
                return OWL2Profile.getSet(new AxiomNotAllowed<OWLEquivalentClassesAxiom>((Set<ConstructNotAllowed>)na, axiom));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLEquivalentDataPropertiesAxiom axiom) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLFunctionalDataPropertyAxiom axiom) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLFunctionalObjectPropertyAxiom axiom) {
            if (OWL2Profile.this.propertyManager.isNonSimple((OWLObjectPropertyExpression)axiom.getProperty())) {
                return OWL2Profile.getSet(new NonSimplePropertyInFunctionalPropertyAxiom(axiom));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLImportsDeclaration axiom) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            if (OWL2Profile.this.propertyManager.isNonSimple((OWLObjectPropertyExpression)axiom.getProperty())) {
                return OWL2Profile.getSet(new NonSimplePropertyInInverseFunctionalPropertyAxiom(axiom));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLInverseObjectPropertiesAxiom axiom) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            if (OWL2Profile.this.propertyManager.isNonSimple((OWLObjectPropertyExpression)axiom.getProperty())) {
                return OWL2Profile.getSet(new NonSimplePropertyInIrreflexivePropertyAxiom(axiom));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLObjectPropertyAssertionAxiom axiom) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLObjectPropertyDomainAxiom axiom) {
            Set<ConstructNotAllowed> na = axiom.getDomain().accept(this);
            if (!na.isEmpty()) {
                return OWL2Profile.getSet(new AxiomNotAllowed<OWLObjectPropertyDomainAxiom>(na, axiom));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLObjectPropertyRangeAxiom axiom) {
            Set<ConstructNotAllowed> na = ((OWLDescription)axiom.getRange()).accept(this);
            if (!na.isEmpty()) {
                return OWL2Profile.getSet(new AxiomNotAllowed<OWLObjectPropertyRangeAxiom>(na, axiom));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLObjectSubPropertyAxiom axiom) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLOntologyAnnotationAxiom axiom) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLReflexiveObjectPropertyAxiom axiom) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLSameIndividualsAxiom axiom) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLSubClassAxiom axiom) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLSymmetricObjectPropertyAxiom axiom) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLTransitiveObjectPropertyAxiom axiom) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(SWRLRule rule) {
            for (SWRLAtom sWRLAtom : rule.getBody()) {
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLClass desc) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLDataAllRestriction desc) {
            Set<ConstructNotAllowed> na = ((OWLDataRange)desc.getFiller()).accept(this);
            if (!na.isEmpty()) {
                return OWL2Profile.getSet(new DescriptionNotAllowed(na, (OWLDescription)desc));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLDataExactCardinalityRestriction desc) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLDataMaxCardinalityRestriction desc) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLDataMinCardinalityRestriction desc) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLDataSomeRestriction desc) {
            Set<ConstructNotAllowed> na = ((OWLDataRange)desc.getFiller()).accept(this);
            if (!na.isEmpty()) {
                return OWL2Profile.getSet(new DescriptionNotAllowed(na, (OWLDescription)desc));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLDataValueRestriction desc) {
            Set<ConstructNotAllowed> na = ((OWLConstant)desc.getValue()).accept(this);
            if (!na.isEmpty()) {
                return OWL2Profile.getSet(new DescriptionNotAllowed(na, (OWLDescription)desc));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLObjectAllRestriction desc) {
            Set<ConstructNotAllowed> na = ((OWLDescription)desc.getFiller()).accept(this);
            if (!na.isEmpty()) {
                return OWL2Profile.getSet(new DescriptionNotAllowed(na, (OWLDescription)desc));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLObjectComplementOf desc) {
            Set<ConstructNotAllowed> na = desc.getOperand().accept(this);
            if (!na.isEmpty()) {
                return OWL2Profile.getSet(new DescriptionNotAllowed(na, (OWLDescription)desc));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLObjectExactCardinalityRestriction desc) {
            if (OWL2Profile.this.propertyManager.isNonSimple((OWLObjectPropertyExpression)desc.getProperty())) {
                return OWL2Profile.getSet(new NonSimplePropertyInCardinalityRestriction(desc));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLObjectIntersectionOf desc) {
            for (OWLDescription op : desc.getOperands()) {
                Set<ConstructNotAllowed> na = op.accept(this);
                if (na.isEmpty()) continue;
                return OWL2Profile.getSet(new DescriptionNotAllowed(na, (OWLDescription)desc));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLObjectMaxCardinalityRestriction desc) {
            if (OWL2Profile.this.propertyManager.isNonSimple((OWLObjectPropertyExpression)desc.getProperty())) {
                return OWL2Profile.getSet(new NonSimplePropertyInCardinalityRestriction(desc));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLObjectMinCardinalityRestriction desc) {
            if (OWL2Profile.this.propertyManager.isNonSimple((OWLObjectPropertyExpression)desc.getProperty())) {
                return OWL2Profile.getSet(new NonSimplePropertyInCardinalityRestriction(desc));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLObjectOneOf desc) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLObjectSelfRestriction desc) {
            if (OWL2Profile.this.propertyManager.isNonSimple((OWLObjectPropertyExpression)desc.getProperty())) {
                return OWL2Profile.getSet(new NonSimplePropertyInExistsSelfRestriction((OWLDescription)desc));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLObjectSomeRestriction desc) {
            Set<ConstructNotAllowed> na = ((OWLDescription)desc.getFiller()).accept(this);
            if (!na.isEmpty()) {
                return OWL2Profile.getSet(new DescriptionNotAllowed(na, (OWLDescription)desc));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLObjectUnionOf desc) {
            for (OWLDescription op : desc.getOperands()) {
                Set<ConstructNotAllowed> na = op.accept(this);
                if (na.isEmpty()) continue;
                return OWL2Profile.getSet(new DescriptionNotAllowed(na, (OWLDescription)desc));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLObjectValueRestriction desc) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLDataComplementOf node) {
            Set<ConstructNotAllowed> na = node.getDataRange().accept(this);
            if (!na.isEmpty()) {
                return OWL2Profile.getSet(new DataRangeNotAllowed(na, (OWLDataRange)node));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLDataOneOf node) {
            for (OWLConstant op : node.getValues()) {
                Set<ConstructNotAllowed> na = op.accept(this);
                if (na.isEmpty()) continue;
                return OWL2Profile.getSet(new DataRangeNotAllowed(na, (OWLDataRange)node));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLDataRangeFacetRestriction node) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLDataRangeRestriction node) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLDataType node) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLTypedConstant node) {
            Set<ConstructNotAllowed> na = node.getDataType().accept(this);
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLUntypedConstant node) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLDataProperty property) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLObjectProperty property) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLObjectPropertyInverse property) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLIndividual individual) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLConstantAnnotation annotation) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLObjectAnnotation annotation) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(SWRLAtomConstantObject node) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(SWRLAtomDVariable node) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(SWRLAtomIndividualObject node) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(SWRLAtomIVariable node) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(SWRLBuiltInAtom node) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(SWRLClassAtom node) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(SWRLDataRangeAtom node) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(SWRLDataValuedPropertyAtom node) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(SWRLDifferentFromAtom node) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(SWRLObjectPropertyAtom node) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(SWRLSameAsAtom node) {
            return Collections.emptySet();
        }

        @Override
        public Set<ConstructNotAllowed> visit(OWLOntology ontology) {
            return Collections.emptySet();
        }
    }
}

