/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.profiles;

import java.net.URI;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.profiles.ConstructNotAllowed;
import org.semanticweb.owl.profiles.OWLProfile;
import org.semanticweb.owl.profiles.OWLProfileReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWL2ProfileReport
extends OWLProfileReport {
    private Set<OWLObjectPropertyExpression> nonSimpleRoles;
    private Set<OWLObjectPropertyExpression> simpleRoles;

    public OWL2ProfileReport(OWLProfile profile, URI ontologyURI, Set<ConstructNotAllowed> disallowedConstructs, Set<OWLObjectPropertyExpression> nonSimpleRoles, Set<OWLObjectPropertyExpression> simpleRoles) {
        super(profile, ontologyURI, disallowedConstructs);
        this.nonSimpleRoles = new TreeSet<OWLObjectPropertyExpression>(nonSimpleRoles);
        this.simpleRoles = new TreeSet<OWLObjectPropertyExpression>(simpleRoles);
    }

    public Set<OWLObjectPropertyExpression> getNonSimpleRoles() {
        return this.nonSimpleRoles;
    }

    public Set<OWLObjectPropertyExpression> getSimpleRoles() {
        return this.simpleRoles;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\n[Simple properties]\n");
        for (OWLObjectPropertyExpression prop : this.simpleRoles) {
            sb.append("\t");
            sb.append(prop);
            sb.append("\n");
        }
        sb.append("\n[Non-simple properties]\n");
        for (OWLObjectPropertyExpression prop : this.nonSimpleRoles) {
            sb.append("\t");
            sb.append(prop);
            sb.append("\n");
        }
        return sb.toString();
    }
}

