/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.profiles;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectAnnotation;
import org.semanticweb.owl.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitorEx;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.model.SWRLAtom;
import org.semanticweb.owl.model.SWRLAtomConstantObject;
import org.semanticweb.owl.model.SWRLAtomDVariable;
import org.semanticweb.owl.model.SWRLAtomIVariable;
import org.semanticweb.owl.model.SWRLAtomIndividualObject;
import org.semanticweb.owl.model.SWRLBuiltInAtom;
import org.semanticweb.owl.model.SWRLClassAtom;
import org.semanticweb.owl.model.SWRLDataRangeAtom;
import org.semanticweb.owl.model.SWRLDataValuedPropertyAtom;
import org.semanticweb.owl.model.SWRLDifferentFromAtom;
import org.semanticweb.owl.model.SWRLObjectPropertyAtom;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.model.SWRLSameAsAtom;
import org.semanticweb.owl.profiles.AxiomNotAllowed;
import org.semanticweb.owl.profiles.ConstructNotAllowed;
import org.semanticweb.owl.profiles.DataRangeNotAllowed;
import org.semanticweb.owl.profiles.DescriptionNotAllowed;
import org.semanticweb.owl.profiles.OWLProfile;
import org.semanticweb.owl.profiles.OWLProfileReport;
import org.semanticweb.owl.util.OWLObjectPropertyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLDLProfile
implements OWLProfile {
    private OWLObjectPropertyManager propertyManager;

    @Override
    public String getName() {
        return "OWL DL";
    }

    @Override
    public OWLProfileReport checkOntology(OWLOntology ontology, OWLOntologyManager manager) {
        this.propertyManager = new OWLObjectPropertyManager(manager, ontology);
        HashSet<ConstructNotAllowed> notAllowed = new HashSet<ConstructNotAllowed>();
        AxiomChecker checker = new AxiomChecker();
        for (OWLOntology ont : manager.getImportsClosure(ontology)) {
            for (OWLAxiom ax : ont.getAxioms()) {
                ConstructNotAllowed na = ax.accept(checker);
                if (na == null) continue;
                notAllowed.add(na);
            }
        }
        HashMap<URI, Set<OWLEntity>> uri2EntityMap = new HashMap<URI, Set<OWLEntity>>();
        HashSet<URI> annotationURIs = new HashSet<URI>();
        for (OWLOntology ont : manager.getImportsClosure(ontology)) {
            for (OWLClass oWLClass : ont.getReferencedClasses()) {
                OWLDLProfile.mapEntity(oWLClass, uri2EntityMap);
            }
            for (OWLObjectProperty oWLObjectProperty : ont.getReferencedObjectProperties()) {
                OWLDLProfile.mapEntity(oWLObjectProperty, uri2EntityMap);
            }
            for (OWLDataProperty oWLDataProperty : ont.getReferencedDataProperties()) {
                OWLDLProfile.mapEntity(oWLDataProperty, uri2EntityMap);
            }
            for (OWLIndividual oWLIndividual : ont.getReferencedIndividuals()) {
                OWLDLProfile.mapEntity(oWLIndividual, uri2EntityMap);
            }
            annotationURIs.addAll(ont.getAnnotationURIs());
        }
        for (URI uri : uri2EntityMap.keySet()) {
            Set entities = (Set)uri2EntityMap.get(uri);
            if (entities.size() > 2) {
                notAllowed.add(new PunningNotAllowed(new HashSet<OWLEntity>(entities)));
            }
            if (!annotationURIs.contains(uri)) continue;
            notAllowed.add(new PunningWithAnnotationURI(entities));
        }
        return new OWLProfileReport(this, ontology.getURI(), notAllowed);
    }

    private static void mapEntity(OWLEntity entity, Map<URI, Set<OWLEntity>> map) {
        Set<OWLEntity> entities = map.get(entity.getURI());
        if (entities == null) {
            entities = new HashSet<OWLEntity>(2);
            map.put(entity.getURI(), entities);
        }
        entities.add(entity);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PunningWithAnnotationURI
    extends ConstructNotAllowed<Set<OWLEntity>> {
        public PunningWithAnnotationURI(Set<OWLEntity> construct) {
            super(construct);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            Set entities = (Set)this.getConstruct();
            sb.append("Punning is not allowed: <");
            sb.append(((OWLEntity)entities.iterator().next()).getURI());
            sb.append(">");
            sb.append(" is used as an annotation property URI, ");
            Iterator it = entities.iterator();
            while (it.hasNext()) {
                OWLEntity ent = (OWLEntity)it.next();
                if (ent.isOWLClass()) {
                    sb.append("a class URI");
                } else if (ent.isOWLObjectProperty()) {
                    sb.append("an object property URI");
                } else if (ent.isOWLDataProperty()) {
                    sb.append("a data property URI");
                } else if (ent.isOWLIndividual()) {
                    sb.append("an individual URI");
                }
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PunningNotAllowed
    extends ConstructNotAllowed<Set<OWLEntity>> {
        public PunningNotAllowed(Set<OWLEntity> construct) {
            super(construct);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            Set entities = (Set)this.getConstruct();
            sb.append("Punning is not allowed: <");
            sb.append(((OWLEntity)entities.iterator().next()).getURI());
            sb.append("> is used as ");
            Iterator it = entities.iterator();
            while (it.hasNext()) {
                OWLEntity ent = (OWLEntity)it.next();
                if (ent.isOWLClass()) {
                    sb.append("a class URI");
                } else if (ent.isOWLObjectProperty()) {
                    sb.append("an object property URI");
                } else if (ent.isOWLDataProperty()) {
                    sb.append("a data property URI");
                } else if (ent.isOWLIndividual()) {
                    sb.append("an individual URI");
                }
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            return sb.toString();
        }
    }

    private class NonSimplePropertiesNotAllowedInCardinalityRestrictions
    extends DescriptionNotAllowed {
        public NonSimplePropertiesNotAllowedInCardinalityRestrictions(OWLObjectCardinalityRestriction construct) {
            super(construct);
        }
    }

    private class NonSimplePropertiesNotAllowedInFunctionalPropertyAxioms
    extends AxiomNotAllowed {
        public NonSimplePropertiesNotAllowedInFunctionalPropertyAxioms(OWLAxiom construct) {
            super(construct);
        }
    }

    private class PropertyInversesNotAllowed
    extends ConstructNotAllowed {
        public PropertyInversesNotAllowed(ConstructNotAllowed cause, Object construct) {
            super(cause, construct);
        }

        public PropertyInversesNotAllowed(OWLObjectPropertyInverse construct) {
            super(construct);
        }
    }

    private class OWL2DataRangeNotAllowed
    extends DataRangeNotAllowed {
        public OWL2DataRangeNotAllowed(ConstructNotAllowed cause, OWLDataRange construct) {
            super(cause, construct);
        }

        public OWL2DataRangeNotAllowed(OWLDataRange construct) {
            super(construct);
        }
    }

    private class SelfRestrictionsNotAllowed
    extends DescriptionNotAllowed {
        public SelfRestrictionsNotAllowed(OWLDescription construct) {
            super(construct);
        }
    }

    private class QCRsNotAllowed
    extends DescriptionNotAllowed {
        public QCRsNotAllowed(OWLDescription construct) {
            super(construct);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnnotationValueNotAllowed
    extends ConstructNotAllowed<OWLAnnotation> {
        public AnnotationValueNotAllowed(OWLAnnotation annotation) {
            super(annotation);
        }

        public AnnotationValueNotAllowed(ConstructNotAllowed cause, OWLAnnotation construct) {
            super(cause, construct);
        }
    }

    private class DisjointClassAxiomNotAllowed
    extends AxiomNotAllowed {
        public DisjointClassAxiomNotAllowed(OWLDisjointClassesAxiom axiom) {
            super(axiom);
        }
    }

    private class OWL2AxiomNotAllowed
    extends AxiomNotAllowed {
        private boolean canBeRewritten;

        public OWL2AxiomNotAllowed(OWLAxiom construct, boolean canBeRewritten) {
            super(construct);
            this.canBeRewritten = canBeRewritten;
        }

        public boolean isCanBeRewrittenIntoOWLDL() {
            return this.canBeRewritten;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AxiomChecker
    implements OWLObjectVisitorEx<ConstructNotAllowed> {
        private AxiomChecker() {
        }

        @Override
        public ConstructNotAllowed visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
            return new OWL2AxiomNotAllowed(axiom, false);
        }

        @Override
        public ConstructNotAllowed visit(OWLAxiomAnnotationAxiom axiom) {
            return new OWL2AxiomNotAllowed(axiom, false);
        }

        @Override
        public ConstructNotAllowed visit(OWLClassAssertionAxiom axiom) {
            ConstructNotAllowed descNA = axiom.getDescription().accept(this);
            if (descNA != null) {
                return new AxiomNotAllowed<OWLClassAssertionAxiom>(descNA, axiom);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDataPropertyAssertionAxiom axiom) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDataPropertyDomainAxiom axiom) {
            ConstructNotAllowed na = axiom.getDomain().accept(this);
            if (na != null) {
                return new AxiomNotAllowed<OWLDataPropertyDomainAxiom>(na, axiom);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDataPropertyRangeAxiom axiom) {
            ConstructNotAllowed na = ((OWLDataRange)axiom.getRange()).accept(this);
            if (na != null) {
                return new AxiomNotAllowed<OWLDataPropertyRangeAxiom>(na, axiom);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDataSubPropertyAxiom axiom) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDeclarationAxiom axiom) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDifferentIndividualsAxiom axiom) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDisjointClassesAxiom axiom) {
            if (axiom.getDescriptions().size() > 2) {
                return new DisjointClassAxiomNotAllowed(axiom);
            }
            for (OWLDescription desc : axiom.getDescriptions()) {
                ConstructNotAllowed na = desc.accept(this);
                if (na == null) continue;
                return new AxiomNotAllowed<OWLDisjointClassesAxiom>(na, axiom);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDisjointDataPropertiesAxiom axiom) {
            return new OWL2AxiomNotAllowed(axiom, false);
        }

        @Override
        public ConstructNotAllowed visit(OWLDisjointObjectPropertiesAxiom axiom) {
            return new OWL2AxiomNotAllowed(axiom, false);
        }

        @Override
        public ConstructNotAllowed visit(OWLDisjointUnionAxiom axiom) {
            return new OWL2AxiomNotAllowed(axiom, true);
        }

        @Override
        public ConstructNotAllowed visit(OWLEntityAnnotationAxiom axiom) {
            ConstructNotAllowed na = axiom.getAnnotation().accept(this);
            if (na != null) {
                return new AxiomNotAllowed<OWLEntityAnnotationAxiom>(na, axiom);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLEquivalentClassesAxiom axiom) {
            for (OWLDescription desc : axiom.getDescriptions()) {
                ConstructNotAllowed na = desc.accept(this);
                if (na == null) continue;
                return new AxiomNotAllowed<OWLEquivalentClassesAxiom>(na, axiom);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLEquivalentDataPropertiesAxiom axiom) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLFunctionalDataPropertyAxiom axiom) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLFunctionalObjectPropertyAxiom axiom) {
            if (OWLDLProfile.this.propertyManager.isNonSimple((OWLObjectPropertyExpression)axiom.getProperty())) {
                return new NonSimplePropertiesNotAllowedInFunctionalPropertyAxioms(axiom);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLImportsDeclaration axiom) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLInverseObjectPropertiesAxiom axiom) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            return new OWL2AxiomNotAllowed(axiom, false);
        }

        @Override
        public ConstructNotAllowed visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            return new OWL2AxiomNotAllowed(axiom, true);
        }

        @Override
        public ConstructNotAllowed visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            return new OWL2AxiomNotAllowed(axiom, true);
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectPropertyAssertionAxiom axiom) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
            return new OWL2AxiomNotAllowed(axiom, false);
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectPropertyDomainAxiom axiom) {
            ConstructNotAllowed na = axiom.getDomain().accept(this);
            if (na != null) {
                return new AxiomNotAllowed<OWLObjectPropertyDomainAxiom>(na, axiom);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectPropertyRangeAxiom axiom) {
            ConstructNotAllowed na = ((OWLDescription)axiom.getRange()).accept(this);
            if (na != null) {
                return new AxiomNotAllowed<OWLObjectPropertyRangeAxiom>(na, axiom);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectSubPropertyAxiom axiom) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLOntologyAnnotationAxiom axiom) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLReflexiveObjectPropertyAxiom axiom) {
            return new OWL2AxiomNotAllowed(axiom, false);
        }

        @Override
        public ConstructNotAllowed visit(OWLSameIndividualsAxiom axiom) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLSubClassAxiom axiom) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLSymmetricObjectPropertyAxiom axiom) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLTransitiveObjectPropertyAxiom axiom) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(SWRLRule rule) {
            for (SWRLAtom sWRLAtom : rule.getBody()) {
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLClass desc) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDataAllRestriction desc) {
            ConstructNotAllowed na = ((OWLDataRange)desc.getFiller()).accept(this);
            if (na != null) {
                return new DescriptionNotAllowed(na, (OWLDescription)desc);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDataExactCardinalityRestriction desc) {
            if (desc.isQualified()) {
                return new QCRsNotAllowed((OWLDescription)desc);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDataMaxCardinalityRestriction desc) {
            if (desc.isQualified()) {
                return new QCRsNotAllowed((OWLDescription)desc);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDataMinCardinalityRestriction desc) {
            if (desc.isQualified()) {
                return new QCRsNotAllowed((OWLDescription)desc);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDataSomeRestriction desc) {
            ConstructNotAllowed na = ((OWLDataRange)desc.getFiller()).accept(this);
            if (na != null) {
                return new DescriptionNotAllowed(na, (OWLDescription)desc);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDataValueRestriction desc) {
            ConstructNotAllowed na = ((OWLConstant)desc.getValue()).accept(this);
            if (na != null) {
                return new DescriptionNotAllowed(na, (OWLDescription)desc);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectAllRestriction desc) {
            ConstructNotAllowed na = ((OWLDescription)desc.getFiller()).accept(this);
            if (na != null) {
                return new DescriptionNotAllowed(na, (OWLDescription)desc);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectComplementOf desc) {
            ConstructNotAllowed na = desc.getOperand().accept(this);
            if (na != null) {
                return new DescriptionNotAllowed(na, (OWLDescription)desc);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectExactCardinalityRestriction desc) {
            if (desc.isQualified()) {
                return new QCRsNotAllowed((OWLDescription)desc);
            }
            if (OWLDLProfile.this.propertyManager.isNonSimple((OWLObjectPropertyExpression)desc.getProperty())) {
                return new NonSimplePropertiesNotAllowedInCardinalityRestrictions(desc);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectIntersectionOf desc) {
            for (OWLDescription op : desc.getOperands()) {
                ConstructNotAllowed na = op.accept(this);
                if (na == null) continue;
                return new DescriptionNotAllowed(na, (OWLDescription)desc);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectMaxCardinalityRestriction desc) {
            if (desc.isQualified()) {
                return new QCRsNotAllowed((OWLDescription)desc);
            }
            if (OWLDLProfile.this.propertyManager.isNonSimple((OWLObjectPropertyExpression)desc.getProperty())) {
                return new NonSimplePropertiesNotAllowedInCardinalityRestrictions(desc);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectMinCardinalityRestriction desc) {
            if (desc.isQualified()) {
                return new QCRsNotAllowed((OWLDescription)desc);
            }
            if (OWLDLProfile.this.propertyManager.isNonSimple((OWLObjectPropertyExpression)desc.getProperty())) {
                return new NonSimplePropertiesNotAllowedInCardinalityRestrictions(desc);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectOneOf desc) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectSelfRestriction desc) {
            return new SelfRestrictionsNotAllowed((OWLDescription)desc);
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectSomeRestriction desc) {
            ConstructNotAllowed na = ((OWLDescription)desc.getFiller()).accept(this);
            if (na != null) {
                return new DescriptionNotAllowed(na, (OWLDescription)desc);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectUnionOf desc) {
            for (OWLDescription op : desc.getOperands()) {
                ConstructNotAllowed na = op.accept(this);
                if (na == null) continue;
                return new DescriptionNotAllowed(na, (OWLDescription)desc);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectValueRestriction desc) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDataComplementOf node) {
            ConstructNotAllowed na = node.getDataRange().accept(this);
            if (na != null) {
                return new DataRangeNotAllowed(na, (OWLDataRange)node);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDataOneOf node) {
            for (OWLConstant op : node.getValues()) {
                ConstructNotAllowed na = op.accept(this);
                if (na == null) continue;
                return new DataRangeNotAllowed(na, (OWLDataRange)node);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDataRangeFacetRestriction node) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDataRangeRestriction node) {
            return new OWL2DataRangeNotAllowed((OWLDataRange)node);
        }

        @Override
        public ConstructNotAllowed visit(OWLDataType node) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLTypedConstant node) {
            ConstructNotAllowed na = node.getDataType().accept(this);
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLUntypedConstant node) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDataProperty property) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectProperty property) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectPropertyInverse property) {
            return new PropertyInversesNotAllowed(property);
        }

        @Override
        public ConstructNotAllowed visit(OWLIndividual individual) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLConstantAnnotation annotation) {
            ConstructNotAllowed na = ((OWLConstant)annotation.getAnnotationValue()).accept(this);
            if (na == null) {
                return null;
            }
            return new AnnotationValueNotAllowed(na, annotation);
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectAnnotation annotation) {
            ConstructNotAllowed na = ((OWLIndividual)annotation.getAnnotationValue()).accept(this);
            if (na == null) {
                return null;
            }
            return new AnnotationValueNotAllowed(na, annotation);
        }

        @Override
        public ConstructNotAllowed visit(SWRLAtomConstantObject node) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(SWRLAtomDVariable node) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(SWRLAtomIndividualObject node) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(SWRLAtomIVariable node) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(SWRLBuiltInAtom node) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(SWRLClassAtom node) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(SWRLDataRangeAtom node) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(SWRLDataValuedPropertyAtom node) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(SWRLDifferentFromAtom node) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(SWRLObjectPropertyAtom node) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(SWRLSameAsAtom node) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLOntology ontology) {
            return null;
        }
    }
}

