/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectAnnotation;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.model.SWRLAtomConstantObject;
import org.semanticweb.owl.model.SWRLAtomDObject;
import org.semanticweb.owl.model.SWRLAtomDVariable;
import org.semanticweb.owl.model.SWRLAtomIObject;
import org.semanticweb.owl.model.SWRLAtomIVariable;
import org.semanticweb.owl.model.SWRLAtomIndividualObject;
import org.semanticweb.owl.model.SWRLBuiltInAtom;
import org.semanticweb.owl.model.SWRLClassAtom;
import org.semanticweb.owl.model.SWRLDataRangeAtom;
import org.semanticweb.owl.model.SWRLDataValuedPropertyAtom;
import org.semanticweb.owl.model.SWRLDifferentFromAtom;
import org.semanticweb.owl.model.SWRLObjectPropertyAtom;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.model.SWRLSameAsAtom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLObjectComponentCollector
implements OWLObjectVisitor {
    private Set<OWLObject> result = new HashSet<OWLObject>();

    public Set<OWLObject> getComponents(OWLObject object) {
        this.result.clear();
        object.accept(this);
        return new HashSet<OWLObject>(this.result);
    }

    public Set<OWLObject> getResult() {
        return Collections.unmodifiableSet(this.result);
    }

    private void process(Set<? extends OWLObject> objects) {
        for (OWLObject oWLObject : objects) {
            oWLObject.accept(this);
        }
    }

    protected void handleObject(OWLObject obj) {
        this.result.add(obj);
    }

    @Override
    public void visit(OWLOntology ontology) {
        this.process(ontology.getAxioms());
    }

    @Override
    public void visit(OWLClass cls) {
        this.handleObject(cls);
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.handleObject(property);
    }

    @Override
    public void visit(OWLObjectPropertyInverse property) {
        this.handleObject(property);
        property.getInverse().accept(this);
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.handleObject(property);
    }

    @Override
    public void visit(OWLIndividual individual) {
        this.handleObject(individual);
    }

    @Override
    public void visit(OWLDataType dataType) {
        this.handleObject(dataType);
    }

    @Override
    public void visit(OWLObjectIntersectionOf desc) {
        this.handleObject(desc);
        for (OWLDescription op : desc.getOperands()) {
            op.accept(this);
        }
    }

    @Override
    public void visit(OWLObjectUnionOf desc) {
        this.handleObject(desc);
        this.process(desc.getOperands());
    }

    @Override
    public void visit(OWLObjectComplementOf desc) {
        this.handleObject(desc);
        desc.getOperand().accept(this);
    }

    @Override
    public void visit(OWLObjectSomeRestriction desc) {
        this.handleObject(desc);
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLDescription)desc.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLObjectAllRestriction desc) {
        this.handleObject(desc);
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLDescription)desc.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLObjectValueRestriction desc) {
        this.handleObject(desc);
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLIndividual)desc.getValue()).accept(this);
    }

    @Override
    public void visit(OWLObjectMinCardinalityRestriction desc) {
        this.handleObject(desc);
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLDescription)desc.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLObjectExactCardinalityRestriction desc) {
        this.handleObject(desc);
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLDescription)desc.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLObjectMaxCardinalityRestriction desc) {
        this.handleObject(desc);
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLDescription)desc.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLObjectSelfRestriction desc) {
        this.handleObject(desc);
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLObjectOneOf desc) {
        this.handleObject(desc);
        this.process(desc.getIndividuals());
    }

    @Override
    public void visit(OWLDataSomeRestriction desc) {
        this.handleObject(desc);
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataAllRestriction desc) {
        this.handleObject(desc);
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataValueRestriction desc) {
        this.handleObject(desc);
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataMinCardinalityRestriction desc) {
        this.handleObject(desc);
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataExactCardinalityRestriction desc) {
        this.handleObject(desc);
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataMaxCardinalityRestriction desc) {
        this.handleObject(desc);
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLSubClassAxiom axiom) {
        this.handleObject(axiom);
        axiom.getSubClass().accept(this);
        axiom.getSuperClass().accept(this);
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.handleObject(axiom);
        axiom.getSubject().accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLIndividual)axiom.getObject()).accept(this);
    }

    @Override
    public void visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
        this.handleObject(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.handleObject(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        this.handleObject(axiom);
        this.process(axiom.getDescriptions());
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.handleObject(axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLImportsDeclaration axiom) {
        this.handleObject(axiom);
    }

    @Override
    public void visit(OWLAxiomAnnotationAxiom axiom) {
        this.handleObject(axiom);
        ((OWLAxiom)axiom.getSubject()).accept(this);
        axiom.getAnnotation().accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.handleObject(axiom);
        axiom.getDomain().accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.handleObject(axiom);
        this.process(axiom.getProperties());
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.handleObject(axiom);
        axiom.getSubject().accept(this);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLConstant)axiom.getObject()).accept(this);
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.handleObject(axiom);
        this.process(axiom.getIndividuals());
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.handleObject(axiom);
        this.process(axiom.getProperties());
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.handleObject(axiom);
        this.process(axiom.getProperties());
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.handleObject(axiom);
        ((OWLDescription)axiom.getRange()).accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.handleObject(axiom);
        axiom.getSubject().accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLIndividual)axiom.getObject()).accept(this);
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.handleObject(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLObjectSubPropertyAxiom axiom) {
        this.handleObject(axiom);
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        this.handleObject(axiom);
        axiom.getOWLClass().accept(this);
        this.process(axiom.getDescriptions());
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
        this.handleObject(axiom);
        axiom.getEntity().accept(this);
    }

    @Override
    public void visit(OWLEntityAnnotationAxiom axiom) {
        this.handleObject(axiom);
        ((OWLEntity)axiom.getSubject()).accept(this);
        axiom.getAnnotation().accept(this);
    }

    @Override
    public void visit(OWLOntologyAnnotationAxiom axiom) {
        this.handleObject(axiom);
        axiom.getAnnotation().accept(this);
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.handleObject(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.handleObject(axiom);
        ((OWLDataRange)axiom.getRange()).accept(this);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.handleObject(axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.handleObject(axiom);
        this.process(axiom.getProperties());
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        this.handleObject(axiom);
        axiom.getDescription().accept(this);
        axiom.getIndividual().accept(this);
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.handleObject(axiom);
        this.process(axiom.getDescriptions());
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.handleObject(axiom);
        axiom.getSubject().accept(this);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLConstant)axiom.getObject()).accept(this);
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.handleObject(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.handleObject(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataSubPropertyAxiom axiom) {
        this.handleObject(axiom);
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept(this);
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.handleObject(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLSameIndividualsAxiom axiom) {
        this.handleObject(axiom);
        this.process(axiom.getIndividuals());
    }

    @Override
    public void visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
        this.handleObject(axiom);
        for (OWLObjectPropertyExpression prop : axiom.getPropertyChain()) {
            prop.accept(this);
        }
        axiom.getSuperProperty().accept(this);
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.handleObject(axiom);
        this.process(axiom.getProperties());
    }

    @Override
    public void visit(SWRLRule node) {
        this.handleObject(node);
        this.process(node.getBody());
        this.process(node.getHead());
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        this.handleObject(node);
        node.getDataRange().accept(this);
    }

    @Override
    public void visit(OWLDataOneOf node) {
        this.handleObject(node);
        this.process(node.getValues());
    }

    @Override
    public void visit(OWLDataRangeRestriction node) {
        this.handleObject(node);
        node.getDataRange().accept(this);
        this.process(node.getFacetRestrictions());
    }

    @Override
    public void visit(OWLTypedConstant node) {
        this.handleObject(node);
        node.getDataType().accept(this);
    }

    @Override
    public void visit(OWLUntypedConstant node) {
        this.handleObject(node);
    }

    @Override
    public void visit(OWLDataRangeFacetRestriction node) {
        this.handleObject(node);
        node.getFacetValue().accept(this);
    }

    @Override
    public void visit(OWLObjectAnnotation node) {
        this.handleObject(node);
        ((OWLIndividual)node.getAnnotationValue()).accept(this);
    }

    @Override
    public void visit(OWLConstantAnnotation node) {
        this.handleObject(node);
        ((OWLConstant)node.getAnnotationValue()).accept(this);
    }

    @Override
    public void visit(SWRLClassAtom node) {
        this.handleObject(node);
        ((OWLDescription)node.getPredicate()).accept(this);
        ((SWRLAtomIObject)node.getArgument()).accept(this);
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
        this.handleObject(node);
        ((OWLDataRange)node.getPredicate()).accept(this);
        ((SWRLAtomDObject)node.getArgument()).accept(this);
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
        this.handleObject(node);
        ((OWLObjectPropertyExpression)node.getPredicate()).accept(this);
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
        ((SWRLAtomIObject)node.getSecondArgument()).accept(this);
    }

    @Override
    public void visit(SWRLDataValuedPropertyAtom node) {
        this.handleObject(node);
        ((OWLDataPropertyExpression)node.getPredicate()).accept(this);
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
        ((SWRLAtomDObject)node.getSecondArgument()).accept(this);
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
        this.handleObject(node);
        for (SWRLAtomDObject obj : node.getArguments()) {
            obj.accept(this);
        }
    }

    @Override
    public void visit(SWRLAtomDVariable node) {
        this.handleObject(node);
    }

    @Override
    public void visit(SWRLAtomIVariable node) {
        this.handleObject(node);
    }

    @Override
    public void visit(SWRLAtomIndividualObject node) {
        this.handleObject(node);
        node.getIndividual().accept(this);
    }

    @Override
    public void visit(SWRLAtomConstantObject node) {
        this.handleObject(node);
        node.getConstant().accept(this);
    }

    @Override
    public void visit(SWRLSameAsAtom node) {
        this.handleObject(node);
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
        ((SWRLAtomIObject)node.getSecondArgument()).accept(this);
    }

    @Override
    public void visit(SWRLDifferentFromAtom node) {
        this.handleObject(node);
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
        ((SWRLAtomIObject)node.getSecondArgument()).accept(this);
    }
}

