/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Set;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLOntologySetProvider;
import org.semanticweb.owl.util.OWLAxiomFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLOntologyMerger
implements OWLAxiomFilter {
    private OWLOntologySetProvider setProvider;
    private OWLAxiomFilter axiomFilter;
    private boolean mergeOnlyLogicalAxioms;

    public OWLOntologyMerger(OWLOntologySetProvider setProvider) {
        this.setProvider = setProvider;
        this.axiomFilter = this;
    }

    public OWLOntologyMerger(OWLOntologySetProvider setProvider, boolean mergeOnlyLogicalAxioms) {
        this.setProvider = setProvider;
        this.mergeOnlyLogicalAxioms = mergeOnlyLogicalAxioms;
        this.axiomFilter = this;
    }

    public OWLOntologyMerger(OWLOntologySetProvider setProvider, OWLAxiomFilter axiomFilter) {
        this.setProvider = setProvider;
        this.axiomFilter = axiomFilter;
    }

    public OWLOntology createMergedOntology(OWLOntologyManager ontologyManager, URI ontologyURI) throws OWLOntologyCreationException, OWLOntologyChangeException {
        OWLOntology ontology = ontologyManager.createOntology(ontologyURI);
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLOntology ont : this.setProvider.getOntologies()) {
            for (OWLAxiom oWLAxiom : this.getAxioms(ont)) {
                if (!this.axiomFilter.passes(oWLAxiom)) continue;
                changes.add(new AddAxiom(ontology, oWLAxiom));
            }
        }
        ontologyManager.applyChanges(changes);
        return ontology;
    }

    private Set<? extends OWLAxiom> getAxioms(OWLOntology ont) {
        if (this.mergeOnlyLogicalAxioms) {
            return ont.getLogicalAxioms();
        }
        return ont.getAxioms();
    }

    @Override
    public boolean passes(OWLAxiom axiom) {
        return true;
    }
}

