/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.RemoveAxiom;
import org.semanticweb.owl.model.SetOntologyURI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLOntologyURIChanger {
    private OWLOntologyManager owlOntologyManager;

    public OWLOntologyURIChanger(OWLOntologyManager owlOntologyManager) {
        this.owlOntologyManager = owlOntologyManager;
    }

    public List<OWLOntologyChange> getChanges(OWLOntology ontology, URI newURI) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        changes.add(new SetOntologyURI(ontology, newURI));
        for (OWLOntology ont : this.owlOntologyManager.getOntologies()) {
            for (OWLImportsDeclaration decl : ont.getImportsDeclarations()) {
                if (!decl.getImportedOntologyURI().equals(ontology.getURI())) continue;
                changes.add(new RemoveAxiom(ont, decl));
                changes.add(new AddAxiom(ont, this.owlOntologyManager.getOWLDataFactory().getOWLImportsDeclarationAxiom(ontology, newURI)));
            }
        }
        return changes;
    }
}

