/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.inference.OWLReasoner;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.inference.UndefinedEntityException;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.util.OWLEntityCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLReasonerMediator
implements OWLReasoner {
    public static final boolean SILENT_UNDEFINED_ENTITY_HANDLING_DEFAULT_VALUE = false;
    private OWLReasoner kernel;
    private boolean silentUndefinedEntityHandling;
    private boolean undefinedClassesSatisfiable;
    private boolean entitiesDefined;
    private OWLEntityCollector collector = new OWLEntityCollector();

    public OWLReasonerMediator(OWLReasoner kernel) {
        this.kernel = kernel;
        this.silentUndefinedEntityHandling = false;
        this.undefinedClassesSatisfiable = true;
    }

    public OWLReasoner getKernel() {
        return this.kernel;
    }

    public boolean isSilentUndefinedEntityHandlingEnabled() {
        return this.silentUndefinedEntityHandling;
    }

    public void setSilentUndefinedEntityHandling(boolean silentUndefinedEntityHandling) {
        this.silentUndefinedEntityHandling = silentUndefinedEntityHandling;
    }

    public boolean isUndefinedClassesSatisfiable() {
        return this.undefinedClassesSatisfiable;
    }

    public void setUndefinedClassesSatisfiable(boolean b) {
        this.undefinedClassesSatisfiable = b;
    }

    public boolean checkDefined(OWLDescription description) throws OWLReasonerException {
        if (description.isAnonymous()) {
            this.collector.reset();
            description.accept(this.collector);
            for (OWLEntity entity : this.collector.getObjects()) {
                if (entity instanceof OWLClass) {
                    if (this.isDefined((OWLClass)entity)) continue;
                    this.processUndefinedEntity(entity);
                    return false;
                }
                if (entity instanceof OWLObjectProperty) {
                    if (this.isDefined((OWLObjectProperty)entity)) continue;
                    this.processUndefinedEntity(entity);
                    return false;
                }
                if (entity instanceof OWLDataProperty) {
                    if (this.isDefined((OWLDataProperty)entity)) continue;
                    this.processUndefinedEntity(entity);
                    return false;
                }
                if (!(entity instanceof OWLIndividual) || this.isDefined((OWLIndividual)entity)) continue;
                this.processUndefinedEntity(entity);
                return false;
            }
            return true;
        }
        if (this.isDefined(description.asOWLClass())) {
            return true;
        }
        this.processUndefinedEntity(description.asOWLClass());
        return false;
    }

    public boolean checkDefined(OWLObjectPropertyExpression prop) throws OWLReasonerException {
        if (prop.isAnonymous()) {
            return true;
        }
        if (this.isDefined(prop.asOWLObjectProperty())) {
            return true;
        }
        this.processUndefinedEntity(prop.asOWLObjectProperty());
        return false;
    }

    public boolean checkDefined(OWLDataPropertyExpression prop) throws OWLReasonerException {
        if (this.isDefined((OWLDataProperty)prop)) {
            return true;
        }
        this.processUndefinedEntity((OWLDataProperty)prop);
        return false;
    }

    public boolean checkDefined(OWLIndividual individual) throws OWLReasonerException {
        if (this.isDefined(individual)) {
            return true;
        }
        this.processUndefinedEntity(individual);
        return false;
    }

    private void processUndefinedEntity(OWLEntity entity) throws OWLReasonerException {
        if (this.silentUndefinedEntityHandling) {
            return;
        }
        throw new UndefinedEntityException(entity);
    }

    @Override
    public boolean isConsistent(OWLOntology ontology) throws OWLReasonerException {
        return this.kernel.isConsistent(ontology);
    }

    @Override
    public void loadOntologies(Set<OWLOntology> ontologies) throws OWLReasonerException {
        this.kernel.loadOntologies(ontologies);
    }

    @Override
    public boolean isClassified() throws OWLReasonerException {
        return this.kernel.isClassified();
    }

    @Override
    public void classify() throws OWLReasonerException {
        this.kernel.classify();
    }

    @Override
    public boolean isRealised() throws OWLReasonerException {
        return this.kernel.isRealised();
    }

    @Override
    public void realise() throws OWLReasonerException {
        this.kernel.realise();
    }

    @Override
    public boolean isDefined(OWLClass cls) throws OWLReasonerException {
        return this.kernel.isDefined(cls);
    }

    @Override
    public boolean isDefined(OWLObjectProperty prop) throws OWLReasonerException {
        return this.kernel.isDefined(prop);
    }

    @Override
    public boolean isDefined(OWLDataProperty prop) throws OWLReasonerException {
        return this.kernel.isDefined(prop);
    }

    @Override
    public boolean isDefined(OWLIndividual ind) throws OWLReasonerException {
        return this.kernel.isDefined(ind);
    }

    @Override
    public Set<OWLOntology> getLoadedOntologies() {
        return this.kernel.getLoadedOntologies();
    }

    @Override
    public void unloadOntologies(Set<OWLOntology> ontologies) throws OWLReasonerException {
        this.kernel.unloadOntologies(ontologies);
    }

    @Override
    public void clearOntologies() throws OWLReasonerException {
        this.kernel.clearOntologies();
    }

    @Override
    public void dispose() throws OWLReasonerException {
        this.kernel.dispose();
    }

    @Override
    public boolean isSubClassOf(OWLDescription clsC, OWLDescription clsD) throws OWLReasonerException {
        if (!this.checkDefined(clsC)) {
            return false;
        }
        if (!this.checkDefined(clsD)) {
            return false;
        }
        return this.kernel.isSubClassOf(clsC, clsD);
    }

    @Override
    public boolean isEquivalentClass(OWLDescription clsC, OWLDescription clsD) throws OWLReasonerException {
        if (!this.checkDefined(clsC)) {
            return false;
        }
        if (!this.checkDefined(clsD)) {
            return false;
        }
        return this.kernel.isEquivalentClass(clsC, clsD);
    }

    @Override
    public Set<Set<OWLClass>> getSuperClasses(OWLDescription clsC) throws OWLReasonerException {
        if (!this.checkDefined(clsC)) {
            return Collections.emptySet();
        }
        return this.kernel.getSuperClasses(clsC);
    }

    @Override
    public Set<Set<OWLClass>> getAncestorClasses(OWLDescription clsC) throws OWLReasonerException {
        if (!this.checkDefined(clsC)) {
            return Collections.emptySet();
        }
        return this.kernel.getAncestorClasses(clsC);
    }

    @Override
    public Set<Set<OWLClass>> getSubClasses(OWLDescription clsC) throws OWLReasonerException {
        if (!this.checkDefined(clsC)) {
            return Collections.emptySet();
        }
        return this.kernel.getSubClasses(clsC);
    }

    @Override
    public Set<Set<OWLClass>> getDescendantClasses(OWLDescription clsC) throws OWLReasonerException {
        if (!this.checkDefined(clsC)) {
            return Collections.emptySet();
        }
        return this.kernel.getDescendantClasses(clsC);
    }

    @Override
    public Set<OWLClass> getEquivalentClasses(OWLDescription clsC) throws OWLReasonerException {
        if (!this.checkDefined(clsC)) {
            return Collections.emptySet();
        }
        return this.kernel.getEquivalentClasses(clsC);
    }

    @Override
    public Set<OWLClass> getInconsistentClasses() throws OWLReasonerException {
        return this.kernel.getInconsistentClasses();
    }

    @Override
    public boolean isSatisfiable(OWLDescription description) throws OWLReasonerException {
        if (!this.checkDefined(description)) {
            return this.undefinedClassesSatisfiable;
        }
        return this.kernel.isSatisfiable(description);
    }

    @Override
    public Set<Set<OWLClass>> getTypes(OWLIndividual individual, boolean direct) throws OWLReasonerException {
        if (!this.checkDefined(individual)) {
            return Collections.emptySet();
        }
        return this.kernel.getTypes(individual, direct);
    }

    @Override
    public Set<OWLIndividual> getIndividuals(OWLDescription clsC, boolean direct) throws OWLReasonerException {
        if (!this.checkDefined(clsC)) {
            return Collections.emptySet();
        }
        return this.kernel.getIndividuals(clsC, direct);
    }

    @Override
    public Map<OWLObjectProperty, Set<OWLIndividual>> getObjectPropertyRelationships(OWLIndividual individual) throws OWLReasonerException {
        if (!this.checkDefined(individual)) {
            return Collections.emptyMap();
        }
        return this.kernel.getObjectPropertyRelationships(individual);
    }

    @Override
    public Map<OWLDataProperty, Set<OWLConstant>> getDataPropertyRelationships(OWLIndividual individual) throws OWLReasonerException {
        if (!this.checkDefined(individual)) {
            return Collections.emptyMap();
        }
        return this.kernel.getDataPropertyRelationships(individual);
    }

    @Override
    public boolean hasType(OWLIndividual individual, OWLDescription type, boolean direct) throws OWLReasonerException {
        if (!this.checkDefined(individual)) {
            return false;
        }
        if (!this.checkDefined(type)) {
            return false;
        }
        return this.kernel.hasType(individual, type, direct);
    }

    @Override
    public boolean hasObjectPropertyRelationship(OWLIndividual subject, OWLObjectPropertyExpression property, OWLIndividual object) throws OWLReasonerException {
        if (!this.checkDefined(subject)) {
            return false;
        }
        if (!this.checkDefined(property)) {
            return false;
        }
        if (!this.checkDefined(object)) {
            return false;
        }
        return this.kernel.hasObjectPropertyRelationship(subject, property, object);
    }

    @Override
    public boolean hasDataPropertyRelationship(OWLIndividual subject, OWLDataPropertyExpression property, OWLConstant object) throws OWLReasonerException {
        if (!this.checkDefined(subject)) {
            return false;
        }
        if (!this.checkDefined(property)) {
            return false;
        }
        return this.kernel.hasDataPropertyRelationship(subject, property, object);
    }

    @Override
    public Set<OWLIndividual> getRelatedIndividuals(OWLIndividual subject, OWLObjectPropertyExpression property) throws OWLReasonerException {
        if (!this.checkDefined(subject)) {
            return Collections.emptySet();
        }
        if (!this.checkDefined(property)) {
            return Collections.emptySet();
        }
        return this.kernel.getRelatedIndividuals(subject, property);
    }

    @Override
    public Set<OWLConstant> getRelatedValues(OWLIndividual subject, OWLDataPropertyExpression property) throws OWLReasonerException {
        if (!this.checkDefined(subject)) {
            return Collections.emptySet();
        }
        if (!this.checkDefined(property)) {
            return Collections.emptySet();
        }
        return this.kernel.getRelatedValues(subject, property);
    }

    @Override
    public Set<Set<OWLObjectProperty>> getSuperProperties(OWLObjectProperty property) throws OWLReasonerException {
        if (!this.checkDefined(property)) {
            return Collections.emptySet();
        }
        return this.kernel.getSuperProperties(property);
    }

    @Override
    public Set<Set<OWLObjectProperty>> getSubProperties(OWLObjectProperty property) throws OWLReasonerException {
        if (!this.checkDefined(property)) {
            return Collections.emptySet();
        }
        return this.kernel.getSubProperties(property);
    }

    @Override
    public Set<Set<OWLObjectProperty>> getAncestorProperties(OWLObjectProperty property) throws OWLReasonerException {
        if (!this.checkDefined(property)) {
            return Collections.emptySet();
        }
        return this.kernel.getAncestorProperties(property);
    }

    @Override
    public Set<Set<OWLObjectProperty>> getDescendantProperties(OWLObjectProperty property) throws OWLReasonerException {
        if (!this.checkDefined(property)) {
            return Collections.emptySet();
        }
        return this.kernel.getDescendantProperties(property);
    }

    @Override
    public Set<Set<OWLObjectProperty>> getInverseProperties(OWLObjectProperty property) throws OWLReasonerException {
        if (!this.checkDefined(property)) {
            return Collections.emptySet();
        }
        return this.kernel.getInverseProperties(property);
    }

    @Override
    public Set<OWLObjectProperty> getEquivalentProperties(OWLObjectProperty property) throws OWLReasonerException {
        if (!this.checkDefined(property)) {
            return Collections.emptySet();
        }
        return this.kernel.getEquivalentProperties(property);
    }

    @Override
    public Set<Set<OWLDescription>> getDomains(OWLObjectProperty property) throws OWLReasonerException {
        if (!this.checkDefined(property)) {
            return Collections.emptySet();
        }
        return this.kernel.getDomains(property);
    }

    @Override
    public Set<OWLDescription> getRanges(OWLObjectProperty property) throws OWLReasonerException {
        if (!this.checkDefined(property)) {
            return Collections.emptySet();
        }
        return this.kernel.getRanges(property);
    }

    @Override
    public boolean isFunctional(OWLObjectProperty property) throws OWLReasonerException {
        if (!this.checkDefined(property)) {
            return false;
        }
        return this.kernel.isFunctional(property);
    }

    @Override
    public boolean isInverseFunctional(OWLObjectProperty property) throws OWLReasonerException {
        if (!this.checkDefined(property)) {
            return false;
        }
        return this.kernel.isInverseFunctional(property);
    }

    @Override
    public boolean isSymmetric(OWLObjectProperty property) throws OWLReasonerException {
        if (!this.checkDefined(property)) {
            return false;
        }
        return this.kernel.isSymmetric(property);
    }

    @Override
    public boolean isTransitive(OWLObjectProperty property) throws OWLReasonerException {
        if (!this.checkDefined(property)) {
            return false;
        }
        return this.kernel.isTransitive(property);
    }

    @Override
    public boolean isReflexive(OWLObjectProperty property) throws OWLReasonerException {
        if (!this.checkDefined(property)) {
            return false;
        }
        return this.kernel.isReflexive(property);
    }

    @Override
    public boolean isIrreflexive(OWLObjectProperty property) throws OWLReasonerException {
        if (!this.checkDefined(property)) {
            return false;
        }
        return this.kernel.isIrreflexive(property);
    }

    @Override
    public boolean isAntiSymmetric(OWLObjectProperty property) throws OWLReasonerException {
        if (!this.checkDefined(property)) {
            return false;
        }
        return this.kernel.isAntiSymmetric(property);
    }

    @Override
    public Set<Set<OWLDataProperty>> getSuperProperties(OWLDataProperty property) throws OWLReasonerException {
        if (!this.checkDefined(property)) {
            return Collections.emptySet();
        }
        return this.kernel.getSuperProperties(property);
    }

    @Override
    public Set<Set<OWLDataProperty>> getSubProperties(OWLDataProperty property) throws OWLReasonerException {
        if (!this.checkDefined(property)) {
            return Collections.emptySet();
        }
        return this.kernel.getSubProperties(property);
    }

    @Override
    public Set<Set<OWLDataProperty>> getAncestorProperties(OWLDataProperty property) throws OWLReasonerException {
        if (!this.checkDefined(property)) {
            return Collections.emptySet();
        }
        return this.kernel.getAncestorProperties(property);
    }

    @Override
    public Set<Set<OWLDataProperty>> getDescendantProperties(OWLDataProperty property) throws OWLReasonerException {
        if (!this.checkDefined(property)) {
            return Collections.emptySet();
        }
        return this.kernel.getDescendantProperties(property);
    }

    @Override
    public Set<OWLDataProperty> getEquivalentProperties(OWLDataProperty property) throws OWLReasonerException {
        if (!this.checkDefined(property)) {
            return Collections.emptySet();
        }
        return this.kernel.getEquivalentProperties(property);
    }

    @Override
    public Set<Set<OWLDescription>> getDomains(OWLDataProperty property) throws OWLReasonerException {
        if (!this.checkDefined(property)) {
            return Collections.emptySet();
        }
        return this.kernel.getDomains(property);
    }

    @Override
    public Set<OWLDataRange> getRanges(OWLDataProperty property) throws OWLReasonerException {
        if (!this.checkDefined(property)) {
            return Collections.emptySet();
        }
        return this.kernel.getRanges(property);
    }

    @Override
    public boolean isFunctional(OWLDataProperty property) throws OWLReasonerException {
        if (!this.checkDefined(property)) {
            return false;
        }
        return this.kernel.isFunctional(property);
    }

    public String toString() {
        return this.kernel.toString();
    }
}

