/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLPropertyExpressionVisitor;

public class ObjectPropertySimplifier {
    private OWLDataFactory dataFactory;
    private Simplifier simplifier;

    public ObjectPropertySimplifier(OWLDataFactory dataFactory) {
        this.dataFactory = dataFactory;
        this.simplifier = new Simplifier();
    }

    public OWLObjectPropertyExpression getSimplified(OWLObjectPropertyExpression prop) {
        this.simplifier.reset();
        prop.accept(this.simplifier);
        if (this.simplifier.isInverse()) {
            return this.dataFactory.getOWLObjectPropertyInverse(this.simplifier.getProperty());
        }
        return this.simplifier.getProperty();
    }

    private static class Simplifier
    implements OWLPropertyExpressionVisitor {
        private OWLObjectProperty property;
        private int depth;

        private Simplifier() {
        }

        public void reset() {
            this.depth = 0;
            this.property = null;
        }

        public OWLObjectProperty getProperty() {
            return this.property;
        }

        public int getDepth() {
            return this.depth;
        }

        public boolean isInverse() {
            return this.depth % 2 != 0;
        }

        public void visit(OWLObjectProperty property) {
            this.property = property;
        }

        public void visit(OWLObjectPropertyInverse property) {
            ++this.depth;
            property.getInverse().accept(this);
        }

        public void visit(OWLDataProperty property) {
        }
    }
}

