/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.model.OWLAnnotationAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLEntityVisitor;
import org.semanticweb.owl.model.OWLEntityVisitorEx;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLNamedObjectVisitor;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLObjectVisitorEx;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLProperty;
import org.semanticweb.owl.model.OWLRuntimeException;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import uk.ac.manchester.cs.owl.ImplUtils;
import uk.ac.manchester.cs.owl.OWLObjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLIndividualImpl
extends OWLObjectImpl
implements OWLIndividual {
    private boolean anon;
    protected URI uri;

    protected OWLIndividualImpl(OWLDataFactory dataFactory, URI uri, boolean anon) {
        super(dataFactory);
        this.uri = uri;
        this.anon = anon;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public boolean isAnonymous() {
        return this.anon;
    }

    @Override
    public Set<OWLDescription> getTypes(OWLOntology ontology) {
        TreeSet<OWLDescription> result = new TreeSet<OWLDescription>();
        for (OWLClassAssertionAxiom axiom : ontology.getClassAssertionAxioms(this)) {
            result.add(axiom.getDescription());
        }
        return result;
    }

    @Override
    public Set<OWLDescription> getTypes(Set<OWLOntology> ontologies) {
        TreeSet<OWLDescription> result = new TreeSet<OWLDescription>();
        for (OWLOntology ont : ontologies) {
            result.addAll(this.getTypes(ont));
        }
        return result;
    }

    public Map<OWLProperty, Set<OWLObject>> getPropertyValues(OWLOntology ontology) {
        HashMap<OWLProperty, Set<OWLObject>> results = new HashMap<OWLProperty, Set<OWLObject>>();
        Map<OWLObjectPropertyExpression, Set<OWLIndividual>> opMap = this.getObjectPropertyValues(ontology);
        for (OWLObjectPropertyExpression prop : opMap.keySet()) {
            results.put((OWLProperty)((Object)prop), new HashSet(opMap.get(prop)));
        }
        Map<OWLDataPropertyExpression, Set<OWLConstant>> dpMap = this.getDataPropertyValues(ontology);
        for (OWLDataPropertyExpression prop : dpMap.keySet()) {
            results.put((OWLProperty)((Object)prop), new HashSet(dpMap.get(prop)));
        }
        return results;
    }

    public Map<OWLProperty, Set<OWLObject>> getNPropertyValues(OWLOntology ontology) {
        HashMap<OWLProperty, Set<OWLObject>> results = new HashMap<OWLProperty, Set<OWLObject>>();
        Map<OWLObjectPropertyExpression, Set<OWLIndividual>> opMap = this.getObjectPropertyValues(ontology);
        for (OWLObjectPropertyExpression prop : opMap.keySet()) {
            results.put((OWLProperty)((Object)prop), new HashSet(opMap.get(prop)));
        }
        Map<OWLDataPropertyExpression, Set<OWLConstant>> dpMap = this.getDataPropertyValues(ontology);
        for (OWLDataPropertyExpression prop : dpMap.keySet()) {
            results.put((OWLProperty)((Object)prop), new HashSet(dpMap.get(prop)));
        }
        return results;
    }

    @Override
    public Map<OWLObjectPropertyExpression, Set<OWLIndividual>> getObjectPropertyValues(OWLOntology ontology) {
        HashMap<OWLObjectPropertyExpression, Set<OWLIndividual>> result = new HashMap<OWLObjectPropertyExpression, Set<OWLIndividual>>();
        for (OWLObjectPropertyAssertionAxiom ax : ontology.getObjectPropertyAssertionAxioms(this)) {
            TreeSet inds = (TreeSet)result.get(ax.getProperty());
            if (inds == null) {
                inds = new TreeSet();
                result.put((OWLObjectPropertyExpression)ax.getProperty(), inds);
            }
            inds.add(ax.getObject());
        }
        return result;
    }

    @Override
    public Map<OWLObjectPropertyExpression, Set<OWLIndividual>> getNegativeObjectPropertyValues(OWLOntology ontology) {
        HashMap<OWLObjectPropertyExpression, Set<OWLIndividual>> result = new HashMap<OWLObjectPropertyExpression, Set<OWLIndividual>>();
        for (OWLNegativeObjectPropertyAssertionAxiom ax : ontology.getNegativeObjectPropertyAssertionAxioms(this)) {
            TreeSet inds = (TreeSet)result.get(ax.getProperty());
            if (inds == null) {
                inds = new TreeSet();
                result.put((OWLObjectPropertyExpression)ax.getProperty(), inds);
            }
            inds.add(ax.getObject());
        }
        return result;
    }

    @Override
    public Map<OWLDataPropertyExpression, Set<OWLConstant>> getDataPropertyValues(OWLOntology ontology) {
        HashMap<OWLDataPropertyExpression, Set<OWLConstant>> result = new HashMap<OWLDataPropertyExpression, Set<OWLConstant>>();
        for (OWLDataPropertyAssertionAxiom ax : ontology.getDataPropertyAssertionAxioms(this)) {
            TreeSet vals = (TreeSet)result.get(ax.getProperty());
            if (vals == null) {
                vals = new TreeSet();
                result.put((OWLDataPropertyExpression)ax.getProperty(), vals);
            }
            vals.add(ax.getObject());
        }
        return result;
    }

    @Override
    public Map<OWLDataPropertyExpression, Set<OWLConstant>> getNegativeDataPropertyValues(OWLOntology ontology) {
        HashMap<OWLDataPropertyExpression, Set<OWLConstant>> result = new HashMap<OWLDataPropertyExpression, Set<OWLConstant>>();
        for (OWLNegativeDataPropertyAssertionAxiom ax : ontology.getNegativeDataPropertyAssertionAxioms(this)) {
            TreeSet inds = (TreeSet)result.get(ax.getProperty());
            if (inds == null) {
                inds = new TreeSet();
                result.put((OWLDataPropertyExpression)ax.getProperty(), inds);
            }
            inds.add(ax.getObject());
        }
        return result;
    }

    @Override
    public Set<OWLAnnotation> getAnnotations(OWLOntology ontology) {
        return ImplUtils.getAnnotations(this, Collections.singleton(ontology));
    }

    @Override
    public Set<OWLAnnotationAxiom> getAnnotationAxioms(OWLOntology ontology) {
        return ImplUtils.getAnnotationAxioms(this, Collections.singleton(ontology));
    }

    @Override
    public Set<OWLAnnotation> getAnnotations(OWLOntology ontology, URI annotationURI) {
        return ImplUtils.getAnnotations(this, annotationURI, Collections.singleton(ontology));
    }

    public Set<OWLClassAssertionAxiom> getIndividualTypeAxioms(OWLOntology ontology) {
        return ontology.getClassAssertionAxioms(this);
    }

    public Set<OWLObjectPropertyAssertionAxiom> getIndividualObjectRelationshipAxioms(OWLOntology ontology) {
        return ontology.getObjectPropertyAssertionAxioms(this);
    }

    public Set<OWLDataPropertyAssertionAxiom> getIndividualDataRelationshipAxioms(OWLOntology ontology) {
        return ontology.getDataPropertyAssertionAxioms(this);
    }

    @Override
    public Set<OWLIndividual> getSameIndividuals(OWLOntology ontology) {
        TreeSet<OWLIndividual> result = new TreeSet<OWLIndividual>();
        for (OWLSameIndividualsAxiom ax : ontology.getSameIndividualAxioms(this)) {
            result.addAll(ax.getIndividuals());
        }
        result.remove(this);
        return result;
    }

    @Override
    public Set<OWLIndividual> getDifferentIndividuals(OWLOntology ontology) {
        TreeSet<OWLIndividual> result = new TreeSet<OWLIndividual>();
        for (OWLDifferentIndividualsAxiom ax : ontology.getDifferentIndividualAxioms(this)) {
            result.addAll(ax.getIndividuals());
        }
        result.remove(this);
        return result;
    }

    public Set<OWLNegativeObjectPropertyAssertionAxiom> getIndividualNotObjectRelationshipAxioms(OWLOntology ontology) throws OWLException {
        return ontology.getNegativeObjectPropertyAssertionAxioms(this);
    }

    public Set<OWLNegativeDataPropertyAssertionAxiom> getIndividualNotDataRelationshipAxioms(OWLOntology ontology) throws OWLException {
        return ontology.getNegativeDataPropertyAssertionAxioms(this);
    }

    @Override
    public OWLClass asOWLClass() {
        throw new OWLRuntimeException("Not an OWLClass!");
    }

    @Override
    public OWLDataProperty asOWLDataProperty() {
        throw new OWLRuntimeException("Not a data property!");
    }

    @Override
    public OWLDataType asOWLDataType() {
        throw new OWLRuntimeException("Not a data type!");
    }

    @Override
    public OWLIndividual asOWLIndividual() {
        return this;
    }

    @Override
    public OWLObjectProperty asOWLObjectProperty() {
        throw new OWLRuntimeException("Not an object property");
    }

    @Override
    public boolean isOWLClass() {
        return false;
    }

    @Override
    public boolean isOWLDataProperty() {
        return false;
    }

    @Override
    public boolean isOWLDataType() {
        return false;
    }

    @Override
    public boolean isOWLIndividual() {
        return true;
    }

    @Override
    public boolean isOWLObjectProperty() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLIndividual)) {
                return false;
            }
            URI otherURI = ((OWLIndividual)obj).getURI();
            String otherFragment = otherURI.getFragment();
            String thisFragment = this.uri.getFragment();
            if (otherFragment != null && thisFragment != null && !otherFragment.equals(thisFragment)) {
                return false;
            }
            return ((OWLIndividual)obj).getURI().equals(this.uri);
        }
        return false;
    }

    @Override
    public void accept(OWLEntityVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLNamedObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLEntityVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        return this.uri.compareTo(((OWLIndividual)object).getURI());
    }
}

