/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.explanation.ordering;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.AxiomType;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLAxiomVisitor;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLLogicalAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLOntologyURIMapper;
import org.semanticweb.owl.model.OWLProperty;
import org.semanticweb.owl.model.OWLPropertyAxiom;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLRuntimeException;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.util.OWLEntityCollector;
import uk.ac.manchester.cs.bhig.util.Tree;
import uk.ac.manchester.cs.owl.explanation.ordering.EntailedAxiomTree;
import uk.ac.manchester.cs.owl.explanation.ordering.ExplanationOrderer;
import uk.ac.manchester.cs.owl.explanation.ordering.ExplanationTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExplanationOrderer
implements ExplanationOrderer {
    private Set<OWLAxiom> currentExplanation = Collections.emptySet();
    private Map<OWLEntity, Set<OWLAxiom>> lhs2AxiomMap = new HashMap<OWLEntity, Set<OWLAxiom>>();
    private Map<OWLAxiom, Set<OWLEntity>> entitiesByAxiomRHS = new HashMap<OWLAxiom, Set<OWLEntity>>();
    private SeedExtractor seedExtractor = new SeedExtractor();
    private OWLOntologyManager man = OWLManager.createOWLOntologyManager();
    private OWLOntology ont;
    private Map<OWLObject, Set<OWLAxiom>> mappedAxioms;
    private Set<AxiomType> passTypes;
    private OWLEntity currentSource;
    private OWLEntity currentTarget;

    public DefaultExplanationOrderer() {
        this.man.addURIMapper(new OWLOntologyURIMapper(){

            public URI getPhysicalURI(URI ontologyURI) {
                return ontologyURI;
            }
        });
        this.mappedAxioms = new HashMap<OWLObject, Set<OWLAxiom>>();
        this.passTypes = new HashSet<AxiomType>();
        this.passTypes.add(AxiomType.DISJOINT_CLASSES);
    }

    private void reset() {
        this.lhs2AxiomMap.clear();
        this.entitiesByAxiomRHS.clear();
    }

    @Override
    public ExplanationTree getOrderedExplanation(OWLAxiom entailment, Set<OWLAxiom> axioms) {
        this.currentExplanation = new HashSet<OWLAxiom>(axioms);
        this.buildIndices();
        EntailedAxiomTree root = new EntailedAxiomTree(entailment);
        this.currentSource = this.seedExtractor.getSource(entailment);
        this.insertChildren(this.currentSource, root);
        this.currentTarget = this.seedExtractor.getTarget(entailment);
        Set axs = root.getUserObjectClosure();
        final HashSet<OWLLogicalAxiom> targetAxioms = new HashSet<OWLLogicalAxiom>();
        if (this.currentTarget != null) {
            if (this.currentTarget.isOWLClass()) {
                targetAxioms.addAll(this.ont.getAxioms(this.currentTarget.asOWLClass()));
            }
            if (this.currentTarget.isOWLObjectProperty()) {
                targetAxioms.addAll(this.ont.getAxioms(this.currentTarget.asOWLObjectProperty()));
            }
            if (this.currentTarget.isOWLDataProperty()) {
                targetAxioms.addAll(this.ont.getAxioms(this.currentTarget.asOWLDataProperty()));
            }
            if (this.currentTarget.isOWLIndividual()) {
                targetAxioms.addAll(this.ont.getAxioms(this.currentTarget.asOWLIndividual()));
            }
        }
        ArrayList<OWLAxiom> rootAxioms = new ArrayList<OWLAxiom>();
        for (OWLAxiom ax : axioms) {
            if (axs.contains(ax)) continue;
            rootAxioms.add(ax);
        }
        Collections.sort(rootAxioms, new Comparator<OWLAxiom>(){

            @Override
            public int compare(OWLAxiom o1, OWLAxiom o2) {
                if (targetAxioms.contains(o1)) {
                    return 1;
                }
                if (targetAxioms.contains(o2)) {
                    return -1;
                }
                return 0;
            }
        });
        for (OWLAxiom ax : rootAxioms) {
            root.addChild(new ExplanationTree(ax));
        }
        return root;
    }

    private List<OWLEntity> getRHSEntitiesSorted(OWLAxiom ax) {
        Collection<OWLEntity> entities = this.getRHSEntities(ax);
        ArrayList<OWLEntity> sortedEntities = new ArrayList<OWLEntity>(entities);
        Collections.sort(sortedEntities, new Comparator<OWLObject>(){

            @Override
            public int compare(OWLObject o1, OWLObject o2) {
                if (o1 instanceof OWLProperty) {
                    return -1;
                }
                return 1;
            }
        });
        return sortedEntities;
    }

    private void insertChildren(OWLEntity entity, ExplanationTree tree) {
        HashSet currentPath = new HashSet(tree.getUserObjectPathToRoot());
        Set<Object> axioms = Collections.emptySet();
        if (entity.isOWLClass()) {
            axioms = this.ont.getAxioms(entity.asOWLClass());
        } else if (entity.isOWLObjectProperty()) {
            axioms = this.ont.getAxioms(entity.asOWLObjectProperty());
        } else if (entity.isOWLDataProperty()) {
            axioms = this.ont.getAxioms(entity.asOWLDataProperty());
        } else if (entity.isOWLIndividual()) {
            axioms = this.ont.getAxioms(entity.asOWLIndividual());
        }
        for (OWLAxiom oWLAxiom : axioms) {
            Set<OWLAxiom> mapped;
            if (this.passTypes.contains(oWLAxiom.getAxiomType()) || (mapped = DefaultExplanationOrderer.getIndexedSet(entity, this.mappedAxioms, true)).contains(oWLAxiom) || currentPath.contains(oWLAxiom)) continue;
            mapped.add(oWLAxiom);
            ExplanationTree child = new ExplanationTree(oWLAxiom);
            tree.addChild(child);
            for (OWLEntity ent : this.getRHSEntitiesSorted(oWLAxiom)) {
                this.insertChildren(ent, child);
            }
        }
        this.sortChildrenAxioms(tree);
    }

    private void sortChildrenAxioms(ExplanationTree tree) {
        Comparator<Tree<OWLAxiom>> comparator = new Comparator<Tree<OWLAxiom>>(){

            @Override
            public int compare(Tree<OWLAxiom> o1, Tree<OWLAxiom> o2) {
                OWLAxiom ax1 = o1.getUserObject();
                OWLAxiom ax2 = o2.getUserObject();
                if (ax1 instanceof OWLEquivalentClassesAxiom) {
                    return 1;
                }
                if (ax2 instanceof OWLEquivalentClassesAxiom) {
                    return -1;
                }
                if (ax1 instanceof OWLPropertyAxiom) {
                    return -1;
                }
                if (ax1 instanceof OWLSubClassAxiom && ax2 instanceof OWLSubClassAxiom) {
                    OWLSubClassAxiom sc1 = (OWLSubClassAxiom)ax1;
                    OWLSubClassAxiom sc2 = (OWLSubClassAxiom)ax2;
                    return sc1.getSuperClass().compareTo(sc2.getSuperClass());
                }
                int childCount1 = o1.getChildCount();
                childCount1 = childCount1 > 0 ? 1 : 0;
                int childCount2 = o2.getChildCount();
                int diff = childCount1 - (childCount2 = childCount2 > 0 ? 1 : 0);
                if (diff != 0) {
                    return diff;
                }
                return 1;
            }
        };
        tree.sortChildren(comparator);
    }

    private void buildIndices() {
        this.reset();
        AxiomMapBuilder builder = new AxiomMapBuilder();
        for (OWLAxiom ax : this.currentExplanation) {
            ax.accept(builder);
        }
        try {
            if (this.ont != null) {
                this.man.removeOntology(this.ont.getURI());
            }
            this.ont = this.man.createOntology(URI.create("http://www.semanticweb.org/ontology" + System.currentTimeMillis()));
            ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
            for (OWLAxiom ax : this.currentExplanation) {
                changes.add(new AddAxiom(this.ont, ax));
                ax.accept(builder);
            }
            this.man.applyChanges(changes);
        }
        catch (OWLOntologyCreationException e) {
            throw new OWLRuntimeException(e);
        }
        catch (OWLOntologyChangeException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private static <K, E> Set<E> getIndexedSet(K obj, Map<K, Set<E>> map, boolean addIfEmpty) {
        Set<E> values = map.get(obj);
        if (values == null) {
            values = new HashSet();
            if (addIfEmpty) {
                map.put(obj, values);
            }
        }
        return values;
    }

    private Set<OWLAxiom> getAxiomsForLHS(OWLEntity lhs) {
        return DefaultExplanationOrderer.getIndexedSet(lhs, this.lhs2AxiomMap, true);
    }

    private Collection<OWLEntity> getRHSEntities(OWLAxiom axiom) {
        return DefaultExplanationOrderer.getIndexedSet(axiom, this.entitiesByAxiomRHS, true);
    }

    private void indexAxiomsByRHSEntities(OWLObject rhs, OWLAxiom axiom) {
        OWLEntityCollector collector = new OWLEntityCollector();
        rhs.accept(collector);
        DefaultExplanationOrderer.getIndexedSet(axiom, this.entitiesByAxiomRHS, true).addAll(collector.getObjects());
    }

    private class AxiomMapBuilder
    implements OWLAxiomVisitor {
        private AxiomMapBuilder() {
        }

        public void visit(OWLSubClassAxiom axiom) {
            if (!axiom.getSubClass().isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(axiom.getSubClass().asOWLClass()).add(axiom);
                DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(axiom.getSuperClass(), axiom);
            }
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            for (OWLDescription desc : axiom.getDescriptions()) {
                if (!desc.isAnonymous()) {
                    DefaultExplanationOrderer.this.getAxiomsForLHS(desc.asOWLClass()).add(axiom);
                }
                DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(desc, axiom);
            }
        }

        public void visit(OWLDataPropertyDomainAxiom axiom) {
            DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()).add(axiom);
            DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(axiom.getDomain(), axiom);
        }

        public void visit(OWLImportsDeclaration axiom) {
        }

        public void visit(OWLAxiomAnnotationAxiom axiom) {
        }

        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
            DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(axiom.getDomain(), axiom);
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                if (!prop.isAnonymous()) {
                    DefaultExplanationOrderer.this.getAxiomsForLHS(prop.asOWLObjectProperty()).add(axiom);
                }
                DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(prop, axiom);
            }
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLDifferentIndividualsAxiom axiom) {
            for (OWLIndividual ind : axiom.getIndividuals()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(ind).add(axiom);
                DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(ind, axiom);
            }
        }

        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(prop.asOWLDataProperty()).add(axiom);
                DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(prop, axiom);
            }
        }

        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                if (!prop.isAnonymous()) {
                    DefaultExplanationOrderer.this.getAxiomsForLHS(prop.asOWLObjectProperty()).add(axiom);
                }
                DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(prop, axiom);
            }
        }

        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
            DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(axiom.getRange(), axiom);
        }

        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        public void visit(OWLObjectSubPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getSubProperty()).isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getSubProperty()).asOWLObjectProperty()).add(axiom);
            }
            DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(axiom.getSuperProperty(), axiom);
        }

        public void visit(OWLDisjointUnionAxiom axiom) {
            DefaultExplanationOrderer.this.getAxiomsForLHS(axiom.getOWLClass()).add(axiom);
        }

        public void visit(OWLDeclarationAxiom axiom) {
        }

        public void visit(OWLEntityAnnotationAxiom axiom) {
        }

        public void visit(OWLOntologyAnnotationAxiom axiom) {
        }

        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        public void visit(OWLDataPropertyRangeAxiom axiom) {
            if (!((OWLDataPropertyExpression)axiom.getProperty()).isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()).add(axiom);
            }
            DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(axiom.getRange(), axiom);
        }

        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            if (!((OWLDataPropertyExpression)axiom.getProperty()).isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()).add(axiom);
            }
        }

        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(prop.asOWLDataProperty()).add(axiom);
                DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(prop, axiom);
            }
        }

        public void visit(OWLClassAssertionAxiom axiom) {
            DefaultExplanationOrderer.this.getAxiomsForLHS(axiom.getIndividual()).add(axiom);
            DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(axiom.getDescription(), axiom);
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            for (OWLDescription desc : axiom.getDescriptions()) {
                if (!desc.isAnonymous()) {
                    DefaultExplanationOrderer.this.getAxiomsForLHS(desc.asOWLClass()).add(axiom);
                }
                DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(desc, axiom);
            }
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(axiom.getSubject(), axiom);
        }

        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        public void visit(OWLDataSubPropertyAxiom axiom) {
            DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLDataPropertyExpression)axiom.getSubProperty()).asOWLDataProperty()).add(axiom);
            DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(axiom.getSuperProperty(), axiom);
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        public void visit(OWLSameIndividualsAxiom axiom) {
            for (OWLIndividual ind : axiom.getIndividuals()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(ind).add(axiom);
                DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(ind, axiom);
            }
        }

        public void visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
        }

        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            if (!axiom.getFirstProperty().isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(axiom.getFirstProperty().asOWLObjectProperty()).add(axiom);
            }
            DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(axiom.getFirstProperty(), axiom);
            DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(axiom.getSecondProperty(), axiom);
        }

        public void visit(SWRLRule rule) {
        }
    }

    private class SeedExtractor
    implements OWLAxiomVisitor {
        private OWLEntity source;
        private OWLEntity target;

        public OWLEntity getSource(OWLAxiom axiom) {
            axiom.accept(this);
            return this.source;
        }

        public OWLEntity getTarget(OWLAxiom axiom) {
            axiom.accept(this);
            return this.target;
        }

        public void visit(OWLSubClassAxiom axiom) {
            if (!axiom.getSubClass().isAnonymous()) {
                this.source = axiom.getSubClass().asOWLClass();
            }
            if (!axiom.getSuperClass().isOWLNothing()) {
                this.target = axiom.getSuperClass().asOWLClass();
            }
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
        }

        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
        }

        public void visit(OWLDataPropertyDomainAxiom axiom) {
        }

        public void visit(OWLImportsDeclaration axiom) {
        }

        public void visit(OWLAxiomAnnotationAxiom axiom) {
        }

        public void visit(OWLObjectPropertyDomainAxiom axiom) {
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLDifferentIndividualsAxiom axiom) {
        }

        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        }

        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        }

        public void visit(OWLObjectPropertyRangeAxiom axiom) {
        }

        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        }

        public void visit(OWLObjectSubPropertyAxiom axiom) {
        }

        public void visit(OWLDisjointUnionAxiom axiom) {
        }

        public void visit(OWLDeclarationAxiom axiom) {
        }

        public void visit(OWLEntityAnnotationAxiom axiom) {
        }

        public void visit(OWLOntologyAnnotationAxiom axiom) {
        }

        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        }

        public void visit(OWLDataPropertyRangeAxiom axiom) {
        }

        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        }

        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        }

        public void visit(OWLClassAssertionAxiom axiom) {
            if (!axiom.getDescription().isAnonymous()) {
                this.source = axiom.getIndividual();
                this.target = axiom.getDescription().asOWLClass();
            }
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            Iterator<OWLDescription> it = axiom.getDescriptions().iterator();
            this.source = it.next().asOWLClass();
            this.target = it.next().asOWLClass();
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        }

        public void visit(OWLDataSubPropertyAxiom axiom) {
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        }

        public void visit(OWLSameIndividualsAxiom axiom) {
        }

        public void visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
        }

        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        }

        public void visit(SWRLRule rule) {
        }
    }
}

