/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.explanation;

import com.clarkparsia.explanation.TransactionAwareSingleExpGen;
import com.clarkparsia.explanation.util.DefinitionTracker;
import org.semanticweb.owl.inference.OWLClassReasoner;
import org.semanticweb.owl.inference.OWLReasonerFactory;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;

public abstract class SingleExplanationGeneratorImpl
implements TransactionAwareSingleExpGen {
    private boolean inTransaction;
    protected OWLOntologyManager owlOntologyManager;
    protected OWLOntology ontology;
    protected OWLClassReasoner reasoner;
    protected OWLReasonerFactory reasonerFactory;
    protected DefinitionTracker definitionTracker;
    protected OWLClassReasoner altReasoner;

    public SingleExplanationGeneratorImpl(OWLOntologyManager manager) {
        this.owlOntologyManager = manager;
        this.definitionTracker = new DefinitionTracker(manager);
    }

    public OWLOntologyManager getOntologyManager() {
        return this.owlOntologyManager;
    }

    public void setOntology(OWLOntology ontology) {
        this.ontology = ontology;
        this.altReasoner = null;
        this.definitionTracker.setOntology(ontology);
    }

    public OWLClassReasoner getReasoner() {
        return this.reasoner;
    }

    public void setReasoner(OWLClassReasoner reasoner) {
        this.reasoner = reasoner;
        this.altReasoner = null;
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public OWLReasonerFactory getReasonerFactory() {
        return this.reasonerFactory;
    }

    public void setReasonerFactory(OWLReasonerFactory reasonerFactory) {
        this.reasonerFactory = reasonerFactory;
        this.altReasoner = null;
    }

    public OWLClassReasoner getAltReasoner() {
        if (this.altReasoner == null) {
            this.altReasoner = this.reasonerFactory.createReasoner(this.owlOntologyManager);
        }
        return this.altReasoner;
    }

    protected boolean isFirstExplanation() {
        return !this.inTransaction;
    }

    public void beginTransaction() {
        if (this.inTransaction) {
            throw new RuntimeException("Already in transaction");
        }
        this.inTransaction = true;
    }

    public void endTransaction() {
        if (!this.inTransaction) {
            throw new RuntimeException("Cannot end transaction");
        }
        this.inTransaction = false;
    }
}

