/*
 * Decompiled with CFR 0.152.
 */
package org.coode.manchesterowlsyntax;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.coode.manchesterowlsyntax.ManchesterOWLSyntax;
import org.coode.manchesterowlsyntax.ManchesterOWLSyntaxTokenizer;
import org.semanticweb.owl.expression.OWLEntityChecker;
import org.semanticweb.owl.expression.ParserException;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLPropertyExpression;
import org.semanticweb.owl.model.OWLQuantifiedRestriction;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.SetOntologyURI;
import org.semanticweb.owl.util.CollectionFactory;
import org.semanticweb.owl.util.NamespaceUtil;
import org.semanticweb.owl.vocab.DublinCoreVocabulary;
import org.semanticweb.owl.vocab.Namespaces;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;
import org.semanticweb.owl.vocab.OWLRestrictedDataRangeFacetVocabulary;
import org.semanticweb.owl.vocab.XSDVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManchesterOWLSyntaxEditorParser {
    private OWLDataFactory dataFactory;
    private List<ManchesterOWLSyntaxTokenizer.Token> tokens;
    private int tokenIndex;
    private OWLEntityChecker owlEntityChecker;
    private final String EOF = "<EOF>";
    private String base;
    private Set<String> classNames;
    private Set<String> objectPropertyNames;
    private Set<String> dataPropertyNames;
    private Set<String> individualNames;
    private Set<String> dataTypeNames;
    private Set<String> annotationURIs;
    private Set<String> restrictionKeywords;
    private Map<String, String> namespaceMap;
    private String buffer;
    public static final String AND = ManchesterOWLSyntax.AND.toString();
    public static final String OR = ManchesterOWLSyntax.OR.toString();
    public static final String INV = ManchesterOWLSyntax.INVERSE.toString();
    public static final String SOME = ManchesterOWLSyntax.SOME.toString();
    public static final String SELF = ManchesterOWLSyntax.SELF.toString();
    public static final String ONLY = ManchesterOWLSyntax.ONLY.toString();
    public static final String VALUE = ManchesterOWLSyntax.VALUE.toString();
    public static final String MIN = ManchesterOWLSyntax.MIN.toString();
    public static final String MAX = ManchesterOWLSyntax.MAX.toString();
    public static final String EXACTLY = ManchesterOWLSyntax.EXACTLY.toString();
    public static final String ONLYSOME = ManchesterOWLSyntax.ONLYSOME.toString();
    public static final String NOT = ManchesterOWLSyntax.NOT.toString();
    public static final String CLASS = ManchesterOWLSyntax.CLASS.toString() + ":";
    public static final String SUB_CLASS_OF = ManchesterOWLSyntax.SUBCLASS_OF.toString() + ":";
    public static final String EQUIVALENT_TO = ManchesterOWLSyntax.EQUIVALENT_TO.toString() + ":";
    public static final String DISJOINT_WITH = ManchesterOWLSyntax.DISJOINT_WITH.toString() + ":";
    public static final String DISJOINT_UNION_OF = ManchesterOWLSyntax.DISJOINT_UNION_OF.toString() + ":";
    public static final String DISJOINT_CLASSES = ManchesterOWLSyntax.DISJOINT_CLASSES.toString() + ":";
    public static final String DISJOINT_OBJECT_PROPERTIES = ManchesterOWLSyntax.DISJOINT_OBJECT_PROPERTIES.toString() + ":";
    public static final String DISJOINT_DATA_PROPERTIES = ManchesterOWLSyntax.DISJOINT_DATA_PROPERTIES.toString() + ":";
    public static final String OBJECT_PROPERTY = ManchesterOWLSyntax.OBJECT_PROPERTY.toString() + ":";
    public static final String DATA_PROPERTY = ManchesterOWLSyntax.DATA_PROPERTY.toString() + ":";
    public static final String SUB_PROPERTY_OF = ManchesterOWLSyntax.SUB_PROPERTY_OF.toString() + ":";
    public static final String DOMAIN = ManchesterOWLSyntax.DOMAIN.toString() + ":";
    public static final String RANGE = ManchesterOWLSyntax.RANGE.toString() + ":";
    public static final String INVERSES = ManchesterOWLSyntax.INVERSES.toString() + ":";
    public static final String CHARACTERISTICS = ManchesterOWLSyntax.CHARACTERISTICS.toString() + ":";
    public static final String INDIVIDUAL = ManchesterOWLSyntax.INDIVIDUAL.toString() + ":";
    public static final String ANNOTATIONS = ManchesterOWLSyntax.ANNOTATIONS.toString() + ":";
    public static final String TYPES = ManchesterOWLSyntax.TYPES.toString() + ":";
    public static final String FACTS = ManchesterOWLSyntax.FACTS.toString() + ":";
    public static final String SAME_AS = ManchesterOWLSyntax.SAME_AS.toString() + ":";
    public static final String SAME_INDIVIDUAL = ManchesterOWLSyntax.SAME_INDIVIDUAL.toString() + ":";
    public static final String DIFFERENT_FROM = ManchesterOWLSyntax.DIFFERENT_FROM.toString() + ":";
    public static final String DIFFERENT_INDIVIDUALS = ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS.toString() + ":";
    public static final String VALUE_PARTITION = "ValuePartition:";
    public static final String ONTOLOGY = ManchesterOWLSyntax.ONTOLOGY.toString() + ":";
    public static final String NAMESPACE = ManchesterOWLSyntax.NAMESPACE.toString() + ":";
    public static final String IMPORT = ManchesterOWLSyntax.IMPORT.toString() + ":";
    public static final String SUB_PROPERTY_CHAIN = ManchesterOWLSyntax.SUB_PROPERTY_CHAIN.toString() + ":";
    public static final String FUNCTIONAL = ManchesterOWLSyntax.FUNCTIONAL.toString();
    public static final String INVERSE_FUNCTIONAL = ManchesterOWLSyntax.INVERSE_FUNCTIONAL.toString();
    public static final String SYMMETRIC = ManchesterOWLSyntax.SYMMETRIC.toString();
    public static final String ANTI_SYMMETRIC = ManchesterOWLSyntax.ANTI_SYMMETRIC.toString();
    public static final String ASYMMETRIC = ManchesterOWLSyntax.ASYMMETRIC.toString();
    public static final String TRANSITIVE = ManchesterOWLSyntax.TRANSITIVE.toString();
    public static final String REFLEXIVE = ManchesterOWLSyntax.REFLEXIVE.toString();
    public static final String IRREFLEXIVE = ManchesterOWLSyntax.IRREFLEXIVE.toString();
    public static final String INVERSE_OF = (Object)((Object)ManchesterOWLSyntax.INVERSE_OF) + ":";
    private Set<String> potentialKeywords;
    private static final Set<String> FRAME_TOKENS = Collections.unmodifiableSet(CollectionFactory.createSet(CLASS, OBJECT_PROPERTY, DATA_PROPERTY, INDIVIDUAL, "ValuePartition:", DISJOINT_CLASSES, DISJOINT_DATA_PROPERTIES, DISJOINT_OBJECT_PROPERTIES, DIFFERENT_INDIVIDUALS));
    private Map<String, URI> nameURIMap = new HashMap<String, URI>();

    public ManchesterOWLSyntaxEditorParser(OWLDataFactory dataFactory, String s) {
        this.dataFactory = dataFactory;
        this.potentialKeywords = new HashSet<String>();
        this.restrictionKeywords = new HashSet<String>();
        this.restrictionKeywords.add(ManchesterOWLSyntax.SOME.toString());
        this.restrictionKeywords.add(ManchesterOWLSyntax.ONLY.toString());
        this.restrictionKeywords.add(ManchesterOWLSyntax.MIN.toString());
        this.restrictionKeywords.add(ManchesterOWLSyntax.MAX.toString());
        this.restrictionKeywords.add(ManchesterOWLSyntax.EXACTLY.toString());
        this.restrictionKeywords.add(ManchesterOWLSyntax.VALUE.toString());
        this.restrictionKeywords.add(ManchesterOWLSyntax.THAT.toString());
        this.classNames = new HashSet<String>();
        this.objectPropertyNames = new HashSet<String>();
        this.dataPropertyNames = new HashSet<String>();
        this.individualNames = new HashSet<String>();
        this.dataTypeNames = new HashSet<String>();
        this.annotationURIs = new HashSet<String>();
        this.namespaceMap = new HashMap<String, String>();
        this.namespaceMap.put("rdf", Namespaces.RDF.toString());
        this.namespaceMap.put("rdfs", Namespaces.RDFS.toString());
        this.namespaceMap.put("owl", Namespaces.OWL.toString());
        this.namespaceMap.put("dc", "http://purl.org/dc/elements/1.1/".toString());
        NamespaceUtil u = new NamespaceUtil();
        for (XSDVocabulary xSDVocabulary : XSDVocabulary.values()) {
            this.dataTypeNames.add(xSDVocabulary.getURI().getFragment());
            this.dataTypeNames.add("xsd:" + xSDVocabulary.getURI().getFragment());
        }
        this.dataTypeNames.add(OWLRDFVocabulary.RDF_XML_LITERAL.getURI().getFragment());
        this.dataTypeNames.add("rdf:" + OWLRDFVocabulary.RDF_XML_LITERAL.getURI().getFragment());
        this.dataTypeNames.add(dataFactory.getTopDataType().getURI().getFragment());
        for (URI uri : OWLRDFVocabulary.BUILT_IN_ANNOTATION_PROPERTIES) {
            String[] res = u.split(uri.toString(), null);
            this.annotationURIs.add(u.getPrefix(res[0]) + ":" + res[1]);
        }
        for (Enum enum_ : DublinCoreVocabulary.values()) {
            this.annotationURIs.add(((DublinCoreVocabulary)enum_).getQName());
        }
        this.buffer = s;
        this.base = "http://www.semanticweb.org#";
        this.owlEntityChecker = new DefaultEntityChecker();
        this.tokens = new ArrayList<ManchesterOWLSyntaxTokenizer.Token>();
        ManchesterOWLSyntaxTokenizer tokenizer = new ManchesterOWLSyntaxTokenizer(this.buffer);
        this.tokens.addAll(tokenizer.tokenize());
        this.tokenIndex = 0;
    }

    public OWLDataFactory getDataFactory() {
        return this.dataFactory;
    }

    protected List<ManchesterOWLSyntaxTokenizer.Token> getTokens() {
        return this.tokens;
    }

    protected void reset() {
        this.tokenIndex = 0;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public OWLEntityChecker getOWLEntityChecker() {
        return this.owlEntityChecker;
    }

    public void setOWLEntityChecker(OWLEntityChecker owlEntityChecker) {
        this.owlEntityChecker = owlEntityChecker;
    }

    public boolean isClassName(String name) {
        if (this.classNames.contains(name)) {
            return true;
        }
        return this.owlEntityChecker != null && this.owlEntityChecker.getOWLClass(name) != null;
    }

    public boolean isObjectPropertyName(String name) {
        if (this.objectPropertyNames.contains(name)) {
            return true;
        }
        return this.owlEntityChecker != null && this.owlEntityChecker.getOWLObjectProperty(name) != null;
    }

    public boolean isAnnotationURI(String name) {
        return this.annotationURIs.contains(name);
    }

    public boolean isDataPropertyName(String name) {
        if (this.dataPropertyNames.contains(name)) {
            return true;
        }
        return this.owlEntityChecker != null && this.owlEntityChecker.getOWLDataProperty(name) != null;
    }

    public boolean isIndividualName(String name) {
        if (this.individualNames.contains(name)) {
            return true;
        }
        return this.owlEntityChecker != null && this.owlEntityChecker.getOWLIndividual(name) != null;
    }

    public boolean isDatatypeName(String name) {
        if (this.dataTypeNames.contains(name)) {
            return true;
        }
        return this.owlEntityChecker != null && this.owlEntityChecker.getOWLDataType(name) != null;
    }

    public OWLClass getOWLClass(String name) {
        OWLClass cls = this.owlEntityChecker.getOWLClass(name);
        if (cls == null && this.objectPropertyNames.contains(name)) {
            cls = this.getDataFactory().getOWLClass(this.getURI(name));
        }
        return cls;
    }

    public OWLObjectProperty getOWLObjectProperty(String name) {
        OWLObjectProperty prop = this.owlEntityChecker.getOWLObjectProperty(name);
        if (prop == null && this.objectPropertyNames.contains(name)) {
            prop = this.getDataFactory().getOWLObjectProperty(this.getURI(name));
        }
        return prop;
    }

    public OWLIndividual getOWLIndividual(String name) {
        OWLIndividual ind = this.owlEntityChecker.getOWLIndividual(name);
        if (ind == null && this.objectPropertyNames.contains(name)) {
            ind = this.getDataFactory().getOWLIndividual(this.getURI(name));
        }
        return ind;
    }

    public OWLDataProperty getOWLDataProperty(String name) {
        OWLDataProperty prop = this.owlEntityChecker.getOWLDataProperty(name);
        if (prop == null && this.objectPropertyNames.contains(name)) {
            prop = this.getDataFactory().getOWLDataProperty(this.getURI(name));
        }
        return prop;
    }

    public OWLDataType getDataType(String name) {
        if (name.startsWith("xsd:")) {
            return this.dataFactory.getOWLDataType(URI.create((Object)((Object)Namespaces.XSD) + name.substring(name.indexOf(58) + 1)));
        }
        return this.dataFactory.getOWLDataType(URI.create((Object)((Object)Namespaces.XSD) + name));
    }

    public URI getAnnotationURI(String name) {
        return this.getURI(name);
    }

    private ManchesterOWLSyntaxTokenizer.Token getLastToken() {
        if (this.tokenIndex - 1 > -1) {
            return this.tokens.get(this.tokenIndex - 1);
        }
        return this.tokens.get(0);
    }

    private String peekToken() {
        return this.tokens.get(this.tokenIndex).getToken();
    }

    protected String consumeToken() {
        String token = this.tokens.get(this.tokenIndex).getToken();
        ++this.tokenIndex;
        if (this.tokenIndex == this.tokens.size()) {
            --this.tokenIndex;
        }
        return token;
    }

    public ManchesterOWLSyntaxTokenizer.Token getToken() {
        return this.tokens.get(this.tokenIndex);
    }

    public int getTokenPos() {
        return this.getToken().getPos();
    }

    public int getTokenCol() {
        return this.getToken().getCol();
    }

    public int getTokenRow() {
        return this.getToken().getRow();
    }

    public OWLDescription parseDescription() throws ParserException {
        OWLDescription desc = this.parseIntersection();
        if (!this.consumeToken().equals("<EOF>")) {
            this.throwException("<EOF>");
        }
        return desc;
    }

    public OWLDescription parseIntersection() throws ParserException {
        HashSet<OWLDescription> ops = new HashSet<OWLDescription>();
        String kw = AND;
        while (kw.equalsIgnoreCase(AND)) {
            this.potentialKeywords.remove(AND);
            ops.add(this.parseUnion());
            this.potentialKeywords.add(AND);
            kw = this.peekToken();
            if (kw.equalsIgnoreCase(AND)) {
                kw = this.consumeToken();
                continue;
            }
            if (!kw.equalsIgnoreCase("that")) continue;
            this.consumeToken();
            kw = AND;
        }
        if (ops.size() == 1) {
            return (OWLDescription)ops.iterator().next();
        }
        return this.dataFactory.getOWLObjectIntersectionOf(ops);
    }

    public OWLDescription parseUnion() throws ParserException {
        HashSet<OWLDescription> ops = new HashSet<OWLDescription>();
        String kw = OR;
        while (kw.equalsIgnoreCase(OR)) {
            this.potentialKeywords.remove(OR);
            ops.add(this.parseNonNaryDescription());
            this.potentialKeywords.add(OR);
            kw = this.peekToken();
            if (!kw.equalsIgnoreCase(OR)) continue;
            kw = this.consumeToken();
        }
        if (ops.size() == 1) {
            return (OWLDescription)ops.iterator().next();
        }
        return this.dataFactory.getOWLObjectUnionOf(ops);
    }

    public OWLObjectPropertyExpression parseObjectPropertyExpression(boolean allowUndeclared) throws ParserException {
        String tok = this.consumeToken();
        if (tok.equalsIgnoreCase(INV)) {
            String open = this.consumeToken();
            if (!open.equals("(")) {
                this.throwException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.consumeToken();
            if (!close.equals(")")) {
                this.throwException(")");
            }
            return this.dataFactory.getOWLObjectPropertyInverse(prop);
        }
        if (!allowUndeclared && !this.isObjectPropertyName(tok)) {
            this.throwException(false, true, false, false, false, INV);
        }
        return this.getOWLObjectProperty(tok);
    }

    public OWLObjectPropertyExpression parseObjectPropertyExpression() throws ParserException {
        return this.parseObjectPropertyExpression(false);
    }

    public OWLDescription parseRestriction() throws ParserException {
        String tok = this.peekToken();
        if (this.isObjectPropertyName(tok) || tok.equalsIgnoreCase(INV)) {
            return this.parseObjectRestriction();
        }
        if (this.isDataPropertyName(tok)) {
            return this.parseDataRestriction();
        }
        this.consumeToken();
        this.throwException(false, true, true, false);
        return null;
    }

    public OWLDescription parseNonNaryDescription() throws ParserException {
        String tok = this.peekToken();
        if (tok.equalsIgnoreCase(NOT)) {
            this.consumeToken();
            OWLDescription complemented = this.parseNestedClassExpression(false);
            return this.dataFactory.getOWLObjectComplementOf(complemented);
        }
        if (this.isObjectPropertyName(tok) || tok.equalsIgnoreCase(INV)) {
            return this.parseObjectRestriction();
        }
        if (this.isDataPropertyName(tok)) {
            return this.parseDataRestriction();
        }
        if (tok.equals("{")) {
            return this.parseObjectOneOf();
        }
        if (tok.equals("(")) {
            return this.parseNestedClassExpression(false);
        }
        if (this.isClassName(tok)) {
            this.consumeToken();
            return this.getOWLClass(tok);
        }
        this.consumeToken();
        this.throwException(true, true, true, false, false, "(", "{", NOT, INV);
        return null;
    }

    private OWLDescription parseObjectRestriction() throws ParserException {
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
        String kw = this.consumeToken();
        if (kw.equalsIgnoreCase(SOME)) {
            String possSelfToken = this.peekToken();
            if (possSelfToken.equalsIgnoreCase(SELF)) {
                this.consumeToken();
                return this.dataFactory.getOWLObjectSelfRestriction(prop);
            }
            OWLDescription filler = null;
            try {
                filler = this.parseNestedClassExpression(false);
            }
            catch (ParserException e) {
                HashSet<String> keywords = new HashSet<String>();
                keywords.addAll(e.getExpectedKeywords());
                keywords.add(SELF);
                this.throwException(e.isClassNameExpected(), e.isObjectPropertyNameExpected(), e.isDataPropertyNameExpected(), e.isIndividualNameExpected(), e.isDatatypeNameExpected(), keywords.toArray(new String[keywords.size()]));
            }
            return this.dataFactory.getOWLObjectSomeRestriction(prop, filler);
        }
        if (kw.equalsIgnoreCase(ONLY)) {
            OWLDescription filler = this.parseNestedClassExpression(false);
            return this.dataFactory.getOWLObjectAllRestriction(prop, filler);
        }
        if (kw.equalsIgnoreCase(VALUE)) {
            String indName = this.consumeToken();
            if (!this.isIndividualName(indName)) {
                this.throwException(false, false, false, true);
            }
            return this.dataFactory.getOWLObjectValueRestriction(prop, this.getOWLIndividual(indName));
        }
        if (kw.equalsIgnoreCase(MIN)) {
            int card = this.parseInteger();
            OWLDescription filler = this.parseNestedClassExpression(true);
            if (filler != null) {
                return this.dataFactory.getOWLObjectMinCardinalityRestriction(prop, card, filler);
            }
            return this.dataFactory.getOWLObjectMinCardinalityRestriction(prop, card);
        }
        if (kw.equalsIgnoreCase(MAX)) {
            int card = this.parseInteger();
            OWLDescription filler = this.parseNestedClassExpression(true);
            if (filler != null) {
                return this.dataFactory.getOWLObjectMaxCardinalityRestriction(prop, card, filler);
            }
            return this.dataFactory.getOWLObjectMaxCardinalityRestriction(prop, card);
        }
        if (kw.equalsIgnoreCase(EXACTLY)) {
            int card = this.parseInteger();
            OWLDescription filler = this.parseNestedClassExpression(true);
            if (filler != null) {
                return this.dataFactory.getOWLObjectExactCardinalityRestriction(prop, card, filler);
            }
            return this.dataFactory.getOWLObjectExactCardinalityRestriction(prop, card);
        }
        if (kw.equalsIgnoreCase(ONLYSOME)) {
            String tok = this.peekToken();
            HashSet<OWLDescription> descs = new HashSet<OWLDescription>();
            if (!tok.equals("[")) {
                descs.add(this.parseIntersection());
            } else {
                descs.addAll(this.parseDescriptionList("[", "]"));
            }
            HashSet<OWLQuantifiedRestriction<OWLObjectPropertyExpression, OWLDescription>> ops = new HashSet<OWLQuantifiedRestriction<OWLObjectPropertyExpression, OWLDescription>>();
            for (OWLDescription desc : descs) {
                ops.add(this.dataFactory.getOWLObjectSomeRestriction(prop, desc));
            }
            OWLDescription filler = descs.size() == 1 ? (OWLDescription)descs.iterator().next() : this.dataFactory.getOWLObjectUnionOf(descs);
            ops.add(this.dataFactory.getOWLObjectAllRestriction(prop, filler));
            return this.dataFactory.getOWLObjectIntersectionOf(ops);
        }
        this.throwException(SOME, ONLY, VALUE, MIN, MAX, EXACTLY);
        return null;
    }

    public OWLDescription parseDataRestriction() throws ParserException {
        OWLDataProperty prop = this.parseDataProperty();
        String kw = this.consumeToken();
        if (kw.equalsIgnoreCase(SOME)) {
            OWLDataRange rng = this.parseDataRange(false);
            return this.dataFactory.getOWLDataSomeRestriction(prop, rng);
        }
        if (kw.equalsIgnoreCase(ONLY)) {
            OWLDataRange rng = this.parseDataRange(false);
            return this.dataFactory.getOWLDataAllRestriction(prop, rng);
        }
        if (kw.equalsIgnoreCase(VALUE)) {
            OWLConstant con = this.parseConstant();
            return this.dataFactory.getOWLDataValueRestriction(prop, con);
        }
        if (kw.equalsIgnoreCase(MIN)) {
            int card = this.parseInteger();
            OWLDataRange rng = this.parseDataRange(true);
            if (rng != null) {
                return this.dataFactory.getOWLDataMinCardinalityRestriction(prop, card, rng);
            }
            return this.dataFactory.getOWLDataMinCardinalityRestriction(prop, card);
        }
        if (kw.equalsIgnoreCase(EXACTLY)) {
            int card = this.parseInteger();
            OWLDataRange rng = this.parseDataRange(true);
            if (rng != null) {
                return this.dataFactory.getOWLDataExactCardinalityRestriction(prop, card, rng);
            }
            return this.dataFactory.getOWLDataExactCardinalityRestriction(prop, card, rng);
        }
        if (kw.equalsIgnoreCase(MAX)) {
            int card = this.parseInteger();
            OWLDataRange rng = this.parseDataRange(true);
            if (rng != null) {
                return this.dataFactory.getOWLDataMaxCardinalityRestriction(prop, card, rng);
            }
            return this.dataFactory.getOWLDataMaxCardinalityRestriction(prop, card, rng);
        }
        this.throwException(SOME, ONLY, VALUE, MIN, EXACTLY, MAX);
        return null;
    }

    public OWLRestrictedDataRangeFacetVocabulary parseFacet() throws ParserException {
        String facet = this.consumeToken();
        if (facet.equals(">")) {
            if (this.peekToken().equals("=")) {
                this.consumeToken();
                return OWLRestrictedDataRangeFacetVocabulary.MIN_INCLUSIVE;
            }
            return OWLRestrictedDataRangeFacetVocabulary.MIN_EXCLUSIVE;
        }
        if (facet.equals("<")) {
            if (this.peekToken().equals("=")) {
                this.consumeToken();
                return OWLRestrictedDataRangeFacetVocabulary.MAX_INCLUSIVE;
            }
            return OWLRestrictedDataRangeFacetVocabulary.MAX_EXCLUSIVE;
        }
        return OWLRestrictedDataRangeFacetVocabulary.getFacetBySymbolicName(facet);
    }

    public OWLDataRange parseDataRange(boolean allowLookahead) throws ParserException {
        String tok = this.peekToken();
        if (this.isDatatypeName(tok)) {
            this.consumeToken();
            OWLDataType dataType = this.getDataType(tok);
            String next = this.peekToken();
            if (next.equals("[")) {
                this.consumeToken();
                String sep = ",";
                HashSet<OWLDataRangeFacetRestriction> facetRestrictions = new HashSet<OWLDataRangeFacetRestriction>();
                while (sep.equals(",")) {
                    OWLConstant con;
                    OWLRestrictedDataRangeFacetVocabulary fv = this.parseFacet();
                    if (fv == null) {
                        this.throwException(OWLRestrictedDataRangeFacetVocabulary.getFacets().toArray(new String[OWLRestrictedDataRangeFacetVocabulary.getFacetURIs().size()]));
                    }
                    if (!(con = this.parseConstant()).isTyped()) {
                        con = this.dataFactory.getOWLTypedConstant(con.getLiteral());
                    }
                    facetRestrictions.add(this.dataFactory.getOWLDataRangeFacetRestriction(fv, con.asOWLTypedConstant()));
                    sep = this.consumeToken();
                }
                if (!sep.equals("]")) {
                    this.throwException("]");
                }
                return this.dataFactory.getOWLDataRangeRestriction((OWLDataRange)dataType, facetRestrictions);
            }
            return dataType;
        }
        if (tok.equalsIgnoreCase(NOT)) {
            return this.parseDataComplementOf();
        }
        if (tok.equals("{")) {
            return this.parseDataOneOf();
        }
        if (!allowLookahead) {
            this.consumeToken();
            this.throwException(false, false, false, false, true, NOT, "{");
        }
        return null;
    }

    private Set<OWLDataRange> parseDataRangeList() throws ParserException {
        String sep = ",";
        HashSet<OWLDataRange> ranges = new HashSet<OWLDataRange>();
        while (sep.equals(",")) {
            this.potentialKeywords.remove(",");
            OWLDataRange rng = this.parseDataRange(false);
            ranges.add(rng);
            this.potentialKeywords.add(",");
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        return ranges;
    }

    private OWLDataRange parseDataOneOf() throws ParserException {
        this.consumeToken();
        HashSet<OWLConstant> cons = new HashSet<OWLConstant>();
        String sep = ",";
        while (sep.equals(",")) {
            OWLConstant con = this.parseConstant();
            cons.add(con);
            sep = this.consumeToken();
        }
        if (!sep.equals("}")) {
            this.throwException(",", "}");
        }
        return this.dataFactory.getOWLDataOneOf(cons);
    }

    private OWLDataRange parseDataComplementOf() throws ParserException {
        String open;
        String not = this.consumeToken();
        if (!not.equalsIgnoreCase(NOT)) {
            this.throwException(NOT);
        }
        if (!(open = this.consumeToken()).equals("(")) {
            this.throwException("(");
        }
        OWLDataRange complementedDataRange = this.parseDataRange(false);
        String close = this.consumeToken();
        if (!close.equals(")")) {
            this.throwException(")");
        }
        return this.dataFactory.getOWLDataComplementOf(complementedDataRange);
    }

    public OWLConstant parseConstant() throws ParserException {
        String tok = this.consumeToken();
        if (tok.startsWith("\"")) {
            String lit = tok.substring(1, tok.length() - 1).trim();
            if (this.peekToken().equals("^")) {
                this.consumeToken();
                if (!this.peekToken().equals("^")) {
                    this.throwException("^");
                }
                this.consumeToken();
                String dataType = this.consumeToken();
                return this.dataFactory.getOWLTypedConstant(lit, this.getDataType(dataType));
            }
            if (this.peekToken().equals("@")) {
                this.consumeToken();
                String lang = this.consumeToken();
                return this.dataFactory.getOWLUntypedConstant(lit, lang);
            }
            return this.dataFactory.getOWLUntypedConstant(lit);
        }
        try {
            int i = Integer.parseInt(tok);
            return this.dataFactory.getOWLTypedConstant(i);
        }
        catch (NumberFormatException e) {
            if (tok.endsWith("f")) {
                try {
                    float f = Float.parseFloat(tok);
                    return this.dataFactory.getOWLTypedConstant(f);
                }
                catch (NumberFormatException e2) {
                    // empty catch block
                }
            }
            try {
                double d = Double.parseDouble(tok);
                return this.dataFactory.getOWLTypedConstant(tok, this.dataFactory.getOWLDataType(XSDVocabulary.DOUBLE.getURI()));
            }
            catch (NumberFormatException numberFormatException) {
                if (tok.equals("true")) {
                    return this.dataFactory.getOWLTypedConstant(true);
                }
                if (tok.equals("false")) {
                    return this.dataFactory.getOWLTypedConstant(false);
                }
                this.throwException(false, false, false, false, false, "true", "false", "<integer>", "<float>", "<double>", "\"<Literal>\"", "\"<Literal>\"^^<datatype>", "\"<Literal>\"@<lang>");
                return null;
            }
        }
    }

    public int parseInteger() throws ParserException {
        String i = this.consumeToken();
        try {
            return Integer.parseInt(i);
        }
        catch (NumberFormatException e) {
            throw new ParserException(this.getToken().getToken(), this.getTokenPos(), this.getTokenRow(), true, this.getTokenCol());
        }
    }

    public String getLineCol() {
        return "Encountered " + this.getLastToken() + " at " + this.getTokenRow() + ":" + this.getTokenCol() + " ";
    }

    private OWLDescription parseNestedClassExpression(boolean lookaheadCheck) throws ParserException {
        String tok = this.peekToken();
        if (tok.equals("(")) {
            this.consumeToken();
            OWLDescription desc = this.parseIntersection();
            String closeBracket = this.consumeToken();
            if (!closeBracket.equals(")")) {
                this.throwException(")");
            }
            return desc;
        }
        if (tok.equals("{")) {
            return this.parseObjectOneOf();
        }
        if (this.isClassName(tok)) {
            String name = this.consumeToken();
            return this.getOWLClass(name);
        }
        if (!lookaheadCheck) {
            this.consumeToken();
            this.throwException(true, false, false, false, false, "(", "{");
        }
        return null;
    }

    public OWLDescription parseObjectOneOf() throws ParserException {
        String open = this.consumeToken();
        if (!open.equals("{")) {
            this.throwException("{");
        }
        String sep = ",";
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        while (sep.equals(",")) {
            OWLIndividual ind = this.parseIndividual();
            inds.add(ind);
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        String close = this.consumeToken();
        if (!close.equals("}")) {
            this.throwException("}", ",");
        }
        return this.dataFactory.getOWLObjectOneOf(inds);
    }

    public Set<OWLAxiom> parseFrames() throws ParserException {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        while (true) {
            String tok;
            if ((tok = this.peekToken()).equalsIgnoreCase(CLASS)) {
                axioms.addAll(this.parseClassFrame());
                continue;
            }
            if (tok.equalsIgnoreCase(OBJECT_PROPERTY)) {
                axioms.addAll(this.parseObjectPropertyFrame());
                continue;
            }
            if (tok.equalsIgnoreCase(DATA_PROPERTY)) {
                axioms.addAll(this.parseDataPropertyFrame());
                continue;
            }
            if (tok.equalsIgnoreCase(INDIVIDUAL)) {
                axioms.addAll(this.parseIndividualFrame());
                continue;
            }
            if (tok.equalsIgnoreCase(VALUE_PARTITION)) {
                this.parseValuePartitionFrame();
                continue;
            }
            if (tok.equals("<EOF>")) break;
            this.throwException(CLASS, OBJECT_PROPERTY, DATA_PROPERTY, INDIVIDUAL, VALUE_PARTITION);
        }
        return axioms;
    }

    public Set<OWLAnnotation> parseAnnotations() throws ParserException {
        HashSet<OWLAnnotation> annos = new HashSet<OWLAnnotation>();
        String header = this.consumeToken();
        if (!header.equals(ANNOTATIONS)) {
            this.throwException(ANNOTATIONS);
        }
        String sep = ",";
        while (sep.equals(",")) {
            OWLAnnotation<OWLIndividual> anno;
            String obj;
            String prop = this.consumeToken();
            if (!this.isAnnotationURI(prop)) {
                this.throwException(this.annotationURIs.toArray(new String[this.annotationURIs.size()]));
            }
            if (this.isIndividualName(obj = this.peekToken())) {
                OWLIndividual ind = this.parseIndividual();
                anno = this.dataFactory.getOWLObjectAnnotation(this.getAnnotationURI(prop), ind);
                annos.add(anno);
            } else {
                OWLConstant con = this.parseConstant();
                anno = null;
                URI annoURI = this.getAnnotationURI(prop);
                anno = annoURI.equals(OWLRDFVocabulary.RDFS_LABEL.getURI()) ? (con.isTyped() ? this.dataFactory.getOWLLabelAnnotation(con.getLiteral()) : (con.asOWLUntypedConstant().hasLang() ? this.dataFactory.getOWLLabelAnnotation(con.getLiteral(), con.asOWLUntypedConstant().getLang()) : this.dataFactory.getOWLLabelAnnotation(con.getLiteral()))) : this.dataFactory.getOWLConstantAnnotation(annoURI, con);
                annos.add(anno);
            }
            if (!(sep = this.peekToken()).equals(",")) continue;
            this.consumeToken();
        }
        return annos;
    }

    public Set<OWLAxiom> parseAnnotations(OWLEntity subject) throws ParserException {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        for (OWLAnnotation anno : this.parseAnnotations()) {
            axioms.add(this.dataFactory.getOWLEntityAnnotationAxiom(subject, anno));
        }
        return axioms;
    }

    public Set<OWLAxiom> parseClassFrame() throws ParserException {
        return this.parseClassFrame(false);
    }

    public Set<OWLAxiom> parseClassFrameEOF() throws ParserException {
        return this.parseClassFrame(true);
    }

    private Set<OWLAxiom> parseClassFrame(boolean eof) throws ParserException {
        String subj;
        String tok = this.consumeToken();
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        if (!tok.equalsIgnoreCase(CLASS)) {
            this.throwException(CLASS);
        }
        if (!this.isClassName(subj = this.consumeToken())) {
            this.throwException(true, false, false, false);
        }
        OWLClass cls = this.getOWLClass(subj);
        block0: while (true) {
            OWLDescription desc;
            Iterator<OWLDescription> i$;
            Set<OWLDescription> descs;
            String sect;
            if ((sect = this.peekToken()).equalsIgnoreCase(SUB_CLASS_OF)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                descs = this.parseDescriptionList();
                i$ = descs.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    desc = i$.next();
                    axioms.add(this.dataFactory.getOWLSubClassAxiom(cls, desc));
                }
            }
            if (sect.equalsIgnoreCase(EQUIVALENT_TO)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                descs = this.parseDescriptionList();
                i$ = descs.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    desc = i$.next();
                    axioms.add(this.dataFactory.getOWLEquivalentClassesAxiom(CollectionFactory.createSet(cls, desc)));
                }
            }
            if (sect.equalsIgnoreCase(DISJOINT_WITH)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                descs = this.parseDescriptionList();
                i$ = descs.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    desc = i$.next();
                    axioms.add(this.dataFactory.getOWLDisjointClassesAxiom((OWLDescription)cls, desc));
                }
            }
            if (sect.equalsIgnoreCase(DISJOINT_UNION_OF)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                descs = this.parseDescriptionList();
                axioms.add(this.dataFactory.getOWLDisjointUnionAxiom(cls, descs));
                continue;
            }
            if (sect.equals(ANNOTATIONS)) {
                this.potentialKeywords.clear();
                axioms.addAll(this.parseAnnotations(cls));
                continue;
            }
            if (!eof || sect.equals("<EOF>")) break;
            this.throwException(SUB_CLASS_OF, EQUIVALENT_TO, DISJOINT_WITH, ANNOTATIONS);
        }
        return axioms;
    }

    public Set<OWLAxiom> parseObjectPropertyFrame() throws ParserException {
        return this.parseObjectPropertyFrame(false);
    }

    public Set<OWLAxiom> parseObjectPropertyFrame(boolean eof) throws ParserException {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        OWLObjectPropertyExpression prop = null;
        String tok = this.consumeToken();
        if (!tok.equalsIgnoreCase(OBJECT_PROPERTY)) {
            this.throwException(OBJECT_PROPERTY);
        }
        String subj = this.peekToken();
        this.objectPropertyNames.add(subj);
        prop = this.parseObjectPropertyExpression();
        block0: while (true) {
            OWLObjectPropertyExpression pe;
            Iterator<OWLObject> i$;
            Collection<OWLObjectPropertyExpression> props;
            String sect;
            if ((sect = this.peekToken()).equalsIgnoreCase(SUB_PROPERTY_OF)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                props = this.parseObjectPropertyList();
                i$ = props.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    pe = i$.next();
                    axioms.add(this.dataFactory.getOWLSubObjectPropertyAxiom(prop, pe));
                }
            }
            if (sect.equalsIgnoreCase(EQUIVALENT_TO)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                props = this.parseObjectPropertyList();
                i$ = props.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    pe = i$.next();
                    axioms.add(this.dataFactory.getOWLEquivalentObjectPropertiesAxiom(CollectionFactory.createSet(prop, pe)));
                }
            }
            if (sect.equalsIgnoreCase(DISJOINT_WITH)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                props = this.parseObjectPropertyList();
                i$ = props.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    pe = i$.next();
                    axioms.add(this.dataFactory.getOWLDisjointObjectPropertiesAxiom(CollectionFactory.createSet(prop, pe)));
                }
            }
            if (sect.equalsIgnoreCase(DOMAIN)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                Set<OWLDescription> domains = this.parseDescriptionList();
                i$ = domains.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    OWLDescription dom = (OWLDescription)i$.next();
                    axioms.add(this.dataFactory.getOWLObjectPropertyDomainAxiom(prop, dom));
                }
            }
            if (sect.equalsIgnoreCase(RANGE)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                Set<OWLDescription> ranges = this.parseDescriptionList();
                i$ = ranges.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    OWLDescription rng = (OWLDescription)i$.next();
                    axioms.add(this.dataFactory.getOWLObjectPropertyRangeAxiom(prop, rng));
                }
            }
            if (sect.equalsIgnoreCase(INVERSES) || sect.equalsIgnoreCase(INVERSE_OF)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                Set<OWLObjectPropertyExpression> inverses = this.parseObjectPropertyList();
                i$ = inverses.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    OWLObjectPropertyExpression inv = (OWLObjectPropertyExpression)i$.next();
                    axioms.add(this.dataFactory.getOWLInverseObjectPropertiesAxiom(prop, inv));
                }
            }
            if (sect.equalsIgnoreCase(CHARACTERISTICS)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                axioms.addAll(this.parseObjectPropertyCharacteristicList(prop));
                continue;
            }
            if (sect.equalsIgnoreCase(ANNOTATIONS)) {
                this.potentialKeywords.clear();
                axioms.addAll(this.parseAnnotations(prop.asOWLObjectProperty()));
                continue;
            }
            if (sect.equalsIgnoreCase(SUB_PROPERTY_CHAIN)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                props = this.parseObjectPropertyChain();
                axioms.add(this.dataFactory.getOWLObjectPropertyChainSubPropertyAxiom((List<? extends OWLObjectPropertyExpression>)props, prop));
                continue;
            }
            if (!eof || sect.equals("<EOF>")) break;
            this.throwException(SUB_PROPERTY_OF, EQUIVALENT_TO, DISJOINT_WITH, ANNOTATIONS, DOMAIN, RANGE, INVERSES, CHARACTERISTICS, SUB_PROPERTY_CHAIN);
        }
        return axioms;
    }

    public Set<OWLAxiom> parseDataPropertyFrame() throws ParserException {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        String tok = this.consumeToken();
        if (!tok.equalsIgnoreCase(DATA_PROPERTY)) {
            this.throwException(DATA_PROPERTY);
        }
        String subj = this.consumeToken();
        this.dataPropertyNames.add(subj);
        OWLDataProperty prop = this.getOWLDataProperty(subj);
        block0: while (true) {
            OWLDataProperty pe;
            Iterator<OWLObject> i$;
            Set<OWLDataProperty> props;
            String sect;
            if ((sect = this.peekToken()).equalsIgnoreCase(SUB_PROPERTY_OF)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                props = this.parseDataPropertyList();
                i$ = props.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    pe = i$.next();
                    axioms.add(this.dataFactory.getOWLSubDataPropertyAxiom(prop, pe));
                }
            }
            if (sect.equalsIgnoreCase(EQUIVALENT_TO)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                props = this.parseDataPropertyList();
                i$ = props.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    pe = i$.next();
                    axioms.add(this.dataFactory.getOWLEquivalentDataPropertiesAxiom(CollectionFactory.createSet(prop, pe)));
                }
            }
            if (sect.equalsIgnoreCase(DISJOINT_WITH)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                props = this.parseDataPropertyList();
                i$ = props.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    pe = i$.next();
                    axioms.add(this.dataFactory.getOWLDisjointDataPropertiesAxiom(CollectionFactory.createSet(prop, pe)));
                }
            }
            if (sect.equalsIgnoreCase(DOMAIN)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                Set<OWLDescription> domains = this.parseDescriptionList();
                i$ = domains.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    OWLDescription dom = (OWLDescription)i$.next();
                    axioms.add(this.dataFactory.getOWLDataPropertyDomainAxiom(prop, dom));
                }
            }
            if (sect.equalsIgnoreCase(RANGE)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                Set<OWLDataRange> ranges = this.parseDataRangeList();
                i$ = ranges.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    OWLDataRange rng = (OWLDataRange)i$.next();
                    axioms.add(this.dataFactory.getOWLDataPropertyRangeAxiom(prop, rng));
                }
            }
            if (sect.equalsIgnoreCase(CHARACTERISTICS)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                String characteristic = this.consumeToken();
                if (!characteristic.equals(FUNCTIONAL)) {
                    this.throwException(FUNCTIONAL);
                }
                axioms.add(this.dataFactory.getOWLFunctionalDataPropertyAxiom(prop));
                continue;
            }
            if (!sect.equalsIgnoreCase(ANNOTATIONS)) break;
            this.potentialKeywords.clear();
            axioms.addAll(this.parseAnnotations(prop));
        }
        return axioms;
    }

    public Set<OWLAxiom> parseIndividualFrame() throws ParserException {
        String tok = this.consumeToken();
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        if (!tok.equalsIgnoreCase(INDIVIDUAL)) {
            this.throwException(INDIVIDUAL);
        }
        String subj = this.consumeToken();
        OWLIndividual ind = this.getOWLIndividual(subj);
        block2: while (true) {
            Set<OWLIndividual> inds;
            String sect;
            if ((sect = this.peekToken()).equalsIgnoreCase(TYPES)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                Set<OWLDescription> descs = this.parseDescriptionList();
                Iterator<OWLDescription> i$ = descs.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block2;
                    OWLDescription desc = i$.next();
                    axioms.add(this.dataFactory.getOWLClassAssertionAxiom(ind, desc));
                }
            }
            if (sect.equalsIgnoreCase(FACTS)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                String sep = ",";
                while (true) {
                    OWLPropertyExpression<OWLDataPropertyExpression, OWLDataRange> p;
                    String prop;
                    if (!sep.equals(",")) continue block2;
                    boolean negative = false;
                    if (this.peekToken().equals(NOT)) {
                        this.consumeToken();
                        negative = true;
                    }
                    if (this.isDataPropertyName(prop = this.peekToken())) {
                        p = this.parseDataProperty();
                        OWLConstant con = this.parseConstant();
                        if (!negative) {
                            axioms.add(this.dataFactory.getOWLDataPropertyAssertionAxiom(ind, (OWLDataPropertyExpression)p, con));
                        } else {
                            axioms.add(this.dataFactory.getOWLNegativeDataPropertyAssertionAxiom(ind, (OWLDataPropertyExpression)p, con));
                        }
                    } else if (this.isObjectPropertyName(prop)) {
                        p = this.parseObjectPropertyExpression();
                        OWLIndividual obj = this.parseIndividual();
                        if (!negative) {
                            axioms.add(this.dataFactory.getOWLObjectPropertyAssertionAxiom(ind, (OWLObjectPropertyExpression)p, obj));
                        } else {
                            axioms.add(this.dataFactory.getOWLNegativeObjectPropertyAssertionAxiom(ind, (OWLObjectPropertyExpression)p, obj));
                        }
                    } else if (this.isAnnotationURI(prop)) {
                        OWLAnnotation<OWLIndividual> annotation;
                        URI annotationURI = this.getAnnotationURI(prop);
                        String object = this.peekToken();
                        if (this.individualNames.contains(object)) {
                            annotation = this.dataFactory.getOWLObjectAnnotation(annotationURI, this.getOWLIndividual(object));
                        } else {
                            OWLConstant con = null;
                            try {
                                con = this.parseConstant();
                            }
                            catch (ParserException e) {
                                this.throwException(e.isClassNameExpected(), e.isObjectPropertyNameExpected(), e.isDataPropertyNameExpected(), true, e.isDatatypeNameExpected(), e.getExpectedKeywords().toArray(new String[e.getExpectedKeywords().size()]));
                            }
                            annotation = this.dataFactory.getOWLConstantAnnotation(annotationURI, con);
                        }
                        axioms.add(this.dataFactory.getOWLEntityAnnotationAxiom(ind, annotation));
                    } else {
                        this.consumeToken();
                        this.throwException(false, true, true, false, false, ",");
                    }
                    if (!(sep = this.peekToken()).equals(",")) continue;
                    this.consumeToken();
                }
            }
            if (sect.equalsIgnoreCase(SAME_AS)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                inds = this.parseIndividualList();
                inds.add(ind);
                axioms.add(this.dataFactory.getOWLSameIndividualsAxiom(inds));
                continue;
            }
            if (sect.equalsIgnoreCase(DIFFERENT_FROM)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                inds = this.parseIndividualList();
                inds.add(ind);
                axioms.add(this.dataFactory.getOWLDifferentIndividualsAxiom(inds));
                continue;
            }
            if (!sect.equalsIgnoreCase(ANNOTATIONS)) break;
            this.potentialKeywords.clear();
            axioms.addAll(this.parseAnnotations(ind));
        }
        return axioms;
    }

    public Set<OWLAxiom> parseValuePartitionFrame() throws ParserException {
        OWLClass cls;
        String section = this.consumeToken();
        if (!section.equalsIgnoreCase(VALUE_PARTITION)) {
            this.throwException(VALUE_PARTITION);
        }
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
        String clsName = this.consumeToken();
        if (clsName.equals("<EOF>")) {
            this.throwException(false, true, false, false, false, new String[0]);
        }
        if ((cls = this.getOWLClass(clsName)) == null) {
            this.throwException(true, false, false, false);
        }
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.parseValuePartitionValues(cls));
        axioms.add(this.dataFactory.getOWLFunctionalObjectPropertyAxiom(prop));
        axioms.add(this.dataFactory.getOWLObjectPropertyRangeAxiom(prop, cls));
        return axioms;
    }

    public Set<OWLAxiom> parseValuePartitionValues(OWLClass superclass) throws ParserException {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        HashSet<OWLClass> siblings = new HashSet<OWLClass>();
        String sep = ",";
        String open = this.consumeToken();
        if (!open.equals("[")) {
            this.throwException("[");
        }
        while (sep.equals(",")) {
            String clsName = this.consumeToken();
            OWLClass cls = this.getOWLClass(clsName);
            if (cls == null) {
                this.throwException(true, false, false, false);
            }
            siblings.add(cls);
            axioms.add(this.getDataFactory().getOWLSubClassAxiom(cls, superclass));
            if (this.peekToken().equals("[")) {
                axioms.addAll(this.parseValuePartitionValues(cls));
            }
            if (!(sep = this.peekToken()).equals(",")) continue;
            this.consumeToken();
        }
        String close = this.consumeToken();
        if (!close.equals("]")) {
            this.throwException("]");
        }
        axioms.add(this.getDataFactory().getOWLDisjointClassesAxiom(siblings));
        return axioms;
    }

    public OWLDisjointClassesAxiom parseDisjointClasses() throws ParserException {
        String section = this.consumeToken();
        if (!section.equalsIgnoreCase(DISJOINT_CLASSES)) {
            this.throwException(DISJOINT_CLASSES);
        }
        Set<OWLDescription> descriptions = this.parseDescriptionList();
        return this.getDataFactory().getOWLDisjointClassesAxiom(descriptions);
    }

    public OWLSameIndividualsAxiom parseSameIndividual() throws ParserException {
        String section = this.consumeToken();
        if (!section.equalsIgnoreCase(SAME_INDIVIDUAL)) {
            this.throwException(SAME_INDIVIDUAL);
        }
        Set<OWLIndividual> individuals = this.parseIndividualList();
        return this.getDataFactory().getOWLSameIndividualsAxiom(individuals);
    }

    public OWLDisjointObjectPropertiesAxiom parseDisjointObjectProperties() throws ParserException {
        String section = this.consumeToken();
        if (!section.equalsIgnoreCase(DISJOINT_OBJECT_PROPERTIES)) {
            this.throwException(DISJOINT_OBJECT_PROPERTIES);
        }
        Set<OWLObjectPropertyExpression> props = this.parseObjectPropertyList();
        return this.getDataFactory().getOWLDisjointObjectPropertiesAxiom(props);
    }

    public OWLDisjointDataPropertiesAxiom parseDisjointDataProperties() throws ParserException {
        String section = this.consumeToken();
        if (!section.equalsIgnoreCase(DISJOINT_DATA_PROPERTIES)) {
            this.throwException(DISJOINT_DATA_PROPERTIES);
        }
        Set<OWLDataProperty> props = this.parseDataPropertyList();
        return this.getDataFactory().getOWLDisjointDataPropertiesAxiom(props);
    }

    public OWLDifferentIndividualsAxiom parseDifferentIndividuals() throws ParserException {
        String section = this.consumeToken();
        if (!section.equalsIgnoreCase(DIFFERENT_INDIVIDUALS)) {
            this.throwException(DIFFERENT_INDIVIDUALS);
        }
        Set<OWLIndividual> props = this.parseIndividualList();
        return this.getDataFactory().getOWLDifferentIndividualsAxiom(props);
    }

    public Set<OWLAxiom> parseObjectPropertyCharacteristicList(OWLObjectPropertyExpression prop) throws ParserException {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        String sep = ",";
        while (sep.equals(",")) {
            String characteristic = this.consumeToken();
            if (characteristic.equalsIgnoreCase(FUNCTIONAL)) {
                axioms.add(this.dataFactory.getOWLFunctionalObjectPropertyAxiom(prop));
            } else if (characteristic.equalsIgnoreCase(INVERSE_FUNCTIONAL)) {
                axioms.add(this.dataFactory.getOWLInverseFunctionalObjectPropertyAxiom(prop));
            } else if (characteristic.equalsIgnoreCase(SYMMETRIC)) {
                axioms.add(this.dataFactory.getOWLSymmetricObjectPropertyAxiom(prop));
            } else if (characteristic.equalsIgnoreCase(ANTI_SYMMETRIC) || characteristic.equalsIgnoreCase(ASYMMETRIC)) {
                axioms.add(this.dataFactory.getOWLAntiSymmetricObjectPropertyAxiom(prop));
            } else if (characteristic.equalsIgnoreCase(TRANSITIVE)) {
                axioms.add(this.dataFactory.getOWLTransitiveObjectPropertyAxiom(prop));
            } else if (characteristic.equalsIgnoreCase(REFLEXIVE)) {
                axioms.add(this.dataFactory.getOWLReflexiveObjectPropertyAxiom(prop));
            } else if (characteristic.equalsIgnoreCase(IRREFLEXIVE)) {
                axioms.add(this.dataFactory.getOWLIrreflexiveObjectPropertyAxiom(prop));
            } else {
                this.throwException(FUNCTIONAL, INVERSE_FUNCTIONAL, SYMMETRIC, ANTI_SYMMETRIC, TRANSITIVE, REFLEXIVE, IRREFLEXIVE);
            }
            if (!(sep = this.peekToken()).equals(",")) continue;
            sep = this.consumeToken();
        }
        return axioms;
    }

    public Set<OWLDescription> parseDescriptionList() throws ParserException {
        HashSet<OWLDescription> descs = new HashSet<OWLDescription>();
        String sep = ",";
        while (sep.equals(",")) {
            this.potentialKeywords.remove(",");
            descs.add(this.parseIntersection());
            this.potentialKeywords.add(",");
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            sep = this.consumeToken();
        }
        return descs;
    }

    public Set<OWLDescription> parseDescriptionList(String expectedOpen, String expectedClose) throws ParserException {
        String open = this.consumeToken();
        HashSet<OWLDescription> descs = new HashSet<OWLDescription>();
        if (!open.equals(expectedOpen)) {
            this.throwException(expectedOpen);
        }
        String sep = ",";
        while (sep.equals(",")) {
            this.potentialKeywords.remove(",");
            OWLDescription desc = this.parseIntersection();
            this.potentialKeywords.add(",");
            descs.add(desc);
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            sep = this.consumeToken();
        }
        String close = this.consumeToken();
        if (!close.equals(expectedClose)) {
            this.throwException(expectedClose);
        }
        return descs;
    }

    public Set<OWLDataProperty> parseDataPropertyList() throws ParserException {
        HashSet<OWLDataProperty> props = new HashSet<OWLDataProperty>();
        String sep = ",";
        while (sep.equals(",")) {
            sep = this.peekToken();
            OWLDataProperty prop = this.parseDataProperty();
            props.add(prop);
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        return props;
    }

    public Set<OWLObjectPropertyExpression> parseObjectPropertyList() throws ParserException {
        HashSet<OWLObjectPropertyExpression> props = new HashSet<OWLObjectPropertyExpression>();
        String sep = ",";
        while (sep.equals(",")) {
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            props.add(prop);
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        return props;
    }

    public Set<OWLIndividual> parseIndividualList() throws ParserException {
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        String sep = ",";
        while (sep.equals(",")) {
            inds.add(this.parseIndividual());
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        return inds;
    }

    public List<OWLObjectPropertyExpression> parseObjectPropertyChain() throws ParserException {
        String delim = "o";
        ArrayList<OWLObjectPropertyExpression> properties = new ArrayList<OWLObjectPropertyExpression>();
        while (delim.equals("o")) {
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            properties.add(prop);
            delim = this.peekToken();
            if (!delim.equals("o")) continue;
            this.consumeToken();
        }
        return properties;
    }

    public OWLObjectPropertyChainSubPropertyAxiom parsePropertyChainSubPropertyAxiom() throws ParserException {
        List<OWLObjectPropertyExpression> props = this.parseObjectPropertyChain();
        String imp = this.consumeToken() + this.consumeToken();
        if (!imp.equals("->")) {
            this.throwException("->", "o");
        }
        OWLObjectPropertyExpression superProp = this.parseObjectPropertyExpression();
        return this.dataFactory.getOWLObjectPropertyChainSubPropertyAxiom(props, superProp);
    }

    public OWLClassAxiom parseClassAxiom() throws ParserException {
        OWLDescription lhs = this.parseIntersection();
        String kw = this.consumeToken();
        if (kw.equalsIgnoreCase(ManchesterOWLSyntax.SUBCLASS_OF.toString())) {
            OWLDescription rhs = this.parseIntersection();
            return this.dataFactory.getOWLSubClassAxiom(lhs, rhs);
        }
        if (kw.equalsIgnoreCase(ManchesterOWLSyntax.EQUIVALENT_TO.toString())) {
            OWLDescription rhs = this.parseIntersection();
            return this.dataFactory.getOWLEquivalentClassesAxiom(lhs, rhs);
        }
        if (kw.equalsIgnoreCase(ManchesterOWLSyntax.DISJOINT_WITH.toString())) {
            OWLDescription rhs = this.parseIntersection();
            return this.dataFactory.getOWLDisjointClassesAxiom(lhs, rhs);
        }
        this.throwException(ManchesterOWLSyntax.SUBCLASS_OF.toString(), ManchesterOWLSyntax.EQUIVALENT_TO.toString(), ManchesterOWLSyntax.DISJOINT_WITH.toString());
        return null;
    }

    public OWLObjectPropertyAxiom parseObjectPropertyAxiom() throws ParserException {
        String tok = this.peekToken();
        if (tok.equals((Object)ManchesterOWLSyntax.FUNCTIONAL)) {
            this.consumeToken();
            String open = this.consumeToken();
            if (!open.equals("(")) {
                this.throwException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.consumeToken();
            if (!close.equals(")")) {
                this.throwException(")");
            }
            return this.dataFactory.getOWLFunctionalObjectPropertyAxiom(prop);
        }
        if (tok.equals((Object)ManchesterOWLSyntax.INVERSE_FUNCTIONAL)) {
            this.consumeToken();
            String open = this.consumeToken();
            if (!open.equals("(")) {
                this.throwException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.consumeToken();
            if (!close.equals(")")) {
                this.throwException(")");
            }
            return this.dataFactory.getOWLInverseFunctionalObjectPropertyAxiom(prop);
        }
        if (tok.equals((Object)ManchesterOWLSyntax.TRANSITIVE)) {
            this.consumeToken();
            String open = this.consumeToken();
            if (!open.equals("(")) {
                this.throwException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.consumeToken();
            if (!close.equals(")")) {
                this.throwException(")");
            }
            return this.dataFactory.getOWLTransitiveObjectPropertyAxiom(prop);
        }
        if (tok.equals((Object)ManchesterOWLSyntax.SYMMETRIC)) {
            this.consumeToken();
            String open = this.consumeToken();
            if (!open.equals("(")) {
                this.throwException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.consumeToken();
            if (!close.equals(")")) {
                this.throwException(")");
            }
            return this.dataFactory.getOWLSymmetricObjectPropertyAxiom(prop);
        }
        if (tok.equals((Object)ManchesterOWLSyntax.REFLEXIVE)) {
            this.consumeToken();
            String open = this.consumeToken();
            if (!open.equals("(")) {
                this.throwException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.consumeToken();
            if (!close.equals(")")) {
                this.throwException(")");
            }
            return this.dataFactory.getOWLReflexiveObjectPropertyAxiom(prop);
        }
        if (tok.equals((Object)ManchesterOWLSyntax.IRREFLEXIVE)) {
            this.consumeToken();
            String open = this.consumeToken();
            if (!open.equals("(")) {
                this.throwException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.consumeToken();
            if (!close.equals(")")) {
                this.throwException(")");
            }
            return this.dataFactory.getOWLIrreflexiveObjectPropertyAxiom(prop);
        }
        if (tok.equals((Object)ManchesterOWLSyntax.ANTI_SYMMETRIC)) {
            this.consumeToken();
            String open = this.consumeToken();
            if (!open.equals("(")) {
                this.throwException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.consumeToken();
            if (!close.equals(")")) {
                this.throwException(")");
            }
            return this.dataFactory.getOWLAntiSymmetricObjectPropertyAxiom(prop);
        }
        return null;
    }

    public OWLIndividual parseIndividual() throws ParserException {
        String name = this.consumeToken();
        if (!this.isIndividualName(name)) {
            this.throwException(false, false, false, true);
        }
        return this.getOWLIndividual(name);
    }

    public OWLIndividual parseIndividual(boolean defined) throws ParserException {
        String name = this.consumeToken();
        if (defined && !this.isIndividualName(name)) {
            this.throwException(false, false, false, true);
        }
        return this.getOWLIndividual(name);
    }

    public OWLDataProperty parseDataProperty() throws ParserException {
        String name = this.consumeToken();
        if (!this.isDataPropertyName(name)) {
            this.throwException(false, false, true, false);
        }
        return this.getOWLDataProperty(name);
    }

    public Map<String, URI> parseNamespace() throws ParserException {
        String nsTok = this.consumeToken();
        if (!nsTok.equals(NAMESPACE)) {
            this.throwException(NAMESPACE);
        }
        String tok = this.peekToken();
        HashMap<String, URI> map = new HashMap<String, URI>(2);
        if (tok.startsWith("<")) {
            URI uri = this.parseURI();
            map.put("", uri);
        } else {
            String prefix = this.consumeToken();
            String delim = this.peekToken();
            if (delim.equals("=")) {
                this.consumeToken();
            }
            URI uri = this.parseURI();
            map.put(tok, uri);
        }
        return map;
    }

    public OWLImportsDeclaration parseImportsDeclaration(OWLOntology ont) throws ParserException {
        String section = this.consumeToken();
        if (!section.equalsIgnoreCase(IMPORT)) {
            this.throwException(IMPORT);
        }
        URI importedOntologyURI = this.parseURI();
        return this.dataFactory.getOWLImportsDeclarationAxiom(ont, importedOntologyURI);
    }

    public URI parseURI() throws ParserException {
        String open = this.consumeToken();
        if (!open.equals("<")) {
            this.throwException("<");
        }
        String uri = this.consumeToken();
        String close = this.consumeToken();
        if (!close.equals(">")) {
            this.throwException(">");
        }
        return URI.create(uri);
    }

    private void processDeclaredEntities() {
        for (int i = 0; i < this.tokens.size(); ++i) {
            ManchesterOWLSyntaxTokenizer.Token tok = this.tokens.get(i);
            if (tok.getToken().equals(CLASS)) {
                if (i + 1 >= this.tokens.size()) continue;
                this.classNames.add(this.tokens.get(i + 1).getToken());
                continue;
            }
            if (tok.getToken().equals(OBJECT_PROPERTY)) {
                if (i + 1 >= this.tokens.size()) continue;
                this.objectPropertyNames.add(this.tokens.get(i + 1).getToken());
                continue;
            }
            if (tok.getToken().equals(DATA_PROPERTY)) {
                if (i + 1 >= this.tokens.size()) continue;
                this.dataPropertyNames.add(this.tokens.get(i + 1).getToken());
                continue;
            }
            if (tok.getToken().equals(INDIVIDUAL)) {
                if (i + 1 >= this.tokens.size()) continue;
                this.individualNames.add(this.tokens.get(i + 1).getToken());
                continue;
            }
            if (!tok.getToken().equals(VALUE_PARTITION)) continue;
            if (i + 1 < this.tokens.size()) {
                this.objectPropertyNames.add(this.tokens.get(i + 1).getToken());
            }
            if (i + 2 >= this.tokens.size()) continue;
            this.classNames.add(this.tokens.get(i + 2).getToken());
        }
    }

    private static void addNamesToSet(String buffer, String sectionName, Set<String> names) {
        Pattern p = Pattern.compile("(" + sectionName + "\\s*)(\\S*)");
        Matcher matcher = p.matcher(buffer);
        while (matcher.find()) {
            names.add(matcher.group(2));
        }
    }

    public void parseOntology(OWLOntologyManager manager, OWLOntology ont) throws ParserException, OWLOntologyCreationException, OWLOntologyChangeException {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        URI ontologyURI = null;
        this.processDeclaredEntities();
        block0: while (true) {
            Iterator<Object> i$;
            String section = this.peekToken();
            if (ontologyURI == null && section.equals(ONTOLOGY)) {
                this.consumeToken();
                ontologyURI = this.parseURI();
                this.setBase(ontologyURI + "#");
                block1: while (true) {
                    if (!this.peekToken().equals(ANNOTATIONS)) continue block0;
                    Set<OWLAnnotation> annos = this.parseAnnotations();
                    i$ = annos.iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block1;
                        OWLAnnotation anno = i$.next();
                        axioms.add(this.dataFactory.getOWLOntologyAnnotationAxiom(ont, anno));
                    }
                    break;
                }
            }
            if (section.equalsIgnoreCase(CLASS)) {
                axioms.addAll(this.parseClassFrame());
                continue;
            }
            if (section.equalsIgnoreCase(OBJECT_PROPERTY)) {
                axioms.addAll(this.parseObjectPropertyFrame());
                continue;
            }
            if (section.equalsIgnoreCase(DATA_PROPERTY)) {
                axioms.addAll(this.parseDataPropertyFrame());
                continue;
            }
            if (section.equalsIgnoreCase(INDIVIDUAL)) {
                axioms.addAll(this.parseIndividualFrame());
                continue;
            }
            if (section.equalsIgnoreCase(VALUE_PARTITION)) {
                axioms.addAll(this.parseValuePartitionFrame());
                continue;
            }
            if (section.equalsIgnoreCase(IMPORT)) {
                OWLImportsDeclaration decl = this.parseImportsDeclaration(ont);
                axioms.add(decl);
                manager.makeLoadImportRequest(decl);
                continue;
            }
            if (section.equalsIgnoreCase(NAMESPACE)) {
                Map<String, URI> nsMap = this.parseNamespace();
                i$ = nsMap.keySet().iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    String ns = (String)i$.next();
                    this.namespaceMap.put(ns, nsMap.get(ns).toString());
                }
            }
            if (section.equalsIgnoreCase(DISJOINT_CLASSES)) {
                axioms.add(this.parseDisjointClasses());
                continue;
            }
            if (section.equalsIgnoreCase(DISJOINT_OBJECT_PROPERTIES)) {
                axioms.add(this.parseDisjointObjectProperties());
                continue;
            }
            if (section.equalsIgnoreCase(DISJOINT_DATA_PROPERTIES)) {
                axioms.add(this.parseDisjointDataProperties());
                continue;
            }
            if (section.equalsIgnoreCase(DIFFERENT_INDIVIDUALS)) {
                axioms.add(this.parseDifferentIndividuals());
                continue;
            }
            if (section.equalsIgnoreCase(SAME_INDIVIDUAL)) {
                axioms.add(this.parseSameIndividual());
                continue;
            }
            if (section.equals("<EOF>")) break;
            this.consumeToken();
            this.throwException(CLASS, OBJECT_PROPERTY, DATA_PROPERTY, INDIVIDUAL, IMPORT, VALUE_PARTITION, NAMESPACE, DISJOINT_CLASSES, DISJOINT_OBJECT_PROPERTIES, DISJOINT_DATA_PROPERTIES, DIFFERENT_INDIVIDUALS, SAME_INDIVIDUAL);
        }
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>(axioms.size());
        for (OWLAxiom ax : axioms) {
            changes.add(new AddAxiom(ont, ax));
        }
        changes.add(new SetOntologyURI(ont, ontologyURI));
        manager.applyChanges(changes);
    }

    protected void throwException(String ... keywords) throws ParserException {
        HashSet<String> theKeywords = new HashSet<String>();
        theKeywords.addAll(Arrays.asList(keywords));
        theKeywords.addAll(this.potentialKeywords);
        this.potentialKeywords.clear();
        ManchesterOWLSyntaxTokenizer.Token lastToken = this.getLastToken();
        throw new ParserException(lastToken.getToken(), lastToken.getPos(), lastToken.getRow(), lastToken.getCol(), false, false, false, false, false, theKeywords);
    }

    protected void throwException(boolean classNameExpected, boolean objectPropertyNameExpected, boolean dataPropertyNameExpected, boolean individualNameExpected, boolean datatypeNameExpected, String ... keywords) throws ParserException {
        HashSet<String> theKeywords = new HashSet<String>();
        theKeywords.addAll(Arrays.asList(keywords));
        if (objectPropertyNameExpected) {
            theKeywords.add(INV);
        }
        theKeywords.addAll(this.potentialKeywords);
        this.potentialKeywords.clear();
        ManchesterOWLSyntaxTokenizer.Token lastToken = this.getLastToken();
        throw new ParserException(lastToken.getToken(), lastToken.getPos(), lastToken.getRow(), lastToken.getCol(), classNameExpected, objectPropertyNameExpected, dataPropertyNameExpected, individualNameExpected, datatypeNameExpected, theKeywords);
    }

    protected void throwException(boolean classNameExpected, boolean objectPropertyNameExpected, boolean dataPropertyNameExpected, boolean individualNameExpected) throws ParserException {
        HashSet<String> keywords = new HashSet<String>();
        if (objectPropertyNameExpected) {
            keywords.add(INV);
        }
        keywords.addAll(this.potentialKeywords);
        this.potentialKeywords.clear();
        ManchesterOWLSyntaxTokenizer.Token lastToken = this.getLastToken();
        throw new ParserException(lastToken.getToken(), lastToken.getPos(), lastToken.getRow(), lastToken.getCol(), classNameExpected, objectPropertyNameExpected, dataPropertyNameExpected, individualNameExpected, false, keywords);
    }

    public URI getURI(String name) {
        String prefix;
        String ns;
        URI uri = this.nameURIMap.get(name);
        if (uri != null) {
            return uri;
        }
        int colonIndex = name.indexOf(58);
        if (colonIndex != -1 && (ns = this.namespaceMap.get(prefix = name.substring(0, colonIndex))) != null) {
            uri = URI.create(ns + name.substring(colonIndex + 1, name.length()));
            this.nameURIMap.put(name, uri);
            return uri;
        }
        uri = URI.create(this.base + name);
        this.nameURIMap.put(name, uri);
        return uri;
    }

    private class DefaultEntityChecker
    implements OWLEntityChecker {
        private Map<String, OWLDataType> dataTypeNameMap = new HashMap<String, OWLDataType>();

        public DefaultEntityChecker() {
            for (XSDVocabulary v : XSDVocabulary.values()) {
                this.dataTypeNameMap.put(v.getURI().getFragment(), ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDataType(v.getURI()));
                this.dataTypeNameMap.put("xsd:" + v.getURI().getFragment(), ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDataType(v.getURI()));
            }
        }

        public OWLClass getOWLClass(String name) {
            if (name.equals("Thing") || name.equals("owl:Thing")) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLThing();
            }
            if (name.equals("Nothing") || name.equals("owl:Nothing")) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLNothing();
            }
            if (ManchesterOWLSyntaxEditorParser.this.classNames.contains(name)) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLClass(ManchesterOWLSyntaxEditorParser.this.getURI(name));
            }
            return null;
        }

        public OWLObjectProperty getOWLObjectProperty(String name) {
            if (ManchesterOWLSyntaxEditorParser.this.objectPropertyNames.contains(name)) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLObjectProperty(ManchesterOWLSyntaxEditorParser.this.getURI(name));
            }
            return null;
        }

        public OWLDataProperty getOWLDataProperty(String name) {
            if (ManchesterOWLSyntaxEditorParser.this.dataPropertyNames.contains(name)) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDataProperty(ManchesterOWLSyntaxEditorParser.this.getURI(name));
            }
            return null;
        }

        public OWLIndividual getOWLIndividual(String name) {
            if (ManchesterOWLSyntaxEditorParser.this.individualNames.contains(name)) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLIndividual(ManchesterOWLSyntaxEditorParser.this.getURI(name));
            }
            return null;
        }

        public OWLDataType getOWLDataType(String name) {
            return this.dataTypeNameMap.get(name);
        }
    }
}

