/*
 * Decompiled with CFR 0.152.
 */
package org.coode.obo.parser;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.coode.obo.parser.AntiSymmetricHandler;
import org.coode.obo.parser.DefaultNamespaceTagValueHandler;
import org.coode.obo.parser.DisjointFromHandler;
import org.coode.obo.parser.IDTagValueHandler;
import org.coode.obo.parser.IntersectionOfHandler;
import org.coode.obo.parser.InverseHandler;
import org.coode.obo.parser.IsATagValueHandler;
import org.coode.obo.parser.NameTagValueHandler;
import org.coode.obo.parser.OBOParserHandler;
import org.coode.obo.parser.OBOVocabulary;
import org.coode.obo.parser.PartOfTagValueHandler;
import org.coode.obo.parser.ReflexiveHandler;
import org.coode.obo.parser.RelationshipTagValueHandler;
import org.coode.obo.parser.SymmetricTagValueHandler;
import org.coode.obo.parser.TagValueHandler;
import org.coode.obo.parser.TransitiveOverHandler;
import org.coode.obo.parser.TransitiveTagValueHandler;
import org.coode.obo.parser.UnionOfHandler;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.util.CollectionFactory;

public class OBOConsumer
implements OBOParserHandler {
    private static final Logger logger = Logger.getLogger(OBOConsumer.class.getName());
    private OWLOntologyManager owlOntologyManager;
    private OWLOntology ontology;
    private boolean inHeader;
    private String currentId;
    private Map<String, TagValueHandler> handlerMap;
    private String defaultNamespace;
    private String currentNamespace;
    private String stanzaType;
    private boolean termType;
    private boolean typedefType;
    private boolean instanceType;
    private Set<OWLDescription> intersectionOfOperands;
    private Set<OWLDescription> unionOfOperands;
    private Map<String, URI> uriCache;

    public OBOConsumer(OWLOntologyManager owlOntologyManager, OWLOntology ontology) {
        this.owlOntologyManager = owlOntologyManager;
        this.ontology = ontology;
        this.defaultNamespace = "http://purl.org/obo/owl";
        this.intersectionOfOperands = new HashSet<OWLDescription>();
        this.unionOfOperands = new HashSet<OWLDescription>();
        this.uriCache = new HashMap<String, URI>();
        this.loadBuiltinURIs();
        this.setupTagHandlers();
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.owlOntologyManager;
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public String getCurrentId() {
        return this.currentId;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public String getCurrentNamespace() {
        return this.currentNamespace;
    }

    public void setCurrentNamespace(String currentNamespace) {
        this.currentNamespace = currentNamespace;
    }

    public void setCurrentId(String currentId) {
        this.currentId = currentId;
    }

    public void addUnionOfOperand(OWLDescription description) {
        this.unionOfOperands.add(description);
    }

    public void addIntersectionOfOperand(OWLDescription description) {
        this.intersectionOfOperands.add(description);
    }

    public String getStanzaType() {
        return this.stanzaType;
    }

    public boolean isTerm() {
        return this.termType;
    }

    public boolean isTypedef() {
        return this.typedefType;
    }

    public boolean isInstanceType() {
        return this.instanceType;
    }

    private void loadBuiltinURIs() {
        for (OBOVocabulary v : OBOVocabulary.values()) {
            this.uriCache.put(v.getName(), v.getURI());
        }
    }

    private void setupTagHandlers() {
        this.handlerMap = new HashMap<String, TagValueHandler>();
        this.addTagHandler(new IDTagValueHandler(this));
        this.addTagHandler(new NameTagValueHandler(this));
        this.addTagHandler(new IsATagValueHandler(this));
        this.addTagHandler(new PartOfTagValueHandler(this));
        this.addTagHandler(new TransitiveTagValueHandler(this));
        this.addTagHandler(new SymmetricTagValueHandler(this));
        this.addTagHandler(new RelationshipTagValueHandler(this));
        this.addTagHandler(new UnionOfHandler(this));
        this.addTagHandler(new IntersectionOfHandler(this));
        this.addTagHandler(new DisjointFromHandler(this));
        this.addTagHandler(new AntiSymmetricHandler(this));
        this.addTagHandler(new InverseHandler(this));
        this.addTagHandler(new ReflexiveHandler(this));
        this.addTagHandler(new TransitiveOverHandler(this));
        this.addTagHandler(new DefaultNamespaceTagValueHandler(this));
    }

    private void addTagHandler(TagValueHandler handler) {
        this.handlerMap.put(handler.getTag(), handler);
    }

    public void startHeader() {
        this.inHeader = true;
    }

    public void endHeader() {
        this.inHeader = false;
    }

    public void startStanza(String name) {
        this.currentId = null;
        this.currentNamespace = null;
        this.stanzaType = name;
        this.termType = this.stanzaType.equals("Term");
        this.typedefType = false;
        this.instanceType = false;
        if (!this.termType) {
            this.typedefType = this.stanzaType.equals("Typedef");
            if (!this.typedefType) {
                this.instanceType = this.stanzaType.equals("Instance");
            }
        }
    }

    public void endStanza() {
        if (!this.unionOfOperands.isEmpty()) {
            this.createUnionEquivalentClass();
            this.unionOfOperands.clear();
        }
        if (!this.intersectionOfOperands.isEmpty()) {
            this.createIntersectionEquivalentClass();
            this.intersectionOfOperands.clear();
        }
    }

    private void createUnionEquivalentClass() {
        OWLDescription equivalentClass = this.unionOfOperands.size() == 1 ? this.unionOfOperands.iterator().next() : this.getDataFactory().getOWLObjectUnionOf(this.unionOfOperands);
        this.createEquivalentClass(equivalentClass);
    }

    private void createIntersectionEquivalentClass() {
        OWLDescription equivalentClass = this.intersectionOfOperands.size() == 1 ? this.intersectionOfOperands.iterator().next() : this.getDataFactory().getOWLObjectIntersectionOf(this.intersectionOfOperands);
        this.createEquivalentClass(equivalentClass);
    }

    private void createEquivalentClass(OWLDescription description) {
        OWLEquivalentClassesAxiom ax = this.getDataFactory().getOWLEquivalentClassesAxiom(CollectionFactory.createSet(this.getCurrentClass(), description));
        try {
            this.getOWLOntologyManager().applyChange(new AddAxiom(this.ontology, ax));
        }
        catch (OWLOntologyChangeException e) {
            logger.severe(e.getMessage());
        }
    }

    public void handleTagValue(String tag, String value) {
        try {
            TagValueHandler handler = this.handlerMap.get(tag);
            if (handler != null) {
                handler.handle(this.currentId, value);
            } else if (this.inHeader) {
                if (tag.equals("import")) {
                    try {
                        URI uri = URI.create(value.trim());
                        OWLImportsDeclaration decl = this.owlOntologyManager.getOWLDataFactory().getOWLImportsDeclarationAxiom(this.ontology, uri);
                        this.owlOntologyManager.makeLoadImportRequest(decl);
                        this.owlOntologyManager.applyChange(new AddAxiom(this.ontology, decl));
                    }
                    catch (OWLOntologyCreationException e) {
                        e.printStackTrace();
                    }
                } else {
                    OWLUntypedConstant con = this.getDataFactory().getOWLUntypedConstant(value);
                    OWLConstantAnnotation anno = this.getDataFactory().getOWLConstantAnnotation(this.getURI(tag), con);
                    OWLOntologyAnnotationAxiom ax = this.getDataFactory().getOWLOntologyAnnotationAxiom(this.ontology, anno);
                    this.owlOntologyManager.applyChange(new AddAxiom(this.ontology, ax));
                }
            } else if (this.currentId != null) {
                OWLEntity entity = this.getCurrentEntity();
                OWLUntypedConstant con = this.getDataFactory().getOWLUntypedConstant(value);
                OWLConstantAnnotation anno = this.getDataFactory().getOWLConstantAnnotation(this.getURI(tag), con);
                OWLEntityAnnotationAxiom ax = this.getDataFactory().getOWLEntityAnnotationAxiom(entity, anno);
                this.owlOntologyManager.applyChange(new AddAxiom(this.ontology, ax));
            }
        }
        catch (OWLOntologyChangeException e) {
            logger.severe(e.getMessage());
        }
    }

    private OWLDataFactory getDataFactory() {
        return this.getOWLOntologyManager().getOWLDataFactory();
    }

    public OWLClass getCurrentClass() {
        return this.getDataFactory().getOWLClass(this.getURI(this.currentId));
    }

    public OWLEntity getCurrentEntity() {
        if (this.isTerm()) {
            return this.getCurrentClass();
        }
        if (this.isTypedef()) {
            return this.getDataFactory().getOWLObjectProperty(this.getURI(this.currentId));
        }
        return this.getDataFactory().getOWLIndividual(this.getURI(this.currentId));
    }

    public URI getURI(String s) {
        URI uri;
        if (s == null) {
            for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                System.out.println(e);
            }
        }
        if ((uri = this.uriCache.get(s)) != null) {
            return uri;
        }
        String localName = s;
        String namespace = this.getDefaultNamespace();
        localName = s.replace(':', '_');
        if (this.currentNamespace != null) {
            namespace = this.currentNamespace;
        }
        localName = localName.replace(' ', '-');
        try {
            uri = new URI(namespace + localName);
        }
        catch (URISyntaxException e) {
            System.out.println("URI Syntax Exception: " + namespace + localName);
        }
        this.uriCache.put(s, uri);
        return uri;
    }
}

