/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdfxml.parser;

import java.net.URI;
import org.coode.owl.rdfxml.parser.OWLRDFConsumer;
import org.coode.owl.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

public class TPPropertyDomainHandler
extends TriplePredicateHandler {
    public TPPropertyDomainHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.RDFS_DOMAIN.getURI());
    }

    public boolean canHandleStreaming(URI subject, URI predicate, URI object) throws OWLException {
        if (!this.isAnonymous(object)) {
            if (this.getConsumer().isObjectPropertyOnly(subject)) {
                return true;
            }
            if (this.getConsumer().isDataPropertyOnly(subject)) {
                return true;
            }
        }
        return false;
    }

    public void handleTriple(URI subject, URI predicate, URI object) throws OWLException {
        if (this.getConsumer().isObjectPropertyOnly(subject)) {
            this.translateObjectPropertyDomain(subject, predicate, object);
        } else if (this.getConsumer().isDataPropertyOnly(subject)) {
            this.translateDataPropertyDomain(subject, predicate, object);
        } else {
            URI rangeURI = this.getConsumer().getResourceObject(subject, predicate, false);
            if (this.getConsumer().isDataRange(rangeURI)) {
                this.translateDataPropertyDomain(subject, predicate, object);
            } else {
                this.translateObjectPropertyDomain(subject, predicate, object);
            }
        }
    }

    private void translateDataPropertyDomain(URI subject, URI predicate, URI object) throws OWLException {
        this.addAxiom(this.getDataFactory().getOWLDataPropertyDomainAxiom(this.translateDataProperty(subject), this.translateDescription(object)));
        this.consumeTriple(subject, predicate, object);
    }

    private void translateObjectPropertyDomain(URI subject, URI predicate, URI object) throws OWLException {
        this.addAxiom(this.getDataFactory().getOWLObjectPropertyDomainAxiom(this.translateObjectProperty(subject), this.translateDescription(object)));
        this.consumeTriple(subject, predicate, object);
    }
}

