/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.owlxml.renderer;

import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import org.coode.xml.XMLWriter;
import org.coode.xml.XMLWriterFactory;
import org.coode.xml.XMLWriterNamespaceManager;
import org.semanticweb.owl.io.OWLRendererException;
import org.semanticweb.owl.io.OWLRendererIOException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLRuntimeException;
import org.semanticweb.owl.util.VersionInfo;
import org.semanticweb.owl.vocab.Namespaces;
import org.semanticweb.owl.vocab.OWLXMLVocabulary;

public class OWLXMLWriter {
    private XMLWriter writer;

    public OWLXMLWriter(Writer writer, XMLWriterNamespaceManager xmlWriterNamespaceManager, OWLOntology ontology) {
        this.writer = XMLWriterFactory.getInstance().createXMLWriter(writer, xmlWriterNamespaceManager, Namespaces.OWL2XML.toString());
    }

    public OWLXMLWriter(Writer writer, XMLWriterNamespaceManager xmlWriterNamespaceManager) {
        this.writer = XMLWriterFactory.getInstance().createXMLWriter(writer, xmlWriterNamespaceManager, Namespaces.OWL2XML.toString());
    }

    public void startDocument(OWLOntology ontology) throws OWLRendererException {
        try {
            this.writer.startDocument(OWLXMLVocabulary.ONTOLOGY.toString());
            this.writeNameAttribute(ontology.getURI());
        }
        catch (IOException e) {
            throw new OWLRendererIOException(e);
        }
    }

    public void endDocument() {
        try {
            this.writer.endDocument();
            this.writer.writeComment(VersionInfo.getVersionInfo().getGeneratedByMessage());
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    public void writeStartElement(URI name) {
        try {
            this.writer.writeStartElement(name.toString());
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    public void writeEndElement() {
        try {
            this.writer.writeEndElement();
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    public void writeDatatypeAttribute(URI datatype) {
        try {
            this.writer.writeAttribute(OWLXMLVocabulary.DATATYPE_URI.getURI().toString(), datatype.toString());
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    public void writeNameAttribute(URI uri) {
        try {
            String value = uri.toString();
            String attName = (Object)((Object)Namespaces.OWL2XML) + "URI";
            if (value.startsWith(this.writer.getXMLBase())) {
                this.writer.writeAttribute(attName, value.substring(this.writer.getXMLBase().length(), value.length()));
            } else {
                this.writer.writeAttribute(attName, value);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeCardinalityAttribute(int cardinality) {
        try {
            this.writer.writeAttribute((Object)((Object)Namespaces.OWL2XML) + "cardinality", Integer.toString(cardinality));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeTextContent(String text) {
        try {
            this.writer.writeTextContent(text);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeFacetAttribute(URI facetURI) {
        try {
            this.writer.writeAttribute(OWLXMLVocabulary.DATATYPE_FACET.getURI().toString(), facetURI.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeAnnotationURIAttribute(URI uri) {
        try {
            this.writer.writeAttribute(OWLXMLVocabulary.ANNOTATION_URI.toString(), uri.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

