/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import org.semanticweb.owl.io.OWLOntologyOutputTarget;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyFormat;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLOntologyStorageException;
import org.semanticweb.owl.model.OWLOntologyStorer;

public abstract class AbstractOWLOntologyStorer
implements OWLOntologyStorer {
    public void storeOntology(OWLOntologyManager manager, OWLOntology ontology, URI physicalURI, OWLOntologyFormat ontologyFormat) throws OWLOntologyStorageException {
        try {
            OutputStream os;
            if (!physicalURI.isAbsolute()) {
                throw new OWLOntologyStorageException("Physical URI must be absolute: " + physicalURI);
            }
            if (physicalURI.getScheme().equals("file")) {
                File file = new File(physicalURI);
                file.getParentFile().mkdirs();
                os = new FileOutputStream(file);
            } else {
                URL url = physicalURI.toURL();
                URLConnection conn = url.openConnection();
                os = conn.getOutputStream();
            }
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter(os));
            this.storeOntology(manager, ontology, w, ontologyFormat);
            ((Writer)w).close();
        }
        catch (IOException e) {
            throw new OWLOntologyStorageException(e);
        }
    }

    public void storeOntology(OWLOntologyManager manager, OWLOntology ontology, OWLOntologyOutputTarget target, OWLOntologyFormat format) throws OWLOntologyStorageException {
        if (target.isWriterAvailable()) {
            this.storeOntology(manager, ontology, target.getWriter(), format);
        } else if (target.isOutputStreamAvailable()) {
            this.storeOntology(manager, ontology, new BufferedWriter(new OutputStreamWriter(target.getOutputStream())), format);
        } else if (target.isPhysicalURIAvailable()) {
            this.storeOntology(manager, ontology, target.getPhysicalURI(), format);
        } else {
            throw new OWLOntologyStorageException("Neither a Writer, OutputStream or Physical URI could be obtained to store the ontology");
        }
    }

    protected abstract void storeOntology(OWLOntologyManager var1, OWLOntology var2, Writer var3, OWLOntologyFormat var4) throws OWLOntologyStorageException;
}

