/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.semanticweb.owl.model.NamespaceManager;
import org.semanticweb.owl.vocab.Namespaces;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNamespaceManager
implements NamespaceManager {
    private String defaultNamespace;
    private Map<String, String> prefix2NamespaceMap;

    public DefaultNamespaceManager() {
        this(null);
    }

    public void clear() {
        this.defaultNamespace = null;
        this.prefix2NamespaceMap.clear();
    }

    public DefaultNamespaceManager(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
        this.prefix2NamespaceMap = new HashMap<String, String>();
        this.prefix2NamespaceMap.put("", defaultNamespace);
        this.registerNamespace("owl", Namespaces.OWL.toString());
        this.registerNamespace("rdfs", Namespaces.RDFS.toString());
        this.registerNamespace("rdf", Namespaces.RDF.toString());
        this.registerNamespace("xsd", Namespaces.XSD.toString());
        this.registerNamespace("skos", Namespaces.SKOS.toString());
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
        this.prefix2NamespaceMap.put("", defaultNamespace);
    }

    @Override
    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    @Override
    public boolean containsPrefixMapping(String prefix) {
        return this.prefix2NamespaceMap.containsKey(prefix) && this.prefix2NamespaceMap.get(prefix) != null;
    }

    @Override
    public URI getURI(String curie) {
        int sep = curie.indexOf(58);
        if (sep == -1) {
            if (this.getDefaultNamespace() != null) {
                return URI.create(this.getDefaultNamespace() + curie);
            }
            return URI.create(curie);
        }
        return URI.create(this.getNamespace(curie.substring(0, sep)) + curie.substring(sep + 1));
    }

    @Override
    public Map<String, String> getNamespaceMap() {
        return Collections.unmodifiableMap(this.prefix2NamespaceMap);
    }

    @Override
    public String getNamespace(String prefix) {
        return this.prefix2NamespaceMap.get(prefix);
    }

    public void registerNamespace(String prefix, String namespace) {
        this.prefix2NamespaceMap.put(prefix, namespace);
        if (prefix.trim().length() == 0) {
            this.defaultNamespace = namespace;
        }
    }

    public void unregisterNamespace(String namespace) {
        Iterator<String> it = this.prefix2NamespaceMap.values().iterator();
        while (it.hasNext()) {
            if (!it.next().equals(namespace)) continue;
            it.remove();
            return;
        }
    }
}

