/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEntityVisitor;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectAnnotation;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.model.SWRLAtom;
import org.semanticweb.owl.model.SWRLAtomConstantObject;
import org.semanticweb.owl.model.SWRLAtomDObject;
import org.semanticweb.owl.model.SWRLAtomDVariable;
import org.semanticweb.owl.model.SWRLAtomIObject;
import org.semanticweb.owl.model.SWRLAtomIVariable;
import org.semanticweb.owl.model.SWRLAtomIndividualObject;
import org.semanticweb.owl.model.SWRLAtomObject;
import org.semanticweb.owl.model.SWRLBuiltInAtom;
import org.semanticweb.owl.model.SWRLClassAtom;
import org.semanticweb.owl.model.SWRLDataRangeAtom;
import org.semanticweb.owl.model.SWRLDataValuedPropertyAtom;
import org.semanticweb.owl.model.SWRLDifferentFromAtom;
import org.semanticweb.owl.model.SWRLObjectPropertyAtom;
import org.semanticweb.owl.model.SWRLObjectVisitor;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.model.SWRLSameAsAtom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLEntityCollector
implements OWLObjectVisitor,
SWRLObjectVisitor {
    private Set<OWLEntity> objects = new HashSet<OWLEntity>();
    private boolean collectClasses = true;
    private boolean collectObjectProperties = true;
    private boolean collectDataProperties = true;
    private boolean collectIndividuals = true;
    private boolean collectDataTypes = true;

    public void reset() {
        this.objects.clear();
    }

    public void setCollectClasses(boolean collectClasses) {
        this.collectClasses = collectClasses;
    }

    public void setCollectObjectProperties(boolean collectObjectProperties) {
        this.collectObjectProperties = collectObjectProperties;
    }

    public void setCollectDataProperties(boolean collectDataProperties) {
        this.collectDataProperties = collectDataProperties;
    }

    public void setCollectIndividuals(boolean collectIndividuals) {
        this.collectIndividuals = collectIndividuals;
    }

    public void setCollectDataTypes(boolean collectDataTypes) {
        this.collectDataTypes = collectDataTypes;
    }

    public Set<OWLEntity> getObjects() {
        return Collections.unmodifiableSet(this.objects);
    }

    @Override
    public void visit(OWLSubClassAxiom axiom) {
        axiom.getSubClass().accept(this);
        axiom.getSuperClass().accept(this);
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLIndividual)axiom.getObject()).accept(this);
    }

    @Override
    public void visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        for (OWLDescription desc : axiom.getDescriptions()) {
            desc.accept(this);
        }
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        axiom.getDomain().accept(this);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLImportsDeclaration axiom) {
    }

    @Override
    public void visit(OWLAxiomAnnotationAxiom axiom) {
        ((OWLAxiom)axiom.getSubject()).accept(this);
        axiom.getAnnotation().accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        axiom.getDomain().accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
            prop.accept(this);
        }
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLConstant)axiom.getObject()).accept(this);
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        for (OWLIndividual ind : axiom.getIndividuals()) {
            ind.accept(this);
        }
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        for (OWLDataPropertyExpression prop : axiom.getProperties()) {
            prop.accept(this);
        }
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
            prop.accept(this);
        }
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        ((OWLDescription)axiom.getRange()).accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLIndividual)axiom.getObject()).accept(this);
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLObjectSubPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        axiom.getOWLClass().accept((OWLEntityVisitor)this);
        for (OWLDescription desc : axiom.getDescriptions()) {
            desc.accept(this);
        }
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
        axiom.getEntity().accept(this);
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLDataRange)axiom.getRange()).accept(this);
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        for (OWLDataPropertyExpression prop : axiom.getProperties()) {
            prop.accept(this);
        }
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        axiom.getDescription().accept(this);
        axiom.getIndividual().accept(this);
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        for (OWLDescription desc : axiom.getDescriptions()) {
            desc.accept(this);
        }
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLConstant)axiom.getObject()).accept(this);
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataSubPropertyAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept(this);
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLSameIndividualsAxiom axiom) {
        for (OWLIndividual ind : axiom.getIndividuals()) {
            ind.accept(this);
        }
    }

    @Override
    public void visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
        for (OWLObjectPropertyExpression prop : axiom.getPropertyChain()) {
            prop.accept(this);
        }
        axiom.getSuperProperty().accept(this);
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        axiom.getFirstProperty().accept(this);
        axiom.getSecondProperty().accept(this);
    }

    @Override
    public void visit(OWLClass desc) {
        if (this.collectClasses) {
            this.objects.add(desc);
        }
    }

    @Override
    public void visit(OWLObjectIntersectionOf desc) {
        for (OWLDescription operand : desc.getOperands()) {
            operand.accept(this);
        }
    }

    @Override
    public void visit(OWLObjectUnionOf desc) {
        for (OWLDescription operand : desc.getOperands()) {
            operand.accept(this);
        }
    }

    @Override
    public void visit(OWLObjectComplementOf desc) {
        desc.getOperand().accept(this);
    }

    @Override
    public void visit(OWLObjectSomeRestriction desc) {
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLDescription)desc.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLObjectAllRestriction desc) {
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLDescription)desc.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLObjectValueRestriction desc) {
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLIndividual)desc.getValue()).accept(this);
    }

    @Override
    public void visit(OWLObjectMinCardinalityRestriction desc) {
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLDescription)desc.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLObjectExactCardinalityRestriction desc) {
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLDescription)desc.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLObjectMaxCardinalityRestriction desc) {
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLDescription)desc.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLObjectSelfRestriction desc) {
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLObjectOneOf desc) {
        for (OWLIndividual ind : desc.getIndividuals()) {
            ind.accept(this);
        }
    }

    @Override
    public void visit(OWLDataSomeRestriction desc) {
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        ((OWLDataRange)desc.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLDataAllRestriction desc) {
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        ((OWLDataRange)desc.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLDataValueRestriction desc) {
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        ((OWLConstant)desc.getValue()).accept(this);
    }

    @Override
    public void visit(OWLDataMinCardinalityRestriction desc) {
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        ((OWLDataRange)desc.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLDataExactCardinalityRestriction desc) {
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        ((OWLDataRange)desc.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLDataMaxCardinalityRestriction desc) {
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        ((OWLDataRange)desc.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        node.getDataRange().accept(this);
    }

    @Override
    public void visit(OWLDataOneOf node) {
        for (OWLConstant val : node.getValues()) {
            val.accept(this);
        }
    }

    @Override
    public void visit(OWLDataRangeRestriction node) {
        node.getDataRange().accept(this);
        for (OWLDataRangeFacetRestriction facetRestriction : node.getFacetRestrictions()) {
            facetRestriction.accept(this);
        }
    }

    @Override
    public void visit(OWLDataRangeFacetRestriction node) {
        node.getFacetValue().accept(this);
    }

    @Override
    public void visit(OWLTypedConstant node) {
        node.getDataType().accept((OWLEntityVisitor)this);
    }

    @Override
    public void visit(OWLUntypedConstant node) {
    }

    @Override
    public void visit(OWLObjectPropertyInverse expression) {
        expression.getInverse().accept(this);
    }

    @Override
    public void visit(OWLObjectProperty property) {
        if (this.collectObjectProperties) {
            this.objects.add(property);
        }
    }

    @Override
    public void visit(OWLDataProperty property) {
        if (this.collectDataProperties) {
            this.objects.add(property);
        }
    }

    @Override
    public void visit(OWLIndividual individual) {
        if (this.collectIndividuals) {
            this.objects.add(individual);
        }
    }

    @Override
    public void visit(OWLDataType dataType) {
        if (this.collectDataTypes) {
            this.objects.add(dataType);
        }
    }

    @Override
    public void visit(OWLEntityAnnotationAxiom axiom) {
        ((OWLEntity)axiom.getSubject()).accept(this);
        axiom.getAnnotation().accept(this);
    }

    @Override
    public void visit(OWLOntologyAnnotationAxiom axiom) {
        axiom.getAnnotation().accept(this);
    }

    @Override
    public void visit(OWLOntology ontology) {
        this.objects.addAll(ontology.getReferencedEntities());
    }

    @Override
    public void visit(OWLConstantAnnotation annotation) {
        ((OWLConstant)annotation.getAnnotationValue()).accept(this);
    }

    @Override
    public void visit(OWLObjectAnnotation annotation) {
        ((OWLIndividual)annotation.getAnnotationValue()).accept(this);
    }

    @Override
    public void visit(SWRLRule rule) {
        for (SWRLAtom atom : rule.getBody()) {
            atom.accept(this);
        }
        for (SWRLAtom atom : rule.getHead()) {
            atom.accept(this);
        }
    }

    @Override
    public void visit(SWRLClassAtom node) {
        ((SWRLAtomIObject)node.getArgument()).accept(this);
        ((OWLDescription)node.getPredicate()).accept(this);
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
        ((SWRLAtomDObject)node.getArgument()).accept(this);
        ((OWLDataRange)node.getPredicate()).accept(this);
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
        ((OWLObjectPropertyExpression)node.getPredicate()).accept(this);
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
        ((SWRLAtomIObject)node.getSecondArgument()).accept(this);
    }

    @Override
    public void visit(SWRLDataValuedPropertyAtom node) {
        ((OWLDataPropertyExpression)node.getPredicate()).accept(this);
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
        ((SWRLAtomDObject)node.getSecondArgument()).accept(this);
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
        for (SWRLAtomObject atomObj : node.getAllArguments()) {
            atomObj.accept(this);
        }
    }

    @Override
    public void visit(SWRLAtomDVariable node) {
    }

    @Override
    public void visit(SWRLAtomIVariable node) {
    }

    @Override
    public void visit(SWRLAtomIndividualObject node) {
        node.getIndividual().accept(this);
    }

    @Override
    public void visit(SWRLAtomConstantObject node) {
        node.getConstant().accept(this);
    }

    @Override
    public void visit(SWRLDifferentFromAtom node) {
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
    }

    @Override
    public void visit(SWRLSameAsAtom node) {
        ((SWRLAtomIObject)node.getSecondArgument()).accept(this);
    }
}

