/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityVisitor;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.RemoveAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLEntityRemover
implements OWLEntityVisitor {
    private List<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
    private Set<OWLOntology> ontologies;

    public OWLEntityRemover(OWLOntologyManager owlOntologyManager, Set<OWLOntology> ontologies) {
        this.ontologies = new HashSet<OWLOntology>(ontologies);
    }

    public List<OWLOntologyChange> getChanges() {
        return new ArrayList<OWLOntologyChange>(this.changes);
    }

    public void reset() {
        this.changes.clear();
    }

    private void generateChanges(OWLEntity entity) {
        for (OWLOntology ont : this.ontologies) {
            for (OWLAxiom ax : ont.getReferencingAxioms(entity)) {
                this.changes.add(new RemoveAxiom(ont, ax));
            }
        }
    }

    @Override
    public void visit(OWLClass cls) {
        this.generateChanges(cls);
    }

    @Override
    public void visit(OWLDataType dataType) {
        this.generateChanges(dataType);
    }

    @Override
    public void visit(OWLIndividual individual) {
        this.generateChanges(individual);
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.generateChanges(property);
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.generateChanges(property);
    }
}

