/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectAnnotation;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLObjectVisitorEx;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.model.SWRLAtom;
import org.semanticweb.owl.model.SWRLAtomConstantObject;
import org.semanticweb.owl.model.SWRLAtomDObject;
import org.semanticweb.owl.model.SWRLAtomDVariable;
import org.semanticweb.owl.model.SWRLAtomIObject;
import org.semanticweb.owl.model.SWRLAtomIVariable;
import org.semanticweb.owl.model.SWRLAtomIndividualObject;
import org.semanticweb.owl.model.SWRLBuiltInAtom;
import org.semanticweb.owl.model.SWRLClassAtom;
import org.semanticweb.owl.model.SWRLDataRangeAtom;
import org.semanticweb.owl.model.SWRLDataValuedPropertyAtom;
import org.semanticweb.owl.model.SWRLDifferentFromAtom;
import org.semanticweb.owl.model.SWRLObjectPropertyAtom;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.model.SWRLSameAsAtom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLObjectWalker<O extends OWLObject> {
    private Set<O> objects;
    private OWLObjectVisitorEx visitor;
    private boolean visitDuplicates;

    public OWLObjectWalker(Set<O> objects) {
        this(objects, true);
    }

    public OWLObjectWalker(Set<O> objects, boolean visitDuplicates) {
        this.objects = new HashSet<O>(objects);
        this.visitDuplicates = visitDuplicates;
    }

    public <E> void walkStructure(OWLObjectVisitorEx<E> visitor) {
        this.visitor = visitor;
        StructureWalker walker = new StructureWalker();
        for (OWLObject o : this.objects) {
            o.accept(walker);
        }
    }

    private class StructureWalker
    implements OWLObjectVisitor {
        private Set<OWLObject> visited = new HashSet<OWLObject>();

        private StructureWalker() {
        }

        private void process(OWLObject object) {
            if (OWLObjectWalker.this.visitDuplicates) {
                if (!this.visited.contains(object)) {
                    this.visited.add(object);
                    object.accept(OWLObjectWalker.this.visitor);
                }
            } else {
                object.accept(OWLObjectWalker.this.visitor);
            }
        }

        public void visit(OWLOntology ontology) {
            this.process(ontology);
            for (OWLAxiom ax : ontology.getAxioms()) {
                ax.accept(this);
            }
        }

        public void visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
            this.process(axiom);
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        }

        public void visit(OWLAxiomAnnotationAxiom axiom) {
            this.process(axiom);
            ((OWLAxiom)axiom.getSubject()).accept(this);
            axiom.getAnnotation().accept(this);
        }

        public void visit(OWLClassAssertionAxiom axiom) {
            this.process(axiom);
            axiom.getIndividual().accept(this);
            axiom.getDescription().accept(this);
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            this.process(axiom);
            axiom.getSubject().accept(this);
            ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
            ((OWLConstant)axiom.getObject()).accept(this);
        }

        public void visit(OWLDataPropertyDomainAxiom axiom) {
            this.process(axiom);
            axiom.getDomain().accept(this);
            ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        }

        public void visit(OWLDataPropertyRangeAxiom axiom) {
            this.process(axiom);
            ((OWLDataRange)axiom.getRange()).accept(this);
            ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        }

        public void visit(OWLDataSubPropertyAxiom axiom) {
            this.process(axiom);
            ((OWLDataPropertyExpression)axiom.getSubProperty()).accept(this);
            ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
        }

        public void visit(OWLDeclarationAxiom axiom) {
            this.process(axiom);
            axiom.getEntity().accept(this);
        }

        public void visit(OWLDifferentIndividualsAxiom axiom) {
            this.process(axiom);
            for (OWLIndividual ind : axiom.getIndividuals()) {
                ind.accept(this);
            }
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            this.process(axiom);
            for (OWLDescription desc : axiom.getDescriptions()) {
                desc.accept(this);
            }
        }

        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            this.process(axiom);
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                prop.accept(this);
            }
        }

        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            this.process(axiom);
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                prop.accept(this);
            }
        }

        public void visit(OWLDisjointUnionAxiom axiom) {
            this.process(axiom);
            axiom.getOWLClass().accept(this);
            for (OWLDescription desc : axiom.getDescriptions()) {
                desc.accept(this);
            }
        }

        public void visit(OWLEntityAnnotationAxiom axiom) {
            this.process(axiom);
            ((OWLEntity)axiom.getSubject()).accept(this);
            axiom.getAnnotation().accept(this);
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            this.process(axiom);
            for (OWLDescription desc : axiom.getDescriptions()) {
                desc.accept(this);
            }
        }

        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            this.process(axiom);
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                prop.accept(this);
            }
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            this.process(axiom);
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                prop.accept(this);
            }
        }

        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            this.process(axiom);
            ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        }

        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            this.process(axiom);
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        }

        public void visit(OWLImportsDeclaration axiom) {
            this.process(axiom);
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            this.process(axiom);
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        }

        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            this.process(axiom);
            axiom.getFirstProperty().accept(this);
            axiom.getSecondProperty().accept(this);
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            this.process(axiom);
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            this.process(axiom);
            axiom.getSubject().accept(this);
            ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
            ((OWLConstant)axiom.getObject()).accept(this);
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            this.process(axiom);
            axiom.getSubject().accept(this);
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
            ((OWLIndividual)axiom.getObject()).accept(this);
        }

        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            this.process(axiom);
            axiom.getSubject().accept(this);
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
            ((OWLIndividual)axiom.getObject()).accept(this);
        }

        public void visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
            this.process(axiom);
            for (OWLObjectPropertyExpression prop : axiom.getPropertyChain()) {
                prop.accept(this);
            }
            axiom.getSuperProperty().accept(this);
        }

        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            this.process(axiom);
            axiom.getDomain().accept(this);
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        }

        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            this.process(axiom);
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
            ((OWLDescription)axiom.getRange()).accept(this);
        }

        public void visit(OWLObjectSubPropertyAxiom axiom) {
            this.process(axiom);
            ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
            ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
        }

        public void visit(OWLOntologyAnnotationAxiom axiom) {
            this.process(axiom);
            axiom.getAnnotation().accept(this);
        }

        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            this.process(axiom);
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        }

        public void visit(OWLSameIndividualsAxiom axiom) {
            this.process(axiom);
            for (OWLIndividual ind : axiom.getIndividuals()) {
                ind.accept(this);
            }
        }

        public void visit(OWLSubClassAxiom axiom) {
            this.process(axiom);
            axiom.getSubClass().accept(this);
            axiom.getSuperClass().accept(this);
        }

        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            this.process(axiom);
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        }

        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            this.process(axiom);
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        }

        public void visit(SWRLRule rule) {
            this.process(rule);
            for (SWRLAtom at : rule.getBody()) {
                at.accept(this);
            }
            for (SWRLAtom at : rule.getHead()) {
                at.accept(this);
            }
        }

        public void visit(OWLClass desc) {
            this.process(desc);
        }

        public void visit(OWLDataAllRestriction desc) {
            this.process(desc);
            ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
            ((OWLDataRange)desc.getFiller()).accept(this);
        }

        public void visit(OWLDataExactCardinalityRestriction desc) {
            this.process(desc);
            ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
            ((OWLDataRange)desc.getFiller()).accept(this);
        }

        public void visit(OWLDataMaxCardinalityRestriction desc) {
            this.process(desc);
            ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
            ((OWLDataRange)desc.getFiller()).accept(this);
        }

        public void visit(OWLDataMinCardinalityRestriction desc) {
            this.process(desc);
            ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
            ((OWLDataRange)desc.getFiller()).accept(this);
        }

        public void visit(OWLDataSomeRestriction desc) {
            this.process(desc);
            ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
            ((OWLDataRange)desc.getFiller()).accept(this);
        }

        public void visit(OWLDataValueRestriction desc) {
            this.process(desc);
            ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
            ((OWLConstant)desc.getValue()).accept(this);
        }

        public void visit(OWLObjectAllRestriction desc) {
            this.process(desc);
            ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
            ((OWLDescription)desc.getFiller()).accept(this);
        }

        public void visit(OWLObjectComplementOf desc) {
            this.process(desc);
            desc.getOperand().accept(this);
        }

        public void visit(OWLObjectExactCardinalityRestriction desc) {
            this.process(desc);
            ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
            ((OWLDescription)desc.getFiller()).accept(this);
        }

        public void visit(OWLObjectIntersectionOf desc) {
            this.process(desc);
            for (OWLDescription op : desc.getOperands()) {
                op.accept(this);
            }
        }

        public void visit(OWLObjectMaxCardinalityRestriction desc) {
            this.process(desc);
            ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
            ((OWLDescription)desc.getFiller()).accept(this);
        }

        public void visit(OWLObjectMinCardinalityRestriction desc) {
            this.process(desc);
            ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
            ((OWLDescription)desc.getFiller()).accept(this);
        }

        public void visit(OWLObjectOneOf desc) {
            this.process(desc);
            for (OWLIndividual ind : desc.getIndividuals()) {
                ind.accept(this);
            }
        }

        public void visit(OWLObjectSelfRestriction desc) {
            this.process(desc);
            ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        }

        public void visit(OWLObjectSomeRestriction desc) {
            this.process(desc);
            ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
            ((OWLDescription)desc.getFiller()).accept(this);
        }

        public void visit(OWLObjectUnionOf desc) {
            this.process(desc);
            for (OWLDescription op : desc.getOperands()) {
                op.accept(this);
            }
        }

        public void visit(OWLObjectValueRestriction desc) {
            this.process(desc);
            ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
            ((OWLIndividual)desc.getValue()).accept(this);
        }

        public void visit(OWLDataComplementOf node) {
            this.process(node);
            node.getDataRange().accept(this);
        }

        public void visit(OWLDataOneOf node) {
            this.process(node);
            for (OWLConstant con : node.getValues()) {
                con.accept(this);
            }
        }

        public void visit(OWLDataRangeFacetRestriction node) {
            this.process(node);
            node.getFacetValue().accept(this);
        }

        public void visit(OWLDataRangeRestriction node) {
            this.process(node);
            node.getDataRange().accept(this);
            for (OWLDataRangeFacetRestriction fr : node.getFacetRestrictions()) {
                fr.accept(this);
            }
        }

        public void visit(OWLDataType node) {
            this.process(node);
        }

        public void visit(OWLTypedConstant node) {
            this.process(node);
            node.getDataType().accept(this);
        }

        public void visit(OWLUntypedConstant node) {
            this.process(node);
        }

        public void visit(OWLDataProperty property) {
            this.process(property);
        }

        public void visit(OWLObjectProperty property) {
            this.process(property);
        }

        public void visit(OWLObjectPropertyInverse property) {
            this.process(property);
            property.getInverse().accept(this);
        }

        public void visit(OWLIndividual individual) {
            this.process(individual);
        }

        public void visit(OWLConstantAnnotation annotation) {
            this.process(annotation);
            ((OWLConstant)annotation.getAnnotationValue()).accept(this);
        }

        public void visit(OWLObjectAnnotation annotation) {
            this.process(annotation);
            ((OWLIndividual)annotation.getAnnotationValue()).accept(this);
        }

        public void visit(SWRLAtomConstantObject node) {
            this.process(node);
            node.getConstant().accept(this);
        }

        public void visit(SWRLAtomDVariable node) {
            this.process(node);
        }

        public void visit(SWRLAtomIndividualObject node) {
            this.process(node);
            node.getIndividual().accept(this);
        }

        public void visit(SWRLAtomIVariable node) {
            this.process(node);
        }

        public void visit(SWRLBuiltInAtom node) {
            this.process(node);
            for (SWRLAtomDObject at : node.getArguments()) {
                at.accept(this);
            }
        }

        public void visit(SWRLClassAtom node) {
            this.process(node);
            ((SWRLAtomIObject)node.getArgument()).accept(this);
            ((OWLDescription)node.getPredicate()).accept(this);
        }

        public void visit(SWRLDataRangeAtom node) {
            this.process(node);
            ((SWRLAtomDObject)node.getArgument()).accept(this);
            ((OWLDataRange)node.getPredicate()).accept(this);
        }

        public void visit(SWRLDataValuedPropertyAtom node) {
            this.process(node);
            ((OWLDataPropertyExpression)node.getPredicate()).accept(this);
            ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
            ((SWRLAtomDObject)node.getSecondArgument()).accept(this);
        }

        public void visit(SWRLDifferentFromAtom node) {
            this.process(node);
            ((OWLObjectProperty)node.getPredicate()).accept(this);
            ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
            ((SWRLAtomIObject)node.getSecondArgument()).accept(this);
        }

        public void visit(SWRLObjectPropertyAtom node) {
            this.process(node);
            ((OWLObjectPropertyExpression)node.getPredicate()).accept(this);
            ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
            ((SWRLAtomIObject)node.getSecondArgument()).accept(this);
        }

        public void visit(SWRLSameAsAtom node) {
            this.process(node);
            ((OWLObjectProperty)node.getPredicate()).accept(this);
            ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
            ((SWRLAtomIObject)node.getSecondArgument()).accept(this);
        }
    }
}

