/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.reasonerfactory.pellet;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.owl.inference.OWLReasoner;
import org.semanticweb.owl.inference.OWLReasonerFactory;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.reasonerfactory.OWLReasonerSetupException;

public class PelletReasonerFactory
implements OWLReasonerFactory {
    public static final String CLASS_NAME = "org.mindswap.pellet.owlapi.Reasoner";
    private Constructor reasonerConstructor;

    public PelletReasonerFactory() {
        try {
            Class<?> pelletReasonerClass = Class.forName(CLASS_NAME);
            this.reasonerConstructor = pelletReasonerClass.getConstructor(OWLOntologyManager.class);
            this.turnOffLogging();
            this.setTracingEnabled(false);
        }
        catch (ClassNotFoundException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
    }

    public void setTracingEnabled(boolean b) {
        try {
            Class<?> pelletOptionsClass = Class.forName("org.mindswap.pellet.PelletOptions");
            Field tracingField = pelletOptionsClass.getField("USE_TRACING");
            tracingField.set(pelletOptionsClass, b);
        }
        catch (ClassNotFoundException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
    }

    public void turnOffLogging() {
        this.setABoxLogging(Level.OFF);
        this.setTaxonomyLogging(Level.OFF);
        this.setKnowledgeBaseLogging(Level.OFF);
        this.setRBoxLogging(Level.OFF);
        this.setPelletVisitorLogging(Level.OFF);
    }

    public void setPelletVisitorLogging(Level level) {
        this.setLoggingLevel("org.mindswap.pellet.owlapi.PelletVisitor", level);
    }

    public void setRBoxLogging(Level level) {
        this.setLoggingLevel("org.mindswap.pellet.RBox", level);
    }

    public void setKnowledgeBaseLogging(Level level) {
        this.setLoggingLevel("org.mindswap.pellet.KnowledgeBase", level);
    }

    public void setTaxonomyLogging(Level level) {
        this.setLoggingLevel("org.mindswap.pellet.taxonomy.Taxonomy", level);
    }

    public void setABoxLogging(Level level) {
        this.setLoggingLevel("org.mindswap.pellet.ABox", level);
    }

    public void setLoggingLevel(String className, Level level) {
        try {
            Class<?> cls = Class.forName(className);
            Class<?> apacheLoggerCls = Class.forName("org.apache.commons.logging.impl.Jdk14Logger");
            Field logField = cls.getField("log");
            Object apacheLoggerObject = apacheLoggerCls.cast(logField.get(cls));
            Method getLoggerMethod = apacheLoggerCls.getMethod("getLogger", new Class[0]);
            Logger logger = (Logger)getLoggerMethod.invoke(apacheLoggerObject, null);
            logger.setLevel(level);
        }
        catch (ClassNotFoundException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
    }

    public String getReasonerName() {
        return "Pellet";
    }

    public OWLReasoner createReasoner(OWLOntologyManager manager) {
        try {
            return (OWLReasoner)this.reasonerConstructor.newInstance(manager);
        }
        catch (InstantiationException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
    }
}

