/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.AxiomType;
import org.semanticweb.owl.model.OWLAnnotationAxiom;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLAxiomVisitor;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEntityVisitor;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLIndividualAxiom;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLLogicalAxiom;
import org.semanticweb.owl.model.OWLMutableOntology;
import org.semanticweb.owl.model.OWLNamedObject;
import org.semanticweb.owl.model.OWLNamedObjectVisitor;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLObjectVisitorEx;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyChangeVisitor;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLPropertyAxiom;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.RemoveAxiom;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.model.SetOntologyURI;
import org.semanticweb.owl.model.UnknownOWLOntologyException;
import org.semanticweb.owl.util.CollectionFactory;
import org.semanticweb.owl.util.OWLAxiomVisitorAdapter;
import org.semanticweb.owl.util.OWLEntityCollector;
import uk.ac.manchester.cs.owl.FakeSet;
import uk.ac.manchester.cs.owl.OWLObjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLOntologyImpl
extends OWLObjectImpl
implements OWLMutableOntology {
    private URI ontologyURI;
    private Set<OWLAxiom> allAxioms;
    private Set<OWLLogicalAxiom> logicalAxioms;
    private Map<AxiomType, Set<OWLAxiom>> axiomsByType;
    private Set<SWRLRule> ruleAxioms;
    private Set<OWLAnnotationAxiom> annotationAxioms;
    private Set<OWLClassAxiom> owlClassAxioms;
    private Set<OWLClassAxiom> generalClassAxioms;
    private Set<OWLObjectPropertyChainSubPropertyAxiom> propertyChainSubPropertyAxioms;
    private Set<OWLPropertyAxiom> owlObjectPropertyAxioms;
    private Set<OWLPropertyAxiom> owlDataPropertyAxioms;
    private Set<OWLIndividualAxiom> owlIndividualAxioms;
    private Set<OWLDeclarationAxiom> owlDeclarationAxioms;
    private Set<OWLAxiomAnnotationAxiom> owlAxiomAnnotationAxioms;
    private Map<OWLAxiom, Set<OWLAxiomAnnotationAxiom>> owlAxiomAnnotationAxiomByAxiom;
    private Map<OWLOntology, Set<OWLOntologyAnnotationAxiom>> owlOntologyAnnotationAxiomsByOntology;
    private Set<OWLImportsDeclaration> owlImportsAnnotationAxioms;
    private Map<OWLClass, Set<OWLAxiom>> owlClassReferences;
    private Map<OWLObjectProperty, Set<OWLAxiom>> owlObjectPropertyReferences;
    private Map<OWLDataProperty, Set<OWLAxiom>> owlDataPropertyReferences;
    private Map<OWLIndividual, Set<OWLAxiom>> owlIndividualReferences;
    private Map<OWLDataType, Set<OWLAxiom>> owlDataTypeReferences;
    private Map<OWLClass, Set<OWLClassAxiom>> classAxiomsByClass;
    private Map<OWLClass, Set<OWLSubClassAxiom>> subClassAxiomsByLHS;
    private Map<OWLClass, Set<OWLSubClassAxiom>> subClassAxiomsByRHS;
    private Map<OWLClass, Set<OWLEquivalentClassesAxiom>> equivalentClassesAxiomsByClass;
    private Map<OWLClass, Set<OWLDisjointClassesAxiom>> disjointClassesAxiomsByClass;
    private Map<OWLClass, Set<OWLDisjointUnionAxiom>> disjointUnionAxiomsByClass;
    private Map<OWLObjectPropertyExpression, Set<OWLObjectSubPropertyAxiom>> objectSubPropertyAxiomsByLHS;
    private Map<OWLObjectPropertyExpression, Set<OWLObjectSubPropertyAxiom>> objectSubPropertyAxiomsByRHS;
    private Map<OWLObjectPropertyExpression, Set<OWLEquivalentObjectPropertiesAxiom>> equivalentObjectPropertyAxiomsByProperty;
    private Map<OWLObjectPropertyExpression, Set<OWLDisjointObjectPropertiesAxiom>> disjointObjectPropertyAxiomsByProperty;
    private Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyDomainAxiom>> objectPropertyDomainAxiomsByProperty;
    private Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyRangeAxiom>> objectPropertyRangeAxiomsByProperty;
    private Map<OWLObjectPropertyExpression, OWLFunctionalObjectPropertyAxiom> functionalObjectPropertyAxiomsByProperty;
    private Map<OWLObjectPropertyExpression, OWLInverseFunctionalObjectPropertyAxiom> inverseFunctionalPropertyAxiomsByProperty;
    private Map<OWLObjectPropertyExpression, OWLSymmetricObjectPropertyAxiom> symmetricPropertyAxiomsByProperty;
    private Map<OWLObjectPropertyExpression, OWLAntiSymmetricObjectPropertyAxiom> antiSymmetricPropertyAxiomsByProperty;
    private Map<OWLObjectPropertyExpression, OWLReflexiveObjectPropertyAxiom> reflexivePropertyAxiomsByProperty;
    private Map<OWLObjectPropertyExpression, OWLIrreflexiveObjectPropertyAxiom> irreflexivePropertyAxiomsByProperty;
    private Map<OWLObjectPropertyExpression, OWLTransitiveObjectPropertyAxiom> transitivePropertyAxiomsByProperty;
    private Map<OWLObjectPropertyExpression, Set<OWLInverseObjectPropertiesAxiom>> inversePropertyAxiomsByProperty;
    private Map<OWLDataPropertyExpression, Set<OWLDataSubPropertyAxiom>> dataSubPropertyAxiomsByLHS;
    private Map<OWLDataPropertyExpression, Set<OWLDataSubPropertyAxiom>> dataSubPropertyAxiomsByRHS;
    private Map<OWLDataPropertyExpression, Set<OWLEquivalentDataPropertiesAxiom>> equivalentDataPropertyAxiomsByProperty;
    private Map<OWLDataPropertyExpression, Set<OWLDisjointDataPropertiesAxiom>> disjointDataPropertyAxiomsByProperty;
    private Map<OWLDataPropertyExpression, Set<OWLDataPropertyDomainAxiom>> dataPropertyDomainAxiomsByProperty;
    private Map<OWLDataPropertyExpression, Set<OWLDataPropertyRangeAxiom>> dataPropertyRangeAxiomsByProperty;
    private Map<OWLDataPropertyExpression, OWLFunctionalDataPropertyAxiom> functionalDataPropertyAxiomsByProperty;
    private Map<OWLIndividual, Set<OWLClassAssertionAxiom>> typeAxiomsByIndividual;
    private Map<OWLClass, Set<OWLClassAssertionAxiom>> typeAxiomsByClass;
    private Map<OWLIndividual, Set<OWLObjectPropertyAssertionAxiom>> objectPropertyAssertionsByIndividual;
    private Map<OWLIndividual, Set<OWLDataPropertyAssertionAxiom>> dataPropertyAssertionsByIndividual;
    private Map<OWLIndividual, Set<OWLNegativeObjectPropertyAssertionAxiom>> negativeObjectPropertyAssertionAxiomsByIndividual;
    private Map<OWLIndividual, Set<OWLNegativeDataPropertyAssertionAxiom>> negativeDataPropertyAssertionAxiomsByIndividual;
    private Map<OWLIndividual, Set<OWLDifferentIndividualsAxiom>> differentIndividualsAxiomsByIndividual;
    private Map<OWLIndividual, Set<OWLSameIndividualsAxiom>> sameIndividualsAxiomsByIndividual;
    private Map<OWLEntity, Set<OWLDeclarationAxiom>> owlDeclarationAxiomMap;
    private Map<OWLEntity, Set<OWLEntityAnnotationAxiom>> owlEntityAnnotationAxiomsByEntity;
    private Map<URI, Set<OWLAnnotationAxiom>> annotationAxiomsByAnnotationURI;
    private OWLEntityReferenceChecker entityReferenceChecker = new OWLEntityReferenceChecker();
    private ChangeAxiomVisitor changeVisitor = new ChangeAxiomVisitor();
    private OWLOntologyChangeFilter changeFilter = new OWLOntologyChangeFilter();
    private OWLEntityCollector entityCollector = new OWLEntityCollector();
    private OWLNamedObjectReferenceAdder referenceAdder = new OWLNamedObjectReferenceAdder();
    private OWLNamedObjectReferenceRemover referenceRemover = new OWLNamedObjectReferenceRemover();

    public OWLOntologyImpl(OWLDataFactory dataFactory, URI uri) {
        super(dataFactory);
        this.ontologyURI = uri;
        this.createMaps();
    }

    private void createMaps() {
        this.allAxioms = CollectionFactory.createSet();
        this.logicalAxioms = CollectionFactory.createSet();
        this.ruleAxioms = CollectionFactory.createSet();
        this.owlImportsAnnotationAxioms = CollectionFactory.createSet();
        this.disjointClassesAxiomsByClass = CollectionFactory.createMap();
        this.disjointUnionAxiomsByClass = CollectionFactory.createMap();
        this.generalClassAxioms = CollectionFactory.createSet();
        this.propertyChainSubPropertyAxioms = CollectionFactory.createSet();
        this.owlClassReferences = CollectionFactory.createMap();
        this.owlObjectPropertyReferences = CollectionFactory.createMap();
        this.owlDataPropertyReferences = CollectionFactory.createMap();
        this.owlIndividualReferences = CollectionFactory.createMap();
        this.owlOntologyAnnotationAxiomsByOntology = CollectionFactory.createMap();
        this.annotationAxiomsByAnnotationURI = CollectionFactory.createMap();
        this.owlAxiomAnnotationAxiomByAxiom = CollectionFactory.createMap();
        this.axiomsByType = CollectionFactory.createMap();
        this.objectSubPropertyAxiomsByLHS = CollectionFactory.createMap();
        this.objectSubPropertyAxiomsByRHS = CollectionFactory.createMap();
        this.equivalentObjectPropertyAxiomsByProperty = CollectionFactory.createMap();
        this.disjointObjectPropertyAxiomsByProperty = CollectionFactory.createMap();
        this.objectPropertyDomainAxiomsByProperty = CollectionFactory.createMap();
        this.objectPropertyRangeAxiomsByProperty = CollectionFactory.createMap();
        this.functionalObjectPropertyAxiomsByProperty = CollectionFactory.createMap();
        this.inverseFunctionalPropertyAxiomsByProperty = CollectionFactory.createMap();
        this.symmetricPropertyAxiomsByProperty = CollectionFactory.createMap();
        this.antiSymmetricPropertyAxiomsByProperty = CollectionFactory.createMap();
        this.reflexivePropertyAxiomsByProperty = CollectionFactory.createMap();
        this.irreflexivePropertyAxiomsByProperty = CollectionFactory.createMap();
        this.transitivePropertyAxiomsByProperty = CollectionFactory.createMap();
        this.inversePropertyAxiomsByProperty = CollectionFactory.createMap();
        this.dataSubPropertyAxiomsByLHS = CollectionFactory.createMap();
        this.dataSubPropertyAxiomsByRHS = CollectionFactory.createMap();
        this.equivalentDataPropertyAxiomsByProperty = CollectionFactory.createMap();
        this.disjointDataPropertyAxiomsByProperty = CollectionFactory.createMap();
        this.dataPropertyDomainAxiomsByProperty = CollectionFactory.createMap();
        this.dataPropertyRangeAxiomsByProperty = CollectionFactory.createMap();
        this.functionalDataPropertyAxiomsByProperty = CollectionFactory.createMap();
        this.objectPropertyAssertionsByIndividual = CollectionFactory.createMap();
        this.dataPropertyAssertionsByIndividual = CollectionFactory.createMap();
        this.negativeObjectPropertyAssertionAxiomsByIndividual = CollectionFactory.createMap();
        this.negativeDataPropertyAssertionAxiomsByIndividual = CollectionFactory.createMap();
        this.differentIndividualsAxiomsByIndividual = CollectionFactory.createMap();
        this.sameIndividualsAxiomsByIndividual = CollectionFactory.createMap();
    }

    @Override
    public URI getURI() {
        return this.ontologyURI;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        return this.ontologyURI.compareTo(((OWLOntology)object).getURI());
    }

    @Override
    public boolean isEmpty() {
        return this.allAxioms.isEmpty();
    }

    @Override
    public int getAxiomCount() {
        return this.allAxioms.size();
    }

    @Override
    public Set<OWLAxiom> getAxioms() {
        return OWLOntologyImpl.getReturnSet(this.allAxioms);
    }

    @Override
    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType) {
        return OWLOntologyImpl.getAxioms(axiomType, this.axiomsByType, false);
    }

    private <T extends OWLAxiom> Set<T> getAxiomsInternal(AxiomType<T> axiomType) {
        return OWLOntologyImpl.getAxioms(axiomType, this.axiomsByType, false);
    }

    @Override
    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType) {
        return this.axiomsByType.get(axiomType).size();
    }

    @Override
    public Set<OWLLogicalAxiom> getLogicalAxioms() {
        return OWLOntologyImpl.getReturnSet(this.logicalAxioms);
    }

    @Override
    public int getLogicalAxiomCount() {
        return this.logicalAxioms.size();
    }

    @Override
    public Set<SWRLRule> getRules() {
        return OWLOntologyImpl.getReturnSet(this.ruleAxioms);
    }

    @Override
    public Set<OWLClassAxiom> getClassAxioms() {
        if (this.owlClassAxioms == null) {
            this.buildClassAxiomsIndex();
        }
        return OWLOntologyImpl.getReturnSet(this.owlClassAxioms);
    }

    @Override
    public Set<OWLPropertyAxiom> getObjectPropertyAxioms() {
        if (this.owlObjectPropertyAxioms == null) {
            this.buildObjectPropertyAxiomsIndex();
        }
        return OWLOntologyImpl.getReturnSet(this.owlObjectPropertyAxioms);
    }

    @Override
    public Set<OWLPropertyAxiom> getDataPropertyAxioms() {
        if (this.owlDataPropertyAxioms == null) {
            this.buildDataPropertyAxiomsIndex();
        }
        return OWLOntologyImpl.getReturnSet(this.owlDataPropertyAxioms);
    }

    @Override
    public Set<OWLIndividualAxiom> getIndividualAxioms() {
        if (this.owlIndividualAxioms == null) {
            this.buildIndividualAxiomsIndex();
        }
        return OWLOntologyImpl.getReturnSet(this.owlIndividualAxioms);
    }

    @Override
    public Set<OWLAnnotationAxiom> getAnnotationAxioms() {
        if (this.annotationAxioms == null) {
            this.buildAnnotationAxiomsIndex();
        }
        return OWLOntologyImpl.getReturnSet(this.annotationAxioms);
    }

    public Set<OWLAxiomAnnotationAxiom> getAxiomAnnotationAxioms() {
        if (this.owlAxiomAnnotationAxioms == null) {
            this.buildAxiomAnnotationAxiomsIndex();
        }
        return OWLOntologyImpl.getReturnSet(this.owlAxiomAnnotationAxioms);
    }

    @Override
    public Set<OWLDeclarationAxiom> getDeclarationAxioms() {
        if (this.owlDeclarationAxioms == null) {
            this.buildOWLDeclarationAxiomsIndex();
        }
        return OWLOntologyImpl.getReturnSet(this.owlDeclarationAxioms);
    }

    @Override
    public Set<OWLDeclarationAxiom> getDeclarationAxioms(OWLEntity entity) {
        if (this.owlDeclarationAxiomMap == null) {
            this.buildOWLDeclarationAxiomsIndex();
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(entity, this.owlDeclarationAxiomMap, false));
    }

    @Override
    public Set<OWLAxiomAnnotationAxiom> getAnnotations(OWLAxiom axiom) {
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(axiom, this.owlAxiomAnnotationAxiomByAxiom));
    }

    @Override
    public Set<OWLEntityAnnotationAxiom> getEntityAnnotationAxioms(OWLEntity entity) {
        if (this.owlEntityAnnotationAxiomsByEntity == null) {
            this.buildEntityAnnotationAxiomsByEntityIndex();
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(entity, this.owlEntityAnnotationAxiomsByEntity, false));
    }

    @Override
    public Set<OWLOntologyAnnotationAxiom> getAnnotations(OWLOntology ontology) {
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(ontology, this.owlOntologyAnnotationAxiomsByOntology, false));
    }

    @Override
    public Set<OWLOntologyAnnotationAxiom> getOntologyAnnotationAxioms() {
        HashSet<OWLOntologyAnnotationAxiom> result = new HashSet<OWLOntologyAnnotationAxiom>();
        for (Set<OWLOntologyAnnotationAxiom> annos : this.owlOntologyAnnotationAxiomsByOntology.values()) {
            result.addAll(annos);
        }
        return result;
    }

    @Override
    public Set<OWLClassAxiom> getGeneralClassAxioms() {
        return OWLOntologyImpl.getReturnSet(this.generalClassAxioms);
    }

    @Override
    public Set<OWLObjectPropertyChainSubPropertyAxiom> getPropertyChainSubPropertyAxioms() {
        return OWLOntologyImpl.getReturnSet(this.propertyChainSubPropertyAxioms);
    }

    @Override
    public boolean containsAxiom(OWLAxiom axiom) {
        return this.allAxioms.contains(axiom);
    }

    private Map<OWLClass, Set<OWLAxiom>> getOWLClassReferences() {
        return OWLOntologyImpl.getReturnMap(this.owlClassReferences);
    }

    private Map<OWLObjectProperty, Set<OWLAxiom>> getOWLObjectPropertyReferences() {
        return OWLOntologyImpl.getReturnMap(this.owlObjectPropertyReferences);
    }

    private Map<OWLDataProperty, Set<OWLAxiom>> getOWLDataPropertyReferences() {
        if (this.owlDataPropertyReferences == null) {
            this.buildOWLDataPropertyReferencesIndex();
        }
        return OWLOntologyImpl.getReturnMap(this.owlDataPropertyReferences);
    }

    private Map<OWLIndividual, Set<OWLAxiom>> getOWLIndividualReferences() {
        if (this.owlIndividualReferences == null) {
            this.buildOWLIndividualReferencesIndex();
        }
        return OWLOntologyImpl.getReturnMap(this.owlIndividualReferences);
    }

    private Map<OWLDataType, Set<OWLAxiom>> getOWLDataTypeReferences() {
        if (this.owlDataTypeReferences == null) {
            this.buildOWLDataTypeReferencesIndex();
        }
        return OWLOntologyImpl.getReturnMap(this.owlDataTypeReferences);
    }

    @Override
    public Set<URI> getAnnotationURIs() {
        return OWLOntologyImpl.getReturnSet(this.annotationAxiomsByAnnotationURI.keySet());
    }

    @Override
    public boolean containsClassReference(URI owlClassURI) {
        return this.owlClassReferences.containsKey(this.getOWLDataFactory().getOWLClass(owlClassURI));
    }

    @Override
    public boolean containsObjectPropertyReference(URI propURI) {
        return this.owlObjectPropertyReferences.containsKey(this.getOWLDataFactory().getOWLObjectProperty(propURI));
    }

    @Override
    public boolean containsDataPropertyReference(URI propURI) {
        return this.owlDataPropertyReferences.containsKey(this.getOWLDataFactory().getOWLDataProperty(propURI));
    }

    @Override
    public boolean containsIndividualReference(URI individualURI) {
        return this.owlIndividualReferences.containsKey(this.getOWLDataFactory().getOWLIndividual(individualURI));
    }

    @Override
    public boolean containsDataTypeReference(URI datatypeURI) {
        return this.getReferencedDatatypes().contains(this.getOWLDataFactory().getOWLDataType(datatypeURI));
    }

    @Override
    public boolean isPunned(URI uri) {
        int count = 0;
        if (this.containsClassReference(uri)) {
            ++count;
        }
        if (this.containsObjectPropertyReference(uri) && ++count > 1) {
            return true;
        }
        if (this.containsDataPropertyReference(uri) && ++count > 1) {
            return true;
        }
        if (this.containsIndividualReference(uri) && ++count > 1) {
            return true;
        }
        return this.containsDataTypeReference(uri) && ++count > 1;
    }

    public boolean containsReference(OWLClass owlClass) {
        return this.owlClassReferences.keySet().contains(owlClass);
    }

    public boolean containsReference(OWLObjectProperty prop) {
        return this.getOWLObjectPropertyReferences().keySet().contains(prop);
    }

    public boolean containsReference(OWLDataProperty prop) {
        return this.getOWLDataPropertyReferences().keySet().contains(prop);
    }

    public boolean containsReference(OWLIndividual ind) {
        return this.getOWLIndividualReferences().keySet().contains(ind);
    }

    public boolean containsReference(OWLDataType dt) {
        return this.getOWLDataTypeReferences().keySet().contains(dt);
    }

    @Override
    public boolean containsEntityDeclaration(OWLEntity owlEntity) {
        if (this.owlDeclarationAxiomMap == null) {
            this.buildOWLDeclarationAxiomsIndex();
        }
        return this.owlDeclarationAxiomMap.containsKey(owlEntity);
    }

    @Override
    public boolean containsEntityReference(OWLEntity owlEntity) {
        return this.entityReferenceChecker.containsReference(owlEntity);
    }

    @Override
    public Set<OWLAxiom> getReferencingAxioms(OWLEntity owlEntity) {
        if (owlEntity instanceof OWLClass) {
            return OWLOntologyImpl.getAxioms((OWLClass)owlEntity, this.getOWLClassReferences(), false);
        }
        if (owlEntity instanceof OWLObjectProperty) {
            return OWLOntologyImpl.getAxioms((OWLObjectProperty)owlEntity, this.getOWLObjectPropertyReferences(), false);
        }
        if (owlEntity instanceof OWLDataProperty) {
            return OWLOntologyImpl.getAxioms((OWLDataProperty)owlEntity, this.getOWLDataPropertyReferences(), false);
        }
        if (owlEntity instanceof OWLIndividual) {
            return OWLOntologyImpl.getAxioms((OWLIndividual)owlEntity, this.getOWLIndividualReferences(), false);
        }
        if (owlEntity instanceof OWLDataType) {
            return OWLOntologyImpl.getAxioms((OWLDataType)owlEntity, this.getOWLDataTypeReferences(), false);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<OWLClassAxiom> getAxioms(OWLClass cls) {
        if (this.classAxiomsByClass == null) {
            this.buildClassAxiomsByClassIndex();
        }
        return OWLOntologyImpl.getAxioms(cls, this.classAxiomsByClass);
    }

    @Override
    public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression prop) {
        HashSet<OWLObjectPropertyAxiom> result = new HashSet<OWLObjectPropertyAxiom>(50);
        OWLOntologyImpl.addAxiomToSet(this.getAntiSymmetricObjectPropertyAxiom(prop), result);
        OWLOntologyImpl.addAxiomToSet(this.getReflexiveObjectPropertyAxiom(prop), result);
        OWLOntologyImpl.addAxiomToSet(this.getSymmetricObjectPropertyAxiom(prop), result);
        OWLOntologyImpl.addAxiomToSet(this.getIrreflexiveObjectPropertyAxiom(prop), result);
        OWLOntologyImpl.addAxiomToSet(this.getTransitiveObjectPropertyAxiom(prop), result);
        OWLOntologyImpl.addAxiomToSet(this.getInverseFunctionalObjectPropertyAxiom(prop), result);
        OWLOntologyImpl.addAxiomToSet(this.getFunctionalObjectPropertyAxiom(prop), result);
        result.addAll(this.getInverseObjectPropertyAxioms(prop));
        result.addAll(this.getObjectPropertyDomainAxioms(prop));
        result.addAll(this.getEquivalentObjectPropertiesAxioms(prop));
        result.addAll(this.getDisjointObjectPropertiesAxiom(prop));
        result.addAll(this.getObjectPropertyRangeAxioms(prop));
        result.addAll(this.getObjectSubPropertyAxiomsForLHS(prop));
        return result;
    }

    @Override
    public Set<OWLDataPropertyAxiom> getAxioms(final OWLDataProperty prop) {
        final Set<OWLDataPropertyAxiom> result = CollectionFactory.createSet();
        for (OWLAxiom ax : OWLOntologyImpl.getAxioms(prop, this.getOWLDataPropertyReferences(), false)) {
            ax.accept(new OWLAxiomVisitorAdapter(){

                public void visit(OWLDataPropertyDomainAxiom axiom) {
                    if (((OWLDataPropertyExpression)axiom.getProperty()).equals(prop)) {
                        result.add(axiom);
                    }
                }

                public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
                    if (axiom.getProperties().contains(prop)) {
                        result.add(axiom);
                    }
                }

                public void visit(OWLDisjointDataPropertiesAxiom axiom) {
                    if (axiom.getProperties().contains(prop)) {
                        result.add(axiom);
                    }
                }

                public void visit(OWLDataPropertyRangeAxiom axiom) {
                    if (((OWLDataPropertyExpression)axiom.getProperty()).equals(axiom.getProperty())) {
                        result.add(axiom);
                    }
                }

                public void visit(OWLFunctionalDataPropertyAxiom axiom) {
                    if (((OWLDataPropertyExpression)axiom.getProperty()).equals(prop)) {
                        result.add(axiom);
                    }
                }

                public void visit(OWLDataSubPropertyAxiom axiom) {
                    if (((OWLDataPropertyExpression)axiom.getSubProperty()).equals(prop)) {
                        result.add(axiom);
                    }
                }
            });
        }
        return result;
    }

    @Override
    public Set<OWLIndividualAxiom> getAxioms(OWLIndividual individual) {
        HashSet<OWLIndividualAxiom> result = new HashSet<OWLIndividualAxiom>();
        result.addAll(this.getClassAssertionAxioms(individual));
        result.addAll(this.getObjectPropertyAssertionAxioms(individual));
        result.addAll(this.getDataPropertyAssertionAxioms(individual));
        result.addAll(this.getNegativeObjectPropertyAssertionAxioms(individual));
        result.addAll(this.getNegativeDataPropertyAssertionAxioms(individual));
        result.addAll(this.getSameIndividualAxioms(individual));
        result.addAll(this.getDifferentIndividualAxioms(individual));
        return result;
    }

    public Set<OWLNamedObject> getReferencedObjects() {
        HashSet<OWLNamedObject> result = new HashSet<OWLNamedObject>();
        result.addAll(this.owlClassReferences.keySet());
        for (OWLObjectProperty prop : this.owlObjectPropertyReferences.keySet()) {
            if (prop.isAnonymous()) continue;
            result.add(prop);
        }
        result.addAll(this.owlDataPropertyReferences.keySet());
        result.addAll(this.owlIndividualReferences.keySet());
        return result;
    }

    @Override
    public Set<OWLEntity> getReferencedEntities() {
        HashSet<OWLEntity> entities = new HashSet<OWLEntity>();
        entities.addAll(this.getReferencedClasses());
        entities.addAll(this.getReferencedObjectProperties());
        entities.addAll(this.getReferencedDataProperties());
        entities.addAll(this.getReferencedIndividuals());
        entities.addAll(this.getReferencedDatatypes());
        return entities;
    }

    @Override
    public Set<OWLClass> getReferencedClasses() {
        return OWLOntologyImpl.getReturnSet(this.owlClassReferences.keySet());
    }

    @Override
    public Set<OWLObjectProperty> getReferencedObjectProperties() {
        return OWLOntologyImpl.getReturnSet(this.owlObjectPropertyReferences.keySet());
    }

    @Override
    public Set<OWLDataProperty> getReferencedDataProperties() {
        return OWLOntologyImpl.getReturnSet(this.owlDataPropertyReferences.keySet());
    }

    @Override
    public Set<OWLIndividual> getReferencedIndividuals() {
        return OWLOntologyImpl.getReturnSet(this.owlIndividualReferences.keySet());
    }

    public Set<OWLDataType> getReferencedDatatypes() {
        return OWLOntologyImpl.getReturnSet(this.getOWLDataTypeReferences().keySet());
    }

    @Override
    public Set<OWLImportsDeclaration> getImportsDeclarations() {
        return OWLOntologyImpl.getReturnSet(this.owlImportsAnnotationAxioms);
    }

    @Override
    public Set<OWLOntology> getImports(OWLOntologyManager ontologyManager) throws UnknownOWLOntologyException {
        return ontologyManager.getImports(this);
    }

    @Override
    public Set<OWLSubClassAxiom> getSubClassAxiomsForLHS(OWLClass cls) {
        if (this.subClassAxiomsByLHS == null) {
            this.buildSubClassAxiomsByLHSIndex();
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(cls, this.subClassAxiomsByLHS));
    }

    @Override
    public Set<OWLSubClassAxiom> getSubClassAxiomsForRHS(OWLClass cls) {
        if (this.subClassAxiomsByRHS == null) {
            this.buildSubClassAxiomsByRHSIndex();
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(cls, this.subClassAxiomsByRHS));
    }

    @Override
    public Set<OWLEquivalentClassesAxiom> getEquivalentClassesAxioms(OWLClass cls) {
        if (this.equivalentClassesAxiomsByClass == null) {
            this.buildEquivalentClassesAxiomIndex();
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(cls, this.equivalentClassesAxiomsByClass));
    }

    @Override
    public Set<OWLDisjointClassesAxiom> getDisjointClassesAxioms(OWLClass cls) {
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(cls, this.disjointClassesAxiomsByClass));
    }

    @Override
    public Set<OWLDisjointUnionAxiom> getDisjointUnionAxioms(OWLClass owlClass) {
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(owlClass, this.disjointUnionAxiomsByClass));
    }

    @Override
    public Set<OWLObjectSubPropertyAxiom> getObjectSubPropertyAxiomsForLHS(OWLObjectPropertyExpression property) {
        if (this.objectSubPropertyAxiomsByLHS == null) {
            this.buildObjectSubPropertyAxiomsByLHSIndex();
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(property, this.objectSubPropertyAxiomsByLHS));
    }

    @Override
    public Set<OWLObjectSubPropertyAxiom> getObjectSubPropertyAxiomsForRHS(OWLObjectPropertyExpression property) {
        if (this.objectSubPropertyAxiomsByRHS == null) {
            this.buildObjectSubPropertyAxiomsByRHSIndex();
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(property, this.objectSubPropertyAxiomsByRHS));
    }

    @Override
    public Set<OWLObjectPropertyDomainAxiom> getObjectPropertyDomainAxioms(OWLObjectPropertyExpression property) {
        if (this.objectPropertyRangeAxiomsByProperty == null) {
            this.buildObjectPropertyDomainAxiomsByPropertyIndex();
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(property, this.objectPropertyDomainAxiomsByProperty));
    }

    @Override
    public Set<OWLObjectPropertyRangeAxiom> getObjectPropertyRangeAxioms(OWLObjectPropertyExpression property) {
        if (this.objectPropertyRangeAxiomsByProperty == null) {
            this.buildObjectPropertyRangeAxiomsByPropertyIndex();
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(property, this.objectPropertyRangeAxiomsByProperty));
    }

    @Override
    public Set<OWLInverseObjectPropertiesAxiom> getInverseObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(property, this.inversePropertyAxiomsByProperty));
    }

    @Override
    public Set<OWLEquivalentObjectPropertiesAxiom> getEquivalentObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        if (this.equivalentObjectPropertyAxiomsByProperty == null) {
            this.buildEquivalentObjectPropertiesAxiomsByPropertyIndex();
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(property, this.equivalentObjectPropertyAxiomsByProperty));
    }

    @Override
    public Set<OWLDisjointObjectPropertiesAxiom> getDisjointObjectPropertiesAxiom(OWLObjectPropertyExpression property) {
        if (this.disjointObjectPropertyAxiomsByProperty == null) {
            this.buildDisjointObjectPropertiesAxiomsByPropertyIndex();
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(property, this.disjointObjectPropertyAxiomsByProperty));
    }

    @Override
    public OWLFunctionalObjectPropertyAxiom getFunctionalObjectPropertyAxiom(OWLObjectPropertyExpression property) {
        return this.functionalObjectPropertyAxiomsByProperty.get(property);
    }

    @Override
    public OWLInverseFunctionalObjectPropertyAxiom getInverseFunctionalObjectPropertyAxiom(OWLObjectPropertyExpression property) {
        return this.inverseFunctionalPropertyAxiomsByProperty.get(property);
    }

    @Override
    public OWLSymmetricObjectPropertyAxiom getSymmetricObjectPropertyAxiom(OWLObjectPropertyExpression property) {
        return this.symmetricPropertyAxiomsByProperty.get(property);
    }

    @Override
    public OWLAntiSymmetricObjectPropertyAxiom getAntiSymmetricObjectPropertyAxiom(OWLObjectPropertyExpression property) {
        return this.getAsymmetricObjectPropertyAxiom(property);
    }

    @Override
    public OWLAntiSymmetricObjectPropertyAxiom getAsymmetricObjectPropertyAxiom(OWLObjectPropertyExpression property) {
        return this.antiSymmetricPropertyAxiomsByProperty.get(property);
    }

    @Override
    public OWLReflexiveObjectPropertyAxiom getReflexiveObjectPropertyAxiom(OWLObjectPropertyExpression property) {
        return this.reflexivePropertyAxiomsByProperty.get(property);
    }

    @Override
    public OWLIrreflexiveObjectPropertyAxiom getIrreflexiveObjectPropertyAxiom(OWLObjectPropertyExpression property) {
        return this.irreflexivePropertyAxiomsByProperty.get(property);
    }

    @Override
    public OWLTransitiveObjectPropertyAxiom getTransitiveObjectPropertyAxiom(OWLObjectPropertyExpression property) {
        return this.transitivePropertyAxiomsByProperty.get(property);
    }

    @Override
    public OWLFunctionalDataPropertyAxiom getFunctionalDataPropertyAxiom(OWLDataPropertyExpression property) {
        return this.functionalDataPropertyAxiomsByProperty.get(property);
    }

    @Override
    public Set<OWLDataSubPropertyAxiom> getDataSubPropertyAxiomsForLHS(OWLDataProperty lhsProperty) {
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(lhsProperty, this.dataSubPropertyAxiomsByLHS));
    }

    @Override
    public Set<OWLDataSubPropertyAxiom> getDataSubPropertyAxiomsForRHS(OWLDataPropertyExpression property) {
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(property, this.dataSubPropertyAxiomsByRHS));
    }

    @Override
    public Set<OWLDataPropertyDomainAxiom> getDataPropertyDomainAxioms(OWLDataProperty property) {
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(property, this.dataPropertyDomainAxiomsByProperty));
    }

    @Override
    public Set<OWLDataPropertyRangeAxiom> getDataPropertyRangeAxiom(OWLDataProperty property) {
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(property, this.dataPropertyRangeAxiomsByProperty));
    }

    @Override
    public Set<OWLEquivalentDataPropertiesAxiom> getEquivalentDataPropertiesAxiom(OWLDataProperty property) {
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(property, this.equivalentDataPropertyAxiomsByProperty));
    }

    @Override
    public Set<OWLDisjointDataPropertiesAxiom> getDisjointDataPropertiesAxiom(OWLDataProperty property) {
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(property, this.disjointDataPropertyAxiomsByProperty));
    }

    @Override
    public Set<OWLClassAssertionAxiom> getClassAssertionAxioms(OWLIndividual individual) {
        if (this.typeAxiomsByIndividual == null) {
            this.buildTypeAxiomsByIndividualIndex();
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(individual, this.typeAxiomsByIndividual));
    }

    @Override
    public Set<OWLClassAssertionAxiom> getClassAssertionAxioms(OWLClass type) {
        if (this.typeAxiomsByClass == null) {
            this.buildTypeAxiomsByClassIndex();
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(type, this.typeAxiomsByClass));
    }

    @Override
    public Set<OWLDataPropertyAssertionAxiom> getDataPropertyAssertionAxioms(OWLIndividual individual) {
        if (this.dataPropertyAssertionsByIndividual == null) {
            this.buildDataRelationshipsByIndividualIndex();
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(individual, this.dataPropertyAssertionsByIndividual));
    }

    @Override
    public Set<OWLObjectPropertyAssertionAxiom> getObjectPropertyAssertionAxioms(OWLIndividual individual) {
        if (this.objectPropertyAssertionsByIndividual == null) {
            this.buildObjectRelationshipsByIndividualIndex();
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(individual, this.objectPropertyAssertionsByIndividual));
    }

    @Override
    public Set<OWLNegativeObjectPropertyAssertionAxiom> getNegativeObjectPropertyAssertionAxioms(OWLIndividual individual) {
        if (this.negativeObjectPropertyAssertionAxiomsByIndividual == null) {
            this.buildNegativeObjectPropertyAssertionAxiomsByIndvidualIndex();
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(individual, this.negativeObjectPropertyAssertionAxiomsByIndividual));
    }

    @Override
    public Set<OWLNegativeDataPropertyAssertionAxiom> getNegativeDataPropertyAssertionAxioms(OWLIndividual individual) {
        if (this.negativeDataPropertyAssertionAxiomsByIndividual == null) {
            this.buildNegativeDataPropertyAssertionAxiomsByIndvidualIndex();
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(individual, this.negativeDataPropertyAssertionAxiomsByIndividual));
    }

    @Override
    public Set<OWLSameIndividualsAxiom> getSameIndividualAxioms(OWLIndividual individual) {
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(individual, this.sameIndividualsAxiomsByIndividual));
    }

    @Override
    public Set<OWLDifferentIndividualsAxiom> getDifferentIndividualAxioms(OWLIndividual individual) {
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(individual, this.differentIndividualsAxiomsByIndividual));
    }

    @Override
    public List<OWLOntologyChange> applyChange(OWLOntologyChange change) {
        ArrayList<OWLOntologyChange> appliedChanges = new ArrayList<OWLOntologyChange>(1);
        this.changeFilter.reset();
        change.accept(this.changeFilter);
        List<OWLOntologyChange> applied = this.changeFilter.getAppliedChanges();
        if (applied.size() == 1) {
            appliedChanges.add(change);
        } else {
            appliedChanges.addAll(applied);
        }
        return appliedChanges;
    }

    @Override
    public List<OWLOntologyChange> applyChanges(List<OWLOntologyChange> changes) {
        ArrayList<OWLOntologyChange> appliedChanges = new ArrayList<OWLOntologyChange>();
        for (OWLOntologyChange change : changes) {
            change.accept(this.changeFilter);
            appliedChanges.addAll(this.changeFilter.getAppliedChanges());
            this.changeFilter.reset();
        }
        return appliedChanges;
    }

    private void handleAxiomAdded(OWLAxiom axiom) {
        this.allAxioms.add(axiom);
        this.entityCollector.reset();
        axiom.accept(this.entityCollector);
        for (OWLEntity object : this.entityCollector.getObjects()) {
            this.referenceAdder.setAxiom(axiom);
            object.accept(this.referenceAdder);
        }
    }

    private void handleAxiomRemoved(OWLAxiom axiom) {
        this.allAxioms.remove(axiom);
        this.entityCollector.reset();
        axiom.accept(this.entityCollector);
        for (OWLEntity object : this.entityCollector.getObjects()) {
            this.referenceRemover.setAxiom(axiom);
            object.accept(this.referenceRemover);
        }
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLNamedObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    private static <E> Set<E> getReturnSet(Set<E> set) {
        return new HashSet<E>(set);
    }

    private static <K, V> Map<K, V> getReturnMap(Map<K, V> map) {
        return new HashMap<K, V>(map);
    }

    private static <K extends OWLObject, V extends OWLAxiom> Set<V> getAxioms(K key, Map<K, Set<V>> map) {
        Set<V> axioms = map.get(key);
        if (axioms != null) {
            return Collections.unmodifiableSet(axioms);
        }
        return Collections.emptySet();
    }

    private static <K, V extends OWLAxiom> Set<V> getAxioms(K key, Map<K, Set<V>> map, boolean create) {
        Set<V> axioms = map.get(key);
        if (axioms == null) {
            axioms = new FakeSet<V>();
            if (create) {
                map.put(key, axioms);
            }
        }
        return axioms;
    }

    private static <K, V extends OWLAxiom> void addToIndexedSet(K key, Map<K, Set<V>> map, V axiom) {
        if (map == null) {
            return;
        }
        Set<V> axioms = map.get(key);
        if (axioms == null) {
            axioms = new FakeSet<V>();
            map.put(key, axioms);
        }
        axioms.add(axiom);
    }

    private static <K extends OWLObject, V extends OWLAxiom> void addAxiomToMap(K key, Map<K, V> map, V axiom) {
        map.put(key, axiom);
    }

    private static <K, V extends OWLAxiom> void removeAxiomFromSet(K key, Map<K, Set<V>> map, V axiom, boolean removeSetIfEmpty) {
        if (map == null) {
            return;
        }
        Set<V> axioms = map.get(key);
        if (axioms != null) {
            axioms.remove(axiom);
            if (removeSetIfEmpty && axioms.isEmpty()) {
                map.remove(key);
            }
        }
    }

    private static <K extends OWLAxiom> void addAxiomToSet(K axiom, Set<K> axioms) {
        if (axioms != null && axiom != null) {
            axioms.add(axiom);
        }
    }

    private static <K extends OWLAxiom> void removeAxiomFromSet(K axiom, Set<K> axioms) {
        if (axioms != null) {
            axioms.remove(axiom);
        }
    }

    private static <K extends OWLObject, V extends OWLAxiom> void removeAxiomFromMap(K key, Map<K, V> map) {
        map.remove(key);
    }

    private void buildSubClassAxiomsByLHSIndex() {
        this.subClassAxiomsByLHS = CollectionFactory.createMap();
        this.buildAxiomIndex(new OWLAxiomVisitorAdapter(){

            public void visit(OWLSubClassAxiom axiom) {
                if (!axiom.getSubClass().isAnonymous()) {
                    OWLOntologyImpl.addToIndexedSet((OWLClass)axiom.getSubClass(), OWLOntologyImpl.this.subClassAxiomsByLHS, axiom);
                }
            }
        }, AxiomType.SUBCLASS);
    }

    private void buildSubClassAxiomsByRHSIndex() {
        this.subClassAxiomsByRHS = CollectionFactory.createMap();
        this.buildAxiomIndex(new OWLAxiomVisitorAdapter(){

            public void visit(OWLSubClassAxiom axiom) {
                if (!axiom.getSuperClass().isAnonymous()) {
                    OWLOntologyImpl.addToIndexedSet((OWLClass)axiom.getSuperClass(), OWLOntologyImpl.this.subClassAxiomsByRHS, axiom);
                }
            }
        }, AxiomType.SUBCLASS);
    }

    private void buildEquivalentClassesAxiomIndex() {
        this.equivalentClassesAxiomsByClass = CollectionFactory.createMap();
        this.buildAxiomIndex(new OWLAxiomVisitorAdapter(){

            public void visit(OWLEquivalentClassesAxiom axiom) {
                for (OWLDescription desc : axiom.getDescriptions()) {
                    if (desc.isAnonymous()) continue;
                    OWLOntologyImpl.addToIndexedSet((OWLClass)desc, OWLOntologyImpl.this.equivalentClassesAxiomsByClass, axiom);
                }
            }
        }, AxiomType.EQUIVALENT_CLASSES);
    }

    private void buildClassAxiomsIndex() {
        this.owlClassAxioms = CollectionFactory.createSet();
        this.owlClassAxioms.addAll(this.getAxiomsInternal(AxiomType.SUBCLASS));
        this.owlClassAxioms.addAll(this.getAxiomsInternal(AxiomType.EQUIVALENT_CLASSES));
        this.owlClassAxioms.addAll(this.getAxiomsInternal(AxiomType.DISJOINT_CLASSES));
        this.owlClassAxioms.addAll(this.getAxiomsInternal(AxiomType.DISJOINT_UNION));
    }

    private void buildObjectPropertyAxiomsIndex() {
        this.owlObjectPropertyAxioms = CollectionFactory.createSet();
        this.owlObjectPropertyAxioms.addAll(this.getAxiomsInternal(AxiomType.ANTI_SYMMETRIC_OBJECT_PROPERTY));
        this.owlObjectPropertyAxioms.addAll(this.getAxiomsInternal(AxiomType.REFLEXIVE_OBJECT_PROPERTY));
        this.owlObjectPropertyAxioms.addAll(this.getAxiomsInternal(AxiomType.OBJECT_PROPERTY_DOMAIN));
        this.owlObjectPropertyAxioms.addAll(this.getAxiomsInternal(AxiomType.EQUIVALENT_OBJECT_PROPERTIES));
        this.owlObjectPropertyAxioms.addAll(this.getAxiomsInternal(AxiomType.DISJOINT_OBJECT_PROPERTIES));
        this.owlObjectPropertyAxioms.addAll(this.getAxiomsInternal(AxiomType.OBJECT_PROPERTY_RANGE));
        this.owlObjectPropertyAxioms.addAll(this.getAxiomsInternal(AxiomType.FUNCTIONAL_OBJECT_PROPERTY));
        this.owlObjectPropertyAxioms.addAll(this.getAxiomsInternal(AxiomType.SUB_OBJECT_PROPERTY));
        this.owlObjectPropertyAxioms.addAll(this.getAxiomsInternal(AxiomType.SYMMETRIC_OBJECT_PROPERTY));
        this.owlObjectPropertyAxioms.addAll(this.getAxiomsInternal(AxiomType.TRANSITIVE_OBJECT_PROPERTY));
        this.owlObjectPropertyAxioms.addAll(this.getAxiomsInternal(AxiomType.IRREFLEXIVE_OBJECT_PROPERTY));
        this.owlObjectPropertyAxioms.addAll(this.getAxiomsInternal(AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY));
        this.owlObjectPropertyAxioms.addAll(this.getAxiomsInternal(AxiomType.PROPERTY_CHAIN_SUB_PROPERTY));
    }

    private void buildDataPropertyAxiomsIndex() {
        this.owlDataPropertyAxioms = CollectionFactory.createSet();
        this.owlDataPropertyAxioms.addAll(this.getAxiomsInternal(AxiomType.DATA_PROPERTY_DOMAIN));
        this.owlDataPropertyAxioms.addAll(this.getAxiomsInternal(AxiomType.DISJOINT_DATA_PROPERTIES));
        this.owlDataPropertyAxioms.addAll(this.getAxiomsInternal(AxiomType.DATA_PROPERTY_RANGE));
        this.owlDataPropertyAxioms.addAll(this.getAxiomsInternal(AxiomType.FUNCTIONAL_DATA_PROPERTY));
        this.owlDataPropertyAxioms.addAll(this.getAxiomsInternal(AxiomType.EQUIVALENT_DATA_PROPERTIES));
        this.owlDataPropertyAxioms.addAll(this.getAxiomsInternal(AxiomType.SUB_DATA_PROPERTY));
    }

    private void buildIndividualAxiomsIndex() {
        this.owlIndividualAxioms = CollectionFactory.createSet();
        this.owlIndividualAxioms.addAll(this.getAxiomsInternal(AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION));
        this.owlIndividualAxioms.addAll(this.getAxiomsInternal(AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION));
        this.owlIndividualAxioms.addAll(this.getAxiomsInternal(AxiomType.DIFFERENT_INDIVIDUALS));
        this.owlIndividualAxioms.addAll(this.getAxiomsInternal(AxiomType.OBJECT_PROPERTY_ASSERTION));
        this.owlIndividualAxioms.addAll(this.getAxiomsInternal(AxiomType.CLASS_ASSERTION));
        this.owlIndividualAxioms.addAll(this.getAxiomsInternal(AxiomType.DATA_PROPERTY_ASSERTION));
        this.owlIndividualAxioms.addAll(this.getAxiomsInternal(AxiomType.SAME_INDIVIDUAL));
    }

    private void buildOWLDeclarationAxiomsIndex() {
        this.owlDeclarationAxioms = CollectionFactory.createSet();
        this.owlDeclarationAxiomMap = CollectionFactory.createMap();
        this.buildAxiomIndex(new OWLAxiomVisitorAdapter(){

            public void visit(OWLDeclarationAxiom axiom) {
                OWLOntologyImpl.this.owlDeclarationAxioms.add(axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getEntity(), OWLOntologyImpl.this.owlDeclarationAxiomMap, axiom);
            }
        }, AxiomType.DECLARATION);
    }

    private void buildAxiomAnnotationAxiomsIndex() {
        this.owlAxiomAnnotationAxioms = new HashSet<OWLAxiomAnnotationAxiom>();
        this.buildAxiomIndex(new OWLAxiomVisitorAdapter(){

            public void visit(OWLAxiomAnnotationAxiom axiom) {
                OWLOntologyImpl.this.owlAxiomAnnotationAxioms.add(axiom);
            }
        }, AxiomType.AXIOM_ANNOTATION);
    }

    private void buildOWLClassReferencesIndex() {
        this.owlClassReferences = CollectionFactory.createMap();
        OWLEntityCollector collector = new OWLEntityCollector();
        collector.setCollectClasses(true);
        collector.setCollectDataProperties(false);
        collector.setCollectDataTypes(false);
        collector.setCollectIndividuals(false);
        collector.setCollectObjectProperties(false);
        for (OWLAxiom axiom : this.allAxioms) {
            collector.reset();
            axiom.accept(collector);
            for (OWLEntity obj : collector.getObjects()) {
                OWLOntologyImpl.addToIndexedSet((OWLClass)obj, this.owlClassReferences, axiom);
            }
        }
    }

    private void buildOWLObjectPropertyReferencesIndex() {
        this.owlObjectPropertyReferences = CollectionFactory.createMap();
        OWLEntityCollector collector = new OWLEntityCollector();
        collector.setCollectClasses(false);
        collector.setCollectDataProperties(false);
        collector.setCollectDataTypes(false);
        collector.setCollectIndividuals(false);
        collector.setCollectObjectProperties(true);
        for (OWLAxiom axiom : this.allAxioms) {
            collector.reset();
            axiom.accept(collector);
            for (OWLEntity obj : collector.getObjects()) {
                OWLOntologyImpl.addToIndexedSet((OWLObjectProperty)obj, this.owlObjectPropertyReferences, axiom);
            }
        }
    }

    private void buildOWLDataPropertyReferencesIndex() {
        this.owlDataPropertyReferences = CollectionFactory.createMap();
        OWLEntityCollector collector = new OWLEntityCollector();
        collector.setCollectClasses(false);
        collector.setCollectDataProperties(true);
        collector.setCollectDataTypes(false);
        collector.setCollectIndividuals(false);
        collector.setCollectObjectProperties(false);
        for (OWLAxiom axiom : this.allAxioms) {
            collector.reset();
            axiom.accept(collector);
            for (OWLEntity obj : collector.getObjects()) {
                OWLOntologyImpl.addToIndexedSet((OWLDataProperty)obj, this.owlDataPropertyReferences, axiom);
            }
        }
    }

    private void buildOWLIndividualReferencesIndex() {
        this.owlIndividualReferences = CollectionFactory.createMap();
        OWLEntityCollector collector = new OWLEntityCollector();
        collector.setCollectClasses(false);
        collector.setCollectDataProperties(false);
        collector.setCollectDataTypes(false);
        collector.setCollectIndividuals(true);
        collector.setCollectObjectProperties(false);
        for (OWLAxiom axiom : this.allAxioms) {
            collector.reset();
            axiom.accept(collector);
            for (OWLEntity obj : collector.getObjects()) {
                OWLOntologyImpl.addToIndexedSet((OWLIndividual)obj, this.owlIndividualReferences, axiom);
            }
        }
    }

    private void buildOWLDataTypeReferencesIndex() {
        this.owlDataTypeReferences = CollectionFactory.createMap();
        OWLEntityCollector collector = new OWLEntityCollector();
        collector.setCollectClasses(false);
        collector.setCollectDataProperties(false);
        collector.setCollectDataTypes(true);
        collector.setCollectIndividuals(false);
        collector.setCollectObjectProperties(false);
        for (OWLAxiom axiom : this.allAxioms) {
            collector.reset();
            axiom.accept(collector);
            for (OWLEntity obj : collector.getObjects()) {
                OWLOntologyImpl.addToIndexedSet((OWLDataType)obj, this.owlDataTypeReferences, axiom);
            }
        }
    }

    private void buildAxiomIndex(OWLAxiomVisitor visitor, AxiomType axiomType) {
        Set axioms = this.getAxiomsInternal(axiomType);
        for (OWLAxiom axiom : axioms) {
            axiom.accept(visitor);
        }
    }

    private void buildEntityAnnotationAxiomsByEntityIndex() {
        this.owlEntityAnnotationAxiomsByEntity = CollectionFactory.createMap();
        this.buildAxiomIndex(new OWLAxiomVisitorAdapter(){

            public void visit(OWLEntityAnnotationAxiom axiom) {
                OWLOntologyImpl.addToIndexedSet(axiom.getSubject(), OWLOntologyImpl.this.owlEntityAnnotationAxiomsByEntity, axiom);
            }
        }, AxiomType.ENTITY_ANNOTATION);
    }

    private void buildTypeAxiomsByIndividualIndex() {
        this.typeAxiomsByIndividual = CollectionFactory.createMap();
        this.buildAxiomIndex(new OWLAxiomVisitorAdapter(){

            public void visit(OWLClassAssertionAxiom axiom) {
                OWLOntologyImpl.addToIndexedSet(axiom.getIndividual(), OWLOntologyImpl.this.typeAxiomsByIndividual, axiom);
            }
        }, AxiomType.CLASS_ASSERTION);
    }

    private void buildTypeAxiomsByClassIndex() {
        this.typeAxiomsByClass = CollectionFactory.createMap();
        this.buildAxiomIndex(new OWLAxiomVisitorAdapter(){

            public void visit(OWLClassAssertionAxiom axiom) {
                if (!axiom.getDescription().isAnonymous()) {
                    OWLOntologyImpl.addToIndexedSet((OWLClass)axiom.getDescription(), OWLOntologyImpl.this.typeAxiomsByClass, axiom);
                }
            }
        }, AxiomType.CLASS_ASSERTION);
    }

    private void buildDataRelationshipsByIndividualIndex() {
        this.dataPropertyAssertionsByIndividual = CollectionFactory.createMap();
        this.buildAxiomIndex(new OWLAxiomVisitorAdapter(){

            public void visit(OWLDataPropertyAssertionAxiom axiom) {
                OWLOntologyImpl.addToIndexedSet(axiom.getSubject(), OWLOntologyImpl.this.dataPropertyAssertionsByIndividual, axiom);
            }
        }, AxiomType.DATA_PROPERTY_ASSERTION);
    }

    private void buildObjectRelationshipsByIndividualIndex() {
        this.objectPropertyAssertionsByIndividual = CollectionFactory.createMap();
        this.buildAxiomIndex(new OWLAxiomVisitorAdapter(){

            public void visit(OWLObjectPropertyAssertionAxiom axiom) {
                OWLOntologyImpl.addToIndexedSet(axiom.getSubject(), OWLOntologyImpl.this.objectPropertyAssertionsByIndividual, axiom);
            }
        }, AxiomType.OBJECT_PROPERTY_ASSERTION);
    }

    private void buildObjectSubPropertyAxiomsByLHSIndex() {
        this.objectSubPropertyAxiomsByLHS = CollectionFactory.createMap();
        this.buildAxiomIndex(new OWLAxiomVisitorAdapter(){

            public void visit(OWLObjectSubPropertyAxiom axiom) {
                OWLOntologyImpl.addToIndexedSet(axiom.getSubProperty(), OWLOntologyImpl.this.objectSubPropertyAxiomsByLHS, axiom);
            }
        }, AxiomType.SUB_OBJECT_PROPERTY);
    }

    private void buildObjectSubPropertyAxiomsByRHSIndex() {
        this.objectSubPropertyAxiomsByRHS = CollectionFactory.createMap();
        this.buildAxiomIndex(new OWLAxiomVisitorAdapter(){

            public void visit(OWLObjectSubPropertyAxiom axiom) {
                OWLOntologyImpl.addToIndexedSet(axiom.getSuperProperty(), OWLOntologyImpl.this.objectSubPropertyAxiomsByRHS, axiom);
            }
        }, AxiomType.SUB_OBJECT_PROPERTY);
    }

    private void buildObjectPropertyRangeAxiomsByPropertyIndex() {
        this.objectPropertyRangeAxiomsByProperty = CollectionFactory.createMap();
        this.buildAxiomIndex(new OWLAxiomVisitorAdapter(){

            public void visit(OWLObjectPropertyRangeAxiom axiom) {
                OWLOntologyImpl.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.objectPropertyRangeAxiomsByProperty, axiom);
            }
        }, AxiomType.OBJECT_PROPERTY_RANGE);
    }

    private void buildObjectPropertyDomainAxiomsByPropertyIndex() {
        this.objectPropertyDomainAxiomsByProperty = CollectionFactory.createMap();
        this.buildAxiomIndex(new OWLAxiomVisitorAdapter(){

            public void visit(OWLObjectPropertyDomainAxiom axiom) {
                OWLOntologyImpl.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.objectPropertyDomainAxiomsByProperty, axiom);
            }
        }, AxiomType.OBJECT_PROPERTY_DOMAIN);
    }

    private void buildEquivalentObjectPropertiesAxiomsByPropertyIndex() {
        this.equivalentObjectPropertyAxiomsByProperty = CollectionFactory.createMap();
        this.buildAxiomIndex(new OWLAxiomVisitorAdapter(){

            public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
                for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.addToIndexedSet(prop, OWLOntologyImpl.this.equivalentObjectPropertyAxiomsByProperty, axiom);
                }
            }
        }, AxiomType.EQUIVALENT_OBJECT_PROPERTIES);
    }

    private void buildDisjointObjectPropertiesAxiomsByPropertyIndex() {
        this.disjointObjectPropertyAxiomsByProperty = CollectionFactory.createMap();
        this.buildAxiomIndex(new OWLAxiomVisitorAdapter(){

            public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
                for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.addToIndexedSet(prop, OWLOntologyImpl.this.disjointObjectPropertyAxiomsByProperty, axiom);
                }
            }
        }, AxiomType.DISJOINT_OBJECT_PROPERTIES);
    }

    private void buildNegativeObjectPropertyAssertionAxiomsByIndvidualIndex() {
        this.negativeObjectPropertyAssertionAxiomsByIndividual = CollectionFactory.createMap();
        this.buildAxiomIndex(new OWLAxiomVisitorAdapter(){

            public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
                OWLOntologyImpl.addToIndexedSet(axiom.getSubject(), OWLOntologyImpl.this.negativeObjectPropertyAssertionAxiomsByIndividual, axiom);
            }
        }, AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION);
    }

    private void buildNegativeDataPropertyAssertionAxiomsByIndvidualIndex() {
        this.negativeDataPropertyAssertionAxiomsByIndividual = CollectionFactory.createMap();
        this.buildAxiomIndex(new OWLAxiomVisitorAdapter(){

            public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
                OWLOntologyImpl.addToIndexedSet(axiom.getSubject(), OWLOntologyImpl.this.negativeDataPropertyAssertionAxiomsByIndividual, axiom);
            }
        }, AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION);
    }

    private void buildAnnotationAxiomsIndex() {
        this.annotationAxioms = new HashSet<OWLAnnotationAxiom>();
        this.annotationAxioms.addAll(this.getAxiomsInternal(AxiomType.AXIOM_ANNOTATION));
        this.annotationAxioms.addAll(this.getAxiomsInternal(AxiomType.ENTITY_ANNOTATION));
        this.annotationAxioms.addAll(this.getAxiomsInternal(AxiomType.ONTOLOGY_ANNOTATION));
    }

    private void buildClassAxiomsByClassIndex() {
        this.classAxiomsByClass = new HashMap<OWLClass, Set<OWLClassAxiom>>();
        this.buildAxiomIndex(new OWLAxiomVisitorAdapter(){

            public void visit(OWLEquivalentClassesAxiom axiom) {
                for (OWLDescription desc : axiom.getDescriptions()) {
                    if (desc.isAnonymous()) continue;
                    OWLOntologyImpl.addToIndexedSet((OWLClass)desc, OWLOntologyImpl.this.classAxiomsByClass, axiom);
                }
            }
        }, AxiomType.EQUIVALENT_CLASSES);
        this.buildAxiomIndex(new OWLAxiomVisitorAdapter(){

            public void visit(OWLSubClassAxiom axiom) {
                if (!axiom.getSubClass().isAnonymous()) {
                    OWLOntologyImpl.addToIndexedSet((OWLClass)axiom.getSubClass(), OWLOntologyImpl.this.classAxiomsByClass, axiom);
                }
            }
        }, AxiomType.SUBCLASS);
        this.buildAxiomIndex(new OWLAxiomVisitorAdapter(){

            public void visit(OWLDisjointClassesAxiom axiom) {
                for (OWLDescription desc : axiom.getDescriptions()) {
                    if (desc.isAnonymous()) continue;
                    OWLOntologyImpl.addToIndexedSet((OWLClass)desc, OWLOntologyImpl.this.classAxiomsByClass, axiom);
                }
            }
        }, AxiomType.DISJOINT_CLASSES);
        this.buildAxiomIndex(new OWLAxiomVisitorAdapter(){

            public void visit(OWLDisjointUnionAxiom axiom) {
                OWLOntologyImpl.addToIndexedSet(axiom.getOWLClass(), OWLOntologyImpl.this.classAxiomsByClass, axiom);
            }
        }, AxiomType.DISJOINT_UNION);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OWLOntology)) {
            return false;
        }
        OWLOntology other = (OWLOntology)obj;
        return other.getURI().equals(this.ontologyURI);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AllAxioms
    extends AxiomSetCache<OWLAxiom> {
        private AllAxioms() {
        }

        @Override
        protected void build() {
            this.createSet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AxiomSetCache<E extends OWLAxiom>
    extends SetCache<E> {
        private AxiomSetCache() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class SetCache<E> {
        private Set<E> theSet = null;

        protected void createSet() {
            this.theSet = new HashSet();
        }

        public boolean add(E val) {
            if (this.theSet == null) {
                this.createSet();
            }
            return this.theSet.add(val);
        }

        public boolean remove(E val) {
            if (this.theSet == null) {
                return false;
            }
            return this.theSet.remove(val);
        }

        public boolean contains(E val) {
            if (this.theSet == null) {
                return false;
            }
            return this.theSet.contains(val);
        }

        public Set<E> getAll() {
            if (this.theSet == null) {
                this.build();
            }
            return this.theSet;
        }

        public Set<E> getAllInternal() {
            if (this.theSet == null) {
                this.build();
            }
            return this.theSet;
        }

        protected abstract void build();
    }

    private class OWLEntityReferenceChecker
    implements OWLEntityVisitor {
        private boolean ref;

        private OWLEntityReferenceChecker() {
        }

        public boolean containsReference(OWLEntity entity) {
            this.ref = false;
            entity.accept(this);
            return this.ref;
        }

        public void visit(OWLClass cls) {
            this.ref = OWLOntologyImpl.this.containsReference(cls);
        }

        public void visit(OWLDataType dataType) {
            this.ref = OWLOntologyImpl.this.containsReference(dataType);
        }

        public void visit(OWLIndividual individual) {
            this.ref = OWLOntologyImpl.this.containsReference(individual);
        }

        public void visit(OWLDataProperty property) {
            this.ref = OWLOntologyImpl.this.containsReference(property);
        }

        public void visit(OWLObjectProperty property) {
            this.ref = OWLOntologyImpl.this.containsReference(property);
        }
    }

    private class ChangeAxiomVisitor
    implements OWLAxiomVisitor {
        private boolean addAxiom = false;

        private ChangeAxiomVisitor() {
        }

        public void setAddAxiom(boolean addAxiom) {
            this.addAxiom = addAxiom;
        }

        public void visit(OWLSubClassAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlClassAxioms);
                OWLOntologyImpl.addToIndexedSet(AxiomType.SUBCLASS, OWLOntologyImpl.this.axiomsByType, axiom);
                if (!axiom.getSubClass().isAnonymous()) {
                    OWLClass subClass = (OWLClass)axiom.getSubClass();
                    OWLOntologyImpl.addToIndexedSet(subClass, OWLOntologyImpl.this.subClassAxiomsByLHS, axiom);
                    OWLOntologyImpl.addToIndexedSet(subClass, OWLOntologyImpl.this.classAxiomsByClass, axiom);
                } else {
                    OWLOntologyImpl.this.generalClassAxioms.add(axiom);
                }
                if (!axiom.getSuperClass().isAnonymous()) {
                    OWLOntologyImpl.addToIndexedSet((OWLClass)axiom.getSuperClass(), OWLOntologyImpl.this.subClassAxiomsByRHS, axiom);
                }
            } else {
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlClassAxioms);
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.SUBCLASS, OWLOntologyImpl.this.axiomsByType, axiom, true);
                if (!axiom.getSubClass().isAnonymous()) {
                    OWLClass subClass = (OWLClass)axiom.getSubClass();
                    OWLOntologyImpl.removeAxiomFromSet(subClass, OWLOntologyImpl.this.subClassAxiomsByLHS, axiom, true);
                    OWLOntologyImpl.removeAxiomFromSet(subClass, OWLOntologyImpl.this.classAxiomsByClass, axiom, true);
                } else {
                    OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.generalClassAxioms);
                }
                if (!axiom.getSuperClass().isAnonymous()) {
                    OWLOntologyImpl.removeAxiomFromSet(axiom.getSuperClass().asOWLClass(), OWLOntologyImpl.this.subClassAxiomsByRHS, axiom, true);
                }
            }
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlIndividualAxioms);
                OWLOntologyImpl.addToIndexedSet(axiom.getSubject(), OWLOntologyImpl.this.negativeObjectPropertyAssertionAxiomsByIndividual, axiom);
                OWLOntologyImpl.addToIndexedSet(AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION, OWLOntologyImpl.this.axiomsByType, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlIndividualAxioms);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getSubject(), OWLOntologyImpl.this.negativeObjectPropertyAssertionAxiomsByIndividual, axiom, true);
            }
        }

        public void visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                OWLOntologyImpl.addAxiomToMap(axiom.getProperty(), OWLOntologyImpl.this.antiSymmetricPropertyAxiomsByProperty, axiom);
                OWLOntologyImpl.addToIndexedSet(AxiomType.ANTI_SYMMETRIC_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.ANTI_SYMMETRIC_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                OWLOntologyImpl.removeAxiomFromMap(axiom.getProperty(), OWLOntologyImpl.this.antiSymmetricPropertyAxiomsByProperty);
            }
        }

        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                OWLOntologyImpl.addAxiomToMap(axiom.getProperty(), OWLOntologyImpl.this.reflexivePropertyAxiomsByProperty, axiom);
                OWLOntologyImpl.addToIndexedSet(AxiomType.REFLEXIVE_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.REFLEXIVE_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                OWLOntologyImpl.removeAxiomFromMap(axiom.getProperty(), OWLOntologyImpl.this.reflexivePropertyAxiomsByProperty);
            }
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlClassAxioms);
                OWLOntologyImpl.addToIndexedSet(AxiomType.DISJOINT_CLASSES, OWLOntologyImpl.this.axiomsByType, axiom);
                boolean allAnon = true;
                for (OWLDescription desc : axiom.getDescriptions()) {
                    if (desc.isAnonymous()) continue;
                    OWLClass cls = (OWLClass)desc;
                    OWLOntologyImpl.addToIndexedSet(cls, OWLOntologyImpl.this.disjointClassesAxiomsByClass, axiom);
                    OWLOntologyImpl.addToIndexedSet(cls, OWLOntologyImpl.this.classAxiomsByClass, axiom);
                    allAnon = false;
                }
                if (allAnon) {
                    OWLOntologyImpl.this.generalClassAxioms.add(axiom);
                }
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.DISJOINT_CLASSES, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlClassAxioms);
                boolean allAnon = true;
                for (OWLDescription desc : axiom.getDescriptions()) {
                    if (desc.isAnonymous()) continue;
                    OWLClass cls = (OWLClass)desc;
                    OWLOntologyImpl.removeAxiomFromSet(cls, OWLOntologyImpl.this.disjointClassesAxiomsByClass, axiom, true);
                    OWLOntologyImpl.removeAxiomFromSet(cls, OWLOntologyImpl.this.classAxiomsByClass, axiom, true);
                    allAnon = false;
                }
                if (allAnon) {
                    OWLOntologyImpl.this.generalClassAxioms.remove(axiom);
                }
            }
        }

        public void visit(OWLDataPropertyDomainAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.DATA_PROPERTY_DOMAIN, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlDataPropertyAxioms);
                OWLOntologyImpl.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.dataPropertyDomainAxiomsByProperty, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.DATA_PROPERTY_DOMAIN, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlDataPropertyAxioms);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.dataPropertyDomainAxiomsByProperty, axiom, true);
            }
        }

        public void visit(OWLImportsDeclaration axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.IMPORTS_DECLARATION, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.this.owlImportsAnnotationAxioms.add(axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.IMPORTS_DECLARATION, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.this.owlImportsAnnotationAxioms.remove(axiom);
            }
        }

        public void visit(OWLAxiomAnnotationAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.AXIOM_ANNOTATION, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.annotationAxioms);
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlAxiomAnnotationAxioms);
                OWLOntologyImpl.addToIndexedSet(axiom.getAnnotation().getAnnotationURI(), OWLOntologyImpl.this.annotationAxiomsByAnnotationURI, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getSubject(), OWLOntologyImpl.this.owlAxiomAnnotationAxiomByAxiom, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.AXIOM_ANNOTATION, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.annotationAxioms);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlAxiomAnnotationAxioms);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getAnnotation().getAnnotationURI(), OWLOntologyImpl.this.annotationAxiomsByAnnotationURI, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getSubject(), OWLOntologyImpl.this.owlAxiomAnnotationAxiomByAxiom, axiom, true);
            }
        }

        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                OWLOntologyImpl.addToIndexedSet(AxiomType.OBJECT_PROPERTY_DOMAIN, OWLOntologyImpl.this.axiomsByType, axiom);
                if (axiom.getProperty() instanceof OWLObjectProperty) {
                    OWLOntologyImpl.addToIndexedSet((OWLObjectProperty)axiom.getProperty(), OWLOntologyImpl.this.objectPropertyDomainAxiomsByProperty, axiom);
                }
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.OBJECT_PROPERTY_DOMAIN, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                if (axiom.getProperty() instanceof OWLObjectProperty) {
                    OWLOntologyImpl.removeAxiomFromSet((OWLObjectProperty)axiom.getProperty(), OWLOntologyImpl.this.objectPropertyDomainAxiomsByProperty, axiom, true);
                }
            }
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                OWLOntologyImpl.addToIndexedSet(AxiomType.EQUIVALENT_OBJECT_PROPERTIES, OWLOntologyImpl.this.axiomsByType, axiom);
                for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.addToIndexedSet(prop, OWLOntologyImpl.this.equivalentObjectPropertyAxiomsByProperty, axiom);
                }
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.EQUIVALENT_OBJECT_PROPERTIES, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.removeAxiomFromSet(prop, OWLOntologyImpl.this.equivalentObjectPropertyAxiomsByProperty, axiom, true);
                }
            }
        }

        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                OWLOntologyImpl.addToIndexedSet(AxiomType.INVERSE_OBJECT_PROPERTIES, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getFirstProperty(), OWLOntologyImpl.this.inversePropertyAxiomsByProperty, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getSecondProperty(), OWLOntologyImpl.this.inversePropertyAxiomsByProperty, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.INVERSE_OBJECT_PROPERTIES, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getFirstProperty(), OWLOntologyImpl.this.inversePropertyAxiomsByProperty, axiom, false);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getSecondProperty(), OWLOntologyImpl.this.inversePropertyAxiomsByProperty, axiom, false);
            }
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlIndividualAxioms);
                OWLOntologyImpl.addToIndexedSet(axiom.getSubject(), OWLOntologyImpl.this.negativeDataPropertyAssertionAxiomsByIndividual, axiom);
                OWLOntologyImpl.addToIndexedSet(AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION, OWLOntologyImpl.this.axiomsByType, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlIndividualAxioms);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getSubject(), OWLOntologyImpl.this.negativeDataPropertyAssertionAxiomsByIndividual, axiom, true);
            }
        }

        public void visit(OWLDifferentIndividualsAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlIndividualAxioms);
                for (OWLIndividual ind : axiom.getIndividuals()) {
                    OWLOntologyImpl.addToIndexedSet(ind, OWLOntologyImpl.this.differentIndividualsAxiomsByIndividual, axiom);
                    OWLOntologyImpl.addToIndexedSet(AxiomType.DIFFERENT_INDIVIDUALS, OWLOntologyImpl.this.axiomsByType, axiom);
                }
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.DIFFERENT_INDIVIDUALS, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlIndividualAxioms);
                for (OWLIndividual ind : axiom.getIndividuals()) {
                    OWLOntologyImpl.removeAxiomFromSet(ind, OWLOntologyImpl.this.differentIndividualsAxiomsByIndividual, axiom, true);
                }
            }
        }

        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlDataPropertyAxioms);
                OWLOntologyImpl.addToIndexedSet(AxiomType.DISJOINT_DATA_PROPERTIES, OWLOntologyImpl.this.axiomsByType, axiom);
                for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.addToIndexedSet(prop, OWLOntologyImpl.this.disjointDataPropertyAxiomsByProperty, axiom);
                }
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.DISJOINT_DATA_PROPERTIES, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlDataPropertyAxioms);
                for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.removeAxiomFromSet(prop, OWLOntologyImpl.this.disjointDataPropertyAxiomsByProperty, axiom, true);
                }
            }
        }

        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.DISJOINT_OBJECT_PROPERTIES, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.addToIndexedSet(prop, OWLOntologyImpl.this.disjointObjectPropertyAxiomsByProperty, axiom);
                }
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.DISJOINT_OBJECT_PROPERTIES, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.removeAxiomFromSet(prop, OWLOntologyImpl.this.disjointObjectPropertyAxiomsByProperty, axiom, true);
                }
            }
        }

        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                OWLOntologyImpl.addToIndexedSet(AxiomType.OBJECT_PROPERTY_RANGE, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.objectPropertyRangeAxiomsByProperty, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.OBJECT_PROPERTY_RANGE, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.objectPropertyRangeAxiomsByProperty, axiom, true);
            }
        }

        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlIndividualAxioms);
                OWLOntologyImpl.addToIndexedSet(AxiomType.OBJECT_PROPERTY_ASSERTION, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getSubject(), OWLOntologyImpl.this.objectPropertyAssertionsByIndividual, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.OBJECT_PROPERTY_ASSERTION, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlIndividualAxioms);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getSubject(), OWLOntologyImpl.this.objectPropertyAssertionsByIndividual, axiom, true);
            }
        }

        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                OWLOntologyImpl.addToIndexedSet(AxiomType.FUNCTIONAL_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addAxiomToMap(axiom.getProperty(), OWLOntologyImpl.this.functionalObjectPropertyAxiomsByProperty, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.FUNCTIONAL_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                OWLOntologyImpl.removeAxiomFromMap(axiom.getProperty(), OWLOntologyImpl.this.functionalObjectPropertyAxiomsByProperty);
            }
        }

        public void visit(OWLObjectSubPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                OWLOntologyImpl.addToIndexedSet(AxiomType.SUB_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getSubProperty(), OWLOntologyImpl.this.objectSubPropertyAxiomsByLHS, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getSuperProperty(), OWLOntologyImpl.this.objectSubPropertyAxiomsByRHS, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.SUB_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getSubProperty(), OWLOntologyImpl.this.objectSubPropertyAxiomsByLHS, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getSuperProperty(), OWLOntologyImpl.this.objectSubPropertyAxiomsByRHS, axiom, true);
            }
        }

        public void visit(OWLDisjointUnionAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlClassAxioms);
                OWLOntologyImpl.addToIndexedSet(AxiomType.DISJOINT_UNION, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getOWLClass(), OWLOntologyImpl.this.disjointUnionAxiomsByClass, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getOWLClass(), OWLOntologyImpl.this.classAxiomsByClass, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.DISJOINT_UNION, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlClassAxioms);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getOWLClass(), OWLOntologyImpl.this.disjointUnionAxiomsByClass, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getOWLClass(), OWLOntologyImpl.this.classAxiomsByClass, axiom, true);
            }
        }

        public void visit(OWLDeclarationAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.DECLARATION, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlDeclarationAxioms);
                OWLOntologyImpl.addToIndexedSet(axiom.getEntity(), OWLOntologyImpl.this.owlDeclarationAxiomMap, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.DECLARATION, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlDeclarationAxioms);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getEntity(), OWLOntologyImpl.this.owlDeclarationAxiomMap, axiom, true);
            }
        }

        public void visit(OWLEntityAnnotationAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.ENTITY_ANNOTATION, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getSubject(), OWLOntologyImpl.this.owlEntityAnnotationAxiomsByEntity, axiom);
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.annotationAxioms);
                OWLOntologyImpl.addToIndexedSet(axiom.getAnnotation().getAnnotationURI(), OWLOntologyImpl.this.annotationAxiomsByAnnotationURI, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.ENTITY_ANNOTATION, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getSubject(), OWLOntologyImpl.this.owlEntityAnnotationAxiomsByEntity, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.annotationAxioms);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getAnnotation().getAnnotationURI(), OWLOntologyImpl.this.annotationAxiomsByAnnotationURI, axiom, true);
            }
        }

        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.SYMMETRIC_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                OWLOntologyImpl.addAxiomToMap(axiom.getProperty(), OWLOntologyImpl.this.symmetricPropertyAxiomsByProperty, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.SYMMETRIC_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                OWLOntologyImpl.removeAxiomFromMap(axiom.getProperty(), OWLOntologyImpl.this.symmetricPropertyAxiomsByProperty);
            }
        }

        public void visit(OWLDataPropertyRangeAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.DATA_PROPERTY_RANGE, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                OWLOntologyImpl.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.dataPropertyRangeAxiomsByProperty, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.DATA_PROPERTY_RANGE, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.dataPropertyRangeAxiomsByProperty, axiom, true);
            }
        }

        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.FUNCTIONAL_DATA_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlDataPropertyAxioms);
                OWLOntologyImpl.addAxiomToMap(axiom.getProperty(), OWLOntologyImpl.this.functionalDataPropertyAxiomsByProperty, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.FUNCTIONAL_DATA_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlDataPropertyAxioms);
                OWLOntologyImpl.removeAxiomFromMap(axiom.getProperty(), OWLOntologyImpl.this.functionalDataPropertyAxiomsByProperty);
            }
        }

        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.EQUIVALENT_DATA_PROPERTIES, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlDataPropertyAxioms);
                for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.addToIndexedSet(prop, OWLOntologyImpl.this.equivalentDataPropertyAxiomsByProperty, axiom);
                }
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.EQUIVALENT_DATA_PROPERTIES, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlDataPropertyAxioms);
                for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.removeAxiomFromSet(prop, OWLOntologyImpl.this.equivalentDataPropertyAxiomsByProperty, axiom, true);
                }
            }
        }

        public void visit(OWLClassAssertionAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlIndividualAxioms);
                OWLOntologyImpl.addToIndexedSet(axiom.getIndividual(), OWLOntologyImpl.this.typeAxiomsByIndividual, axiom);
                OWLOntologyImpl.addToIndexedSet(AxiomType.CLASS_ASSERTION, OWLOntologyImpl.this.axiomsByType, axiom);
                if (!axiom.getDescription().isAnonymous()) {
                    OWLOntologyImpl.addToIndexedSet((OWLClass)axiom.getDescription(), OWLOntologyImpl.this.typeAxiomsByClass, axiom);
                }
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.CLASS_ASSERTION, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlIndividualAxioms);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getIndividual(), OWLOntologyImpl.this.typeAxiomsByIndividual, axiom, true);
                if (!axiom.getDescription().isAnonymous()) {
                    OWLOntologyImpl.removeAxiomFromSet((OWLClass)axiom.getDescription(), OWLOntologyImpl.this.typeAxiomsByClass, axiom, true);
                }
            }
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlClassAxioms);
                OWLOntologyImpl.addToIndexedSet(AxiomType.EQUIVALENT_CLASSES, OWLOntologyImpl.this.axiomsByType, axiom);
                boolean allAnon = true;
                for (OWLDescription desc : axiom.getDescriptions()) {
                    if (desc.isAnonymous()) continue;
                    OWLOntologyImpl.addToIndexedSet((OWLClass)desc, OWLOntologyImpl.this.equivalentClassesAxiomsByClass, axiom);
                    OWLOntologyImpl.addToIndexedSet((OWLClass)desc, OWLOntologyImpl.this.classAxiomsByClass, axiom);
                    allAnon = false;
                }
                if (allAnon) {
                    OWLOntologyImpl.this.generalClassAxioms.add(axiom);
                }
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.EQUIVALENT_CLASSES, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlClassAxioms);
                boolean allAnon = true;
                for (OWLDescription desc : axiom.getDescriptions()) {
                    if (desc.isAnonymous()) continue;
                    OWLOntologyImpl.removeAxiomFromSet((OWLClass)desc, OWLOntologyImpl.this.equivalentClassesAxiomsByClass, axiom, true);
                    OWLOntologyImpl.removeAxiomFromSet((OWLClass)desc, OWLOntologyImpl.this.classAxiomsByClass, axiom, true);
                    allAnon = false;
                }
                if (allAnon) {
                    OWLOntologyImpl.this.generalClassAxioms.remove(axiom);
                }
            }
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlIndividualAxioms);
                OWLOntologyImpl.addToIndexedSet(AxiomType.DATA_PROPERTY_ASSERTION, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getSubject(), OWLOntologyImpl.this.dataPropertyAssertionsByIndividual, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.DATA_PROPERTY_ASSERTION, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlIndividualAxioms);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getSubject(), OWLOntologyImpl.this.dataPropertyAssertionsByIndividual, axiom, true);
            }
        }

        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.TRANSITIVE_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                OWLOntologyImpl.addAxiomToMap(axiom.getProperty(), OWLOntologyImpl.this.transitivePropertyAxiomsByProperty, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.TRANSITIVE_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                OWLOntologyImpl.removeAxiomFromMap(axiom.getProperty(), OWLOntologyImpl.this.transitivePropertyAxiomsByProperty);
            }
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.IRREFLEXIVE_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                OWLOntologyImpl.addAxiomToMap(axiom.getProperty(), OWLOntologyImpl.this.irreflexivePropertyAxiomsByProperty, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.IRREFLEXIVE_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                OWLOntologyImpl.removeAxiomFromMap(axiom.getProperty(), OWLOntologyImpl.this.irreflexivePropertyAxiomsByProperty);
            }
        }

        public void visit(OWLDataSubPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.SUB_DATA_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlDataPropertyAxioms);
                OWLOntologyImpl.addToIndexedSet(axiom.getSubProperty(), OWLOntologyImpl.this.dataSubPropertyAxiomsByLHS, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getSuperProperty(), OWLOntologyImpl.this.dataSubPropertyAxiomsByRHS, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.SUB_DATA_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlDataPropertyAxioms);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getSubProperty(), OWLOntologyImpl.this.dataSubPropertyAxiomsByLHS, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getSuperProperty(), OWLOntologyImpl.this.dataSubPropertyAxiomsByRHS, axiom, true);
            }
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                OWLOntologyImpl.addAxiomToMap(axiom.getProperty(), OWLOntologyImpl.this.inverseFunctionalPropertyAxiomsByProperty, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                OWLOntologyImpl.removeAxiomFromMap(axiom.getProperty(), OWLOntologyImpl.this.inverseFunctionalPropertyAxiomsByProperty);
            }
        }

        public void visit(OWLSameIndividualsAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.SAME_INDIVIDUAL, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlIndividualAxioms);
                for (OWLIndividual ind : axiom.getIndividuals()) {
                    OWLOntologyImpl.addToIndexedSet(ind, OWLOntologyImpl.this.sameIndividualsAxiomsByIndividual, axiom);
                }
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.SAME_INDIVIDUAL, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlIndividualAxioms);
                for (OWLIndividual ind : axiom.getIndividuals()) {
                    OWLOntologyImpl.removeAxiomFromSet(ind, OWLOntologyImpl.this.sameIndividualsAxiomsByIndividual, axiom, true);
                }
            }
        }

        public void visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.PROPERTY_CHAIN_SUB_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.propertyChainSubPropertyAxioms);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.PROPERTY_CHAIN_SUB_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.owlObjectPropertyAxioms);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.propertyChainSubPropertyAxioms);
            }
        }

        public void visit(OWLOntologyAnnotationAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.ONTOLOGY_ANNOTATION, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getSubject(), OWLOntologyImpl.this.owlOntologyAnnotationAxiomsByOntology, axiom);
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.annotationAxioms);
                OWLOntologyImpl.addToIndexedSet(axiom.getAnnotation().getAnnotationURI(), OWLOntologyImpl.this.annotationAxiomsByAnnotationURI, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.ONTOLOGY_ANNOTATION, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getSubject(), OWLOntologyImpl.this.owlOntologyAnnotationAxiomsByOntology, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.annotationAxioms);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getAnnotation().getAnnotationURI(), OWLOntologyImpl.this.annotationAxiomsByAnnotationURI, axiom, true);
            }
        }

        public void visit(SWRLRule rule) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.SWRL_RULE, OWLOntologyImpl.this.axiomsByType, rule);
                OWLOntologyImpl.addAxiomToSet(rule, OWLOntologyImpl.this.ruleAxioms);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.SWRL_RULE, OWLOntologyImpl.this.axiomsByType, rule, true);
                OWLOntologyImpl.removeAxiomFromSet(rule, OWLOntologyImpl.this.ruleAxioms);
            }
        }
    }

    private class OWLNamedObjectReferenceRemover
    implements OWLEntityVisitor {
        private OWLAxiom axiom;

        private OWLNamedObjectReferenceRemover() {
        }

        public void setAxiom(OWLAxiom axiom) {
            this.axiom = axiom;
        }

        public void visit(OWLClass owlClass) {
            OWLOntologyImpl.removeAxiomFromSet(owlClass, OWLOntologyImpl.this.owlClassReferences, this.axiom, true);
        }

        public void visit(OWLObjectProperty property) {
            OWLOntologyImpl.removeAxiomFromSet(property, OWLOntologyImpl.this.owlObjectPropertyReferences, this.axiom, true);
        }

        public void visit(OWLDataProperty property) {
            OWLOntologyImpl.removeAxiomFromSet(property, OWLOntologyImpl.this.owlDataPropertyReferences, this.axiom, true);
        }

        public void visit(OWLIndividual owlIndividual) {
            OWLOntologyImpl.removeAxiomFromSet(owlIndividual, OWLOntologyImpl.this.owlIndividualReferences, this.axiom, true);
        }

        public void visit(OWLOntology ontology) {
        }

        public void visit(OWLDataType dataType) {
            OWLOntologyImpl.removeAxiomFromSet(dataType, OWLOntologyImpl.this.owlDataTypeReferences, this.axiom, true);
        }
    }

    private class OWLNamedObjectReferenceAdder
    implements OWLEntityVisitor {
        private OWLAxiom axiom;

        private OWLNamedObjectReferenceAdder() {
        }

        public void setAxiom(OWLAxiom axiom) {
            this.axiom = axiom;
        }

        public void visit(OWLClass owlClass) {
            OWLOntologyImpl.addToIndexedSet(owlClass, OWLOntologyImpl.this.owlClassReferences, this.axiom);
        }

        public void visit(OWLObjectProperty property) {
            OWLOntologyImpl.addToIndexedSet(property, OWLOntologyImpl.this.owlObjectPropertyReferences, this.axiom);
        }

        public void visit(OWLDataProperty property) {
            OWLOntologyImpl.addToIndexedSet(property, OWLOntologyImpl.this.owlDataPropertyReferences, this.axiom);
        }

        public void visit(OWLIndividual owlIndividual) {
            OWLOntologyImpl.addToIndexedSet(owlIndividual, OWLOntologyImpl.this.owlIndividualReferences, this.axiom);
        }

        public void visit(OWLOntology ontology) {
        }

        public void visit(OWLDataType dataType) {
            OWLOntologyImpl.addToIndexedSet(dataType, OWLOntologyImpl.this.owlDataTypeReferences, this.axiom);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OWLOntologyChangeFilter
    implements OWLOntologyChangeVisitor {
        private List<OWLOntologyChange> appliedChanges = new ArrayList<OWLOntologyChange>();

        public List<OWLOntologyChange> getAppliedChanges() {
            return this.appliedChanges;
        }

        public void reset() {
            this.appliedChanges.clear();
        }

        @Override
        public void visit(RemoveAxiom change) {
            OWLAxiom axiom = change.getAxiom();
            if (OWLOntologyImpl.this.allAxioms.contains(axiom)) {
                OWLOntologyImpl.this.changeVisitor.setAddAxiom(false);
                axiom.accept(OWLOntologyImpl.this.changeVisitor);
                this.appliedChanges.add(change);
                if (axiom.isLogicalAxiom()) {
                    OWLOntologyImpl.this.logicalAxioms.remove((OWLLogicalAxiom)axiom);
                }
                OWLOntologyImpl.this.handleAxiomRemoved(axiom);
            }
        }

        @Override
        public void visit(SetOntologyURI change) {
            if (!change.getNewURI().equals(OWLOntologyImpl.this.ontologyURI)) {
                this.appliedChanges.add(change);
                OWLOntologyImpl.this.ontologyURI = change.getNewURI();
            }
        }

        @Override
        public void visit(AddAxiom change) {
            OWLAxiom axiom = change.getAxiom();
            if (!OWLOntologyImpl.this.allAxioms.contains(axiom)) {
                OWLOntologyImpl.this.changeVisitor.setAddAxiom(true);
                axiom.accept(OWLOntologyImpl.this.changeVisitor);
                this.appliedChanges.add(change);
                if (axiom.isLogicalAxiom()) {
                    OWLOntologyImpl.this.logicalAxioms.add((OWLLogicalAxiom)axiom);
                }
                OWLOntologyImpl.this.handleAxiomAdded(axiom);
            }
        }
    }
}

